#ifndef __SMSCREEN

#define __SMSCREEN

#include <vector>
#include "SM_Renderable.h"



struct MSurface;
struct FVF_PosRhwDiffuseTex1;

namespace ScreenManager
{
  enum eBlend
  {
    E_NORMAL,
    E_ADDITIVE,    
    E_SUBSTRACTIVE,
    E_MULTIPLY,
    E_INVERT,
  };

  struct SMImage
  {
    SMImage  ();
    ~SMImage ();
    int      Init();
    int      Shutdown();

    unsigned m_uWidth;
    unsigned m_uHeight;
    unsigned m_uTilesX;
    unsigned m_uTilesY;
    bool     m_bAlpha;
    int*     m_piTextures;
    char     m_pcName[256];
  };


  int       Init        ();
  int       Shutdown    ();

  int       LoadImagen   (char* pcImageName, MSurface* pSurface=0);
  int       RemoveImage (int iID);
  int       FindImage   (char* pcImageName);

  void      Render      (int iImage, float x, float y, int iSegmentWidth, int iSegmentHeight, eBlend Blend, unsigned uColorBlend=0xFFFFFFFF, float fZoom = 1.0f);    

  SMImage*  GetImage(int iID);
  
};

#endif