#include "SM_CommonFXPCH.h"
#include "SM_Engine3DPCH.h"



class GreetingsFX : public SM_DemoEffect
{
public:              
  GreetingsFX(char const* pcName) : SM_DemoEffect(pcName)
  {
  }

  virtual          ~GreetingsFX()
  {
  }

  #define WIDTH  100
  #define HEIGHT 100

  float m_fOffset[WIDTH*HEIGHT];
  float m_fSpeed[WIDTH*HEIGHT];

  int      Init(const char* pcCommand)
  {
    int i;

    for (i=0 ; i<WIDTH*HEIGHT ; i++)
    {
      m_fOffset[i]=3.1416f*float(rand())/float(RAND_MAX);
      m_fSpeed[i]=1.8f+1.2f*float(rand())/float(RAND_MAX);
    }
    return (0);
  }

  int      Shutdown()
  {
    return (0);
  }

  int      Reset()
  {
    return (0);
  }

  
  int      Start(float fTime)
  {
    m_iShader=ShaderManager::LoadShader("agua");
    return (0);
  }

  int      Stop()
  {
    return (0);
  }

  int      Run(float fTime)
  {
    RenderContext RC;   

    float fRot=0.0f;//
    //float fRot=fTime*0.25f;
    Vector3D v3dVPN=Vector3D(sinf(fRot), 0.0f, cosf(fRot));
    v3dVPN.Normalize();
    Vector3D v3dVUP=Vector3D(0.0f, -1.0f, 0.0f);
    Vector3D v3dVRP=Vector3D::Cross(v3dVUP, v3dVPN);
    
    Quaternion q;
    q.FromFrame(v3dVPN, v3dVUP, v3dVRP);



    RC.Set(
    //Vector3D(0.0f, 0.0f, -1.8f+0.0f*sinf(fTime*0.05)),
    Vector3D(sinf(fRot), 0.0f, cosf(fRot))*1.8f,
    //Quaternion(1.0f, 0.0f, 0.0f, 0.0f),
    q*Quaternion(3.141592f, Vector3D(1.0f, 0.0f, 0.0f)),
    60,
    0.75f,
    0.01f,
    200.0f);
  
    RC.SetViewport(0.0f, 0.0f, 640, 480);
    RC.SyncRasterizer();
    RC.UpdateFrustum();

    
    MeshElement me;
    
    FVF_PosNormalDiffuseTex1 pVertices[WIDTH*HEIGHT];
    unsigned short pusIndices[(WIDTH-1)*(HEIGHT-1)*6]={0,2,1};

    int i,j;

    float y [HEIGHT*WIDTH];
    
    int iIndex=0;
    for (j=0 ; j<HEIGHT ; j++)
    {
      for (i=0 ; i<WIDTH ; i++)
      {
        y[iIndex]=sinf(float(m_fOffset[iIndex]+fTime*(4.0f*m_fSpeed[iIndex])))*0.025f;  
        iIndex++;
      }
    }

    iIndex=0;
    
    for (j=0 ; j<HEIGHT ; j++)
    {
      for (i=0 ; i<WIDTH ; i++)
      {
        unsigned uVertex=j*WIDTH+i;

        pVertices[uVertex].x=0.04f*float(i-WIDTH/2);
        pVertices[uVertex].y=y[uVertex];
        pVertices[uVertex].z=0.04f*float(j-HEIGHT/2);


        #define FACTOR 1.5f
        Vector3D v;
        if (j==0)
        {
          v.x=0.0f;
        }
        else
        {
          v.x=FACTOR*(pVertices[uVertex].y-pVertices[uVertex-1].y);
        }

        if (i==0)
        {
          v.z=0.0f;
        }
        else
        {
          v.z=FACTOR*(pVertices[uVertex].y-pVertices[uVertex-WIDTH].y);
        }

        v.y=1.0f;
        v.Normalize();

        //pVertices[uVertex].y*=0.5f;
        pVertices[uVertex].y=-0.15f;
        
        //v=Vector3D((i*j*3119%32000)-16000, (j*i*3119%32000)-16000, 1.0f);
        //v.Normalize();

        //Vector3D v(0.0f, 0.0f, 1.0f);
        pVertices[uVertex].nx=v.x; pVertices[uVertex].ny=v.y; pVertices[uVertex].nz=v.z;
        pVertices[uVertex].u=float(i)/10.0f; pVertices[uVertex].v=float(j)/10.0f; pVertices[uVertex].diffuse=0xFFFFFFFF;
      }
    }

    unsigned uIndex=0;    
    for (j=0 ; j<HEIGHT-1 ; j++)
    {
      for (i=0 ; i<WIDTH-1 ; i++)
      {
        pusIndices[uIndex+0]=i+j*WIDTH;
        pusIndices[uIndex+1]=i+j*WIDTH+1;
        pusIndices[uIndex+2]=i+(j+1)*WIDTH;
        pusIndices[uIndex+3]=i+j*WIDTH+1;;
        pusIndices[uIndex+4]=i+(j+1)*WIDTH+1;
        pusIndices[uIndex+5]=i+(j+1)*WIDTH;

        uIndex+=6;
      }
    }
    
    me.m_iShader            =m_iShader;
    me.m_iVB                =-1;
    me.m_iIB                =-1;
    me.m_pVertices          =pVertices; 
    me.m_pIndices           =pusIndices;
    me.m_uStartVertex       =0;
    me.m_uVertices          =WIDTH*HEIGHT;
    me.m_uStartIndex        =0;
    me.m_uPrimitives        =(WIDTH-1)*(HEIGHT-1)*2;
    me.m_WorldTransform     =Matrix4X4::Identity;
    me.m_iActiveLightMask   =-1;  
    me.m_fDepth             =0.0f;



    D3DLIGHT8 Light;
    //Light
    
    Light.Type    =D3DLIGHT_POINT;
    Light.Diffuse.a =Light.Diffuse.r=Light.Diffuse.g=Light.Diffuse.b=1.0f;    
    Light.Specular.a =Light.Specular.r=Light.Specular.g=Light.Specular.b=1.0f;
    Light.Diffuse.a =Light.Ambient.r=Light.Ambient.g=Light.Ambient.b=0.0f;
    Light.Position.x=0.0f;
    Light.Position.y=2.0f+2.0f*sinf(fTime);
    Light.Position.z=0.0f;;
    Light.Direction;
    Light.Range   =11120.0f;
    Light.Falloff =0.0;
    Light.Attenuation0=1.0f;
    Light.Attenuation1=0.0f;//0.05f;
    Light.Attenuation2=0.0f;//0.05f;
    Light.Theta=0.0f;
    Light.Phi=0.0f;

    //SM_D3d::SetRenderState(D3DRS_LIGHTING, TRUE);
  
    SM_D3d::Device()->SetLight(0, &Light);
    SM_D3d::Device()->LightEnable(0, TRUE);    



    RenderPipeline::Render(&me);
    RenderPipeline::Flush();
    
    SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);


    return (1);
  }

  int      Command           (float fTime, const char* pcCommand)
  {
    return (0);
  }  

  int m_iShader;

};

DEFINE_EFFECT(GreetingsFX)
GreetingsFX Greetings("GREETINGS");