#include <math.h>
#include <assert.h>
#include <windowsx.h>
#include "SM_D3d.h"
#include "SM_Timer.h"
#include "SM_Main.h"
#include "SM_DemoScript.h"
#include "SM_Music.h"
#include "SM_Renderable.h"
#include "SM_ResourceManager.h"
#include "SM_Shader.h"
#include "SM_RenderPipeline.h"
#include "SM_Coordinates.h"
#include "SM_CommonVF.h"
#include "SM_Screen.h"
#include "SM_DebugText.h"
#include "MVFS.h"
#include "FXFilter.h"
#include "FX3DText.h"
#include "resource.h"


#define USE_ZIP
int g_iPAK=-1;


extern float g_fMP3Time;
extern bool  g_bActive;
extern int   g_iPos;
extern int   g_iRow;
bool         g_bFullscreen;




extern int TestInit();
extern int TestShutdown();
extern int TestRun(float fTime);

class FilterFX;

SM_DemoTune MainModule("MUSIC");



/*
  La funcion para cargar el script de fichero esta fuera
  de la clase de script para que se pueda meter vuestro propio
  gestor de ficheros (en la original estaba dentro, pero esto 
  es mas flexible)
*/
int LoadScript(const char* pcScriptFile)
{
  MVFSFILE* f;

  f=MVFS::fopen(pcScriptFile, "rb");

  if (!f)
  {
    SM_Main::OutputError("File not found %s", pcScriptFile);
    return (-1);
  }

  MVFS::fseek(f, 0, SEEK_END);
  int iLength=MVFS::ftell(f);
  MVFS::fseek(f, 0, SEEK_SET);

  char* pcBuffer=new char[iLength+1];
  if (MVFS::fread(pcBuffer, iLength, 1, f)!=1)
  {
    SM_Main::OutputError("Error reading script from %s", pcScriptFile);
    return (-1);
  }
  pcBuffer[iLength]='\0';


  MVFS::fclose(f);

  int iReturn;
  iReturn=SM_DemoScript::Init(pcBuffer, false);
  

  delete[] pcBuffer;
  
  return (iReturn);
}

int ShutdownMusic(SM_DemoTune* pTune)
{
  delete[] pTune->m_pcBuffer;
  pTune->m_pcBuffer=0;
  return (0);
}



int D3DRequirements(int iMode)
{  
  if (FAILED( SM_D3d::D3D()->CheckDeviceFormat(SM_D3d::GetModes()[iMode].uDevice, 
                                   D3DDEVTYPE_HAL,
                                   SM_D3d::GetModes()[iMode].d3dFormat,
                                   0,
                                   D3DRTYPE_TEXTURE,
                                   D3DFMT_A8R8G8B8)) &&
      FAILED( SM_D3d::D3D()->CheckDeviceFormat(SM_D3d::GetModes()[iMode].uDevice, 
                                   D3DDEVTYPE_HAL,
                                   SM_D3d::GetModes()[iMode].d3dFormat,
                                   0,
                                   D3DRTYPE_TEXTURE,
                                   D3DFMT_A4R4G4B4             )))
  {
    return 0;
  }

                    
  return 1;
}

static BOOL CALLBACK InitDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

struct DialogData
{
  char*     pszIdiom;
  bool      bFullscreen;
  bool      b16Bit;
  bool      b32BitTextures;
  bool      bAntialias;
  unsigned  uResX;
  unsigned  uResY;
};

DialogData MyDialogData;


static BOOL CALLBACK InitDlgProc( HWND _hdlg, UINT _uMsg, WPARAM _wparam, LPARAM _lparam)
{
  //static sData* dlgdata = 0;
  static DialogData* dlgdata = 0;

  switch (_uMsg)
  {
    case WM_INITDIALOG :
      {
        SetWindowPos(_hdlg,HWND_TOPMOST,0,0,1,1,SWP_NOMOVE|SWP_NOSIZE);

        dlgdata = (DialogData*)_lparam;

        HWND hcombo = GetDlgItem( _hdlg,IDC_RESOLUTION);
        ComboBox_ResetContent( hcombo );
        ComboBox_InsertString( hcombo, 0, "640x480" );
        ComboBox_InsertString( hcombo, 1, "800x600" );
        ComboBox_InsertString( hcombo, 2, "1024x768" );
        ComboBox_InsertString( hcombo, 3, "1280x1024" );
        ComboBox_SetCurSel   (hcombo, 0);

        Button_SetCheck( GetDlgItem(_hdlg,IDC_16BIT), BST_CHECKED );
        //Button_SetCheck( GetDlgItem(_hdlg,IDC_ANTIALIAS), BST_CHECKED );

        //Button_SetCheck( GetDlgItem(_hdlg,IDC_TEXTURES32), BST_CHECKED );
        
        
        RECT rectWindow;
	      RECT rectClient;
	      long lCoorxWin, lCooryWin;

    
	      GetWindowRect(_hdlg, &rectWindow);
	      GetClientRect(_hdlg, &rectClient);

        lCoorxWin = (GetSystemMetrics(SM_CXSCREEN) - rectWindow.right) /2;
	      lCooryWin = (GetSystemMetrics(SM_CYSCREEN) - rectWindow.bottom) /2;
	      
	      GetWindowRect(_hdlg, &rectClient);
	      
        BOOL b=SetWindowPos( _hdlg, HWND_NOTOPMOST, 
          lCoorxWin, lCooryWin, 
          rectWindow.right-rectWindow.left, rectWindow.bottom-rectWindow.top, 
          SWP_SHOWWINDOW|SWP_FRAMECHANGED );			                      		      

        /*
        // radio ventana / pantalla completa
        if (dlgdata->coop_mode==sData::COOP_FULL)
          Button_SetCheck( GetDlgItem(_hdlg,IDC_RADIO_FULLSCREEN), BST_CHECKED );
        else
          Button_SetCheck( GetDlgItem(_hdlg,IDC_RADIO_WINDOW), BST_CHECKED );

        // checkboxes warp y quicklad
        Button_SetCheck( 
          GetDlgItem(_hdlg,IDC_CHECK_WARP), 
          dlgdata->warp ? BST_CHECKED : BST_UNCHECKED );

        Button_SetCheck( 
          GetDlgItem(_hdlg,IDC_CHECK_QUICKLOAD), 
          dlgdata->quickload ? BST_CHECKED : BST_UNCHECKED );

        // radio sonido on/off
        if (dlgdata->sound==sData::SND_ON)
          Button_SetCheck( GetDlgItem(_hdlg,IDC_RADIO_SOUNDON), BST_CHECKED );
        else
          Button_SetCheck( GetDlgItem(_hdlg,IDC_RADIO_SOUNDOFF), BST_CHECKED );

        // radio bits textura 16/32
        if (dlgdata->texture_bits==sData::TB_16)
          Button_SetCheck( GetDlgItem(_hdlg,IDC_RADIO_TEXTUREBITS_16), BST_CHECKED );
        else
          Button_SetCheck( GetDlgItem(_hdlg,IDC_RADIO_TEXTUREBITS_32), BST_CHECKED );

        // radio bits zbuffer 16/24/32
        if (dlgdata->zbuffer_bits==sData::ZB_16)
          Button_SetCheck( GetDlgItem(_hdlg,IDC_RADIO_ZBITS_16), BST_CHECKED );
        else
        if (dlgdata->zbuffer_bits==sData::ZB_24)
          Button_SetCheck( GetDlgItem(_hdlg,IDC_RADIO_ZBITS_24), BST_CHECKED );
        else
          Button_SetCheck( GetDlgItem(_hdlg,IDC_RADIO_ZBITS_32), BST_CHECKED );

        // combo box con dispositivos disponibles
        {
          HWND hcombo = GetDlgItem( _hdlg,IDC_DDM );
          // rellenar combo con dispositivos disponibles
          ComboBox_ResetContent( hcombo );
          grx_direct3D::enumDriverDeviceMode( (void*)hcombo, cb_enumDDM );

          // seleccionar dispositivo / modo
          if (dlgdata->szDriverDeviceMode[0]==0)
            ComboBox_SetCurSel( hcombo, 0 ); // por defecto seleccione el primero
          else
            ComboBox_SelectString( hcombo, 0, dlgdata->szDriverDeviceMode );
        }

        // list box con entradas WC
        {
          HWND hlist = GetDlgItem( _hdlg,IDC_LIST_WC );
#ifdef STATICPRUEBAS
          ListBox_ResetContent( hlist );
          pruebas_for_each( (void*)hlist, cb_enumWC );
#else
          EnableWindow( hlist, FALSE );
#endif
        }
        */
      }
      return TRUE;


    case WM_COMMAND :
      switch ( LOWORD(_wparam) )
      {
        case IDOK :
          /*
          {
            // radio ventana / pantalla completa
            dlgdata->coop_mode = 
              Button_GetCheck(GetDlgItem(_hdlg,IDC_RADIO_WINDOW))==BST_CHECKED
              ? sData::COOP_WND : sData::COOP_FULL;

            // checkbox warp
            dlgdata->warp = 
              Button_GetCheck(GetDlgItem(_hdlg,IDC_CHECK_WARP))==BST_CHECKED
              ? true : false;

            // checkbox mnimo detalle
            dlgdata->quickload = 
              Button_GetCheck(GetDlgItem(_hdlg,IDC_CHECK_QUICKLOAD))==BST_CHECKED
              ? true : false;

            // radio sonido on/off
            dlgdata->sound = 
              Button_GetCheck(GetDlgItem(_hdlg,IDC_RADIO_SOUNDON))==BST_CHECKED
              ? sData::SND_ON : sData::SND_OFF;

            // radio bits textura 16/32
            dlgdata->texture_bits = 
              Button_GetCheck(GetDlgItem(_hdlg,IDC_RADIO_TEXTUREBITS_16))==BST_CHECKED
              ? sData::TB_16 : sData::TB_32;

            // radio bits zbuffer 16/24/32
            dlgdata->zbuffer_bits = 
              Button_GetCheck(GetDlgItem(_hdlg,IDC_RADIO_ZBITS_16))==BST_CHECKED
              ? sData::ZB_16 : 
              Button_GetCheck(GetDlgItem(_hdlg,IDC_RADIO_ZBITS_24))==BST_CHECKED
              ? sData::ZB_24 : sData::ZB_32;

            // driver / dispositivo / modo
            ComboBox_GetText( GetDlgItem(_hdlg,IDC_DDM), dlgdata->szDriverDeviceMode, sizeof(dlgdata->szDriverDeviceMode) );

#ifdef STATICPRUEBAS
            // lee estados de WC
            {
              HWND hlist = GetDlgItem( _hdlg,IDC_LIST_WC );
              int n = ListBox_GetCount( hlist );
              for ( int i=0; i<n; ++i )
              {
                void* p = reinterpret_cast<void*>(ListBox_GetItemData(hlist,i));
                pruebas_set_active( p, ListBox_GetSel(hlist,i) ? true : false );
              }
            }
#endif

          }
          dlgdata = 0;
          */                      
            dlgdata->bFullscreen=(Button_GetCheck(GetDlgItem(_hdlg,IDC_WINDOWED))==BST_CHECKED)?false:true;
            

            dlgdata->b16Bit         =Button_GetCheck(GetDlgItem(_hdlg,IDC_16BIT))==BST_CHECKED;
            dlgdata->bAntialias     =Button_GetCheck(GetDlgItem(_hdlg,IDC_ANTIALIAS))==BST_CHECKED;
            dlgdata->b32BitTextures =Button_GetCheck(GetDlgItem(_hdlg,IDC_TEXTURES32))==BST_CHECKED;

            ShaderManager::g_b32BitTextures=dlgdata->b32BitTextures;

            if (Button_GetCheck(GetDlgItem(_hdlg,IDC_HIGHDETAIL))==BST_CHECKED)
            {
              SIZEWIDTH =1024;
              SIZEHEIGHT=1024;
            }
            else
            {
              SIZEWIDTH =512;
              SIZEHEIGHT=512;
            }

            switch (ComboBox_GetCurSel(GetDlgItem( _hdlg,IDC_RESOLUTION )))
            {
            case 0:              
              dlgdata->uResX=640;
              dlgdata->uResY=480;
              break;
            case 1:
              dlgdata->uResX=800;
              dlgdata->uResY=600;
              break;
            case 2:
              dlgdata->uResX=1024;
              dlgdata->uResY=768;
              break;
            case 3:
              dlgdata->uResX=1280;
              dlgdata->uResY=1024;
              break;

            }

            dlgdata->pszIdiom=".txt";
            TextManager::SetLanguage(dlgdata->pszIdiom);  

          EndDialog( _hdlg, IDOK );
          break;

        case IDCANCEL :
          /*
          dlgdata = 0;
          */
          EndDialog( _hdlg, IDCANCEL );
          break;
      }
      break;
  }

  return FALSE;
}


int SmAppPreInit()
{
  /*
  MyDialogData.pszIdiom="";
  MyDialogData.bFullscreen=true;
  MyDialogData.b16Bit=true;
  MyDialogData.bAntialias=false;
  */
  int res = DialogBoxParam(	
                SM_Main::HInstance(),
                MAKEINTRESOURCE(IDD_STARTDIALOG),
                0, /* parent wnd : main win not created yet! */
                (DLGPROC)InitDlgProc,
                (LPARAM)&MyDialogData
              );

  return res==IDOK?0:-1;

  return res;
}

int SmAppInit()
{ 

  MVFS::Init("");

  #ifdef USE_ZIP
  g_iPAK=MVFS::AddPackage(MVFS::E_ZIP, "data.dat");
  #endif

  if (SM_D3d::Init()!=0)
  {
    SM_Main::OutputError("Error initializing d3d ");
    return (-1);
  }

  
  g_bFullscreen=strcmp(SM_Main::CommandLine(), "")?false:true;

  if (SM_D3d::InitDisplay(MyDialogData.uResX, MyDialogData.uResY, 
          MyDialogData.b16Bit?16:32, 
          false, 
          g_bFullscreen==false?g_bFullscreen:MyDialogData.bFullscreen, 
          D3DRequirements, "A8R8G8B8 or A4R4G4B4 Textures and Render to Texture", 
          MyDialogData.bAntialias,
          false)!=0)
  {
    SM_Main::OutputError("Error initializing display");
    return (-1);
  }

  
  SM_Main::SetWindowText("threepixels :: Nature v2.0");
    
  
  if (LoadScript("Data/Script.txt")!=0)
  {
    MessageBox(NULL, "Error initiating demosys. Quitting", "Error", MB_OK);
    return (-1);
  }

  if (ResourceManager::Init()!=0)
  {
    MessageBox(NULL, "Error initiating ResourceManager. Quitting", "Error", MB_OK);
    return (-1);
  }

  if (ShaderManager::Init()!=0)
  {
    SM_Main::OutputError("Error initializing Shader Manager");
    return (-1);
  }
  
  if (ShaderManager::ParseShadersDir("data/shaders/")!=0)
  {
    SM_Main::OutputError("Error parsing shaders");
    return (-1);
  }

  if (g_SceneFilter->Init(true)!=0)
  {
    return -1;
  }
  
  #ifndef RETAIL
  if (DebugText::Init()!=0)
  {
    SM_Main::OutputError("Error initializing debug text. Have you textures/DEBUG_00.TGA?");
    return (-1);
  }
  #endif


  if (ScreenManager::Init()!=0)
  {
    SM_Main::OutputError("Error initializing image manager");
    return (-1);
  }  


  if (TextManager::Init("data/texts/text.txt")!=0)
  {
    SM_Main::OutputError("Error loading data/texts/text.txt");
    return (-1);
  }

	return 0;
}



int SmAppRun()
{
  bool bEscape=false;
     
  #ifdef _DEBUG
  _CrtCheckMemory();
  #endif

  if (g_bActive)
  {
    int iScriptReturn;
    if ((iScriptReturn=SM_DemoScript::RunCommands())==1)
    {      
      SM_DemoScript::RunPreStartFrame(0, MAX_LAYERS);      
      if (SM_D3d::StartFrame()==0)
      {

        SM_D3d::SetRenderState(D3DRS_ALPHATESTENABLE, TRUE);
        SM_D3d::SetRenderState(D3DRS_ALPHAFUNC, D3DCMP_GREATER);
        SM_D3d::SetRenderState(D3DRS_ALPHAREF, 0);
        SM_D3d::SetRenderState(D3DRS_DITHERENABLE, TRUE);
        //float fBias=-0.5f+3.0f*sinf(Timer::GetTime());
        //float fBias=12.0f;
        //SM_D3d::SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));



        if (g_SceneFilter)
        {
          SM_D3d::Device()->Clear(0, NULL, D3DCLEAR_TARGET |D3DCLEAR_ZBUFFER, g_SceneFilter->GetBackColor(), 1.0f, 0 );
        }
        else
        {
          #ifdef _DEBUG
          SM_D3d::Device()->Clear(0, NULL, D3DCLEAR_TARGET |D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0,int(128+127.0f*sinf(Timer::GetTime())),0), 1.0f, 0 );
          #else
          SM_D3d::Device()->Clear(0, NULL, D3DCLEAR_TARGET |D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(255,255,255), 1.0f, 0 );
          #endif
        }

        SM_D3d::Device()->BeginScene();
        

        SM_DemoScript::UpdateTime();
        Timer::SetTime(SM_DemoScript::GetTime());


        RenderPipeline::Flush();
      
        g_SceneFilter->RunPreRender(Timer::GetTime());
        iScriptReturn|=SM_DemoScript::Run(0, 8);

        g_SceneFilter->Run(Timer::GetTime());      
        g_SceneFilter->RunPostRender(Timer::GetTime());

        iScriptReturn|=SM_DemoScript::Run(8, 16);


        Coordinates::UpdatePhysicalSize();
      
        #ifndef RETAIL
        
        static float fFps;
        static int   iFrame=0;
        static DWORD dwLastTime=0;
  
        DWORD dwTime=timeGetTime();
        if (dwTime-dwLastTime>1000)
        {
          fFps=1000.0f*float(iFrame)/float(dwTime-dwLastTime);
          iFrame=0;
          dwLastTime=dwTime;        
        } 
      
        static int g_iPolis;

        g_iPolis=ShaderManager::GetPolygons()-g_iPolis;      
        if (SM_DemoScript::g_bDrawFPS)
        {
          DebugText::RenderText(0, 16, "%.0f fps / Polis %i /MP3 Time: %4.2f s / XM: %i %i", fFps, g_iPolis, g_fMP3Time,g_iPos,g_iRow);
        }
        g_iPolis=ShaderManager::GetPolygons();
        iFrame++;

      
        SM_DemoEffect* pEffect;
      
        if (SM_DemoScript::g_bDrawFPS)
        {
          int iEffects=0;
          for (pEffect=SM_DemoScript::GetFirstActiveEffect() ; pEffect ; pEffect=SM_DemoScript::GetNextActiveEffect())
          {
            DebugText::RenderText(0, 32+16*iEffects, "%s Layer: %i", pEffect->m_pcInstanceName, pEffect->m_iLayer);
            iEffects++;
          }
        }
        #endif
                  

        SM_D3d::Device()->EndScene();
        SM_D3d::Device()->Present( NULL, NULL, NULL, NULL );

        SM_D3d::EndFrame();
        SM_DemoScript::RunPostEndFrame(0, MAX_LAYERS);              
      }    
    }
    else
    {
      switch (iScriptReturn)
      {
      case -1:
        MessageBox(NULL, "Script Runtime Error", "Error", MB_OK);
        bEscape=true;
        break;
      case 0:
        bEscape=true;
      }      
    }
  }
  else
  {
    Sleep(10);
  }  
  

	return (bEscape?0:1);
}

int SmAppEnd()
{
  if (TextManager::Shutdown()!=0)
  {
    return -1;
  }

  if (ScreenManager::Shutdown()!=0)
  {
    return (-1);
  }

  #ifndef RETAIL  
  if (DebugText::Shutdown()!=0)
  {
    return (-1);
  }
  #endif  

  SM_DemoScript::Shutdown();

  if (g_SceneFilter->Init()!=0)
  {
    return (-1);
  }
  
  ShaderManager::Shutdown();

  
  ResourceManager::Shutdown();
   

  
  SM_Main::SetKeyboardHandler(0);

  

  SM_D3d::ShutdownDisplay();

  
  SM_D3d::Shutdown();

   
  ShutdownMusic(&MainModule);
  
  #ifdef USE_ZIP
  if (g_iPAK!=-1)
  {  
    MVFS::RemovePackage(g_iPAK);
  }  
  #endif

  MVFS::Shutdown();

	return 0;
}