#ifndef __MVFSZIPPACK

#define __MVFSZIPPACK

#include "MVFSPack.h"
#include "unzip.h"
#include "MAVLTree.h"



class MVFSZipPack : public MVFSPack
{
public:
                MVFSZipPack   ();
                ~MVFSZipPack  ();

  int           Init          (char* pcBase);
  int           Shutdown      ()            ;

  MVFSFILE*     fopen         (const char* pcFileName, const char* pcFileAttrib);
  int           fclose        (MVFSFILE* pFile);

  int           findfilestart (char* pcPath, char* pcFilter);
  int           findfileget   (char* pcPath);
  int           findfileend   ();

protected:

  char          m_pcZipFileName[256];
  char          m_pcBasePath[256];
  unzFile       m_zipFile;


  struct sFileName
  {
    char*       pcName;
    bool        operator<(const sFileName& sOther) const;
    bool        operator==(const sFileName& sOther) const;   
  };

  struct sFileEntry
  {
    char*  pcName;
    int    iFile;
    int    iPosition;
  };

  int   m_iFindIterator;
  char  m_pcFindPath[256];
  char  m_pcFilter[256];

  sFileEntry*   FindFile    (const char* pcFileName);
  int           FindFileID  (const char* pcFileName);
  MAVLTree<sFileName, sFileEntry> m_avlFiles;

};


#endif