
#include "SM_Engine3DPCH.h"

#include "SM_DebugText.h"

struct GlyphDescriptor
{
  int ascii, m_fx, m_fy, dx, dy, m_fxBase, m_fyBase, width, m_fBBx, m_fBBy, m_fBBw, m_fBBh;
};

#define GLYPHS 91
GlyphDescriptor Glyphs[GLYPHS]=
{
  { 0x20, 0, 0, 16, 16, 5, 11, 6, 0, 0, 1, 1,             },  
  { 0x21, 16, 0, 16, 16, 6, 13, 3, 1, -11, 2, 11,         },
  { 0x22, 32, 0, 16, 16, 5, 13, 6 ,1, -11, 5, 4,          },
  { 0x23, 48, 0, 16, 16, 2, 14, 12, 0, -12, 11, 12,       },
  { 0x24, 64, 0, 16, 16, 3, 14, 10, 0, -13, 9, 15,        },
  { 0x25, 80, 0, 16, 16, 2, 13, 11, 0, -11, 10 ,11,       },
  { 0x26, 96, 0, 16, 16, 3, 13, 9, 0, -11, 9, 11,         },
  { 0x27, 112, 0, 16, 16, 5, 13, 6, 2, -11, 2, 4,         },
  { 0x28, 128, 0, 16, 16, 5, 12, 5, 1, -11, 4, 15,},
  { 0x29, 144, 0, 16, 16, 5, 12, 5, 0, -11, 4, 15,},
  { 0x2a, 160, 0, 16, 16, 4, 13, 7, 0, -11, 7, 6,},
  { 0x2b, 176, 0, 16, 16, 3, 13, 9, 1, -8, 6, 6,},
  { 0x2c, 192, 0, 16, 16, 5, 8, 6, 1, -1, 3, 3,},
  { 0x2d, 208, 0, 16, 16, 3, 10, 9, 2, -5, 5, 2,},
  { 0x2e, 224,0, 16, 16, 5, 9 ,6, 2, -2, 2, 2,},
  { 0x2f, 240, 0, 16, 16, 4, 13, 7, 0, -11, 7, 12,},
  { 0x30, 0, 16, 16, 16, 3, 13, 9, 1, -11, 7, 11,},
  { 0x31, 16, 16, 16, 16, 3, 13, 9, 1, -11, 6, 11,},
  { 0x32, 32, 16, 16, 16, 3, 13, 9, 1, -11, 7, 11,},
  { 0x33, 48, 16, 16, 16, 3, 13, 9, 1, -11, 7, 11,},
  { 0x34, 64, 16, 16, 16, 3, 13, 9, 0, -11, 9, 11,},
  { 0x35, 80, 16, 16, 16, 3, 13, 9, 1, -11, 7, 11,      },
  { 0x36, 96, 16, 16, 16,  3, 13, 9, 1, -11, 7 ,11,},
  { 0x37, 112, 16, 16, 16, 3, 13, 9, 1, -11, 8, 11,},
  { 0x38, 128, 16, 16, 16, 3, 13, 9, 1, -11, 7, 11,},
  { 0x39, 144, 16, 16, 16, 3, 13, 9, 1, -11, 7, 11,},
  { 0x3a, 160, 16, 16, 16, 5, 11, 6, 2, -7, 2, 6,},
  { 0x3b, 176, 16, 16, 16, 5, 11, 6, 1, -7, 3, 9,},
  { 0x3c, 192, 16, 16, 16, 3, 11, 9, 2, -7, 5, 6,     },
  { 0x3d, 208, 16, 16, 16, 3, 12, 9, 1, -8, 5, 6,},
  { 0x3e, 224, 16, 16, 16, 3, 11, 9, 2, -7, 5, 6,},
  { 0x3f, 240, 16, 16, 16, 4, 13, 8, 0, -11, 7, 11,},
  { 0x40, 0, 32,16, 16, 1, 13, 13, 0, -11, 12, 12,},
  { 0x41, 16, 32, 16, 16, 3, 13, 10, 1, -11, 9, 11,},
  { 0x42, 32, 32, 16, 16, 3, 13, 9, 1, -11, 8, 11,},
  { 0x43, 48, 32, 16, 16, 3, 13, 9, 0, -11, 8, 11,        },
  { 0x44, 64, 32, 16, 16, 3, 13, 10, 1, -11, 8, 11,},
  { 0x45, 80, 32, 16, 16, 3, 13, 9, 1, -11, 7, 11,},
  { 0x46, 96, 32, 16, 16, 3, 13, 9, 1, -11, 7, 11,},
  { 0x47, 112, 32, 16, 16, 3, 13, 10, 0, -11, 9, 11,},
  { 0x48, 128, 32, 16, 16, 2, 13, 11, 1, -11, 9, 11,},
  { 0x49, 144, 32, 16, 16, 4, 13, 8, 1, -11, 6, 11,}, 
  { 0x4a, 160, 32, 16, 16, 3, 13, 9, 1, -11, 8, 12,   },
  { 0x4b, 176, 32, 16, 16, 3, 13, 9, 1, -11, 8, 11,},
  { 0x4c, 192, 32, 16, 16, 4, 13, 8, 1, -11, 7, 11,},
  { 0x4d, 208, 32 ,16, 16, 2, 13, 12, 0, -11, 11, 11,},
  { 0x4e, 224, 32, 16, 16, 2, 13, 11, 1, -11, 9, 11,},
  { 0x4f, 240, 32, 16, 16, 2, 13, 11, 0, -11, 11, 11,},
  { 0x50, 0, 48, 16, 16, 4, 13, 7, 0, -11, 6 ,11,},
  { 0x51, 16, 48, 16, 16, 2, 12, 12, 0, -11, 12, 14,    },
  { 0x52, 32, 48, 16, 16, 3, 13, 9, 1, -11, 8, 11,},
  { 0x53, 48, 48, 16, 16, 3, 13, 10, 0, -11, 8, 11,},
  { 0x54, 64, 48, 16, 16, 3, 13, 10, 0, -11, 10, 11,},
  { 0x55, 80, 48, 16, 16, 3, 13, 10, 1, -11, 8, 11,},
  { 0x56, 96, 48, 16, 16, 3, 13, 9, 1, -11, 8, 11,},
  { 0x57, 112, 48, 16, 16, 0, 13, 15, 0, -11, 14, 11,},
  { 0x58, 128, 48, 16, 16, 3, 13, 10, 0, -11, 10, 11, },
  { 0x59, 144, 48, 16, 16, 3, 13, 9, 0, -11, 9, 11,},
  { 0x5a, 160, 48, 16, 16, 3, 13, 10, 0, -11, 9, 11,},
  { 0x5b, 176, 48, 16, 16, 5, 12, 5, 1, -11, 4, 15,},
  { 0x5c, 192, 48, 16, 16, 4, 13, 8, 1, -11, 6, 12,},
  { 0x5d, 208, 48, 16, 16, 5, 12, 5, 0 ,-11, 4, 15,},
  { 0x5e, 224, 48, 16, 16, 3, 13, 9, 2, -11, 6, 3,},
  { 0x5f, 240, 48, 16, 16, 3, 7, 9, -1, 1, 10, 1,               },
  { 0x60, 0, 64, 16, 16, 4, 13, 8, 0, -11, 4, 3,},
  { 0x61, 16, 64, 16, 16, 4, 11, 8, 0, -7, 7, 7,},
  { 0x62, 32, 64, 15, 16, 4, 13, 8, 1, -11, 6, 11,},
  { 0x63, 48, 64, 16, 16, 4, 11, 7, 0, -7, 6, 7,},
  { 0x64, 64, 64, 16, 16, 4, 13, 8, 0, -11, 7, 11,},
  { 0x65, 80, 64, 16, 16, 4, 11, 8, 0, -7, 7, 7,},
  { 0x66, 96, 44, 16, 16, 4, 13, 7, 0, -11, 7, 12,      },
  { 0x67, 112, 64, 16, 16, 4, 10, 7, 0, -7, 6, 11,},
  { 0x68, 128, 64, 16, 16, 4, 13, 8, 1, -11, 6, 11,},
  { 0x69, 144, 64, 16, 16, 6, 13, 4, 1, -10, 2, 10,},
  { 0x6a, 160, 64, 16, 16, 5, 11, 6, 0, -10, 5, 14,},
  { 0x6b, 176, 64, 16, 16, 4, 13, 8, 0, -11, 7, 11,},
  { 0x6c, 192, 64, 16, 16, 6, 13, 4, 1, -11, 2, 11,},
  { 0x6d, 208, 64, 16, 16, 2, 11, 11, 0, -7, 10, 7, },
  { 0x6e, 224, 64, 16, 16, 4, 11, 7, 0, -6, 6, 7,},
  { 0x6f, 240, 64, 16, 16, 4, 11, 7, 0, -7, 6, 7,},
  { 0x70, 0, 80, 16, 16, 4, 10, 7, 0, -7, 6, 11,},
  { 0x71, 16, 80, 16, 16, 4, 10, 7, 0, -7, 6, 11,},
  { 0x72, 32, 80, 16, 16, 4, 11, 7, 0, -7, 6, 7,},
  { 0x73, 48, 80, 16, 16, 4, 11, 7, 0, -7, 6, 7,},
  { 0x74, 64, 80, 16, 16, 4, 12, 7, 0, -9, 6, 9,    },
  { 0x75, 80, 80, 16, 16, 4, 11, 7, 0, -7, 6, 7,},
  { 0x76, 96, 80, 16, 16, 4, 11, 7, 0, -7, 7, 7,},
  { 0x77, 112, 80, 16, 16, 3, 11, 10, 0, -7, 10, 7,},
  { 0x78, 128, 80, 16, 16, 4, 11, 8, 0, -7, 7, 7,},
  { 0x79, 144, 80, 16, 16, 4, 10, 8, -7, 8, 11,},
  { 0x7a, 160, 80, 16, 16, 4, 11, 8, 0, -7, 7, 7,},
}; 


namespace DebugText
{
  int IndexLUT[256];
  int g_iTextureID=-1;

  int Init              ()
  {
    memset(IndexLUT, -1, 256*sizeof(int));

    if ( (g_iTextureID=ShaderManager::LoadShader("DEBUG_00")) == -1)
    {
      return -1;
    }

    int i;

    for (i=0 ; i<GLYPHS ; i++)
    {
      IndexLUT[Glyphs[i].ascii]=i;
    }

    
    return 0;
  }

  int Shutdown          ()
  {
    if (g_iTextureID!=-1)
    {
      ShaderManager::ReleaseShader(g_iTextureID);
    }
    return 0;
  }

  int FillQuad(float x, float y, float fsx, float fsy, unsigned uColor, FVF_PosNormalDiffuseTex1* pv, GlyphDescriptor* pCharacter)
  {
    float fSubPixelOffsetX=-0.5f;
    float fSubPixelOffsetY=-0.5f;

    pv[0].x      =x+(pCharacter->m_fBBx)*fsx+fSubPixelOffsetX;
    pv[0].y      =y+(pCharacter->m_fBBy)*fsy+fSubPixelOffsetY;
    pv[0].z      =0.0f;

    pv[0].diffuse=uColor;
    pv[0].u      =(pCharacter->m_fx+pCharacter->m_fxBase+pCharacter->m_fBBx)/256.0f;
    pv[0].v      =(pCharacter->m_fy+pCharacter->m_fyBase+pCharacter->m_fBBy)/256.0f;

    // Arriba derecha
    pv[1].x     =x+(pCharacter->m_fBBx+pCharacter->m_fBBw)*fsx+fSubPixelOffsetX;
    pv[1].y     =y+(pCharacter->m_fBBy)*fsy+fSubPixelOffsetY;
    pv[1].z     =0.0f;
    pv[1].diffuse=uColor;
    pv[1].u     =(pCharacter->m_fx+pCharacter->m_fxBase+pCharacter->m_fBBx+pCharacter->m_fBBw)/256.0f;
    pv[1].v     =(pCharacter->m_fy+pCharacter->m_fyBase+pCharacter->m_fBBy)/256.0f;

    pv[2].x     =x+(pCharacter->m_fBBx)*fsx+fSubPixelOffsetX;
    pv[2].y     =y+(pCharacter->m_fBBy+pCharacter->m_fBBh)*fsy+fSubPixelOffsetY;
    pv[2].z     =0.0f;
    pv[2].diffuse=uColor;
    pv[2].u     =(pCharacter->m_fx+pCharacter->m_fxBase+pCharacter->m_fBBx)/256.0f;
    pv[2].v     =(pCharacter->m_fy+pCharacter->m_fyBase+pCharacter->m_fBBy+pCharacter->m_fBBh)/256.0f;
  
    // Arriba derecha
    pv[3].x     =x+(pCharacter->m_fBBx+pCharacter->m_fBBw)*fsx+fSubPixelOffsetX;
    pv[3].y     =y+(pCharacter->m_fBBy+pCharacter->m_fBBh)*fsy+fSubPixelOffsetY;
    pv[3].z     =0.0f;
    pv[3].diffuse=uColor;    
    pv[3].u     =(pCharacter->m_fx+pCharacter->m_fxBase+pCharacter->m_fBBx+pCharacter->m_fBBw)/256.0f;
    pv[3].v     =(pCharacter->m_fy+pCharacter->m_fyBase+pCharacter->m_fBBy+pCharacter->m_fBBh)/256.0f;

    /*
    pv[0].x=  0.0f; pv[0].y=  0.0f;
    pv[1].x=100.0f; pv[1].y=  0.0f;
    pv[2].x=  0.0f; pv[2].y=100.0f;
    pv[3].x=100.0f; pv[3].y=100.0f;


    pv[0].u=0.0f; pv[0].v=0.0f;
    pv[1].u=1.0f; pv[1].v=0.0f;
    pv[2].u=0.0f; pv[2].v=1.0f;
    pv[3].u=1.0f; pv[3].v=1.0f;
    */

    return (0);
  }

  void SetD3DDeviceState()
  {
    SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);
    SM_D3d::Device()->SetTransform(D3DTS_VIEW, (D3DMATRIX*)&Matrix4X4::Identity);  
    SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          

    SM_D3d::SetRenderState(D3DRS_FOGENABLE, FALSE);  
    SM_D3d::SetRenderState(D3DRS_SPECULARENABLE , FALSE);
    SM_D3d::SetRenderState(D3DRS_LOCALVIEWER , FALSE);
    SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);  

    SM_D3d::Device()->SetVertexShader(FVF_POSNORMALDIFFUSETEX1);                            
    //SM_D3d::Device()->SetVertexShader(FVF_POSRHWDIFFUSETEX1);
    D3DMATERIAL8 Material;
    Material.Diffuse.r=Material.Diffuse.g=Material.Diffuse.b=Material.Diffuse.a=1.0f;
    Material.Ambient.r=Material.Ambient.g=Material.Ambient.b=Material.Ambient.a=1.0f;
    Material.Specular.r=Material.Specular.g=Material.Specular.b=Material.Specular.a=1.0f;
    Material.Emissive.r=Material.Emissive.g=Material.Emissive.b=Material.Emissive.a=0.0f;
    Material.Power=0.0f;
    SM_D3d::Device()->SetMaterial(&Material);


    float fBias=0.0f;
    SM_D3d::SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));


    Matrix4X4 m;

    float w =2.0f/640.0f;
    float h =-2.0f/480.0f;
    float dw=-1.0f;
    float dh=1.0f;

    m.m_11=w             ; m.m_12=0.0f; m.m_13=0.0f         ; m.m_14=0.0f;
    m.m_21=0.0f          ; m.m_22=h   ; m.m_23=0.0f         ; m.m_24=0.0f;
    m.m_31=0.0f          ; m.m_32=0.0f; m.m_33=1.0f         ; m.m_34=0.0f;
    m.m_41=dw            ; m.m_42=dh  ; m.m_43=0.0f         ; m.m_44=1.0f;

    SM_D3d::Device()->SetTransform(D3DTS_WORLD, (D3DMATRIX*) &Matrix4X4::Identity);      
    SM_D3d::Device()->SetTransform(D3DTS_PROJECTION, (D3DMATRIX*)&m);  
    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
    
    SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);
    SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP , D3DTOP_MODULATE);
    SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
    SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
    SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
    SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);
  
  }

  int __cdecl RenderText(int x, int y, const char* pcText, ... )
  {
    #define MAX_LENGTH 1024

    static FVF_PosNormalDiffuseTex1 pVertices[MAX_LENGTH];
    static unsigned short           pIndices[MAX_LENGTH*6];


    char pcAuxBuffer[MAX_LENGTH];
    va_list lst;	
	  va_start (lst, pcText);
	  vsprintf( pcAuxBuffer, pcText, lst);
	  va_end (lst);

    strupr(pcAuxBuffer);
    pcAuxBuffer[MAX_LENGTH-1]=0;

    
    int iLength=strlen(pcAuxBuffer);
    

    float fCurrentX=float(x);    
    int   iWritten=0;

    for (int i=0 ; i<iLength ; i++)
    {
      int iGlyph=IndexLUT[pcAuxBuffer[i]];

      if (iGlyph!=-1)
      {
        FillQuad(fCurrentX, float(y), 1.0f, 1.0f, 0xFFFFFFFF, pVertices+iWritten*4, &Glyphs[iGlyph]);

        fCurrentX+=Glyphs[iGlyph].width;

        pIndices[iWritten*6  ]=iWritten*4;
        pIndices[iWritten*6+1]=iWritten*4+1;
        pIndices[iWritten*6+2]=iWritten*4+2;
        pIndices[iWritten*6+3]=iWritten*4+1;
        pIndices[iWritten*6+4]=iWritten*4+2;
        pIndices[iWritten*6+5]=iWritten*4+3;

        iWritten++;
      }
    }


    

    MeshElement me;
    me.m_iIB              =-1;
    me.m_iVB              =-1;
    me.m_pVertices        =pVertices; 
    me.m_pIndices         =pIndices;
    me.m_uStartVertex     =0;
    me.m_uVertices        =iWritten*4;
    me.m_uStartIndex      =0;
    me.m_uPrimitives      =iWritten*2;
    me.m_WorldTransform   =Matrix4X4::Identity;
    me.m_uActiveLightMask =0;
    me.m_fDepth           =0;          
    me.m_iShader          =g_iTextureID;

    SetD3DDeviceState();
    RenderPipeline::Render(&me);
    RenderPipeline::Flush();
    

    
    return 0;
  }
};

