#include "SM_Engine3DPCH.h"
#include "SM_D3DMesh.h"
#include "SM_KeyFrameSequence.h"
#include "SM_KeyFrame.h"
#include "SM_Mesh.h"


D3DMesh::D3DMesh()
{  
  m_pKeyFrameSequence=0;
  m_pD3DGeometry=0;
  m_pParent=0;
  m_bVisible=true;
}

D3DMesh::~D3DMesh()
{
  Shutdown();
}

int  D3DMesh::Init()
{
  return (0);
}

int  D3DMesh::Shutdown()
{
  return (0);
}

void DrawTriangle(float x1, float y1, float fRadius)
{
  FVF_PosRhwDiffuseTex1 pVertices[4];
  unsigned short        pIndices[6]={0,1,2,1,2,3};


  pVertices[0].x=x1  ;       pVertices[0].y=y1;         pVertices[0].oow=pVertices[0].z=1.0f; pVertices[0].u=pVertices[0].v=0.0f; pVertices[0].diffuse=0xFF000000;
  pVertices[1].x=x1+fRadius; pVertices[1].y=y1;         pVertices[1].oow=pVertices[1].z=1.0f; pVertices[1].u=pVertices[1].v=0.0f; pVertices[1].diffuse=0xFF000000;
  pVertices[2].x=x1;         pVertices[2].y=y1+fRadius; pVertices[2].oow=pVertices[2].z=1.0f; pVertices[2].u=pVertices[2].v=0.0f; pVertices[2].diffuse=0xFF000000;
  pVertices[3].x=x1+fRadius; pVertices[3].y=y1+fRadius; pVertices[3].oow=pVertices[3].z=1.0f; pVertices[3].u=pVertices[3].v=0.0f; pVertices[3].diffuse=0xFF000000;

  
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP   , D3DTOP_SELECTARG1);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP   , D3DTA_DIFFUSE);
  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAOP   , D3DTOP_SELECTARG1);
  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAARG1 , D3DTA_DIFFUSE);  
  SM_D3d::SetRenderState(D3DRS_FILLMODE, D3DFILL_SOLID);
  SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
  SM_D3d::SetRenderState(D3DRS_ZWRITEENABLE, D3DZB_TRUE);
  
  SM_D3d::SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE );    
  SM_D3d::Device()->SetVertexShader(FVF_POSRHWDIFFUSETEX1);
  
  
  SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,
      6,
      2,
      pIndices,
      D3DFMT_INDEX16,
      pVertices, sizeof(FVF_PosRhwDiffuseTex1)); 


  SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);
  SM_D3d::SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);
  SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          

}

void D3DMesh::GetKeyFrame(float fTime, Vector3D* pV3d, Quaternion* pQ)
{
  if (m_pKeyFrameSequence)
  {
    KeyFrame CurrentKeyFrame;    
    m_pKeyFrameSequence->GetKeyFrame(Timer::GetTime(), m_fKeyFrameSequenceStartTime, pV3d, pQ);    
  }
  else
  {     
    *pV3d=m_Position;
    *pQ  =m_Quaternion;
  }
}

void D3DMesh::Render(RenderContext* pRenderContext, unsigned uOutcode)
{
  int i;   

  if (!m_bVisible)
  {
    return;
  }

  if (m_pKeyFrameSequence)
  {
    KeyFrame CurrentKeyFrame;    
    m_pKeyFrameSequence->GetKeyFrame(Timer::GetTime(), m_fKeyFrameSequenceStartTime, &CurrentKeyFrame);

    ToTransform(&m_WorldTransform, &CurrentKeyFrame.m_Position, &CurrentKeyFrame.m_Rotation);        
    m_Position=CurrentKeyFrame.m_Position;         
  }
  else
  { 
    ToTransform(&m_WorldTransform, &m_Position, &m_Quaternion);                
  }
  
  /*
  */

  if (m_pParent)
  {
    Matrix4X4 Temp;

    /*
    Matrix4X4 Pivot;
    ToTransform(&Pivot, &m_PivotPosition, &Quaternion::IDENTITY);
    Temp=m_WorldTransform;
    Matrix4X4::Mult(&m_WorldTransform, &Temp, &Pivot);
    */
  
    Temp=m_WorldTransform;
    Matrix4X4::Mult(&m_WorldTransform, &Temp, &m_pParent->m_WorldTransform);
  }


  m_Position=Vector3D(m_WorldTransform.m_41,
                      m_WorldTransform.m_42,
                      m_WorldTransform.m_43);
                      
  

  
  /*
  Matrix4X4 m, n, Aux;
  pRenderContext->GetViewport()->ViewMatrix(m);
  pRenderContext->GetViewport()->ProjectionMatrix(n);

    Matrix4X4::Mult(&Aux, &m, &n);


  Vector3D Vertex(m_pD3DGeometry->m_pMeshElements[0].m_pVertices[0].x,
                  m_pD3DGeometry->m_pMeshElements[0].m_pVertices[0].y,
                  m_pD3DGeometry->m_pMeshElements[0].m_pVertices[0].z);

  Vector3D v1;
  Vector3D v2;

  //Vertex=m_Position;

  m_WorldTransform.Transform(&v1, &Vertex, 1);
  Aux.Transform(&v2, &v1, 1);
  v2.x=v2.x*320.0f+320.0f;
  v2.y=v2.y*240.0f+240.0f;

  DrawTriangle(v2.x, v2.y, 20.0f);
  */

  if (m_Sons.size())
  {
    unsigned uSons=m_Sons.size();

    for (i=0 ; i<uSons ; i++)
    {
      m_Sons[i]->Render(pRenderContext, -1);
    }
  }

  if (pRenderContext->OutcodeSphere(&m_Position, m_pD3DGeometry->m_fRadius)==-1)
  {
    return;
  }

  for (i=0 ; i<m_pD3DGeometry->m_uMeshElements ; i++)
  {            
    m_pD3DGeometry->m_pMeshElements[i].m_fDepth=
      (m_Position-pRenderContext->GetViewport()->m_v3dPosition-
       pRenderContext->m_VPN).Length();


    m_pD3DGeometry->m_pMeshElements->m_WorldTransform=m_WorldTransform;
    RenderPipeline::Render(&(m_pD3DGeometry->m_pMeshElements[i]));
  }  
}




