#include "SM_CommonFXPCH.h"
#include "SM_Engine3DPCH.h"
#include "FXEscena3D.h"
#include "SM_ParticleSystem.h"



/*
    RenderContext RC;   

    RC.Set(
    Vector3D(0.0f, 0.0f, 0.0f),
    Quaternion(1.0f, 0.0f, 0.0f, 0.0f),
    90,
    0.75f,
    1.0f,
    200.0f);
  
    RC.SetViewport(0, 0, 640, 480);
    RC.SyncRasterizer();
    RC.UpdateFrustum();
   

    D3DVIEWPORT8 Viewport;
    Viewport.X      =0;
    Viewport.Y      =0;
    Viewport.Width  =640;
    Viewport.Height =480;
    Viewport.MinZ   =0.0f;
    Viewport.MaxZ   =1.0f;

    SM_D3d::Device()->SetViewport(&Viewport);  

    MeshElement me;

    FVF_PosNormalDiffuseTex1 pVertices[3];
    unsigned short pusIndices[3]={0,2,1};

    pVertices[0].x=0.0f; pVertices[0].y=0.0f; pVertices[0].z=10.0f; 
    pVertices[0].nx=0.0f; pVertices[0].ny=0.0f; pVertices[0].nz=1.0f;
    pVertices[0].u=0.0f; pVertices[0].v=0.0f; pVertices[0].diffuse=0xFFFFFFFF;

    pVertices[1].x=0.0f; pVertices[1].y=10.0f; pVertices[1].z=10.0f; 
    pVertices[1].nx=0.0f; pVertices[1].ny=0.0f; pVertices[1].nz=1.0f;
    pVertices[1].u=0.0f; pVertices[1].v=0.0f; pVertices[1].diffuse=0xFFFFFFFF;

    pVertices[2].x=10.0f; pVertices[2].y=10.0f; pVertices[2].z=10.0f; 
    pVertices[2].nx=1.0f; pVertices[2].ny=0.0f; pVertices[2].nz=0.0f;
    pVertices[2].u=0.0f; pVertices[2].v=0.0f; pVertices[2].diffuse=0xFFFFFFFF;
    
    me.m_iShader            =m_iShader;
    me.m_iVB                =-1;
    me.m_iIB                =-1;
    me.m_pVertices          =pVertices; 
    me.m_pIndices           =pusIndices;
    me.m_uStartVertex       =0;
    me.m_uVertices          =3;
    me.m_uStartIndex        =0;
    me.m_uPrimitives        =1;
    me.m_WorldTransform     =Matrix4X4::Identity;
    me.m_uActiveLightMask   =-1;  
    me.m_fDepth             =0.0f;

    RenderPipeline::Render(&me);
    RenderPipeline::Flush();
    */

class ParticulasFX : public SM_DemoEffect
{
public:              
  ParticulasFX(char const* pcName) : SM_DemoEffect(pcName)
  {
    m_pEscenaTarget=0;
    m_pcTargetName[0]=0;
  }

  virtual          ~ParticulasFX()
  {
  }

  int      Init()
  {
    m_iShader=ShaderManager::LoadShader("firework");
    m_ParticleSystem.Init();
    m_ParticleSystem.m_iShader=m_iShader;


    return (0);
  }

  int      Shutdown()
  {
    return (0);
  }

  int      Start(float fTime)
  {
    
    //MSurface s;
    //s.Load("data/textures/firework.bmp");
    return (0);
  }

  int      Stop()
  {
    return (0);
  }

  int      Run(float fTime)
  {
    RenderContext RC;   

    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_CLAMP);
    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_CLAMP);
    SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_POINT);
    SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_POINT);  
    SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);

  

    RC.Set(
    Vector3D(512.0f, 259.0f, 32.97f),
    Quaternion(0.701037f, 0.123466f, -0.691710f, 0.121823f),
    65.4f,
    0.75f,
    1.0f,
    1842.0f);
  
    RC.SetViewport(0, 0, 640, 480);
    RC.SyncRasterizer();
    RC.UpdateFrustum();
   
    

    // Context
    //m_pEscenaTarget->GetScene()->UpdateRC(&RC, fTime);
    
    // Render
    D3DMesh* pMesh=m_pEscenaTarget->GetScene()->GetMesh(m_pcTargetName);
    if (!pMesh)
    {
      SM_Main::OutputError("la escena asignada no tiene un objeto que se llame %s", m_pcTargetName);
      return -1;
    }
    
    Vector3D    v;
    Quaternion  q;

    Matrix4X4 m_Transform;
    pMesh->GetKeyFrame(fTime, &v, &q);
    ToTransform(&m_Transform, &v, &q);            

    m_ParticleSystem.m_v3dSource=v;
    m_ParticleSystem.Render(&RC, -1);
    

    /*
    for (iIterator=ParticleList.First() ; iIterator!=-1 ; iIterator=iNext)
    {
      iNext=ParticleList.Next(iIterator);

      Particle* pParticle;
      ParticleList.Get(iIterator, pParticle);

      if (fTime >= pParticle->fDeath)
      {
        ParticleList.Delete(iIterator);
      }
      else
      {
        float x,y,z;

        float fLive=fTime-pParticle->fBirth;
        x=pParticle->v3dStart.x+fLive*pParticle->v3dVelocity.x;
        y=pParticle->v3dStart.y+fLive*pParticle->v3dVelocity.y;
        z=pParticle->v3dStart.z+fLive*pParticle->v3dVelocity.z-fLive*fLive*9.8;
        //x=0;
        //y=0;
        //z=5.0f+2.0f*sinf(fTime);


        FVF_PosNormalDiffuseTex1* pVertex;
        unsigned short*           pusIndices;
        int      iVertexOffset, iIndexOffset;        

        if ((iVertexOffset=ResourceManager::GiveVBChunk(ResourceManager::m_iPosNormalDiffuseTex1Stream, 3*sizeof(FVF_PosNormalDiffuseTex1), (void**)&pVertex))==-1)
        {
          assert(0);
          continue;
        }

        pVertex[0].x=x;     pVertex[0].y=y; pVertex[0].z=z;
        pVertex[0].nx=0.0f; pVertex[0].ny=0.0f; pVertex[0].ny=0.0f;
        pVertex[0].diffuse=0xFFFFFFFF; pVertex[0].u=0.0f;  pVertex[0].v=0.0f, 

        pVertex[1].x=x+v3dRight.x;     pVertex[1].y=y+v3dRight.y; pVertex[1].z=z+v3dRight.z;
        pVertex[1].nx=0.0f; pVertex[1].ny=0.0f; pVertex[1].ny=0.0f;
        pVertex[1].diffuse=0xFFFFFFFF; pVertex[1].u=2.0f;  pVertex[1].v=0.0f, 

        pVertex[2].x=x+v3dUp.x;     pVertex[2].y=y+v3dUp.y; pVertex[2].z=z+v3dUp.z;
        pVertex[2].nx=0.0f; pVertex[2].ny=0.0f; pVertex[2].ny=0.0f;
        pVertex[2].diffuse=0xFFFFFFFF; pVertex[2].u=0.0f;  pVertex[2].v=2.0f, 
        

        ResourceManager::DoneVBChunk(ResourceManager::m_iPosNormalDiffuseTex1Stream);

        if ((iIndexOffset=ResourceManager::GiveIBChunk(ResourceManager::m_iIndexStream, 3*sizeof(unsigned short), (void**)&pusIndices))==-1)
        {
          assert(0);
          continue;
        }

        pusIndices[0]=0;
        pusIndices[1]=1;
        pusIndices[2]=2;

        ResourceManager::DoneIBChunk(ResourceManager::m_iIndexStream);

        unsigned uStartIndex =iIndexOffset/sizeof(unsigned short);
        unsigned uStartVertex=iVertexOffset/sizeof(FVF_PosNormalDiffuseTex1);


        SM_D3d::Device()->SetStreamSource(
          0, 
          ResourceManager::GetVertexBufferFromID(ResourceManager::m_iPosNormalDiffuseTex1Stream), 
          sizeof(FVF_PosNormalDiffuseTex1));
        
        SM_D3d::Device()->SetIndices(
        ResourceManager::GetIndexBufferFromID(ResourceManager::m_iIndexStream), uStartVertex);


        SM_D3d::Device()->DrawIndexedPrimitive(
          D3DPT_TRIANGLELIST, 
          0,
          3,
          uStartIndex,
          1);        
      }
    }


    
    */

    return (1);
  }

  int      Command           (float fTime, const char* pcCommand)
  {
    SM_DemoEffect::Command(fTime, pcCommand);

    char* pcToken;

    char* pcAux=new char[strlen(pcCommand)+1];
    strcpy(pcAux, pcCommand);

    pcToken=strtok(pcAux, " \t");    

    if (strcmp(pcToken, "SETTARGET")==0)
    {
      pcToken=strtok(0, " \t");

      m_pEscenaTarget=(Escena3D*) GetEffect(pcToken);
      if (!m_pEscenaTarget)
      {
        SM_Main::OutputError("Escena %s no existe!", pcToken);
        return -1;
      }

      pcToken=strtok(0, " \t");
      strcpy(m_pcTargetName, pcToken);
    }
    return (0);
  }  

  int m_iShader;
  //MBStaticList<Particle> ParticleList;
  RenderParticleSystem    m_ParticleSystem;
  Escena3D*               m_pEscenaTarget;
  char                    m_pcTargetName[256];
  
};

DEFINE_EFFECT(ParticulasFX)
ParticulasFX Particulas("PARTICULAS");

