#include "SM_CommonFXPCH.h"
#include "SM_Engine3DPCH.h"
#include "MgcNaturalSpline3.h"
#include "SM_Spline.h"
#include "MBinArray.h"



struct GRIDCELL
{
   float*    f[8];
};



#define     MAX_BATCH 1000




#define SIZE      64   /*32*/
#define DELTA     0.05f  
#define DELTA2 DELTA*1.1f
    
#define BALLWIDTH 14
//#define ISOVALUE  0.09f
#define ISOVALUE  0.1f

#define NBOLAS    5

Vector3D v3dBolas[NBOLAS];

float  m_fGrid[SIZE*SIZE*SIZE];


struct Metaball
{
  void    Init()
  {
    int i,j,k;    
    float* pf=m_fValues;

    for (k=0 ; k<BALLWIDTH ; k++)
    {
      for (j=0 ; j<BALLWIDTH ; j++)
      {
        for (i=0 ; i<BALLWIDTH ; i++)
        {
          float x, y, z;

          x=float(i-BALLWIDTH/2)*DELTA;
          y=float(j-BALLWIDTH/2)*DELTA;
          z=float(k-BALLWIDTH/2)*DELTA;

          

          float fSqrDst=x*x+y*y+z*z;
          float fScalar;
          /*
          if (!fSqrDst)
          {
            fScalar=0.0f;//FLT_MAX;
          }
          else
          {
              fScalar=max(0, (BALLWIDTH/2)*DELTA-sqrtf(fSqrDst));

          }
          */
          //if (j+k==16) fScalar=ISOVALUE; else fScalar=0;

          if (fSqrDst)
          {
            fScalar=0.005f/fSqrDst;
          }
          else
          {
            fScalar=0.0f;
          }
          
          *pf++=fScalar;

          
        }
      }
    }

    float fMaxDist=0.0f;
    for (k=0 ; k<BALLWIDTH-1 ; k++)
    {
      for (j=0 ; j<BALLWIDTH-1 ; j++)
      {
        for (i=0 ; i<BALLWIDTH-1 ; i++)
        {
          #define DIFF 2
          if (  (i<=BALLWIDTH/2-DIFF || i>=BALLWIDTH/2+DIFF) &&
                (j<=BALLWIDTH/2-DIFF || j>=BALLWIDTH/2+DIFF) &&
                (k<=BALLWIDTH/2-DIFF || k>=BALLWIDTH/2+DIFF) )
          {
          float* pf=m_fValues+BALLWIDTH*BALLWIDTH*k+BALLWIDTH*j+i;

          fMaxDist=max(fMaxDist,
                   max(fabsf(pf[0]-pf[1]),
                   max(fabsf(pf[0]-pf[BALLWIDTH]),
                   max(fabsf(pf[0]-pf[BALLWIDTH+1]),
                   max(fabsf(pf[0]-pf[BALLWIDTH*BALLWIDTH+BALLWIDTH]),
                   max(fabsf(pf[0]-pf[BALLWIDTH*BALLWIDTH+BALLWIDTH+1]),
                   max(fabsf(pf[0]-pf[BALLWIDTH*BALLWIDTH]),
                      (fabsf(pf[0]-pf[BALLWIDTH*BALLWIDTH+1])))))))));
          }

        }
      }
    } 

    //Encode(-100.0f, FLT_MAX);
    Encode(ISOVALUE-1.0f*fMaxDist, ISOVALUE+1.0f*fMaxDist);
  }

  void    Encode(float fMin, float fMax)
  {   
    bool      bSolid=true;
    int       iRun  =0;

    int i,j,k;
    float* pf=m_fValues;    
    for (k=0 ; k<BALLWIDTH ; k++)
    {
      for (j=0 ; j<BALLWIDTH ; j++)
      {
        for (i=0 ; i<BALLWIDTH ; i++)
        {
          bool bNewSolid=(*pf>=fMin && *pf<=fMax);

          if (bSolid && !bNewSolid)
          {
            if (iRun) baOffsets.Add(iRun);
            iRun=0;
            bSolid=false;
          }
          else if (!bSolid && bNewSolid)
          {
            if (iRun) baOffsets.Add(-iRun);            
            iRun=0;
            bSolid=true;
          }

          if (bSolid)
          {
            baValues.Add(*pf);
          }
          
          iRun++;
          pf++;
        }

        if (bSolid)
        {
          baOffsets.Add(iRun);
        }
        else
        {
          baOffsets.Add(-iRun);
        }
        iRun=0;
      }      
    }

    #ifdef _DEBUG

    {
    int     iCommands =baOffsets.Used();
    int*    piCommands=baOffsets.Get();
    float*  pfValues  =baValues.Get();

    int i;    
    int iRendered=0;
    int y=0,z=0;
    for (i=0 ; i<iCommands ; i++)
    {
      if (*piCommands>0)
      {
        int i;
        for (i=0 ; i<*piCommands ; i++)
        {
          
          assert(*pfValues==m_fValues[BALLWIDTH*BALLWIDTH*z+BALLWIDTH*y+(iRendered+i)%BALLWIDTH]);

          pfValues++;          
        }

        iRendered+=*piCommands;
      }
      else
      {
        iRendered+=- *piCommands;
      }

      if (iRendered%BALLWIDTH==0)
      {
        y++;

        if (iRendered%(BALLWIDTH*BALLWIDTH)==0)
        {
          z++;
          y=0;
        }
      }

      piCommands++;
    }
    }
    #endif

  }

  void Clear(float x, float y, float z)
  {
    int i,j,k;
    float * pfTarget=m_fGrid+int(z)*SIZE*SIZE+int(y)*SIZE+int(x);
    for (k=0 ; k<BALLWIDTH ; k++)
    {
      float* ps=pfTarget+SIZE*SIZE*k;
      for (j=0 ; j<BALLWIDTH ; j++)
      {
        for (i=0 ; i<BALLWIDTH ; i++)
        {         
          *ps++ =0;          
        }
        ps+=SIZE-(BALLWIDTH/*-1*/);
      }
      ps+=BALLWIDTH;      
    }
  }

  void Render(float x, float y, float z)
  {
    #if 0
    int     iCommands =baOffsets.Used();
    int*    piCommands=baOffsets.Get();
    float*  pfValues  =baValues.Get();

    int i;    
    int iRendered=0;
    int y=0,z=0;
    for (i=0 ; i<iCommands ; i++)
    {
      float* pCurrentSpan=pfTarget+y*SIZE+z*SIZE*SIZE;
      if (*piCommands>0)
      {
        int i;
        for (i=0 ; i<*piCommands ; i++)
        {
          pCurrentSpan[i] += pfValues[i];

          assert(pfValues[i]==m_fValues[BALLWIDTH*BALLWIDTH*z+BALLWIDTH*y+(i+iRendered)%BALLWIDTH]);

          assert(pfTarget<=m_fGrid+SIZE*SIZE*SIZE);
        }
        pCurrentSpan+=i;
        pfValues+=i;
          

        iRendered+=*piCommands;
      }
      else
      {
        iRendered+=- *piCommands;
        pCurrentSpan+=- *piCommands;
        assert(pfTarget<=m_fGrid+SIZE*SIZE*SIZE);
      }

      if (iRendered%BALLWIDTH==0)
      {
        y++;

        if (iRendered%(BALLWIDTH*BALLWIDTH)==0)
        {
          z++;
          y=0;
        }
      }

      piCommands++;      
    }

    assert(pfTarget<=m_fGrid+SIZE*SIZE*SIZE);
    assert(iRendered==BALLWIDTH*BALLWIDTH*BALLWIDTH);
    assert(z==BALLWIDTH);
    assert(y==0);
    assert(piCommands==baOffsets.Get()+baOffsets.Used());
    assert(pfValues  ==baValues.Get()+baValues.Used());
    #else

    float* pfTarget=m_fGrid+int(z)*SIZE*SIZE+int(y)*SIZE+int(x);
    float* pf=m_fValues;
    float* ps=pfTarget;

    float dx=x-int(x); float mdx=1.0f-dx;
    float dy=y-int(y); float mdy=1.0f-dx;
    float dz=z-int(z); float mdz=1.0f-dx;

    int i,j,k;
    for (k=0 ; k<BALLWIDTH ; k++)
    {
      ps=pfTarget+SIZE*SIZE*k;
      for (j=0 ; j<BALLWIDTH ; j++)
      {
        for (i=0 ; i<BALLWIDTH ; i++)
        {
          /*
          *ps++ +=pf[0]*fTrilinear[0]+
                  pf[1]*fTrilinear[1]+
                  pf[BALLWIDTH]*fTrilinear[2]+
                  pf[BALLWIDTH+1]*fTrilinear[3]+
                  pf[BALLWIDTH*BALLWIDTH+0]*fTrilinear[4]+
                  pf[BALLWIDTH*BALLWIDTH+1]*fTrilinear[5]+
                  pf[BALLWIDTH*BALLWIDTH+BALLWIDTH]*fTrilinear[6]+
                  pf[BALLWIDTH*BALLWIDTH+BALLWIDTH+1]*fTrilinear[7];

          pf++;
          */
          x=(-dx+float(i-BALLWIDTH/2));
          y=(-dy+float(j-BALLWIDTH/2));
          z=(-dz+float(k-BALLWIDTH/2));          

          float fSqrDst=x*x+y*y+z*z;          
          if (fSqrDst)
          {
            *ps++ +=1.0f/fSqrDst;
          }          
        }
        pf++;
        ps+=SIZE-(BALLWIDTH/*-1*/);
      }
      //pf+=BALLWIDTH;
      
    }
    #endif  
  }

  


  MBinArray<float> baValues;
  MBinArray<int>   baOffsets;
  float   m_fValues[BALLWIDTH*BALLWIDTH*BALLWIDTH];    
};

Metaball Bola;

class IsoSurfaceFX : public SM_DemoEffect
{
public:              
  IsoSurfaceFX(char const* pcName) : SM_DemoEffect(pcName)
  {
  }

  virtual          ~IsoSurfaceFX()
  {
  }

    
  
  int      Init()
  {
    float fTime=0.0f;

    Bola.Init();

    v3dOffsets[0]=Vector3D(0.0f , 0.0f , 0.0f );
    v3dOffsets[1]=Vector3D(0.0f , DELTA2, 0.0f );
    v3dOffsets[2]=Vector3D(0.0f , 0.0f , DELTA2);
    v3dOffsets[3]=Vector3D(0.0f , DELTA2, DELTA2);
    v3dOffsets[4]=Vector3D(DELTA2, 0.0f , 0.0f );
    v3dOffsets[5]=Vector3D(DELTA2, DELTA2, 0.0f );
    v3dOffsets[6]=Vector3D(DELTA2, 0.0f , DELTA2);
    v3dOffsets[7]=Vector3D(DELTA2, DELTA2, DELTA2);
    

    
    
    m_iShader=ShaderManager::LoadShader("metabola");


    m_MeshElement.m_iShader           =m_iShader;        
    m_MeshElement.m_iVB               =-1;
    m_MeshElement.m_iIB               =-1;
    m_MeshElement.m_pVertices         =new FVF_PosNormalDiffuseTex1[MAX_BATCH]; 
    if (!m_MeshElement.m_pVertices) return -1;

    m_MeshElement.m_pIndices          =new unsigned short[MAX_BATCH];
    if (!m_MeshElement.m_pIndices) return -1;

    int i;
    for (i=0 ; i<MAX_BATCH ; i++)
    {
      m_MeshElement.m_pIndices[i]=i;
    }

    m_MeshElement.m_uStartVertex      =0;
    m_MeshElement.m_uVertices         =0;
    m_MeshElement.m_uStartIndex       =0;
    m_MeshElement.m_uPrimitives       =0;
    m_MeshElement.m_WorldTransform    =Matrix4X4::Identity;
    m_MeshElement.m_uActiveLightMask  =0;  
    m_MeshElement.m_fDepth            =0.0f;

    UpdateScalars(0.0f);

    
    return (0);
  }

  int      Shutdown()
  {
    if (m_MeshElement.m_pVertices)
    {
        delete[] m_MeshElement.m_pVertices;
        m_MeshElement.m_pVertices=0; 
    }

    if (m_MeshElement.m_pIndices)
    {
      delete[] m_MeshElement.m_pIndices;
      m_MeshElement.m_pIndices=0;

    }
    return (0);
  }

  int      Start(float fTime)
  {
    m_iShader=ShaderManager::LoadShader("NULL");
    return (0);
  }

  int      Stop()
  {
    return (0);
  }

  void Flush()
  {

    //m_uStored=0;
    //return;

    m_MeshElement.m_uVertices  =m_uStored;
    m_MeshElement.m_uPrimitives=m_uStored/3;

    RenderPipeline::Render(&m_MeshElement);
    RenderPipeline::Flush();    

    m_uStored=0;
  }


  
  
  void VertexInterp(FVF_PosNormalDiffuseTex1* pVertex, Vector3D& v1, Vector3D& v2, float* p1, float* p2)
  {
    float fLerp=(m_fIso-p1[0])/(p2[0]-p1[0]);


    assert(fLerp>=0.0f && fLerp<=1.0f);

    pVertex->x=v3dBase.x+(v1.x+(v2.x-v1.x)*fLerp);
    pVertex->y=v3dBase.y+(v1.y+(v2.y-v1.y)*fLerp);
    pVertex->z=v3dBase.z+(v1.z+(v2.z-v1.z)*fLerp);

    
    Vector3D Normal(p1[1]+(p2[1]-p1[1])*fLerp-m_fIso, 
                    p1[SIZE]+(p2[SIZE]-p1[SIZE])*fLerp-m_fIso, 
                    p1[SIZE*SIZE]+(p2[SIZE*SIZE]-p1[SIZE*SIZE])*fLerp-m_fIso);
    Normal.Normalize();

    pVertex->nx=Normal.x;
    pVertex->ny=Normal.y;
    pVertex->nz=Normal.z;
    
  }
  
  
  void SpitTri(int v0, int v1, int v2, int v3, unsigned uMask)
  {
    /*
    #define CONV(a,b,c,d) ( ((uMask&(1<<a))>>(a-0)) | ((uMask&(1<<b))>>(b-1)) | ((uMask&(1<<c))>>(c-2)) | ((uMask&(1<<d))>>(d-3)) )


    unsigned uSelector=CONV((7-v0),(7-v1),(7-v2),(7-v3)); 
    */
    unsigned uSelector  = ((uMask&(1<<(7-v0)))>>(7-v0))<<0;
             uSelector |= ((uMask&(1<<(7-v1)))>>(7-v1))<<1;
             uSelector |= ((uMask&(1<<(7-v2)))>>(7-v2))<<2;
             uSelector |= ((uMask&(1<<(7-v3)))>>(7-v3))<<3;

    FVF_PosNormalDiffuseTex1* pVertex=m_MeshElement.m_pVertices+m_uStored;
    switch (uSelector) 
    {
     case 0x0E:
     case 0x01:
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v1],m_Grid.f[v0],m_Grid.f[v1]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v2],m_Grid.f[v0],m_Grid.f[v2]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v3],m_Grid.f[v0],m_Grid.f[v3]); pVertex++;
        m_uStored+=3;
        break;
     case 0x0D:
     case 0x02:
        VertexInterp(pVertex, v3dOffsets[v1],v3dOffsets[v0],m_Grid.f[v1],m_Grid.f[v0]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v1],v3dOffsets[v3],m_Grid.f[v1],m_Grid.f[v3]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v1],v3dOffsets[v2],m_Grid.f[v1],m_Grid.f[v2]); pVertex++;
        m_uStored+=3;
        break;
        
     case 0x0C:
     case 0x03:
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v3],m_Grid.f[v0],m_Grid.f[v3]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v2],m_Grid.f[v0],m_Grid.f[v2]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v1],v3dOffsets[v3],m_Grid.f[v1],m_Grid.f[v3]); pVertex++;
        m_uStored+=3;
        VertexInterp(pVertex, v3dOffsets[v1],v3dOffsets[v3],m_Grid.f[v1],m_Grid.f[v3]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v1],v3dOffsets[v2],m_Grid.f[v1],m_Grid.f[v2]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v2],m_Grid.f[v0],m_Grid.f[v2]); pVertex++;
        m_uStored+=3;
        break;
       
     case 0x0B:
     case 0x04:
        VertexInterp(pVertex, v3dOffsets[v2],v3dOffsets[v0],m_Grid.f[v2],m_Grid.f[v0]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v2],v3dOffsets[v1],m_Grid.f[v2],m_Grid.f[v1]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v2],v3dOffsets[v3],m_Grid.f[v2],m_Grid.f[v3]); pVertex++;        
        m_uStored+=3;
        break;        
     case 0x0A:
     case 0x05:
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v1],m_Grid.f[v0],m_Grid.f[v1]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v2],v3dOffsets[v3],m_Grid.f[v2],m_Grid.f[v3]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v3],m_Grid.f[v0],m_Grid.f[v3]); pVertex++;
        
        m_uStored+=3;
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v1],m_Grid.f[v0],m_Grid.f[v1]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v1],v3dOffsets[v2],m_Grid.f[v1],m_Grid.f[v2]); pVertex++;                
        VertexInterp(pVertex, v3dOffsets[v2],v3dOffsets[v3],m_Grid.f[v2],m_Grid.f[v3]); pVertex++;                
        m_uStored+=3;
        break;
     case 0x09:
     case 0x06:
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v1],m_Grid.f[v0],m_Grid.f[v1]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v1],v3dOffsets[v3],m_Grid.f[v1],m_Grid.f[v3]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v2],v3dOffsets[v3],m_Grid.f[v2],m_Grid.f[v3]); pVertex++;                
        m_uStored+=3;

        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v1],m_Grid.f[v0],m_Grid.f[v1]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v0],v3dOffsets[v2],m_Grid.f[v0],m_Grid.f[v2]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v2],v3dOffsets[v3],m_Grid.f[v2],m_Grid.f[v3]); pVertex++;                
        m_uStored+=3;
        break;
     case 0x07:
     case 0x08:
        VertexInterp(pVertex, v3dOffsets[v3],v3dOffsets[v0],m_Grid.f[v3],m_Grid.f[v0]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v3],v3dOffsets[v2],m_Grid.f[v3],m_Grid.f[v2]); pVertex++;
        VertexInterp(pVertex, v3dOffsets[v3],v3dOffsets[v1],m_Grid.f[v3],m_Grid.f[v1]); pVertex++;        
        m_uStored+=3;
        
        break;
/*        
     default:
       assert(0);
       */
       
     }
  }


  void Polygonize(float* pf, unsigned uMask)
  {  
    int i,j,k;

    unsigned uOffset=pf-m_fGrid;

    k=uOffset/(SIZE*SIZE);
    j=(uOffset%(SIZE*SIZE))/(SIZE);
    i=(uOffset%(SIZE*SIZE))%(SIZE);


    pfCurrent=pf;
    v3dBase=Vector3D((i-SIZE/2)*DELTA2, (j-SIZE/2)*DELTA2, (k-SIZE/2)*DELTA2);

    m_Grid.f[0]=pf;
    m_Grid.f[1]=pf+SIZE;
    m_Grid.f[2]=pf+SIZE*SIZE;
    m_Grid.f[3]=pf+SIZE+SIZE*SIZE;
    m_Grid.f[4]=pf+1;
    m_Grid.f[5]=pf+1+SIZE;
    m_Grid.f[6]=pf+1+SIZE*SIZE;
    m_Grid.f[7]=pf+1+SIZE+SIZE*SIZE;
          

    SpitTri(0,2,4,5, uMask); 
    SpitTri(2,4,5,6, uMask); 
    SpitTri(2,5,6,7, uMask); 
    SpitTri(2,3,5,7, uMask); 
    SpitTri(0,1,2,5, uMask); 
    SpitTri(1,2,3,5, uMask); 
  }

  #define TESTISO(pp, x) ((pp[x]<=m_fIso?1:0))

  void     RenderSubsection(float* pOrigin, unsigned xl, unsigned yl, unsigned zl)
  {
    int i,j,k;          
    
    for (k=0 ; k<zl ; k++)
    {
      for (j=0 ; j<yl ; j++)
      {

        float* pf=pOrigin+k*(SIZE*SIZE)+j*SIZE;

        
        unsigned uMask;
        uMask=(TESTISO(pf, 0             )<<3) |
              (TESTISO(pf, SIZE          )<<2) |
              (TESTISO(pf,      SIZE*SIZE)<<1) |
              (TESTISO(pf, SIZE+SIZE*SIZE)<<0);
        uMask<<=4;
        pf++;

        for (i=0 ; i<xl ; i++)
        {
          uMask|=(TESTISO(pf, 0             )<<3) |
                 (TESTISO(pf, SIZE          )<<2) |
                 (TESTISO(pf,      SIZE*SIZE)<<1) |
                 (TESTISO(pf, SIZE+SIZE*SIZE)<<0);

          if (uMask && uMask!=0xFF)
          {
            // Did we fill the batch?
            if (m_uStored>=MAX_BATCH-12*3)  // 12 is the max tris we can output for one cube
            {
              Flush();
            }
            
  
            Polygonize(pf-1, uMask);            
          }

          uMask&=0x0000000F;
          uMask<<=4;
          pf++;                  
        }
      }
    }
  }
  
  unsigned CalculateMask(float* pOrigin, unsigned xl, unsigned yl, unsigned zl)
  {
    unsigned uMask;
    uMask=(TESTISO(pOrigin, 0                           )<<7) |
          (TESTISO(pOrigin, SIZE*yl                     )<<6) |
          (TESTISO(pOrigin,         SIZE*SIZE*zl        )<<5) |
          (TESTISO(pOrigin, SIZE*yl+SIZE*SIZE*zl        )<<4) |
          (TESTISO(pOrigin, xl                          )<<3) |
          (TESTISO(pOrigin, SIZE*(yl)+xl                )<<2) |
          (TESTISO(pOrigin,      SIZE*SIZE*(zl)+xl      )<<1) |
          (TESTISO(pOrigin, SIZE*(yl)+SIZE*SIZE*(zl)+xl )<<0);

    return uMask;
  }

  void Clear()
  {
    for (int i=0 ; i<NBOLAS ; i++)
    {
      Bola.Clear(v3dBolas[i].x, v3dBolas[i].y, v3dBolas[i].z);      
    }
  }

  void UpdateScalars(float fTime)
  {
    //memset(m_fGrid, 0, sizeof(float)*SIZE*SIZE*SIZE);

    for (int i=0 ; i<NBOLAS ; i++)
    {
      v3dBolas[i].x=(float(SIZE/2)+SIZE/7*sinf(((i&1)?-1.0f:1.0f)*fTime*0.7f+i*i*3.12));
      v3dBolas[i].y=(float(SIZE/2)+SIZE/7*cosf(((i&1)?-1.0f:1.0f)*fTime*0.6f+i*3.4));
      v3dBolas[i].z=(float(SIZE/2)+SIZE/7*sinf(((i&1)?-1.0f:1.0f)*fTime*0.4f+i*1.13));
      
      Bola.Render(v3dBolas[i].x, v3dBolas[i].y, v3dBolas[i].z);      
    }
    /*
    Bola.Render(m_fGrid);
    Bola.Render(m_fGrid+400);
    Bola.Render(m_fGrid+800);
    Bola.Render(m_fGrid+18000);
    Bola.Render(m_fGrid+32000);
    Bola.Render(m_fGrid+122000);
    */


    //memcpy(m_fGrid, Bola.m_fValues, sizeof(float)*SIZE*SIZE*SIZE);
    /*
    int i,j,k;    
    float* pf=m_fGrid;
    for (k=0 ; k<SIZE ; k++)
    {
      for (j=0 ; j<SIZE ; j++)
      {
        for (i=0 ; i<SIZE ; i++)
        {
          float x, y, z;

          x=float(i-SIZE/2)*DELTA;
          y=float(j-SIZE/2)*DELTA;
          z=float(k-SIZE/2)*DELTA;

          float fx=0.5f*sinf(fTime);
          float fy=0.5f*cosf(fTime);
          
          float fDist =0.55f/((x*x+
                              y*y+
                              z*z));

          
          float fDist2 =y<=-0.3f?4.25f:0.0f;

          fDist2=0.1f/(((x-fx)*(x-fx)+
                         y*y+
                         z*z));

          float fDist3=0.1f/(((y-fy)*(y-fy)+
                         x*x+
                         (z+0.2f)*(z+0.2f)));


          float fScalar=fDist//+fDist2+fDist3;

          *pf++=fScalar;//y<0.0f?-1.0f:1.0f;         
        }
      }
    }
    */
  }

  int      Run(float fTime)
  {
    /*
    RenderContext RC;   

    RC.Set(
    Vector3D(0.0f, 0.0f, 0.0f),
    Quaternion(1.0f, 0.0f, 0.0f, 0.0f),
    90,
    0.75f,
    1.0f,
    200.0f);
  
    RC.SetViewport(0, 0, 640, 480);
    RC.SyncRasterizer();
    RC.UpdateFrustum();
    */

    RenderContext RC;   

    //float fRot=0.0f;//
    float fRot=fTime*1.25f;
    Vector3D v3dVPN=Vector3D(sinf(fRot), 0.0f, cosf(fRot));
    v3dVPN.Normalize();
    Vector3D v3dVUP=Vector3D(0.0f, -1.0f, 0.0f);
    Vector3D v3dVRP=Vector3D::Cross(v3dVUP, v3dVPN);
    
    Quaternion q;
    q.FromFrame(v3dVPN, v3dVUP, v3dVRP);



    RC.Set(
    //Vector3D(0.0f, 0.0f, -1.8f+0.0f*sinf(fTime*0.05)),
    Vector3D(3.0f*sinf(fRot), 0.0f, 3.0f*cosf(fRot)),
    //Quaternion(1.0f, 0.0f, 0.0f, 0.0f),
    q*Quaternion(3.141592f, Vector3D(1.0f, 0.0f, 0.0f)),
    60,
    0.75f,
    0.01f,
    200.0f);
  
    RC.SetViewport(0.0f, 0.0f, 640, 480);
    RC.SyncRasterizer();
    RC.UpdateFrustum();


    
  
    UpdateScalars(fTime);
    
    m_fIso=ISOVALUE/*+1.25f*sinf(fTime)*/;

    int Add=0;
    
    


/*
    #if 1
    #define SUBSAMPLE 4

    int i,j,k;

    for (k=0 ; k<SIZE-SUBSAMPLE ; k+=SUBSAMPLE)
    {
      for (j=0 ; j<SIZE-SUBSAMPLE ; j+=SUBSAMPLE)
      {
        float* pf=m_fGrid+SIZE*SIZE*k+SIZE*j;
        for (i=0 ; i<SIZE-SUBSAMPLE ; i+=SUBSAMPLE)
        {      
          unsigned uMask=CalculateMask(pf, SUBSAMPLE, SUBSAMPLE, SUBSAMPLE);

          if (uMask && uMask!=0xFF)
          {
            RenderSubsection(pf, SUBSAMPLE, SUBSAMPLE, SUBSAMPLE);
          }
          pf+=SUBSAMPLE;
        }      
      }      
    }
    #else    
    RenderSubsection(m_fGrid, SIZE-2, SIZE-2, SIZE-2);
    #endif
    */
    for (int i=0 ; i<NBOLAS ; i++)
    {
      int x,y,z;

      x=int(v3dBolas[i].x);
      y=int(v3dBolas[i].y);
      z=int(v3dBolas[i].z);

      float* pf=m_fGrid+SIZE*SIZE*z+SIZE*y+x;

      RenderSubsection(pf, BALLWIDTH, BALLWIDTH, BALLWIDTH);
    }

    
    //RenderSubsection(m_fGrid, SIZE-2, SIZE-2, SIZE-2);

    
    
    if (m_uStored)
    {
      Flush();
    }

    Clear();

    return (1);
  }

  int      Command           (float fTime, const char* pcCommand)
  {
    return (0);
  }  

  unsigned        m_uStored;
  MeshElement     m_MeshElement;
  int             m_iShader;
  static GRIDCELL m_Grid;  
  static float    m_fIso;
  static Vector3D v3dOffsets[8];  
  static Vector3D v3dBase;
  static float*   pfCurrent;
};

float    IsoSurfaceFX::m_fIso;
Vector3D IsoSurfaceFX::v3dOffsets[8];  
Vector3D IsoSurfaceFX::v3dBase;
GRIDCELL IsoSurfaceFX::m_Grid;
float*   IsoSurfaceFX::pfCurrent;

DEFINE_EFFECT(IsoSurfaceFX)
IsoSurfaceFX IsoSurface("ISOSURFACE");


