/* Copyright (C) Gabriel T. DelaRosa, 2004. 
 * All rights reserved worldwide.
*/
#include "skybox.h"

vertex tris[36] = {
   {-10.00, -10.00, 10.00, 1.00,  0.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {10.00, -10.00, 10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, 10.00, 10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, 10.00, 10.00, 1.00,  1.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, 10.00, 10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, -10.00, 10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},

   {-10.00, -10.00, -10.00, 1.00,  0.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, 10.00, -10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {10.00, -10.00, -10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, 10.00, -10.00, 1.00,  1.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, -10.00, -10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, 10.00, -10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},

   {-10.00, -10.00, -10.00, 1.00,  0.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, -10.00, 10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, 10.00, -10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, 10.00, 10.00, 1.00,  1.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, 10.00, -10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, -10.00, 10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},

   {10.00, -10.00, -10.00, 1.00,  0.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {10.00, 10.00, -10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {10.00, -10.00, 10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, 10.00, 10.00, 1.00,  1.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, -10.00, 10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, 10.00, -10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},

   {-10.00, 10.00, 10.00, 1.00,  0.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {10.00, 10.00, 10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, 10.00, -10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, 10.00, -10.00, 1.00,  1.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, 10.00, -10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, 10.00, 10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},

   {-10.00, -10.00, 10.00, 1.00,  0.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, -10.00, -10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},
   {10.00, -10.00, 10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, -10.00, -10.00, 1.00,  1.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {10.00, -10.00, 10.00, 1.00,  0.00, 1.00, 0.00, 0.00,    0,0,0,0},
   {-10.00, -10.00, -10.00, 1.00,  1.00, 0.00, 0.00, 0.00,    0,0,0,0},
};


void draw_skybox(uint32 *txtrs[6], uint16 w, uint16 h, fmatrix *fr, fmatrix *cam)
{
	int i;

	tri_alpha = 0;
	tri_light = 0;
	tri_txtr_w = w;
	tri_txtr_h = h;
	tri_aa = 0;
	tri_cull = 0;


	for (i=0; i<36; i+=3)
	{
		if (i < 6)
		{
			gs_load_texture(0, 0, w, h, txtrs[0], g2_texbuf_addr, w);
			tri_txtr = txtrs[0];
			render_tri(&tris[i], fr, cam);
		}else
		if (i < 12)
		{
			gs_load_texture(0, 0, w, h, txtrs[1], g2_texbuf_addr, w);
			tri_txtr = txtrs[1];
			render_tri(&tris[i], fr, cam);
		}else
		if (i < 18)
		{
			gs_load_texture(0, 0, w, h, txtrs[2], g2_texbuf_addr, w);
			tri_txtr = txtrs[2];
			render_tri(&tris[i], fr, cam);
		}else
		if (i < 24)
		{
			gs_load_texture(0, 0, w, h, txtrs[3], g2_texbuf_addr, w);
			tri_txtr = txtrs[3];
			render_tri(&tris[i], fr, cam);
		}else
		if (i < 30)
		{
			gs_load_texture(0, 0, w, h, txtrs[4], g2_texbuf_addr, w);
			tri_txtr = txtrs[4];
			render_tri(&tris[i], fr, cam);
		}else
		if (i < 36)
		{
			gs_load_texture(0, 0, w, h, txtrs[5], g2_texbuf_addr, w);
			tri_txtr = txtrs[5];
			render_tri(&tris[i], fr, cam);
		}
	}
}


