{$X+}
USES crt,gfx3;

{$I font.con}


CONST FirePal : Array [0..767] of byte = (
           0, 0, 0, 0, 0, 6, 0, 0, 6, 0, 0, 7, 0, 0, 8, 0, 0, 8, 0, 0, 9, 0, 0,10,
           2, 0,10, 4, 0, 9, 6, 0, 9, 8, 0, 8,10, 0, 7,12, 0, 7,14, 0, 6,16, 0, 5,
          18, 0, 5,20, 0, 4,22, 0, 4,24, 0, 3,26, 0, 2,28, 0, 2,30, 0, 1,32, 0, 0,
          32, 0, 0,33, 0, 0,34, 0, 0,35, 0, 0,36, 0, 0,36, 0, 0,37, 0, 0,38, 0, 0,
          39, 0, 0,40, 0, 0,40, 0, 0,41, 0, 0,42, 0, 0,43, 0, 0,44, 0, 0,45, 0, 0,
          46, 1, 0,47, 1, 0,48, 2, 0,49, 2, 0,50, 3, 0,51, 3, 0,52, 4, 0,53, 4, 0,
          54, 5, 0,55, 5, 0,56, 6, 0,57, 6, 0,58, 7, 0,59, 7, 0,60, 8, 0,61, 8, 0,
          63, 9, 0,63, 9, 0,63,10, 0,63,10, 0,63,11, 0,63,11, 0,63,12, 0,63,12, 0,
          63,13, 0,63,13, 0,63,14, 0,63,14, 0,63,15, 0,63,15, 0,63,16, 0,63,16, 0,
          63,17, 0,63,17, 0,63,18, 0,63,18, 0,63,19, 0,63,19, 0,63,20, 0,63,20, 0,
          63,21, 0,63,21, 0,63,22, 0,63,22, 0,63,23, 0,63,24, 0,63,24, 0,63,25, 0,
          63,25, 0,63,26, 0,63,26, 0,63,27, 0,63,27, 0,63,28, 0,63,28, 0,63,29, 0,
          63,29, 0,63,30, 0,63,30, 0,63,31, 0,63,31, 0,63,32, 0,63,32, 0,63,33, 0,
          63,33, 0,63,34, 0,63,34, 0,63,35, 0,63,35, 0,63,36, 0,63,36, 0,63,37, 0,
          63,38, 0,63,38, 0,63,39, 0,63,39, 0,63,40, 0,63,40, 0,63,41, 0,63,41, 0,
          63,42, 0,63,42, 0,63,43, 0,63,43, 0,63,44, 0,63,44, 0,63,45, 0,63,45, 0,
          63,46, 0,63,46, 0,63,47, 0,63,47, 0,63,48, 0,63,48, 0,63,49, 0,63,49, 0,
          63,50, 0,63,50, 0,63,51, 0,63,52, 0,63,52, 0,63,52, 0,63,52, 0,63,52, 0,
          63,53, 0,63,53, 0,63,53, 0,63,53, 0,63,54, 0,63,54, 0,63,54, 0,63,54, 0,
          63,54, 0,63,55, 0,63,55, 0,63,55, 0,63,55, 0,63,56, 0,63,56, 0,63,56, 0,
          63,56, 0,63,57, 0,63,57, 0,63,57, 0,63,57, 0,63,57, 0,63,58, 0,63,58, 0,
          63,58, 0,63,58, 0,63,59, 0,63,59, 0,63,59, 0,63,59, 0,63,60, 0,63,60, 0,
          63,60, 0,63,60, 0,63,60, 0,63,61, 0,63,61, 0,63,61, 0,63,61, 0,63,62, 0,
          63,62, 0,63,62, 0,63,62, 0,63,63, 0,63,63, 1,63,63, 2,63,63, 3,63,63, 4,
          63,63, 5,63,63, 6,63,63, 7,63,63, 8,63,63, 9,63,63,10,63,63,10,63,63,11,
          63,63,12,63,63,13,63,63,14,63,63,15,63,63,16,63,63,17,63,63,18,63,63,19,
          63,63,20,63,63,21,63,63,21,63,63,22,63,63,23,63,63,24,63,63,25,63,63,26,
          63,63,27,63,63,28,63,63,29,63,63,30,63,63,31,63,63,31,63,63,32,63,63,33,
          63,63,34,63,63,35,63,63,36,63,63,37,63,63,38,63,63,39,63,63,40,63,63,41,
          63,63,42,63,63,42,63,63,43,63,63,44,63,63,45,63,63,46,63,63,47,63,63,48,
          63,63,49,63,63,50,63,63,51,63,63,52,63,63,52,63,63,53,63,63,54,63,63,55,
          63,63,56,63,63,57,63,63,58,63,63,59,63,63,60,63,63,61,63,63,62,63,63,63
);
  { Pregenerated palette going from blue to red to yellow }


CONST nStars = 500; { Number of Stars }

Type cStar = Record
              x,y:integer;
              xOfs, yOfs : integer;
              z:longint;
            END;

     cStars = Array [1..nStars] of cStar;

VAR   field : ^cStars;
     field2 : ^cStars;  { Starfield and rotated starfield }

     sincos : Array [0..360,1..2] of integer; { Our sin and cos lookup table }
     lookup : Array [0..127,1..2] of integer; { Used for deciding where to heat
                                                up the sun }

        sun : pointer;
     sunseg : word;     { Pointer and segment of our sun bitmap }

    RootDeg : integer;
    RootRad : real;
 RootRadDir : Boolean;  { Used for rotating the source of the tunnel }

   BkgStars : Array [0..500,1..2] of integer;
                        { Background stars }


Procedure Scale (x,y,w,h,origw,origh,source,dest:word); assembler;
  { Standard scaling routine... could be better }
VAR jx,jy,depth,temp:word;
asm
  push  ds

  mov   ax,source
  mov   ds,ax
  mov   ax,dest
  mov   es,ax
  mov   depth,0
  dec   h

  xor   dx,dx
  mov   ax,origw
  shl   ax,6
  mov   bx,w
  div   bx
  shl   ax,2
  mov   jx,ax     { jx:=origw*256/w }

  xor   dx,dx
  mov   ax,origh
  shl   ax,6
  mov   bx,h
  div   bx
  shl   ax,2
  mov   jy,ax     { jy:=origh*256/h }

  xor   cx,cx
@Loop2 :          { vertical loop }
  push  cx
  mov   ax,depth
  add   ax,jy
  mov   depth,ax

  xor   dx,dx
  mov   ax,depth
  shr   ax,8
  mov   bx,origw
  mul   bx
  mov   temp,ax   { temp:=depth shr 8*origw;}


  mov   di,y
  add   di,cx
  mov   bx,di
  shl   di,8
  shl   bx,6
  add   di,bx
  add   di,x      { es:di = dest ... di=(loop1+y)*320+x }

  mov   cx,w
  xor   bx,bx
  mov   dx,jx
  mov   ax,temp
@Loop1 :          { horizontal loop }
  mov   si,bx
  shr   si,8
  add   si,ax     { ax = temp = start of line }

  push ax

{  movsb           { si=temp+(si shr 8) }
  mov al, ds:[si]
  add al, es:[di]
  stosb
  inc si
        { merge with background, not overwrite }

  pop ax

  add   bx,dx

  dec   cx
  jnz   @loop1    { horizontal loop }

  pop   cx
  inc   cx
  cmp   cx,h
  jl    @loop2    { vertical loop }

  pop   ds
end;




Procedure DrawSun (x,y,z:integer; where:word);
  { Set the scale of the sun and scale it }
VAR w, h :integer;
BEGIN
  if z < -400 then
    exit;

  w := 40+trunc (z / 10);
  h := 40+trunc (z / 10);

  if (h > 2) and (w > 2) then
    Scale (x-w div 2, y-h div 2, w, h, 128, 110, seg(sun^), where);
END;

Procedure Drawstars (where:word);
  { Calculate positions for stars }
VAR x,y:word;
    loop1 : Integer;
BEGIN
  For loop1:=2 to nStars do
    If (field^[loop1].Z < -3) and (field^[loop1].Z > -nStars) then BEGIN
      x:=((field^[loop1].X shl 8) div field^[loop1].z) + field^[loop1].xOfs;
      y:=((field^[loop1].Y shl 8) div field^[loop1].z) + field^[loop1].yOfs;

      If (X > 0) and (X < 320) and (Y > 0) and (Y < 200) then
        If field^[loop1].z<-400 then
          putpixel(x,y,252,where)
        else
        BEGIN
          If field^[loop1].z<-200 then
            putpixel(x,y,253,where);
          DrawSun (x, y, field^[loop1].z, where);
        END;
    END;
END;


Procedure Setup;
  { Setup all variables, get memory etc. }
VAR loop1:integer;
    x, y : integer;
    nTemp : integer;
BEGIN
  randomize;

  getmem (field,sizeof (field^));
  getmem (field2,sizeof (field2^));
  getmem (sun, 128*128);
  fillchar (sun^, 128*128, 0);
  sunseg := seg (sun^);
  setupvirtual;
                        { Get All needed memory }

  field^[1].z:=-1;
  field^[1].x:=4;
  field^[1].y:=7;
  field^[1].xOfs:=160;
  field^[1].yOfs:=100;
  for loop1:=2 to nStars do BEGIN
    repeat
      nTemp := random (360);
      field^[loop1].x:=round(40*COS (rad(nTemp)));
      field^[loop1].y:=round(40*sin (rad(nTemp)));
      field^[loop1].xOfs:=160;
      field^[loop1].yOfs:=100;

    until (field^[loop1].x<>0) or (field^[loop1].y<>0);
    field^[loop1].z:=-loop1;
  END;
                        { Fill in info for the starfield }

  for loop1:=1 to 500 do
  BEGIN
    repeat
      x := random (320);
      y := random (200);
    until (x < 100) or (x > 220) or (y < 70) or (y > 130);
    BkgStars[loop1,1] := x + y * 320;
    BkgStars[loop1,2] := random (30);
  END;
                        { Generate some random stars for the background }

  cls (vaddr,0);
  cls (vga,0);

  for loop1:=0 to 255 do
    Pal (loop1, FirePal[loop1*3], FirePal[loop1*3+1], FirePal[loop1*3+2]);

  For loop1:=0 to 127 do
  BEGIN
    lookup[loop1,1] := 255;
    lookup[loop1,2] := 0;
  END;

  For loop1:=0 to 360 do
  BEGIN
    x := round(sin (rad (loop1))*49);
    y := round(cos (rad (loop1))*43);
    sincos [loop1,1]:=round(sin (rad (loop1))*512);
    sincos [loop1,2]:=round(cos (rad (loop1))*512);

    if (sincos[loop1,1]+64 < lookup[y+64, 1]) then
      lookup[y+64, 1] := x+64;
    if (sincos[loop1,1]+64 > lookup[y+64, 2]) then
      lookup[y+64, 2] := x+64;
  END;
                       { Set up the sincos lookup table. Also generate a circle
                         in which we can put highlights so that our sun is
                         circular }

  pal (252,30,00,00);
  pal (253,40,10,10);
  pal (254,50,15,15);
  pal (255,60,25,25);
END;


Procedure UpdateSun (AddFire :Boolean);
  { Keep our sun "boiling". }
VAR loop1, loop2, x, y:integer;
BEGIN
  if (AddFire) then
   for loop1 := 1 to 20 do
    BEGIN
       repeat
         x := random (128);
         y := random (128);
       until (x > lookup[y, 1]) and (x < lookup[y, 2]);

       mem [seg(sun^):ofs(sun^)+x  +y shl 7    ] := 255;
       mem [seg(sun^):ofs(sun^)+x+1+y shl 7    ] := 155;
       mem [seg(sun^):ofs(sun^)+x-1+y shl 7    ] := 155;
       mem [seg(sun^):ofs(sun^)+x  +y shl 7+128] := 155;
       mem [seg(sun^):ofs(sun^)+x  +y shl 7-128] := 155;
    END;

  asm
    push ds

    mov ax, sunseg
    mov es, ax
    mov di, 128

    mov ax, SunSeg
    mov ds, ax
    mov si, 128

    mov bx, 128

  @l1 :
    mov cx, 128

  @l2 :
    xor ax, ax
    xor dx, dx
    mov al, ds:[si-128-1]
    mov dl, ds:[si-128+1]
    add ax, dx
    mov dl, ds:[si+128-1]
    add ax, dx
    mov dl, ds:[si+128+1]
    add ax, dx

    mov dl, ds:[si-128]
    add ax, dx
    mov dl, ds:[si+128]
    add ax, dx
    mov dl, ds:[si-1]
    add ax, dx
    mov dl, ds:[si+1]
    add ax, dx

    shr ax, 3

    stosb
    inc si

                { Standard averaging. Not too cunning }

    dec cx
    jnz @l2

    dec bx
    jnz @l1

    pop ds
  end;
END;


Procedure Animate;
  { Move, rotate and draw the starfield, while boiling the sun }
VAR Deg, temp : integer;
    x, y : integer;
    loop1 : integer;
    ch : char;
BEGIN
  deg := 0;
  RootDeg := 0;
  RootRad := 0;
  RootRadDir := TRUE;
  ch := #0;
  Repeat
    UpdateSun (TRUE);
    cls (vaddr,0);

    if keypressed then ch:=readkey;

    for loop1:=1 to nStars do
      field^[loop1].z:=field^[loop1].z+10;
        { Move the starfield forward }

    RootDeg := RootDeg + 1;
    if (RootDeg > 360) then
      RootDeg := RootDeg - 360;
    if (RootRadDir = TRUE) then
      RootRad := RootRad + 0.1
    else
      RootRad := RootRad - 0.1;

    if (RootRad < 0) then
      RootRadDir := TRUE;
    if (RootRad > 80) then
      RootRadDir := FALSE;
        { Figure out the new offset for the forward stars }

    for loop1:=1 to nStars do BEGIN
      if field^[loop1].z>-10 then BEGIN
        field^[loop1].z:=-nStars;
        field^[loop1].xOfs := trunc(sincos[deg,1] * RootRad) div 512 + 160;
        field^[loop1].yOfs := trunc(sincos[deg,2] * RootRad) div 512 + 100;
      END;
    END;
        { Reset stars which have flow past us }

    move (field^, field2^, sizeof (field^));
    deg := deg+3;
    if (deg > 360) then
      deg := deg - 360;

    for loop1:=1 to nStars do
    BEGIN
      field^[loop1].x := (((sincos[deg,2]*field2^[loop1].x)) - ((sincos[deg,1]*field2^[loop1].y)));{div fp;}
      field^[loop1].y := (((sincos[deg,1]*field2^[loop1].x)) + ((sincos[deg,2]*field2^[loop1].y)));{div fp;}
      x := field^[loop1].x;
      y := field^[loop1].y;
      asm
        mov ax, x
        sar ax, 9
        mov x, ax
        mov ax, y
        sar ax, 9
        mov y, ax
      end;
      field^[loop1].x := x;
      field^[loop1].y := y;
    END;
        { Rotate the stars too }


    drawstars (vaddr);

    move (field2^, field^, sizeof (field^));

    for loop1:=1 to 500 do
      if (mem [vaddr:BkgStars[loop1, 1]] = 0) then
        mem [vaddr:BkgStars[loop1, 1]] := BkgStars[loop1, 2];


    flip (vaddr, vga);
  Until ch=#27;
END;


Procedure DrawText (x, y:integer; msg : string; where : word);
  { Weenie drawtext routine. Thank goodness it isn't done per frame... I'd
    never live it down }
VAR loop1, loop2, loop3:integer;
BEGIN
  for loop1:=1 to length (msg) do
    for loop2:=1 to 16 do
      for loop3:=1 to 16 do
        putpixel (loop1*17+loop2+x, loop3+y, font[msg[loop1], loop2, loop3], where);
END;



Procedure UpdateScreen;
  { Almost like "boiling" the screen like the sun. For a cute finish }
VAR loop1, loop2, x, y:integer;
BEGIN
  asm
    push ds

    mov ax, $a000
    mov es, ax
    mov di, 320

    mov ax, $a000
    mov ds, ax
    mov si, 320

    mov bx, 35

  @l1 :
    mov cx, 320

  @l2 :
    xor ax, ax
    xor dx, dx
    mov al, ds:[si-320-1]
    mov dl, ds:[si-320+1]
    add ax, dx
    mov dl, ds:[si+320-1]
    add ax, dx
    mov dl, ds:[si+320+1]
    add ax, dx

    mov dl, ds:[si-320]
    add ax, dx
    mov dl, ds:[si+320]
    add ax, dx
    mov dl, ds:[si-1]
    add ax, dx
    mov dl, ds:[si+1]
    add ax, dx

    shr ax, 3

    stosb
    inc si

    dec cx
    jnz @l2

    dec bx
    jnz @l1

    pop ds
  end;
END;



Procedure Animate2;
  { Shutdown screen stuff. Just to show you where the processor time was
    going in the main effect ;) }
VAR AddFire : Boolean;
    FramesLeft : integer;
BEGIN
  while keypressed do readkey;
  cls (vga, 0);
  DrawText ( 16,  0,'THIS IS WHAT THE', VGA);
  DrawText ( 16, 16,'STARS WERE DOING', VGA);

  pal (226, 10,10,10);
  pal (228, 20,20,20);
  pal (231, 30,30,30);
  pal (234, 40,40,40);
  pal (236, 50,50,50);
  pal (238, 60,60,60);

  AddFire := TRUE;
  FramesLeft := 150;

  repeat
    UpdateSun (AddFire);

    if (keypressed) then
      AddFire := FALSE;

    if not AddFire then BEGIN
      FramesLeft := FramesLeft - 1;
      UpdateScreen;
    END;

    asm
      push ds

      mov ax, $a000
      mov es, ax
      xor di, di
      mov di, 96 + 43*320

      mov ax, sunseg
      mov ds, ax
      mov si, 256

      mov dx, 115
    @loop1 :

      mov cx, 64
      rep movsw

      add di, 320-128

      dec dx
      jnz @loop1

      pop ds
    end;
      { Flip sun to screen }

  until FramesLeft = 0;
END;

BEGIN
  setmcga;
  setup;

  Animate;
  Animate2;

  settext;
  freemem (field,sizeof (field^));
  freemem (field2,sizeof (field2^));
  freemem (sun, 128*128);
  shutdown;

  TextAttr := $1f;
  Writeln ('             Hot Star by Denthor (Grant Smith) of ASPHYXIA (1-1-97)             '+
           '                         --==[ dexter@iafrica.com ]==--                         ');
  normvideo;
  Writeln;
  Writeln ('Entry for The Codering. Features :');
  Writeln ('     Background stars');
  Writeln ('     Star tunnel (moving origin)');
  Writeln ('     Star rotation');
  Writeln ('     ''Burning'' star changing each frame');
  Writeln;
  Writeln ('It probably won''t win, but the source is free and it was a great way to spend a');
  Writeln ('public holiday. :-)');
  Writeln;
END.