void RemovePlayer()
{
	// Reset
	playertype=3;
	playercounter=0;
	
	// Explosion
	InitExplosion(playerx, playery,1);
	
	// Barrom
	DoBarrom();
	
	// Kill all enemies
	KillEnemyshoots();
	KillEnemies(0);
}


unsigned char CheckPlayerEnemyCollision()
{
	unsigned char a;
	enemy *en;

	//return 0;
	
	// Collision with enemies
	if(numenemies>0)
	for(a=0;a<numenemies;a++)
	{
		en=&enemies[a];
		if(en->enemyposy+en->enemyheight>playery+3)	
			if(en->enemyposy<playery+13)
				if(en->enemyposx<playerx+13)
					if(en->enemyposx+en->enemywidth>playerx+3)
					{
						RemovePlayer();
						return 1;
					}
	}
	return 0;
}

// Collision with enemyshoots
unsigned char CheckPlayerEnemyshootCollision()
{
	unsigned char a;
	enemyshoot *es;

	//return 0;
	
	if(numenemyshoots>0)
	for(a=0;a<numenemyshoots;a++)
	{
		es=&enemyshoots[a];
		if((es->enemyshootposy+5>playery)	
		&&(es->enemyshootposy<playery+13)
		&&(es->enemyshootposx<playerx+13)
		&&(es->enemyshootposx+5>playerx))
		{
			RemovePlayer();
			return 1;
		}
	}
	return 0;
}

// Hearts
void UpdatePlayerIndicators()
{
	for(unsigned char a=0;a<numplayers;a++)
		SMS_addSprite(240-a*8,4,PLAYERINDICATORBASE);
}

// Init a player
void InitPlayer()
{
	// Constants
	playerx=128;
	playery=200;
	playertype=0;
	playercounter=0;
}

// Load player sprite
void InitPlayerSprite()
{
	LoadSprite(player_psgcompr, PLAYERBASE,player_psgcompr_bank);
}

// Draw player sprite
void DrawPlayer()
{
	// Player sprite
	DrawQuadSprite(playerx,playery,PLAYERBASE);

	// Propulsion
	SMS_addSprite(playerx+4,playery+16,PLAYERBASE+4+sprite82anim);
}

// Move the player
void MovePlayer()
{
	// Move
	if(keystatus&PORT_A_KEY_LEFT)
		if(playerx>SPEEDPLAYERSHOOT_SIDE)
			playerx-=(DEFAULTPLAYERSPEED);
	if(keystatus&PORT_A_KEY_RIGHT)
		if(playerx<(240-SPEEDPLAYERSHOOT_SIDE))
			playerx+=(DEFAULTPLAYERSPEED);
	if(keystatus&PORT_A_KEY_UP)
		if(playery>24)
			playery-=(DEFAULTPLAYERSPEED);
	if(keystatus&PORT_A_KEY_DOWN)
		if(playery<172)
			playery+=(DEFAULTPLAYERSPEED);
}

// Check if player can shoot
void CheckShootPlayer()
{	
	if(playercounter>PLAYERSHOOTINTERVAL_NORMAL)
	{
		if(keystatus&PORT_A_KEY_2)
		{
			if(numplayershoots<MAXPLAYERSHOOTS-1)
			{
				playercounter=0;
				InitPlayershoot(playerx-8,playery,PLAYERSHOOT_SIDE_LEFT);
				InitPlayershoot(playerx+8,playery,PLAYERSHOOT_SIDE_RIGHT);
			}
		}
		if(keystatus&PORT_A_KEY_1)
		{
			if(numplayershoots<MAXPLAYERSHOOTS)
			{
				playercounter=0;
				InitPlayershoot(playerx,playery,PLAYERSHOOT_NORMAL);
			}
		}
	}
		/*		
	// Shoot
	if(keystatus&PORT_A_KEY_1)
	{
		if(keystatus&PORT_A_KEY_2)
		{
			if(numplayershoots<MAXPLAYERSHOOTS-2)
			{
				if(playercounter>PLAYERSHOOTINTERVAL_FULL)
				{
					playercounter=0;
					InitPlayershoot(playerx,playery,PLAYERSHOOT_NORMAL);
					InitPlayershoot(playerx-8,playery,PLAYERSHOOT_SIDE_LEFT);
					InitPlayershoot(playerx+8,playery,PLAYERSHOOT_SIDE_RIGHT);
				}
			}	
		}
		else
		{
			if(numplayershoots<MAXPLAYERSHOOTS)
			{
				if(playercounter>PLAYERSHOOTINTERVAL_NORMAL)
				{
					playercounter=0;
					InitPlayershoot(playerx,playery,PLAYERSHOOT_NORMAL);
				}
			}
		}
	}
	else if(keystatus&PORT_A_KEY_2)
	{
		if(numplayershoots<MAXPLAYERSHOOTS-1)
		{
			if(playercounter>PLAYERSHOOTINTERVAL_SIDE)
			{
				playercounter=0;
				InitPlayershoot(playerx-8,playery,PLAYERSHOOT_SIDE_LEFT);
				InitPlayershoot(playerx+8,playery,PLAYERSHOOT_SIDE_RIGHT);
			}
		}
	}
	*/
}

// Update player status
void UpdatePlayer()
{
	// Counter
	playercounter++;

	// State
	switch(playertype)
	{
		case 5:
			if(playery>playercounter>>4)
			{
				playery-=(playercounter>>4);
				DrawPlayer();
			}
			if(playercounter==160)
			{
				stagenum++;
				exitplaystage=1;
			}
		break;
		case 4:
			MovePlayer();
			DrawPlayer();
			if(playercounter==80)
			{
				playertype=5;
				PlayMusic(afterboss_psg,afterboss_psg_bank,0);
				playercounter=0;
			}
		break;
		case 3:
			if(playercounter>=40)
			{
				numplayers--;
				if(numplayers==0)
				{
					// Game over
					stagenum=0;
					exitplaystage=1;
				}
				else
					// Other player
					InitPlayer();
			}
		break;
		case 0:
			playery--;
			if(playery<160)
			{
				playertype=1;
				playercounter=0;
			}
			DrawPlayer();
		break;
		case 2:
			// Here the collisions
			if(CheckMapCollision(playerx+8,playery+8))
			{
				RemovePlayer();
				return;
			}
			else
			{
				if(stageframe4mod==0)
				{
					if(CheckPlayerEnemyCollision()==0)
					{
						// Continue				
						CheckShootPlayer();
						MovePlayer();
						DrawPlayer();
					}
				}
				else
				{
					if(CheckPlayerEnemyshootCollision()==0)
					{
						// Continue				
						CheckShootPlayer();
						MovePlayer();
						DrawPlayer();
					}
				}
			}
		break;
		case 1:
			if(playercounter>20)playertype=2;
			MovePlayer();
			DrawPlayer();
		break;
	}
}