' ene exporter
' generates minimal contents for usage in small ROMs.

sub usage
	print "$ eneexp2 enems.ene out.h prefix"
End Sub

Dim As Integer fIn, fOut
Dim As uByte d, a, b
Dim As String Dummy, prefix
Dim As Integer mapW, mapH, nEnems, mapPants, nPant, i, j, hl
Dim As uByte t, xy1, xy2, mn
Dim As Integer typeCounters (255)

If Command (3) = "" Then usage: End
prefix = Command (3)

' Outputs 4 bytes per entry
' TS for type + speed
' XY for ini
' XY for end

' .ENE contains...
' t x1 y1 x2 y2 n s1 s2
' n is speed
' s1, s2 are unused.

fIn = FreeFile
Open Command (1) For Binary As #fIn
fOut = FreeFile
Open Command (2) For Output As #fOut

' Skip header
dummy = Input (256, fIn)
Get #fIn, , d: mapW = d
Get #fIn, , d: mapH = d
Get #fIn, , d: Get #fIn, , d
Get #fIn, , d: nEnems = d

mapPants = mapW * mapH

Print #fOut, "// " & Command (2)
Print #fOut, "// Generated by enexp2.exe"
Print #fOut, "// Copyleft 2015 The Mojon Twins"
Print #fOut, ""
Print #fOut, "// Enems structure is {TS XY1 XY2} x " & nEnems & " x MAP_W x MAP_H"
If prefix = "_" Then
	Print #fOut, "const unsigned char enems [] = {"
Else
	Print #fOut, "const unsigned char enems_" & prefix & " [] = {"
End If

hl = 0
For i = 1 To (mapPants * nEnems)
	Get #fIn, , t
	Get #fIn, , a: Get #fIn, , b
	xy1 = (a Shl 4) Or (b And 15)
	Get #fIn, , a: Get #fIn, , b
	xy2 = (a Shl 4) Or (b And 15)
	Get #fIn, , mn
	Get #fIn, , d: Get #fIn, , d
	If hl = 0 Then Print #fOut, "	";
	Print #fOut, "0x" & Hex ((t Shl 4) + mn, 2) & ", 0x" & Hex (xy1, 2) & ", 0x" & Hex (xy2, 2);
	If i < (mapPants * nEnems) Then Print #fOut, ", ";
	hl = hl + 1: If hl = 3 Then hl = 0
	If hl = 0 Then Print #fOut, ""
Next i
Print #fOut, "};"
Print #fOut, ""
If (Command (4) <> "nohotspots") Then
	Print #fOut, "// Hotspots structure is {T XY} x MAP_W x MAP_H"
	If prefix = "_" Then
		Print #fOut, "const unsigned char hotspots [] = {"
	Else
		Print #fOut, "const unsigned char hotspots_" & prefix & " [] = {"
	End If
	hl = 0
	For i = 1 To mapPants
		Get #fIn, , xy1
		Get #fIn, , xy2
		xy1 = (xy1 Shl 4) Or (xy2 And 15)
		Get #fIn, , t
		if hl = 0 Then Print #fOut, "	";
		Print #fOut, "0x" & Hex (t, 2) & ", 0x" & Hex (xy1, 2);
		If i < mapPants Then Print #fOut, ", ";
		hl = (hl + 1) And 3
		If hl = 0 Then Print #fOut, ""
		typeCounters (t) = typeCounters (t) + 1
	Next i
	Print #fOut, "};"
	Print #fOut, ""
	
	For i = 0 To 255
		If typeCounters (i) <> 0 then
			' Print #fOut, "// Wrote " & typecounters (i) & " hotspots of type " & i
			Print #fOut, "#define MAX_HOTSPOTS_TYPE_" & i & "	" & typeCounters (i)	
		End If
	Next i
End If

Close fIn, fOut

Print Command (1) & " read. " & Command (2) & " written. Podewwwr!"
