;Chappie ears game for the Master System
;Furrtek 2015
;Do whatever you want with everything :)

.memorymap
defaultslot 0
slotsize $8000
slot 0 $0000
.endme

.rombankmap
bankstotal 1
banksize $8000
banks 1
.endro

;Possible states
.DEFINE ST_PAUSE 0
.DEFINE ST_LEFTANIM 1
.DEFINE ST_RIGHTANIM 2
.DEFINE ST_LONGPAUSE 3
.DEFINE ST_INPUT 4

.sdsctag 1.10,"CHAPPIESMN","Simon says","Furrtek"

.bank 0 slot 0
.org $0000
  di
  im 1
  jp main

.ORG $0038
  push af
  in   a,($BF)
  ld   (VBLFLAG),a
  pop  af
  ei
  ret

.org $0066
  retn

main:
  ld   sp,$DFF0

  ;Set VDP registers
  ld   hl,vdpregs
  ld   b,vdpregsend-vdpregs
  ld   c,$BF
  otir

  ;Clear whole VRAM
  ld   a,$00
  out  ($BF),a
  push ix
  pop  ix
  ld   a,$40
  out  ($BF),a
  ld   bc,$4000
-:
  xor  a
  out  ($BE),a
  dec  bc
  ld   a,b
  or   c
  jr   nz,-

  ;Load palettes
  ld   a,$00
  out  ($BF),a
  push ix
  pop  ix
  ld   a,$C0
  out  ($BF),a
  ld   hl,PaletteData
  ld   b,32
  ld   c,$BE
  otir

  ;Load head tiles
  ld   de,$0000
  ld   hl,tiles_head
  ld   b,128
  call loadtiles
  
  ;Load ear1a tiles
  ld   de,$0000+(100*32)
  ld   hl,tiles_ear1a
  ld   b,21
  call loadtiles

  ;Load ear1b tiles
  ld   de,$0000+((100+21)*32)
  ld   hl,tiles_ear1b
  ld   b,17
  call loadtiles
  
  ;Load ear1c tiles
  ld   de,$0000+((100+21+17)*32)
  ld   hl,tiles_ear1c
  ld   b,15
  call loadtiles

  ;Load ear2a tiles
  ld   de,$0000+((100+21+17+15)*32)
  ld   hl,tiles_ear2a
  ld   b,19
  call loadtiles

  ;Load ear2b tiles
  ld   de,$0000+((100+21+17+15+19)*32)
  ld   hl,tiles_ear2b
  ld   b,15
  call loadtiles
  
  ;Load ear2c tiles
  ld   de,$0000+((100+21+17+15+19+15)*32)
  ld   hl,tiles_ear2c
  ld   b,13
  call loadtiles

  ;Load eyesn tiles
  ld   de,$0000+((100+21+17+15+19+15+13)*32)
  ld   hl,tiles_eyesn
  ld   b,13
  call loadtiles
  
  ;Load eyesh tiles
  ld   de,$0000+((100+21+17+15+19+15+13+8)*32)
  ld   hl,tiles_eyesh
  ld   b,13
  call loadtiles
  
  ;Load eyess tiles
  ld   de,$0000+((100+21+17+15+19+15+13+8+8)*32)
  ld   hl,tiles_eyess
  ld   b,13
  call loadtiles
  
  ;Load heart tiles
  ld   de,$0000+((100+21+17+15+19+15+13+8+8+8)*32)
  ld   hl,tiles_heart
  ld   b,4
  call loadtiles
  
  ;Load title tiles
  ld   de,$0000+((100+21+17+15+19+15+13+8+8+8+4)*32)
  ld   hl,tiles_title
  ld   b,37
  call loadtiles

  ;Map head
  ld   de,$3800+(9*$02)+(4*$40)
  ld   hl,map_head
  ld   bc,$0E12  ;WWHH
  xor  a
  ld   (TIDX),a
  call maptiles

  ;Map left ear
  ld   de,$3800+(10*2)+(4*$40)
  ld   hl,map_ear1a+1
  ld   bc,$0507  ;WWHH
  ld   a,100
  ld   (TIDX),a
  call maptiles

  ;Map right ear
  ld   de,$3800+(17*2)+(4*$40)
  ld   hl,map_ear2a+1
  ld   bc,$0507  ;WWHH
  ld   a,100+21+17+15
  ld   (TIDX),a
  call maptiles

  ;Map normal eyes
  ld   de,$3800+(14*$02)+(14*$40)
  ld   hl,map_eyes
  ld   bc,$0402  ;WWHH
  ld   a,100+21+17+15+19+15+13
  ld   (TIDX),a
  call maptiles

  ;Map title
  ld   de,$3800+(5*$02)+(1*$40)
  ld   hl,map_title
  ld   bc,$1603  ;WWHH
  ld   a,100+21+17+15+19+15+13+8+8+8+4
  ld   (TIDX),a
  call maptiles

  ;Sprite setup
  ld   a,$00
  out  ($BF),a
  push ix
  pop  ix
  ld   a,$3F+$40
  out  ($BF),a
  push ix
  pop  ix
  ld   a,$D0
  out  ($BE),a		;Nothing for now

  ld   a,$80
  out  ($BF),a
  push ix
  pop  ix
  ld   a,$3F+$40
  out  ($BF),a
  ld   a,120
  out  ($BE),a		;X
  push ix
  pop  ix
  ld   a,100+21+17+15+19+15+13+8+8+8
  out  ($BE),a		;Tile #
  push ix
  pop  ix
  ld   a,120+8
  out  ($BE),a		;X
  push ix
  pop  ix
  ld   a,100+21+17+15+19+15+13+8+8+8+2
  out  ($BE),a		;Tile #

  ;Turn screen on
  ld   a,%11100110
  out  ($BF),a
  push ix
  pop  ix
  ld   a,$81
  out  ($BF),a
  
  ld   a,$1D
  ld   (LAST_RAND),a	;Seed
  ld   a,$EA
  ld   (LAST_RAND+1),a

  xor  a
  ld   (TIMER),a
  ld   (SEQPTR),a
  ld   (FXIDX),a
  ld   a,7
  ld   (SEQLEN),a	;Wanted to have progressive length SEQ but didn't have time :/
  ld   (LOST),a
  ld   a,ST_LONGPAUSE
  ld   (STATE),a
  ld   hl,fx_null	;Loops VGM player to nothing
  call prepfx

  ld   de,seq_test	;Debug
  ld   hl,SEQ
  ld   b,7
-:
  ld   a,(de)
  ld   (hl),a
  inc  de
  inc  hl
  djnz -

  ei

-:
  ld   a,(VBLFLAG)	;Wait for vblank
  or   a
  jr   z,-
  xor  a
  ld   (VBLFLAG),a

  ld   a,(STATE)	;STATE MACHEEN jumptable
  ld   hl,jt_state
  sla  a
  add  a,l
  jr   nc,+
  inc  h
+:
  ld   l,a
  ld   a,(hl)
  inc  hl
  ld   h,(hl)
  ld   l,a
  call dojump
  
  ld   a,(TIMER)
  inc  a
  ld   (TIMER),a

  jp -

dojump:
  jp   (hl)

seq_test:
  .db 1,1,2,2,1,2,1,2
  
fx_null:
  .db $66
  
jt_state:
  .dw proc_pause
  .dw proc_ear1
  .dw proc_ear2
  .dw proc_lpause
  .dw proc_input
  
proc_input:
  call readjp

  ld   a,(JP_ACTIVE)
  bit  2,a
  jr   z,+
  ;Left
  ld   a,(SEQCHECK)
  ld   b,a
  ld   hl,SEQENTER
  add  a,l
  jr   nc,++
  inc  h
++:
  ld   l,a
  ld   a,1
  ld   (hl),a		;Add input to player sequence
  ld   a,b
  inc  a
  ld   (SEQCHECK),a
+:

  ld   a,(JP_ACTIVE)
  bit  3,a
  jr   z,+
  ;Right
  ld   a,(SEQCHECK)
  ld   b,a
  ld   hl,SEQENTER
  add  a,l
  jr   nc,++
  inc  h
++:
  ld   l,a
  ld   a,2
  ld   (hl),a		;Add input to player sequence
  ld   a,b
  inc  a
  ld   (SEQCHECK),a
+:

  ld   a,(SEQCHECK)	;Sequence full ?
  cp   7
  ret  nz
  
  ;Check if player did ir right
  ld   hl,SEQ
  ld   de,SEQENTER
  ld   b,7
-:
  ld   c,(hl)
  ld   a,(de)
  cp   c
  jr   nz,+
  inc  de
  inc  hl
  djnz -
+:

  ld   a,b
  ld   (LOST),a		;Nonzero is wrong
  
  ld   hl,fxh		;Happy sound
  or   a
  jr   z,+
  ld   hl,fxs		;Sad sound
+:
  call prepfx
  
  ld   a,b		;Refresh eyes
  or   a
  ld   a,100+21+17+15+19+15+13+8
  jr   z,+
  ld   a,100+21+17+15+19+15+13+8+8
+:
  ld   de,$3800+(14*$02)+(14*$40)
  ld   hl,map_eyes
  ld   bc,$0402  ;WWHH
  ld   (TIDX),a
  call maptiles

  ld   a,ST_LONGPAUSE
  ld   (STATE),a
  xor  a
  ld   (TIMER),a
  ret
  
proc_pause:
  ld   a,(TIMER)	;Not used :)
  cp   15
  ret  nz
  jp   nextstate
  
proc_ear1:
  ld   a,(TIMER)	;Animate left ear
  srl  a
  srl  a
  and  3
  ld   hl,lut_ear1
  sla  a
  add  a,l
  jr   nc,+
  inc  h
+:
  ld   l,a
  ld   a,(hl)
  inc  hl
  ld   h,(hl)
  ld   l,a

  ld   de,$3800+(10*2)+(4*$40)
  ld   bc,$0507  ;WWHH
  ld   a,(hl)
  inc  hl
  ld   (TIDX),a
  call maptiles

  call updfx
  
  ld   a,(TIMER)
  cp   15
  ret  nz
  jp   nextstate

proc_ear2:
  ld   a,(TIMER)	;Animate right ear
  srl  a
  srl  a
  and  3
  ld   hl,lut_ear2
  sla  a
  add  a,l
  jr   nc,+
  inc  h
+:
  ld   l,a
  ld   a,(hl)
  inc  hl
  ld   h,(hl)
  ld   l,a

  ld   de,$3800+(17*2)+(4*$40)
  ld   bc,$0507  ;WWHH
  ld   a,(hl)
  inc  hl
  ld   (TIDX),a
  call maptiles
  
  call updfx

  ld   a,(TIMER)
  cp   15
  ret  nz
  jr   nextstate

proc_lpause:
  call updfx
  
  ld   a,(LOST)
  or   a
  jr   nz,+
  ld   a,(TIMER)	;Animate <3 icon
  cp   50
  jr   nc,+
  sra  a
  cpl
  add  a,64		;64-Y
  ld   b,a
  ld   a,$00
  out  ($BF),a
  push ix
  pop  ix
  ld   a,$3F+$40
  out  ($BF),a
  push ix
  pop  ix
  ld   a,b
  out  ($BE),a
  push ix
  pop  ix
  ld   a,b
  out  ($BE),a
  push ix
  pop  ix
  ld   a,$D0
  out  ($BE),a
+:

  ld   a,(TIMER)
  cp   50
  jr   nz,+
  ld   a,$00
  out  ($BF),a
  push ix
  pop  ix
  ld   a,$3F+$40
  out  ($BF),a
  push ix
  pop  ix
  ld   a,$D0		;Disable <3
  out  ($BE),a
  ld   a,100+21+17+15+19+15+13
  ld   de,$3800+(14*$02)+(14*$40)
  ld   hl,map_eyes
  ld   bc,$0402  ;WWHH
  ld   (TIDX),a
  call maptiles         ;Normal eyes
+:
  cp   100
  ret  nz
  jr   nextstate

nextstate:		;SM state change
  xor  a
  ld   (TIMER),a
  ld   a,(STATE)
  cp   ST_PAUSE
  jr   z,nst_anim
  cp   ST_LEFTANIM
  jr   z,nst_anim
  cp   ST_RIGHTANIM
  jr   z,nst_anim
  cp   ST_LONGPAUSE
  jr   z,nst_lp
  ret
  
readjp:
  ld   hl,JP_LAST
  in   a,($DC)
  ld   b,a
  xor  $FF
  ld   (JP_CURRENT),a
  ld   c,a
  ld   a,(hl)
  ld   (hl),b
  xor  b		;Difference
  and  c                ;Rising edges
  ld   (JP_ACTIVE),a
  ret

updfx:
  ld   a,(FXPTR)	;VGM play
  ld   l,a
  ld   a,(FXPTR+1)
  ld   h,a
  ld   a,(FXIDX)	;Offset
  ld   b,a
  add  a,l
  jr   nc,+
  inc  h
+:
  ld   l,a
-:
  ld   a,(hl)
  cp   $66		;End
  ret  z
  cp   $62		;Wait frame
  jr   z,+
  inc  hl
  inc  b
  ld   a,(hl)
  out  ($7F),a
  inc  hl
  inc  b
  jr   -
+:
  ld   a,b
  inc  a
  ld   (FXIDX),a
  ret

nst_anim:
  ld   hl,SEQ		;Chappie moves ears
  ld   a,(SEQPTR)
  inc  a
  cp   7
  jr   z,++
  ld   (SEQPTR),a
  add  a,l
  jr   nc,+
  inc  h
+:
  ld   l,a
  ld   a,(hl)
  ld   (STATE),a	;Set state for animation
  or   a
  ret  z
  cp   1
  ld   hl,fx1		;Left ear sound
  jr   z,+
  ld   hl,fx2		;Right ear sound
+:
  call prepfx
  ret
++:
  xor  a
  ld   (SEQCHECK),a
  ld   a,ST_INPUT
  ld   (STATE),a
  ret

nst_lp:
  xor  a
  ld   (SEQPTR),a
  ld   hl,SEQ		;Make new seq
  ld   b,7
-:
  call getrand
  ld   a,(LAST_RAND)
  srl  a		;Whatever...
  and  1
  inc  a
  ld   (hl),a		;1 or 2
  inc  hl
  djnz -
  xor  a
  ld   (FXIDX),a
  ld   a,(SEQ)		;Start playing
  cp   1
  ld   hl,fx1
  jr   z,+
  ld   hl,fx2
+:
  ld   (STATE),a
  ld   a,l
  ld   (FXPTR),a
  ld   a,h
  ld   (FXPTR+1),a
  ret

lut_ear1:
  .dw map_ear1b
  .dw map_ear1c
  .dw map_ear1b
  .dw map_ear1a

lut_ear2:
  .dw map_ear2b
  .dw map_ear2c
  .dw map_ear2b
  .dw map_ear2a

prepfx:
  ld   a,l
  ld   (FXPTR),a
  ld   a,h
  ld   (FXPTR+1),a
  xor  a
  ld   (FXIDX),a
  ret

getrand:
  push af
  push de
  push hl
  ld   de,(LAST_RAND)
  ld   a,d
  ld   h,e
  ld   l,253
  or   a
  sbc  hl,de
  sbc  a,0
  sbc  hl,de
  ld   d,0
  sbc  a,d
  ld   e,a
  sbc  hl,de
  jr   nc,+
  inc  hl
+:
  ld   (LAST_RAND),hl
  pop  hl
  pop  de
  pop  af
  ret

maptiles:
  ld   a,e
  out  ($BF),a
  ld   a,d
  or   $40
  push ix
  pop  ix
  out  ($BF),a
  push bc
-:
  ld   a,(TIDX)
  add  a,(hl)
  out  ($BE),a
  ld   a,0
  adc  a,0
  inc  hl
  or   (hl)
  out  ($BE),a
  inc  hl

  dec  b
  ld   a,b
  or   a
  jr   nz,-

  push hl
  ld   hl,$0040		;Next line
  add  hl,de
  ld   d,h
  ld   e,l
  ld   a,e
  out  ($BF),a
  push ix
  pop  ix
  ld   a,d
  or   $40
  out  ($BF),a
  pop  hl

  pop  af
  push af
  ld   b,a
  dec  c
  ld   a,c
  or   a
  jr   nz,-
  pop  af
  ret

loadtiles:
  ld   a,e
  out  ($BF),a
  ld   a,d
  or   $40
  push ix
  pop  ix
  out  ($BF),a
  ld   c,$08
-:
  ld   a,(hl)
  out  ($BE),a
  push ix
  pop  ix
  inc  hl
  ld   a,(hl)
  out  ($BE),a
  push ix
  pop  ix
  inc  hl
  ld   a,(hl)
  out  ($BE),a
  push ix
  pop  ix
  inc  hl
  ld   a,(hl)
  out  ($BE),a
  push ix
  pop  ix
  inc  hl
  dec  c
  jp   nz,-
  ld   c,8
  dec  b
  jp   nz,-
  ret

tiles_head:
.include "gfx/tiles_head.inc"
tiles_ear1a:
.include "gfx/tiles_ear1a.inc"
tiles_ear1b:
.include "gfx/tiles_ear1b.inc"
tiles_ear1c:
.include "gfx/tiles_ear1c.inc"
tiles_ear2a:
.include "gfx/tiles_ear2a.inc"
tiles_ear2b:
.include "gfx/tiles_ear2b.inc"
tiles_ear2c:
.include "gfx/tiles_ear2c.inc"

map_head:
.include "gfx/map_head.inc"
map_ear1a:
.db 100
.include "gfx/map_ear1a.inc"
map_ear1b:
.db 100+21
.include "gfx/map_ear1b.inc"
map_ear1c:
.db 100+21+17
.include "gfx/map_ear1c.inc"
map_ear2a:
.db 100+21+17+15
.include "gfx/map_ear2a.inc"
map_ear2b:
.db 100+21+17+15+19
.include "gfx/map_ear2b.inc"
map_ear2c:
.db 100+21+17+15+19+15
.include "gfx/map_ear2c.inc"

tiles_eyesn:
.include "gfx/tiles_eyesn.inc"
tiles_eyesh:
.include "gfx/tiles_eyesh.inc"
tiles_eyess:
.include "gfx/tiles_eyess.inc"

map_eyes:
.include "gfx/map_eyes.inc"

tiles_heart:
.include "gfx/tiles_heart.inc"

tiles_title:
.include "gfx/tiles_title.inc"
map_title:
.include "gfx/map_title.inc"

fx1:
.incbin "fx1.bin"
fx2:
.incbin "fx2.bin"
fxh:
.incbin "fxh.bin"
fxs:
.incbin "fxs.bin"

PaletteData:
.db $3F $14 $39 $1B $07 $03 $3F $2A $15 $00 $17 $2A $00 $00 $00 $00
.db $3F $14 $39 $1B $07 $03 $3F $2A $15 $00 $17 $2A $00 $00 $00 $00

vdpregs:
.db $04,$80,%10100010,$81,$ff,$82,$ff,$85,$fb,$86,$F0,$87,$00,$88,$00,$89,$ff,$8a
vdpregsend:

.INCLUDE "ram.asm"

