;SMS FM Tool by Chris Covell, January-March 2015

;==============================================================
; WLA-DX banking setup
;==============================================================
.memorymap
defaultslot 0
slotsize $4000
slot 0 $0000
slot 1 $4000
slot 2 $8000
.endme

.rombankmap
bankstotal 4
banksize $4000
banks 4
.endro

.define Splash_Delay	    $0200
.define Debug_Delay	    $0100
.define Hint_Delay	    $0045

.define SpriteSet           0       ; 0 for sprites to use tiles 0-255, 1 for 256+
.define VRAM_MAP	    $3800 | $4000
.define SpriteTableAddress  $3f00   ; must be a multiple of $100; usually $3f00; fills $100 bytes


;==============================================================
; SDSC tag and SMS rom header
;==============================================================
.sdsctag 1.00,"SMS FM Toy","Use with Paddle(s)","Chris Covell"

.enum $c040
cont1		db	;Controller 1 data
trigger 	db	;Controller trigger
cont2		db	;Controller 2 optional
cont2_trg	db      ;adjacent!
cont2_Paddle_On db
cont2_Paddle_Cur db
cont2_Pdl1	db      ;Old 1
cont2_Pdl2	db      ;Old 2
cont2_Pdl3	db      ;Old 3
cont2_PdlAvg	db      ;Average
cont2_PdlAvgOld db	;Old Version
delay1		dw	;It's a WORD now!
;delay1H
delay2		db
delayHint	dw	;Countdown timer to give hints
temp_addr       dw
Hsyncs		db
lineno		db
nmipass		db
nmicount 	db
prog_mode	db	;Program mode? 0= making music, 1=debug, 2=splash
trigger_mode	db	;0 = locked Trig/Key, 1=Normal Select, 2=Retrigger, 3=KeyONOFF
old_trigmode	db
detune_on	db	;1 = ON, read paddle & detune
detune_lvl	dw	;How much to detune? +1FF to -1FF
detune_chg	db	;Do we update stuff for detuning?
paused		db	;Toggled with the PAUSE NMI!
;----
Paddle_On	db
Paddle_But	db
Paddle_Old	db
Paddle_Avg 	db
Paddle_Cur 	db
Paddle_64 	db	;Paddle value scaled down to 0..$3F
Paddle_16 	db    ;      "         "           0..$0F
Paddle_8  	db    ;      "         "           0..$07
Curr_Inst 	db
FM_Present 	db
;----------
RowNum		db	;Which row 0..14 or so
ColNum  	db	;Which column in each row? (0..7)
RowColXOR	db	;XOR value of old Row, Column
CursDepth 	db    ;00 = editing value, 01 = in Row, 02 =Column 0 choosing Rows
PauseTrgFlag	db	;Flag for Pause OR (2) button!
TrgReleaseFlag  db	;for when (2) button is released!
KeySusMask	db	;Mask out Sustain/Key

; -- below are triggers for VRAM writing in the following VBlank
VBL_Write_ADDR  dsb 2	;$00xx = No writing, otherwise address to "out ($bf)"
VBL_Write_DATA  db	;data to use (manipulation needed, usually...)
VBL_Write_TYPE  db	;0=as-is, 1=checkmark, 2=HEX byte, 3=nybble...
			;$1x = 3 nybbles, high nybble is in the TYPE lnyb
			;$2x = Text writing... INSTRUMENT pointer is in DATA.
;------------------------

;----- FM Instrument Settings!
Tmp_Freq_Lo:	dsb 9	;Temporary frequency
Tmp_Freq_Hi:	dsb 9	;

FM_Freq_Lo:	dsb 9	;bits 0..7 of frequency
FM_Freq_Hi:	dsb 9	;Only a single bit...
FM_Octave:	dsb 9	;0..7 then shifted left one at FM Write time
FM_SusKey:	dsb 9	;Sus = $20, Key = $10, saved as-is.
FM_Instrument:	dsb 9	;$00,$10,...$F0	 (stored in high nybble!)
FM_Volume:	dsb 9	;0..F, Store as-is: F=silent...0=max
FM_Vol_Store:	dsb 3	;When drums are on, temporarily save regs $36,37,38

FM_RTM_Reg:	db	;All the bits for Rhythm in one register
FM_RTM_Vol:     db	;Rhythm VOLUME (a single one, sorry!)

FM_Cust_Switches: dw	;4 bits of switches: Tremolo,Vibrato,Sustain,Rate Key Scale,0000
FM_Cust_Mul:	dw	;0..F, Waveform Rate (Freq?) Multiplier
FM_Cust_LVSc:	dw	;0..3, Level Key Scale factor
FM_Cust_TotLv:  db	;0..3F, Total Level for MODULATOR
FM_Cust_FB:	db	;0..7,  Feedback for MOD/CARRIER
FM_Cust_DistSw: db	;$10 = Carrier distortion, $08 = Modulator distortion

FM_Cust_Attack: dw	;Modulator, Carrier attack ($Fx, but stored as $xF!!!)
FM_Cust_Decay:  dw      ;"   "  decay ($xF)
FM_Cust_Sustain: dw	;"   "  sustain ($Fx, but stored as $xF!!!)
FM_Cust_Release: dw	;"   "  release ($xF)

;-----
.ende

.bank 0 slot 0
.org $0000
;==============================================================
; Boot section
;==============================================================
    di              ; disable interrupts
    im 1            ; Interrupt mode 1
    jp main         ; jump to main program

.org $0038
;==============================================================
; IRQ handler
;==============================================================
    ; Do nothing
	di
	push AF
	in a,($bf)	;check VDP status
	and %10000000		;If it's non-zero, V-sync
	jr nz,NoHSyncFlag
	jp HsyncHandler	;Else it's an H/other interrupt
;----------finished!!!
NoHSyncFlag:
	jp VsyncHandler
;----------finished!!!

.org $0066
;==============================================================
; Pause button handler
;==============================================================
	push AF
	ld a,1
	ld (PauseTrgFlag),a
	ld a,(paused)
	xor 1
	ld (paused),a
	pop AF
	retn


;==============================================================
; Main program
;==============================================================
main:

    ld sp, $dfef
    xor a
    ld ($fffd),a    ;Make sure page 0 is in here.
    inc a
    ld ($fffe),a		;set to bank 1
    inc a
    ld ($ffff),a		;set to bank 2

wait_vdp_ready_lp:	;Try to appease the VDP gods here!
	in a,($bf)		;check VDP status
	and %10000000		;If it's non-zero, V-sync
	jr nz,wait_vdp_ready_lp

    ;TURN SCREEN, INTERRUPTS OFF!
    ld a,%10000100
    out ($bf),a
    ld a,$81
    out ($bf),a

	xor a
	ld hl, $C040
	ld bc, $0FC0
Start_Wait_Loop:
	ld (HL),a
        inc l
        dec c
        jp nz,Start_Wait_Loop
        inc h
        dec b
        jp nz,Start_Wait_Loop
;--------

;	Below not needed because of above.
	xor a
	ld (nmipass),a
	ld (nmicount),a
	ld (FM_Present),a
	ld (Paddle_Cur),a
	ld (Paddle_Old),a
	ld (Paddle_Avg),a
	ld (Paddle_64),a
	ld (cont2_trg),a
	ld (cont2),a
	ld (detune_on),a
	ld (RowNum),a
	ld (ColNum),a
	ld (RowColXOR),a
	ld (cont1),a
	ld (trigger),a
	ld (detune_lvl),a
	ld (detune_lvl+1),a
	ld (detune_chg),a
	ld (paused),a
	ld (VBL_Write_ADDR),a
	ld (VBL_Write_ADDR+1),a
	ld (PauseTrgFlag),a
	ld (TrgReleaseFlag),a

	ld a,2          ;Splash Screen!
	ld (prog_mode),a

	ld a,$80
	ld (Curr_Inst),a

	ld a,$7f           ;Means NO detuning!
	ld (cont2_PdlAvg),a

	ld a,2
	ld (CursDepth),a	;Set to Choosing Rows!

	ld a,$FF
	ld (KeySusMask),a

	ld a,1			;Starting mode is normal, switchable
	ld (trigger_mode),a
	ld (old_trigmode),a


Tile_Loading:
	call VDP_setup
	call NoSprites
	call FMDetection
	call FM_Init
	call Splash_Screen_Wait		;Wait at splash screen!

	call Load_Tiles
	call Load_Palette
        ld a,$55
    	out ($3f),a	;Make Japanese systems work!?

	ld a,1          ;Go To Debug Screen!
	ld (prog_mode),a
	call Debug_Wait

	ld a,0          ;Go To Main Screen!
	ld (prog_mode),a
	ld (PauseTrgFlag),a	;Clear any triggering...
;-------- wait 1
	call Load_Map
	call Init_Message

	call FM_Init
	call FM_First_Note
	call Screen_On

        ld a,$55
    	out ($3f),a	;Make Japanese systems work!?

	call Disable_H_Int
	ei	;enable interrupts

;========================================================
    ; Our Main Loop
Loop:
	ld a,(nmipass)
	or a
	jr z,Loop

	xor a
	ld (nmipass),a

	ld a,(nmicount)		;every $40 vblanks, check connected controller
	and $3f
	jr nz,No_Check_Paddle
	call DetectJapanesePaddle
	call DetectCon2Paddle	;Check if Controller 2 around?
        jr	control_end	;Don't read any more this time.


No_Check_Paddle:
	call	ReadCon2Paddle
	ld a,(Paddle_On)
	or a
	jr nz,pdl_read
	call Read_Controller
	call Controller_Action
	call Move_Cursor_Joy
	jr mixed_paddle_or_controller	;control_end


pdl_read:
;	call DetectJapanesePaddle
	call PaddleAction
	call Move_Cursor_Pdl

mixed_paddle_or_controller:
	call ButtonAction
control_end:

	jr Loop



;++++++++++++++++++++++++++++++++++++++++++


;**************************************************************
; HSync, VSync
;**************************************************************

HsyncHandler:
	pop AF	;push was in the interrupt vec!
	ei
    	reti

VsyncHandler:
	push HL
	push DE
	push BC

	ld a,(prog_mode)
	cp 2
	jr z,vb_splash
	cp 1
	jr z,vb_debug
	cp 0
	jr z,vb_music_mode
	jr vb_end
;----------------- Splash Screen Code
vb_splash:	
	ld a,(paused)		;If paused, don't decrement wait
	or a
	jr nz,vb_splsh_no_delay
	ld a,(delay1+1)
	ld b,a
	ld a,(delay1)		;if delay is zero, do nothing.
	or b
	jr z,vb_splsh_no_delay
	ld HL,(delay1)
	dec HL
	ld (delay1),HL
vb_splsh_no_delay:

	jr vb_end
;-------------------- Debug Mode Code
vb_debug:
	call Print_FM_Paddle	;Is this OK?
	jr vb_splash
	jr vb_end
;----------
;------------------ Music Mode Code
vb_music_mode:
	call Check_VB_Write	;Auto writing during VBlank
	call Move_Sprites
	call Auto_Text_Print	;Prints text strings based on mode/cursor
;------------------

vb_end:
	ld a,(nmicount)
	inc a
	ld (nmicount),a
	xor a
	ld (Hsyncs),a
	ld a,1
	ld (nmipass),a

VIRQ_End:
	pop BC
	pop DE
	pop HL
	pop AF	;push was in the interrupt vec!
	ei
    	reti

;**************************************************************
; Subroutines
;**************************************************************


;--------------------------------------------
.include "gfx_basic_code.inc"
.include "screen_interface.inc"
.include "paddle_joy_code.inc"
.include "fm_code.inc"
.include "sprite_code.inc"

;*************************************************************************
;*************************************************************************
;		Graphics now follow!!!!!
;*************************************************************************
;*************************************************************************

TxtMap:
.include "gfx\text-map.inc"
TxtMapEnd:

TxtTiles:
.include "gfx\text-til.inc"
TxtTilesEnd:

SprTiles:
.include "gfx\spr-til.inc"
SprTilesEnd:



.bank 1 slot 1
.org $0000
Splash_Pal:
.include "gfx\splash-pal1.inc"
.include "gfx\splash-pal2.inc"

SplashTiles:
.include "gfx\splash-til0.inc"
.include "gfx\splash-til1.inc"
.include "gfx\splash-til2.inc"
SplashTilesEnd:

SplashMap:
.include "gfx\splash-map1.inc"
.include "gfx\splash-map2.inc"
SplashMapEnd:

.bank 2 slot 0
.org $8000

.bank 3 slot 0	;Unusable?
.org $8000