;SMS FM Tool by Chris Covell, January-March 2015

;Hmmm.... MEKA might have a bug.  When a paddle is set on Control Port 2, but a
;joypad is in Control Port 1, MEKA gets constant phantom presses from that joypad.
;There isn't this problem on a Japanese SMS.

ButtonAction:		;Check button press and move between rows\cols.


;======= Check controller 2 Button (1) triggered. ==========
	ld a,(cont2_trg)
	and 4		;xxxx21RL
	jr z,no_con2_trg
	ld a,1		;If the button WAS changed, signal the change!
	ld (detune_chg),a
	ld a,(detune_on)	;And swap detune activation
	xor 1
	ld (detune_on),a
	jr z,off_detuning	;If detuning now OFF, Clear the value, etc.
on_detuning:
	call FM_Get_Detune_Level
	call FM_New_Detune		;Detune all channels!
	jr no_detune_change	;no_con2_trg
off_detuning:
	;A should still be Zero
	ld (detune_lvl),a
	ld (detune_lvl+1),a
	call FM_New_Detune		;Detune all channels!
	jr no_detune_change
no_con2_trg:

;===== Check Con 2 Paddle for detuning =======
	ld a,(detune_on)	;If detuning off, no change
	or a
	jr z,no_detune_change
	ld a,(cont2_PdlAvg)
	ld b,a
	ld a,(cont2_PdlAvgOld)
	xor b                	;Compare Current and Old
	jr z,no_detune_change
	ld a,1			;signal the change!
	ld (detune_chg),a
	call FM_Get_Detune_Level
	call FM_New_Detune		;Detune all channels!

no_detune_change:
;============================================


;======== PAUSE and/or (2) BUTTON CHECK =========
	ld a,(PauseTrgFlag)	;First check if pushed Pause/2 Button
	or a
	jr z,no_pause_button
;------------- PAUSE BUTTON HERE
        xor a
	ld (PauseTrgFlag),a	;Clear our Triggered flag
	ld a,(trigger_mode)
	cp 0
	jr z,trgmode0_check_pause
;================================ Trigger Mode 1,2,3 Pause Pushed
	;If not mode 0, check button 1 also pushed
	ld a,(cont1)
    	and $10		;This is button 1
    	jr z,no_enter_trigmode_0
	xor a		;If button 1 HELD and Pause/2 Triggered...
        ld (trigger_mode),a 	;Go to Mode 0
	ret
no_enter_trigmode_0:
	;if not that, move mode up
	ld a,(trigger_mode)
	inc a
	cp 4
	jr nz,+
	ld a,1	;Mode 3-> Mode 1
+:	ld (trigger_mode),a
	ret

;================================ Trigger Mode 0 Pause Pushed
trgmode0_check_pause:
	;We're in Trigger Mode 0
	ld a,(cont1)
    	and $10		;This is button 1
    	jr z,no_escape_trigmode_0
	ld a,1			;If button 1 HELD and Pause/2 Triggered...
        ld (trigger_mode),a 	;Go to Mode 1
	ret
no_escape_trigmode_0:
	;so, retrigger the sounds
	ld a,$FF
	ld (KeySusMask),a
	call	FM_Retrigger_All
no_pause_button:


;Check modes and buttons pressed/released!
	ld a,(trigger_mode)
	cp 0
	jr nz,+

	;In trgmode zero, (2) released also STOPS voice!
	ld a,(TrgReleaseFlag)	;Next check if 2 button is Released!
	and $20			;isolate button 2
	jr z,no_release_button
	ld a,$EF		;KEY OFF
	ld (KeySusMask),a
	call	FM_KEY_OFF_ALL
no_release_button:
	jr menu_button_action
+:	cp 1
	jr nz,+

	;trgmode 1, do nothing...
	jr menu_button_action
+:	cp 2
	jr nz,+

	;trgmode 2, (1) button retriggers
tgrmode2_check:
	ld a,(trigger)
    	and $10
    	jr z,menu_button_action	;Probably nothing happens here, either.
	ld a,$FF
	ld (KeySusMask),a
	call	FM_Retrigger_All
	jr menu_button_action

+:	cp 3
	jr nz,+

	;trgmode 3, (1) button retriggers and is released!
	ld a,(TrgReleaseFlag)	;Next check if 1 button is Released!
	and $10			;isolate button 1
	jr z,tgrmode2_check	;If not, still check for button (1) trigger
	;if released, silence voices
	ld a,$EF		;KEY OFF
	ld (KeySusMask),a
	call	FM_KEY_OFF_ALL

+: ;What, then????

menu_button_action:
;=====================================
	ld a,(trigger_mode)
	and 2			;If trigger mode is 2 or 3, NO selection stuff!
	jr nz,no_trigger_action

;Trig Mode 0,1 Button 1 action:
	ld a,(trigger)
    	and $10
    	jr z,no_trigger_action
        ld a,(CursDepth)	;What level are we moving on?
	cp 2	;Choosing a row?
	jr nz,not_to_lev1
	;If was level 2, fix row and now choose column
	dec a
	ld (CursDepth),a
	ret
not_to_lev1:
	cp 1
	jr nz,was_lev_0
	;If in some columns, choose if Col 0 (Go up to lev 2) otherwise.. to 0.
	ld a,(ColNum)
	or a
	jr nz,to_lev_0
;---
	ld a,2		;Set new cursor level
	ld (CursDepth),a
	ret
to_lev_0:
	xor a
	ld (CursDepth),a

	;Now do the RAM / FM / Video action for each cursor position!
        ld a,(RowNum)
	cp 8	;Is it the last row?
	jr z,chg_voice_regs
	jr nc,not_chg_voice_regs
chg_voice_regs:
	jp Voice_Reg_Check_Handler

not_chg_voice_regs:
	cp 9                    ;Rhythm row!?
	jr nz,not_chg_rtm_regs
chg_rtm_regs:
	jp Rhythm_Check_Handler

not_chg_rtm_regs:
	;So... Change a Custom Instrument setting!

	cp $A			;Modulator Switches
	jr z,chg_cust_switch_regs
	cp $B			;Carrier Switches
	jr nz,not_chg_cust_switch_regs
chg_cust_switch_regs:
	jp Custom_Switch_Handler
not_chg_cust_switch_regs:
	cp $C			;Modulator ADSR etc
	jr z,chg_cust_distort	;Only one switch here
	cp $D
	jr nz,not_chg_cust_distort
chg_cust_distort:
	jp Distort_Check_Handler

;=================================== NO MORE! ==
not_chg_cust_distort:
	ret


was_lev_0:	;For now, go back to level 1
	ld a,1		;Set new cursor level
	ld (CursDepth),a
	ret


no_trigger_action:
	ret


Move_Cursor_Joy:
	ld a,(Paddle_On)
	or a
	jr z,cont_joy_curs
	ret
cont_joy_curs:
	ld a,(CursDepth)	;What level are we moving on?
	cp 2	;Choosing a row?
	jr nz,joy_mv_crs_not_row
	dec a			;Never allow ONLY Row choosing with Joypad.
	ld (CursDepth),a
	ret
joy_mv_crs_not_row:
	cp 1
	jr nz,joy_mv_crs_not_col
;~~~~~1			;Select Row, Column, but this time by Joystick!!!
	ld a,(trigger)
	and $01		;Check for button 'UP'
	jr z,+          ;Decrement cursor Row one by one
	ld a,(RowNum)
	or a
	jr z,no_joy_dec_rownum
	dec a
	ld (RowNum),a
	jr joy_check_colnum_max
no_joy_dec_rownum:
	ret
+:
	ld a,(trigger)
	and $02		;Check for button 'DOWN'
	jr z,+          ;Increment cursor Row one by one
	ld a,(RowNum)
	cp RowNumMax		;Are we AT limit?
	jr z,no_joy_inc_rownum	;If Max=Num, Skip!
	inc a
	ld (RowNum),a
	jr joy_check_colnum_max
no_joy_inc_rownum:
	ret
+:
	ld a,(trigger)
	and $08		;Check for button 'Right'
	jr z,+          ;Move cursor right
        ld a,(ColNum)   ;Get ColNum
	inc a
        ld (ColNum),a   ;Save ColNum
	jr joy_check_colnum_max
+:
	ld a,(trigger)
	and $04		;Check for button 'Left'
	jr z,+          ;Move cursor left, maybe
        ld a,(ColNum)   ;Get ColNum
	or a		;Check if zero
	jr z,no_joy_dec_colnum
	dec a
        ld (ColNum),a   ;Save ColNum
no_joy_dec_colnum:
	ret
+:





joy_check_colnum_max:
	ld HL,ColNumMaxTbl	;Point to Table
	ld a,(RowNum)
	ld e,a		;Copy RowNum to E for addition
	xor a
	ld d,a
	add HL,DE	;Point to Table Max
	ld a,(HL)	;Get table max
	ld c,a		;Move max into C

	;Columns can be 0..7 or so...
	ld a,(ColNum)	;Get Current/New Column value
	cp c            ;Is ColNum = Max?
	jr z,joy_ColMax_OK	;If equal, no problem
	jr c,joy_ColMax_OK 	;If Max > Num, no problem
	;Problem!
        ld a,c		;Max still here
joy_ColMax_OK:
        ld (ColNum),a   ;Save ColNum
	ret

;~~~~~1
joy_mv_crs_not_col:
	jp	mv_crs_not_col	;Treat the Joy as a Paddle!!







Move_Cursor_Pdl:
	ld a,(Paddle_On)
	or a
	jr nz,cont_paddle_curs
	ret
cont_paddle_curs:
	ld a,(CursDepth)	;What level are we moving on?
	cp 2	;Choosing a row?
	jr nz,mv_crs_not_row
	;Rows can be 0..13 or so, so use "Paddle_16"
	ld a,(Paddle_16)
	cp RowNumMax	;Are we past limit?
	jr z,crs_RowMax_OK  ;If Max=Num, OK
	jr c,crs_RowMax_OK  ;If Max > Num, OK
	ld a,RowNumMax	;Set to limit.
crs_RowMax_OK:
	ld (RowNum),a
	ret
mv_crs_not_row:	;Move columns, then?
	cp 1
	jr nz,mv_crs_not_col
;~~~~~1
	ld HL,ColNumMaxTbl	;Point to Table
	ld a,(RowNum)
	ld e,a		;Copy RowNum to E for addition
	xor a
	ld d,a
	add HL,DE	;Point to Table Max
	ld a,(HL)	;Get table max
	ld c,a		;Move max into C

	;Columns can be 0..7 or so, so use "Paddle_8"
	ld a,(Paddle_8)	;Go to Column as chosen by paddle
	cp c            ;Is ColNum = Max?
	jr z,crs_ColMax_OK	;If equal, no problem
	jr c,crs_ColMax_OK 	;If Max > Num, no problem
	;Problem!
        ld a,c		;Max still here
crs_ColMax_OK:
        ld (ColNum),a   ;Save ColNum
	ret
;~~~~~1
mv_crs_not_col: 	;At level 0, change a fluctuating value, maybe?
;----- Level 0!  Read paddle and alter values in realtime!

	;Do the RAM / FM / Video varying for each cursor position!
        ld a,(RowNum)
	cp 8	;Is it the last row?
	jr z,vary_voice_regs
	jr nc,not_vary_voice_regs
vary_voice_regs:
	jp Voice_Reg_Handler
not_vary_voice_regs:
	cp 9
	jr nz,not_vary_rtm_regs
	jp Rtm_Volume_Handler
not_vary_rtm_regs:
	cp $A
	jr z,vary_cust_regs1
	cp $B
	jr nz,not_vary_cust_regs1
vary_cust_regs1:
	jp Cust_Reg1_Handler
not_vary_cust_regs1:
	cp $C
	jr z,vary_cust_adsr_etc
	cp $D
	jr nz,not_vary_cust_adsr_etc
vary_cust_adsr_etc:
	jp Cust_ADSR_Handler
not_vary_cust_adsr_etc:
	;************** NO MORE!
	ret








Read_Con2:
;--- read controller 2 RL12 ONLY here...
	in a,($DD)
Save_P2_Button:
	cpl
	and $0F		;P2 21RL
	ld e,a
	ld a,(cont2)    ;Old button
	xor E		;Find differences
	and E		;Isolate triggered.
	ld D,A
	ld (cont2),DE	;Save in cont2, trigger. (adjacent memory locations)
	call	Simulate_Con2_Paddle
	ret



;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO PADDLE! OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
DetectJapanesePaddle:
    ld     bc,$0000        ; b = 0 for 256 loops; c = 0 for counting
-:  in     a,($dc)
    bit    5,a             ; Get TR input
    jr     nz,+            ; If 1, don't increment c
    inc    c
+:  djnz   -               ; repeat 256 times
    ld     a,c             ; inspect counter
    ; If the counter value is between $60 and $a0 (50% +/- 12.5% of 256)
    ; then set b=$ff else set b=0
    ld     b,$00
    sub    $70
    jr     c,_DetectionEnd
    cp     $20
    jr     nc,_DetectionEnd
    dec    b
_DetectionEnd:
    ld     a,b
    ld 	   (Paddle_On),a
    ret                    ; result in a ($ff if detected, 0 if not)




DetectCon2Paddle:
    ld     bc,$0000        ; b = 0 for 256 loops; c = 0 for counting
-:  in     a,($dd)
    bit    3,a             ; Get CON 2 TR input
    jr     nz,+            ; If 1, don't increment c
    inc    c
+:  djnz   -               ; repeat 256 times
    ld     a,c             ; inspect counter
    ; If the counter value is between $60 and $a0 (50% +/- 12.5% of 256)
    ; then set b=$ff else set b=0
    ld     b,$00
    sub    $70
    jr     c,_Pdl2DetectionEnd
    cp     $20
    jr     nc,_Pdl2DetectionEnd
    dec    b
_Pdl2DetectionEnd:
    ld     a,b
    ld 	   (cont2_Paddle_On),a
    ret         ; result in a ($ff if detected, 0 if not)




;Galactic Protector has better code for reading from 2 paddles:
; First, it waits until TR is high, then waits again until it's low and stores
; the low nybble data from it.  Then it waits again until TR is high, and combines
; the high nybble data just read with the low nybble data.  It also gives up at each
; point after 10 iterations so the game doesn't hang.

ReadPaddle:
    ld a,(Paddle_On)	;Don't do anything if no paddle!
    or a
    jr nz,pad1_startread	;rp0X
    ret
pad1_startread:
    push BC
    ld b,10			;10 loops!
rp0X:  in     a,($dc)         ; FIRST Wait for TR input to be 1
    bit    5,a
    jr     nz,rp0start		;OK, go to next
    djnz   rp0X                 ;Not OK, loop
    jr	paddle1_bail		;Really not OK, BAIL
;---------
rp0start:
    ld b,10
rp0:  in     a,($dc)         ; THEN Wait for TR input to be 0
    bit    5,a
    jr	   z,rp1start	    ;OK, go to next
    djnz   rp0		    ;Not OK, loop
    jr	paddle1_bail		;Really not OK, BAIL
;------
rp1start:
    and    $0f             ; Save RLDU bits in e
    ld     e,a
    ld b,10
rp1:  in     a,($dc)         ; NEXT Wait for TR input to be 1
    bit    5,a
    jr	nz,rp1_end           ;OK, now finish routine
    djnz   rp1               ;Not OK, loop
    jr	paddle1_bail		;Really not OK, BAIL
;---------
rp1_end:
    ld (Paddle_But),a	  ;Save temp

    rrca                   ; Get low 4 bits into 4 high bits
    rrca
    rrca
    rrca
    and    $f0
    or     e               ; Merge with e
    ld 	   (Paddle_Cur),a
    pop BC
    ret                    ; result in a (position 0..255)

paddle1_bail:		;Just exit upon a major error!
paddle2_bail:
	pop BC
	ret


ReadCon2Paddle:
    ld a,(cont2_PdlAvg)		;Save a copy of OLD average!
    ld (cont2_PdlAvgOld),a

    ld a,(cont2_Paddle_On)	;If no paddle, read regular joypad!
    or a
    jr nz,+
    jp Read_Con2
+:
;22222222
	ld a,(cont2_Pdl2) 	;2->3
	ld (cont2_Pdl3),a
	ld a,(cont2_Pdl1)       ;1->2
	ld (cont2_Pdl2),a
    	ld a,(cont2_Paddle_Cur) ;Cur->1
	ld (cont2_Pdl1),a
;22222222

;----------
;;pad2_startread:
;;rp2X:  in     a,($dd)         ; FIRST Wait for TR input to be 1 (HIGH BITS)
;;    bit    3,a
;;    jr z,rp2X
;;rp20:  in     a,($dd)         ; THEN Wait for TR input to be 0
;;   bit    3,a
;;    jr nz,rp20
;;    call Con2_Assemble		;Read other bits in port $DC
;;    ld     e,a
;;rp21:  in     a,($dd)         ; FINALLY Wait for TR input to be 1 again
;;    bit    3,a
;;    jr z,rp21
;;    push AF
;;    call Con2_Assemble		;Read other bits in port $DC


;======= USE EITHER ONE COPY (ABOVE) OR THE OTHER!!! ====
;----------
pad2_startread:
    push BC
    ld b,10			;10 loops!
rp2X:  in     a,($dd)         ; FIRST Wait for TR input to be 1 (HIGH BITS)
    bit    3,a
    jr 	nz,rp20_start
    djnz rp2X
    jr	paddle2_bail		;Bail if done 10 loops.
;----------
rp20_start:
    ld b,10
rp20:  in     a,($dd)         ; THEN Wait for TR input to be 0
    bit    3,a
    jr	   z,rp21_start
    djnz rp20
    jr	paddle2_bail
;----------
rp21_start:
    call Con2_Assemble		;Read other bits in port $DC
    ld     e,a
    ld b,10
rp21:  in     a,($dd)         ; FINALLY Wait for TR input to be 1 again
    bit    3,a
    jr	nz,rp21_end
    djnz rp21
    jr	paddle2_bail
;------
rp21_end:
    pop BC
    push AF
    call Con2_Assemble		;Read other bits in port $DC

;=====================


    rrca                   ; Get low 4 bits into 4 high bits
    rrca
    rrca
    rrca
    and    $f0
    or     e               ; Merge with e
    ld 	   (cont2_Paddle_Cur),a		;New "Current"

	ld H,0
	ld D,0
   	ld L,a
	ld a,(cont2_Pdl3)
	ld e,a
	add HL,DE
	ld a,(cont2_Pdl2)
	ld e,a
	add HL,DE
	ld a,(cont2_Pdl1)
	ld e,a
	add HL,DE
	srl h           ;Divide by 2
	rr  l
	srl h           ;Divide by 2
	rr  l
	ld a,l
      	ld (cont2_PdlAvg),a     ;Average


    pop AF	;Saved Port $DD read...
    or %11111011		;Isolate Paddle Button
    call Save_P2_Button	;Save paddle button as Joystick button

    ret                    ; result in a (position 0..255)


Con2_Assemble:	;We just read Port $DD
	push BC

	and $03		;Isolate RL
	ld c,a
	in a,($DC)	;Read controller 1/2
	and $C0		;isolate D,U
	add a,c
	rlca
	rlca		;P2 xxxxRLDU
	pop BC
	ret


;---------------------
PaddleAction	;-- Now for Paddle Stuff!
	push DE
	push HL
	ld a,(Paddle_On)
	or a
	jr z,no_paddle_read

	call	ReadPaddle	;Current paddle now in A
	call	Divide_Paddle

        ld a,(Paddle_But)
        or %11101111		;Isolate Paddle Button
        call Save_Button	;Save paddle button as Joystick button
no_paddle_read:
	pop HL
	pop DE
	ret
;OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO PADDLE! OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO




Simulate_Con2_Paddle:	;Simulate Pad 2 R/L as paddle movement
	ld a,(cont2)
	and $01		;Check for button 'Left' HELD
	jr z,+          ;Decrement paddle one by one
	jr cont2_dec_paddle
+:
	ld a,(cont2)
	and $02		;Check for button 'Right' HELD
	jr z,+          ;Increment paddle one by one
	jr cont2_inc_paddle
	ret

cont2_dec_paddle:
	ld a,(cont2_PdlAvg)
	dec a
	cp $FF	;Have we gone too far???
	jr nz,write_cont2_paddle
	inc a
	jr write_cont2_paddle
cont2_inc_paddle:
	ld a,(cont2_PdlAvg)
	inc a
	jr nz,write_cont2_paddle
	dec a
write_cont2_paddle:
	ld (cont2_PdlAvg),a
	ret




Divide_Paddle:
	ld a,(Paddle_Cur)
	srl a		;0..127
	srl a		;0..63
	ld (Paddle_64),a
	srl a		;0..31
	srl a		;0..15
	ld (Paddle_16),a
	srl a		;0..7
	ld (Paddle_8),a
	ret

Controller_Action:
	call	Cont_Change_Paddle


	ld a,(trigger)
	and $20		;Check for button '1'
	jr z,+
	ld a,1
	ld (PauseTrgFlag),a	;Emulate the "Pause" button
+:
	ld a,(trigger)
	and $10		;Check for button '2'
	jr z,+
+:
	ld a,(trigger)
	and $01		;Check for button 'UP'
	jr z,+
+:
	ld a,(trigger)
	and $02		;Check for button 'DOWN'
	jr z,+
+:
	ret

Cont_Change_Paddle:	;Controller will "Emulate" a paddle!
	ld a,(CursDepth)	;What Cursor level are we moving on?
	or a
	jr z,sim_paddle         ;If we aren't varying a value, don't touch!
	ret
;----
sim_paddle:
	ld a,(cont1)
	and $01		;Check for button 'UP'
	jr z,+          ;Decrement paddle quickly
	jr cont_fastdec_paddle
+:
	ld a,(cont1)
	and $02		;Check for button 'DOWN'
	jr z,+
	jr cont_fastinc_paddle
+:
	ld a,(cont1)
	and $04		;Check for button 'Left' HELD
	jr z,+          ;Decrement paddle one by one
	jr cont_dec_paddle
+:
	ld a,(cont1)
	and $08		;Check for button 'Right' HELD
	jr z,+          ;Decrement paddle one by one
	jr cont_inc_paddle
+:
	ret

cont_fastinc_paddle:		;Saturates to $DD,$EE,$FF
	ld a,$3F	;Max for 64!
	ld (Paddle_64),a
	ld a,(Paddle_Cur)
	and $F0
	cp $F0	;Already very high?
	jr z,duplicate_paddle_nybble
	add a,$10
	jr duplicate_paddle_nybble	;What it says on the tin

cont_fastdec_paddle:		;Saturates $22,$11,$00
	xor a 		;Set 64 to ZERO
	ld (Paddle_64),a
	ld a,(Paddle_Cur)
	and $F0
	jr z,duplicate_paddle_nybble		;Already Zero?
	sub $10
duplicate_paddle_nybble:
	push BC
	ld c,a
	srl a		;0..127
	srl a		;0..63
	srl a		;0..31
	srl a		;0..15
	or c
	pop BC
	jr	write_cont_paddle


cont_dec_paddle:
	call	Dec_Paddle64
	ld a,(Paddle_Cur)
	dec a
	cp $FF	;Have we gone too far???
	jr nz,write_cont_paddle
	inc a
	jr write_cont_paddle
cont_inc_paddle:
	call	Inc_Paddle64
	ld a,(Paddle_Cur)
	inc a
	jr nz,write_cont_paddle
	dec a
write_cont_paddle:
	ld (Paddle_Cur),a
;;;;	jp	Divide_Paddle
    	;Flow down!
Divide_Paddle_Joy:
;	ld a,(Paddle_Cur)
;	srl a		;0..127
;	srl a		;0..63
	;Paddle 64 will get its own speed here!
	ld a,(Paddle_64)
	srl a		;0..31
	srl a		;0..15
	ld (Paddle_16),a
	srl a		;0..7
	ld (Paddle_8),a
	ret

Dec_Paddle64:
	ld a,(Paddle_64)
	dec a
	cp $FF
	jr nz,write_64_paddle
	inc a
write_64_paddle:
	ld (Paddle_64),a
	ret

Inc_Paddle64:
	ld a,(Paddle_64)
	inc a
	cp $40
	jr nz,write_64_paddle2
	dec a
write_64_paddle2:
	ld (Paddle_64),a
	ret



Read_Controller:
	in a,($DC)	;Read controller
Save_Button:
	cpl
	and $3F
	ld E,A		;Isolate pressed
	ld a,(cont1)    ;Get OLD controller read
	ld D,a		;Save OLD
	xor E           ;Find differences with NEW
;----
	push AF
	and D		;Isolate _released_
	ld (TrgReleaseFlag),a	;Save in memory
	pop AF
;----
	and E		;Isolate triggered.
	ld D,A
	ld (cont1),DE	;Save in cont1, trigger. (adjacent memory locations)
	ret