;SMS FM Tool by Chris Covell, January-March 2015

; fm_code goes here

FM_Get_Detune_Level:
	ld a,(cont2_PdlAvg)
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl	;First paddle * 4
	ld de,$FE04	;This is minus $01FC
	add hl,de
	ld (detune_lvl),HL
	
	ret



FM_New_Detune:		;Re-writes to all of the channels' frequency regs.
	push BC
	ld b,9		;Do all 9 voices
	ld d,0
	ld e,0		;Start at voice 0
new_detune_lp:
	call FM_Collect_2x_Regs	;Sus/Key/Octave...and Freq High Byte!
	call FM_Write_1x_Regs   ;Low Frequency Byte only
	inc e
	djnz	new_detune_lp
	pop BC
	ret




FM_Detune_Get_1x:	;Add Detune to this frequency
			;DE points to row (channel number), HL to "FM_Freq_Lo"+chn
	ld a,(detune_on)
	or a			;Is detuning even ON?
	jr z,no_detune_1x
	ld HL,Tmp_Freq_Lo
	add HL,DE		;Point to temp freq, and we're done!
no_detune_1x:
	ret

FM_Detune_Remake_Get_2x:	;Add Detune to this frequency, store result
				;DE points to row (channel number), HL to "FM_Freq_Hi"+chn
	ld a,(detune_on)
	or a			;Is detuning even ON?
	jr z,no_remake_detune_2x
;;	push DE
	push BC
	ld a,(HL)		;Get high frequency
	ld b,a
	ld HL,FM_Freq_Lo
	add HL,DE		;Point to low freq
	ld a,(HL)
	ld c,a
	ld HL,(detune_lvl)      ;Get detune level
	add HL,BC		;Add current frequency

	;Add current frequency to Detune amt, and REJECT if high 6 bits set. (AND $FE)
	;If bit 7 of high byte is set, underflow (set to low Freq.) otherwise, high freq.

	ld a,h			;Check sum
	and $FE
	jr z,new_freq_in_range
	and $80
	jr z,new_freq_overflow
new_freq_underflow:	;Became too low, set to 0
	ld HL,Tmp_Freq_Lo
	add HL,DE		;Point to temp freq
	xor a
	ld (HL),a
	ld HL,Tmp_Freq_Hi
	add HL,DE		;Point to temp freq
	ld (HL),a
	jr point_new_2x_freq
new_freq_overflow:	;Becomes too high, set to $1FF
	ld HL,Tmp_Freq_Lo
	add HL,DE		;Point to temp freq
	ld a,$FF
	ld (HL),a
	ld HL,Tmp_Freq_Hi
	add HL,DE		;Point to temp freq
	ld a,1
	ld (HL),a
	jr point_new_2x_freq

new_freq_in_range:
	push HL
	pop BC 			;Move new frequency to BC
	ld HL,Tmp_Freq_Lo
	add HL,DE		;Point to temp freq
	ld a,c                  ;Low byte saved
	ld (HL),a
	ld HL,Tmp_Freq_Hi
	add HL,DE		;Point to temp freq
	ld a,b                  ;High byte saved
	ld (HL),a		;And HL points to new data!

point_new_2x_freq:
	pop BC
;;	pop DE

no_remake_detune_2x:
	ret



Distort_Check_Handler:
	ld e,a	;Store RowNum
	ld a,(ColNum)
	cp 5		;This is the Distortion Column!
	jr z,distort_toggle
	ret		;If not so, exit!
distort_toggle:
	ld a,e	;Get back RowNum
	;RowNum should be $C or $D
	and $1		;Isolate 0/1
	jr nz,carrier_distort
modulator_distort:
	ld a,(FM_Cust_DistSw)
	xor $08              ;Toggle Modulator Distortion!
	ld (FM_Cust_DistSw),a
	and $08		     ;Isolate too
	jr distort_cont
carrier_distort:
	ld a,(FM_Cust_DistSw)
	xor $10              ;Toggle Carrier Distortion!
	ld (FM_Cust_DistSw),a
	and $10		     ;Isolate too
distort_cont:
	call Setup_VBWr_Checkmark
	call FM_Collect_03_Reg
	ld a,(RowNum)
	ld e,a
	xor a
	ld d,a
	call Setup_VBWr_Destination ;need to preserve DE?
	jp was_lev_0	;Go back to cursor level 1!


Custom_Switch_Handler:
	;RowNum should be $A or $B, currently in A!
	and $1		;Isolate 0/1
	ld e,a
	xor a
	ld d,a	;Make DE point 0/1

	ld HL,FM_Cust_Switches
	add HL,DE		;Hell, point to Switches now!

	;Check ColNum!
	ld a,(ColNum)

	cp 1
	jr nz,not_tremolo_onoff
tremolo_onoff:
	ld a,(HL)	;Get stored Custom Switches.
	xor $80		;TREMOLO value!
	ld (HL),a
	and $80		;Isolate TREM only
	jr Cust_0001_Exit
not_tremolo_onoff:
	cp 2
	jr nz,not_vibrato_onoff
vibrato_onoff:
	ld a,(HL)	;Get stored Custom Switches.
	xor $40		;VIBRATO value!
	ld (HL),a
	and $40		;Isolate VIBR only
	jr Cust_0001_Exit
not_vibrato_onoff:
	cp 3
	jr nz,not_cussust_onoff
cussust_onoff:
	ld a,(HL)	;Get stored Custom Switches.
	xor $20		;SUSTAIN value!
	ld (HL),a
	and $20		;Isolate SUS only
	jr Cust_0001_Exit
not_cussust_onoff:
	cp 4
	jr nz,not_ratescale_onoff
ratescale_onoff:
	ld a,(HL)	;Get stored Custom Switches.
	xor $10		;Rate Scaling value!
	ld (HL),a
	and $10		;Isolate RTKSC only
	jr Cust_0001_Exit
not_ratescale_onoff:
	;No more here!
	ret
;========================
Cust_0001_Exit:
	call Setup_VBWr_Checkmark
	call FM_Collect_00_01_Regs	;Custom MOD/CAR
	ld a,(RowNum)
	ld e,a
	call Setup_VBWr_Destination ;need to preserve DE?
	jp was_lev_0	;Go back to cursor level 1!


        ;Paddle controls for Custom inst ADSR and TOTLV, FDBK
Cust_ADSR_Handler:
	ld e,a
	;first Row $C, Col $6, $7...
	cp $C
	jr nz,no_check_FB_TOT
	xor a
	ld d,a
	ld a,(ColNum)
	cp 6
	jr z,Vary_Total_Level
	cp 7
	jr nz,no_check_FB_TOT
Vary_Feeback:
	ld a,(Paddle_8)			;Get 0..7 paddle value
	ld (FM_Cust_FB),a		;Store it!
	call Setup_VBWr_Nyb
	call FM_Collect_03_Reg
;	ld a,(RowNum)
;	ld e,a
	call Setup_VBWr_Destination ;need to preserve DE?
	ret	;Stay at current level 0

Vary_Total_Level:
	ld a,(Paddle_64)		;Get 0..63 paddle value
	ld (FM_Cust_TotLv),a		;Store it!
	call Setup_VBWr_HEX
	call FM_Collect_02_Reg
;	ld a,(RowNum)
;	ld e,a
	call Setup_VBWr_Destination ;need to preserve DE?
	ret	;Stay at current level 0

no_check_FB_TOT:
	xor a
	ld d,a	;DE now points to $C or $D
	push DE ;save it for below
	ld a,e
	and $1	;Point 0 or 1 only
	ld e,a
	ld a,(ColNum)
	cp 1	;Attack?
	jr nz,adsr_not_attack
adsr_attack:
	ld HL,FM_Cust_Attack
	jr adsr_save_reg_print
adsr_not_attack:
	cp 2	;Decay
	jr nz,adsr_not_decay
adsr_decay:
	ld HL,FM_Cust_Decay
	jr adsr_save_reg_print
adsr_not_decay:
	cp 3	;Sustain
	jr nz,adsr_not_sustain
adsr_sustain:
	ld HL,FM_Cust_Sustain
	jr adsr_save_reg_print
adsr_not_sustain:
	cp 4	;Release
	jr nz,adsr_not_release
adsr_release:
	ld HL,FM_Cust_Release
	jr adsr_save_reg_print
adsr_not_release:
	pop DE
	ret	;Nothing!
;------
adsr_save_reg_print:
	add HL,DE
	ld a,(Paddle_16)	;Get 0..F paddle value
	ld (HL),a		;Store it (back into RAM)
	push AF
        call FM_Collect_ADSR_Regs
	pop AF			;Get back nybble into A
	pop DE                  ;Get back Row number!
	call Setup_VBWr_Nyb
	call Setup_VBWr_Destination ;need to preserve DE?
	ret	;Stay at current level 0



;==============================


	;Paddle controls for Custom instruments register 1
Cust_Reg1_Handler:
	;RowNum should be $A or $B, currently in A!
	and $1		;Isolate 0/1
	ld e,a
	xor a
	ld d,a	;Make DE point 0/1

	;Check ColNum!
	ld a,(ColNum)
	cp 5
	jr nz,not_vary_cust_multiplier
vary_cust_multiplier:
	ld HL,FM_Cust_Mul
	add HL,DE
	ld a,(Paddle_16)	;Get 0..F paddle value
	ld (HL),a		;Store it!
	call Setup_VBWr_Nyb
	call FM_Collect_00_01_Regs	;Combine Switches & Multiplier
	ld a,(RowNum)
	ld e,a
	call Setup_VBWr_Destination ;need to preserve DE?
	ret	;Stay at current level 0

not_vary_cust_multiplier:
	cp 6
	jr nz,not_vary_cust_levscal
vary_cust_levscal:
	ld HL,FM_Cust_LVSc	;0..3, Level Key Scale factor
	add HL,DE		;Either MODulator or CARrier
	ld a,(Paddle_8)		;Get 0..7 paddle value
	srl a			;0..3
	ld (HL),a		;Store it!
	call Setup_VBWr_Nyb
	ld a,e
	and 1 		;Are we saving the MODULATOR (0) or CARRIER (1)?
	jr nz,car_lvscl
mod_lvscl:	;Writing to register 2
	call FM_Collect_02_Reg
	jr lvscl_done
car_lvscl:	;Writing to register 3
	call FM_Collect_03_Reg
lvscl_done:
	ld a,(RowNum)
	ld e,a
	call Setup_VBWr_Destination ;need to preserve DE?
	ret	;Stay at current level 0

not_vary_cust_levscal:
	;no more!
	ret




;*******************************************************

Voice_Reg_Check_Handler:	;Changes the voices' registers!
	;RowNum should be 0..8, currently in A!
	ld e,a	;Make DE a permanent pointer for RowNum
	xor a
	ld d,a

	;Check ColNum!
	ld a,(ColNum)

	cp 1
	jr nz,not_keyonoff
keyonoff:
	ld a,$FF
	ld (KeySusMask),a	;Restore Key functionality.
	ld HL,FM_SusKey
	add HL,DE
	ld a,(HL)	;Get stored key/sustain.
	xor $10		;KEY value!
	ld (HL),a
	and $10		;Isolate Key only
	call Setup_VBWr_Checkmark
	call FM_Collect_2x_Regs	;Sus/Key/Octave...
	call Setup_VBWr_Destination ;need to preserve DE?
	jp was_lev_0	;Go back to cursor level 1!
not_keyonoff:
	cp 2
	jr nz,not_sustonoff
sustonoff:
	ld HL,FM_SusKey
	add HL,DE
	ld a,(HL)	;Get stored key/sustain.
	xor $20		;SUSTAIN value!
	ld (HL),a
	and $20		;Isolate Sust only
	call Setup_VBWr_Checkmark
	call FM_Collect_2x_Regs	;Sus/Key/Octave...
	call Setup_VBWr_Destination ;need to preserve DE?
	jp was_lev_0	;Go back to cursor level 1!
not_sustonoff:
	;No more checkmarks to change.
	ret



Voice_Reg_Handler:	;Varies the voices' registers by paddle control
	;RowNum should be 0..8, currently in A!
	ld e,a	;Make DE a permanent pointer for RowNum
	xor a
	ld d,a

	;Check ColNum!
	ld a,(ColNum)
	cp 3
	jr nz,not_vary_octave
vary_octave:
	ld HL,FM_Octave
	add HL,DE
	ld a,(Paddle_8)	;Get 0..7 paddle value
	ld (HL),a	;Store it!
	call Setup_VBWr_Nyb
	call FM_Collect_2x_Regs	;Sus/Key/Octave...
	call Setup_VBWr_Destination ;need to preserve DE?
	ret	;Stay at current level 0
not_vary_octave:
	cp 4
	jr nz,not_vary_freq
vary_freq:
	ld a,(Paddle_Cur)	;Get 0..FF paddle value
	ld l,a
	xor a
	ld h,a		;Paddle in HL
	add HL,HL	;x2 (00..1FE)
	inc HL          ;01..1FF
	ld c,h	;Store high byte!
	ld a,l	;Keep low byte

	ld HL,FM_Freq_Lo
	add HL,DE
	ld (HL),a	;Store low byte of frequency
	ld (VBL_Write_DATA),a	;Store it for printing too
	ld a,c		;Get high byte
	ld HL,FM_Freq_Hi
	add HL,DE
	ld (HL),a	;Store High byte of frequency
	call Setup_VBWr_3Nybs
	call FM_Collect_2x_Regs	;Sus/Key/Octave...and Freq High Byte!
	call FM_Write_1x_Regs   ;Low Frequency Byte only
	call Setup_VBWr_Destination ;need to preserve DE?
	ret
not_vary_freq:
	cp 5
	jr nz,not_vary_volume
vary_volume:
	ld HL,FM_Volume
	add HL,DE
	ld a,(Paddle_16)	;Get 0..F paddle value
	xor $f          ;Make 0 the left side.
	ld (HL),a	;Store it!
	xor $f	;Invert Volume nybble!
	call Setup_VBWr_Nyb
	call FM_Collect_3x_Regs	;Instrument & Volume
	call Setup_VBWr_Destination ;need to preserve DE?
	ret	;Stay at current level 0
not_vary_volume:
        cp 6
	jr nz,not_vary_inst
vary_inst:
	call Mute_2x_Regs	;Turn off Key,Sust
	ld a,(Paddle_Cur)	;Get 0..FF paddle value
	and $F0			;Isolate
	ld HL,FM_Instrument
	add HL,DE
	ld (HL),a		;Store instrument!
	call Setup_VBWr_String
	call FM_Collect_3x_Regs	;Instrument & Volume
	call FM_Collect_2x_Regs	;Re-toggle KEY
	call Setup_VBWr_Destination ;need to preserve DE?
	ret	;Stay at current level 0
not_vary_inst:	;No more options!
	ret




FM_Write_1x_Regs: ;RowNum still in DE.
	push BC
	ld HL,FM_Freq_Lo
	add HL,DE
	call FM_Detune_Get_1x ;Add Detune to this frequency
	ld a,(HL)	;Get Frequency
	ld b,a		;Store it...
	ld a,e		;Get RowNum
	or $10		;1x register
	ld c,a
	ld a,b
	call Write_FM	;Write the register!
	pop BC
	ret


FM_Collect_00_01_Regs:  ;0/1 still in DE.
	push HL
	push BC
	ld HL,FM_Cust_Switches	;Combine switches and multiplier
	add HL,DE
	ld a,(HL)
	ld b,a
	ld HL,FM_Cust_Mul
	add HL,DE
	ld a,(HL)
	or b  		;Combine them
	ld c,e		;Move E to C for writing
	call Write_FM	;Write the register!

	pop BC
	pop HL
	ret

FM_Collect_02_Reg:
	push BC
	ld a,(FM_Cust_LVSc)	;Get MOD Level Scale (0..3)
	rrca			;Rotate Circular Right (0..81)
	rrca			;                      (0..C0)
	ld b,a
	ld a,(FM_Cust_TotLv)
	or b			;Or with 6-bit "TOTAL LEVEL"
	ld c,$2
	call Write_FM
	pop BC
	ret

FM_Collect_03_Reg:
	push BC
	ld a,(FM_Cust_LVSc+1)	;Get CARRIER Level Scale (0..3)
	rrca			;Rotate Circular Right (0..81)
	rrca			;                      (0..C0)
	ld b,a
	ld a,(FM_Cust_DistSw)
	or b			;Or with 2-bit Distortion switches
	ld b,a
	ld a,(FM_Cust_FB)
	or b			;Or with 3-bit Feedback level
	ld c,$3
	call Write_FM
	pop BC
	ret





FM_Collect_ADSR_Regs: 	;ADSR for custom instrument
	;Right now, DE should be 0 or 1 (MOD or CAR)
	;Gotta see if ColNum is 1/2 or 3/4 (AD or SR)
	push BC
	ld a,(ColNum)
	dec a 	;0/1 or 2/3
	and 2	;0/0 or 1/1
	jr nz,save_SR
save_AD:
	ld a,e		;Put MOD/CAR in A
	add a,4		;Point to proper reg
	ld c,a		;C reg used for Write_FM
	ld HL,FM_Cust_Attack
	add HL,DE
	ld a,(HL)	;Get Attack
	add a,a         ;x2
	add a,a         ;x4
	add a,a         ;x8
	add a,a         ;x16
	ld b,a
	ld HL,FM_Cust_Decay
	add HL,DE
	ld a,(HL)	;Get Decay
	or b		;Add Attack in
	jr ADSR_save

save_SR:
	ld a,e		;Put MOD/CAR in A
	add a,6		;Point to proper reg
	ld c,a		;C reg used for Write_FM
	ld HL,FM_Cust_Sustain
	add HL,DE
	ld a,(HL)	;Get Sustain
	add a,a         ;x2
	add a,a         ;x4
	add a,a         ;x8
	add a,a         ;x16
	ld b,a
	ld HL,FM_Cust_Release
	add HL,DE
	ld a,(HL)	;Get Release
	or b		;Add Sustain in
ADSR_save:
        call Write_FM
	pop BC
	ret




FM_Collect_2x_Regs: ;RowNum still in DE.
	push BC
	ld HL,FM_SusKey
	add HL,DE
	ld a,(HL)	;Get Sustain/Key
	ld b,a	;Store
	ld a,(KeySusMask)	;Mask out with triggered note, etc.
	and b
sus_key_read:
	ld b,a	;Store...
	ld HL,FM_Octave
	add HL,DE
	ld a,(HL)	;Get Octave
	add a,a		;Multiply by 2
	or b
	ld b,a		;Store...
	ld HL,FM_Freq_Hi
	add HL,DE
	call FM_Detune_Remake_Get_2x ;Add Detune to this frequency, store result
	ld a,(HL)
	or b		;Our final value is now in A!
	ld b,a		;Store it...

	ld a,e		;Get RowNum
	or $20		;2x register
	ld c,a
	ld a,b
	call Write_FM	;Write the register!
	pop BC
	ret

FM_KeyOff_2x_Regs: ;RowNum still in DE.
	push BC
	ld HL,FM_SusKey
	add HL,DE
	ld a,(HL)	;Get Sustain/Key
	and $EF		;Clear KEY!
	jr	sus_key_read



Mute_2x_Regs: ;RowNum still in DE.
;Turn OFF sustain and Key, so start with Octave!
	push BC
	ld HL,FM_Octave
	add HL,DE
	ld a,(HL)	;Get Octave
	add a,a		;Multiply by 2
	ld b,a		;Store...
	ld HL,FM_Freq_Hi
	add HL,DE
	ld a,(HL)
	or b		;Our final value is now in A!
	ld b,a		;Store it...

	ld a,e		;Get RowNum
	or $20		;2x register
	ld c,a
	ld a,b
	call Write_FM	;Write the register!
	pop BC
	ret


FM_Collect_3x_Regs: ;RowNum still in DE.
	ld HL,FM_Volume
	add HL,DE
	ld a,(HL)	;Get Volume
	ld b,a	;Store...
	ld HL,FM_Instrument
	add HL,DE
	ld a,(HL)	;Get Instrument
	or b
	ld b,a		;Store it...

	ld a,e		;Get RowNum
	or $30		;3x register
	ld c,a
	ld a,b
	jp Write_FM	;Write the register!

;=============================================

FM_KEY_OFF_ALL:		;Turn of KEY for all instruments (but keep Sustain)
	PUSH DE
	PUSH BC
	PUSH AF

	xor a
	ld d,a		;Start at Voice 0
	ld e,a
	ld b,$9		;Do 9 registers!
	ld a,(FM_RTM_Reg)
	and $20		;Is Rhythm ON?
	jr z,keyoff_all_voices
;----------- Rhythm ON
	xor a
	call FM_Save_Rhythm_Reg	;Clear Rhythm Register
	ld b,$6 ;do 6 voices only
keyoff_all_voices:
	call	FM_KeyOff_2x_Regs ;RowNum still in DE.
	inc e
	djnz    keyoff_all_voices

	POP AF
	POP BC
	POP DE
	ret




FM_Retrigger_All:
	PUSH DE
	PUSH BC
	PUSH AF

	xor a
	ld d,a		;Start at Voice 0
	ld e,a
	ld b,$9		;Do 9 registers!
	ld a,(FM_RTM_Reg)
	and $20		;Is Rhythm ON?
	jr z,retrigger_all_voices
;----------- Rhythm ON
	xor a
	call FM_Save_Rhythm_Reg	;Clear Rhythm Register
	call FM_Save_Rhythm_Control ;Restore Rhythm!
	ld b,$6 ;do 6 voices only
retrigger_all_voices:
	call	Mute_2x_Regs ;RowNum still in DE.
	call    FM_Collect_2x_Regs ;RowNum still in DE.
	inc e
	djnz    retrigger_all_voices

	POP AF
	POP BC
	POP DE
	ret



;=============================================
;     Rhythm Shit!
;=============================================

Restore_Inst_Vols:	;Save $36-$38
	ld a,(FM_Instrument+6)
	ld b,a
	ld a,(FM_Volume+6) 	;Combine Instrument and Volume
	or b
;;;	ld (FM_Vol_Store),a	;...and save them together
	ld c,$36
	call Write_FM

	ld a,(FM_Instrument+7)
	ld b,a
	ld a,(FM_Volume+7)
	or b
;;;	ld (FM_Vol_Store+1),a
	ld c,$37
	call Write_FM

	ld a,(FM_Instrument+8)
	ld b,a
	ld a,(FM_Volume+8)
	or b
;;;	ld (FM_Vol_Store+2),a
	ld c,$38
	call Write_FM

	ret

Write_RTM_Vols:	;Copies current volume to all Rhythm regs
	ld a,(FM_RTM_Vol)
	ld c,$36
	call Write_FM
	ld b,a
	add a,a		;x2
	add a,a
	add a,a		;x8
	add a,a		;x16
	or b			;Volume now in both Nybbles!
	ld c,$37
	call Write_FM
	ld c,$38
	call Write_FM
	ret



;=============================================
FM_Swap_Rhythm:	;Turns Rhythm on/off and saves\restores regs

	ld d,$0
	ld e,$6		;FAKE RowNum in DE


	ld a,(FM_RTM_Reg)	;Get stored Rhythm On/Off
	and $20
	jr z,fm_rtm_turnoff

	call	Mute_2x_Regs
	inc e		;Inst $7
	call	Mute_2x_Regs
	inc e		;Inst $8
	call	Mute_2x_Regs

	call	Write_RTM_Vols	;If rhythm on, write Rhythm volumes


;------------------- INIT FREQ REGS FOR RHYTHM ---------
	ld a,$20
	ld c,$16
	call	Write_FM
	ld a,$50
	inc c
	call	Write_FM
	ld a,$C0
	inc c
	call	Write_FM
	ld a,$05
	ld c,$26
	call	Write_FM
	ld a,$05
	inc c
	call	Write_FM
	ld a,$01
	inc c
	call	Write_FM


	jr	FM_Save_Rhythm_Control	;Save Rhythm OFF register
;-----------
fm_rtm_turnoff:
	call	FM_Save_Rhythm_Control	;Turn OFF RTM register!
	call	Restore_Inst_Vols	;If rhythm off, restore instruments!

	call	FM_Collect_2x_Regs ;RowNum still in DE...?
	inc e		;Inst $7
	call	FM_Collect_2x_Regs
	inc e		;Inst $8
	call	FM_Collect_2x_Regs
	call	FM_Write_1x_Regs ;Inst $8
	dec e
	call	FM_Write_1x_Regs ;Inst $7
	dec e
	call	FM_Write_1x_Regs ;Inst $6

	ret


FM_Save_Rhythm_Control:
	ld a,(FM_RTM_Reg)
FM_Save_Rhythm_Reg:
	ld c,$0e	;Rhythm Control Register!
	jp	Write_FM


;=============================================
Rhythm_Check_Handler:

	;Check ColNum!
	ld a,(ColNum)
	cp 1
	jr nz,not_rtm_onoff	;Enable/Disable rhythm
rtm_onoff:
	ld a,(FM_RTM_Reg)	;Get stored Rhythm On/Off
	xor $20
	ld (FM_RTM_Reg),a
	and $20		;Isolate Key only
	call Setup_VBWr_Checkmark
	call Setup_VBWr_Destination
	call FM_Swap_Rhythm
	jp was_lev_0	;Go back to cursor level 1!
not_rtm_onoff:
	cp 2
	jr nz,not_basstrg	;Enable/Disable Bass
basstrg:
	ld a,(FM_RTM_Reg)	;Get BASS DRUM On/Off
	xor $10
	ld (FM_RTM_Reg),a
	and $10			;Isolate
	jr Trg_Rtm_End
not_basstrg:
	cp 3
	jr nz,not_snaretrg	;Enable/Disable Snare
snaretrg:
	ld a,(FM_RTM_Reg)	;Get Snare DRUM On/Off
	xor $8
	ld (FM_RTM_Reg),a
	and $8			;Isolate
	jr Trg_Rtm_End
not_snaretrg:
	cp 4
	jr nz,not_tomtrg	;Enable/Disable Tom-Tom
tomtrg:
	ld a,(FM_RTM_Reg)	;Get TOM-TOM On/Off
	xor $4
	ld (FM_RTM_Reg),a
	and $4			;Isolate
	jr Trg_Rtm_End
not_tomtrg:
	cp 5
	jr nz,not_cymtrg	;Enable/Disable Cymbal
cymtrg:
	ld a,(FM_RTM_Reg)	;Get CYMBAL On/Off
	xor $2
	ld (FM_RTM_Reg),a
	and $2			;Isolate
	jr Trg_Rtm_End
not_cymtrg:
	cp 6
	jr nz,not_hihattrg	;Enable/Disable Hi-Hat
hihattrg:
	ld a,(FM_RTM_Reg)	;Get HIHAT On/Off
	xor $1
	ld (FM_RTM_Reg),a
	and $1			;Isolate
	jr Trg_Rtm_End
not_hihattrg:
	ret


Trg_Rtm_End:
	call	 Setup_VBWr_Checkmark
	call 	Setup_VBWr_Destination
	call	FM_Save_Rhythm_Control
	jp 	was_lev_0	;Go back to cursor level 1!
;------


Rtm_Volume_Handler:	;Varies the Rhythm Volume only!
	ld e,a	;Make DE a permanent pointer for RowNum
	xor a
	ld d,a
	ld a,(ColNum)
	cp 7		;Only column 7 changes here!
	jr nz,no_rtm_vol_change
	ld a,(Paddle_16)	;Get 0..F paddle value
	xor $f          	;Make 0 the left side.
	ld (FM_RTM_Vol),a	;Store it!
	xor $f	;Invert Volume nybble!
	call Setup_VBWr_Nyb
	call Setup_VBWr_Destination ;need to preserve DE?
	ld a,(FM_RTM_Reg)
	and $20				;If Rhythm not triggered, no Register Writing!
	jr z,no_rtm_vol_change
	call	Write_RTM_Vols 		;Rhythm Volume
no_rtm_vol_change:
	ret	;Stay at current level 0


;=============================================
;     END OF Rhythm Shit!
;=============================================




;=============================================




FM_Init:   ;Maybe not necessary, but initialize FM regs?
    	ld c,$0F	;Test OFF
    	xor a
    	call Write_FM
	ld b,$39	;Highest register value+1
	ld c,a
clr_fm_lp:
	call Write_FM	;Clear FM registers
	inc c
	djnz clr_fm_lp
;--------------- Set Custom FM data ---------
	ld HL,FM_Cust_Attack	;ADSR start
	ld a,$1
	ld b,8			;8 RAM variables
init_fm_adsr:
	ld (HL),a
	inc HL
	djnz init_fm_adsr

	ld a,$11
	ld c,$4		;Set ADSR 1st reg
    	call Write_FM
	inc c           ;AD
    	call Write_FM
	inc c           ;SR
    	call Write_FM
	inc c           ;SR
    	call Write_FM

;--------------- Set instruments 8..0 --------
    	ld c,$30	;Voice 0 inst/vol
    	ld a,$80	;Start at 8=Organ
	ld b,9
	ld HL,FM_Instrument ;(RAM storage)
init_fm_insts:
    	call Write_FM
	ld (HL),a		;Store RAM too
	inc HL
	sub $10	;Go down to next instrument
	inc c
	djnz init_fm_insts

	;** Don't need to write to Volume RAM because 0=max volume **

	ld HL,FM_Freq_Hi
	ld a,1		;$100
	ld b,9
init_ram_freqhi:
	ld (HL),a
	inc HL
	djnz init_ram_freqhi

	ld HL,FM_Octave
	ld a,4		;$4 in RAM... $8 in FM register!
	ld b,9
init_ram_octave:
	ld (HL),a
	inc HL
	djnz init_ram_octave
	ret


FM_First_Note:
    	ld c,$20	;Voice 0 trig etc
    	ld a,%00011001
    	call Write_FM
	ld a,$10	;Voice 0 Key ON only!
	ld (FM_SusKey),a
	ret



FM_RegDump:		;Block Write to FM Registers
			;HL points to register write list (C: A)...,$FF terminated
	ld a,(HL)	;Get Register Byte!
	cp $FF
	jr z,regdump_finished
	ld c,a		;Move register to C
	inc HL
	ld a,(HL) 	;Get data in A
	inc HL
	call	Write_FM	;Write the data!
	jr	FM_RegDump
regdump_finished:
	ret



;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ FM UNIT! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
FMDetection:
    ld a,($c000)
    or $04             ; Disable I/O chip
    out ($3E),a
    ld bc,$0700        ; Counter (7 -> b), plus 0 -> c
-:  ld a,b
    and %00000001      ; Mask to bit 0 only
    out ($f2),a        ; Output to the audio control port
    ld e,a
    in a,($f2)         ; Read back
    and %00000111      ; Mask to bits 0-2 only
    cp e               ; Check low 3 bits are the same as what was written
    jr nz,+
    inc c              ; c = # of times the test was passed
+:  djnz -
    ld a,c
    cp 7               ; Check test was passed 7 times out of 7
    jr z,+
    xor a              ; If not, result is 0
+:  and 1              ; If so, result is 1
    out ($f2),a        ; Output result to audio control port
    ld (FM_Present),a       ; Store result in FM_Present
    ld a,($c000)
    out ($3e),a        ; Turn I/O chip back on
    ret


Write_FM:	;Writes A to the FM register in C
    push BC
    push AF
    ld a,(FM_Present) ;First, is the FM chip on?
    or a
    jp z,No_Write_FM
    ld a,c
    out ($F0),a		;Write specified YM2413 register
    pop AF
    push BC
    pop BC
    out ($F1),a
    push BC
    pop BC
    push BC
    pop BC
;-- finally,
    pop BC
    ret
No_Write_FM:
    pop AF
    pop BC
    ret


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ FM UNIT! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


;Useful Patches!
;ModSus,LvKsc2,CarVib,CarSus,Mod338D,FB3,Car9115  -  Bweah Bweah voice!
;Oct6,ModSus,CarVib,CarSus,Mod4811,TotLvl6,FB6,Car5318 - Guitar/Screamin' Bandleader

;Splash fanfare:
;Oct 2,3,4;Frq ~100,CarSus,Mod2101,Car1101,TotLvl$0D,FB6 - orchestral WAH

splash_fanfare:
.db $30,$00,$31,$00,$32,$00,$33,$00,$34,$00,$35,$00,$36,$00,$37,$00,$38,$00 ;Instrument 0
.db $00,$00,$01,$20	;Sustain on for Carrier
.db $02,$0D		;FM Level
.db $03,$06		;Feedback Level
.db $04,$21,$05,$11,$06,$01,$07,$01	;ADSR for both MOD/CAR
.db $0E,$00		;Rhythm Off
.db $10,$00,$11,$01,$12,$02,$13,$03,$14,$04,$15,$05,$16,$06,$17,$00,$18,$00 ;Note LSB
.db $20,$19,$21,$19	;Octave 4 and Trigger ON!
.db $22,$17,$23,$17	;Octave 3 and Trigger ON!
.db $24,$15,$25,$15	;Octave 2 and Trigger ON!
.db $26,$13		;Octave 1 and Trigger ON!
.db $27,$09,$28,$09	;Silent
.db -1

fanfare_end:
.db $20,$09,$21,$09	;Octave 4 and Trigger OFF
.db $22,$07,$23,$07	;Octave 3 and Trigger OFF
.db $24,$05,$25,$05	;Octave 2 and Trigger OFF
.db $26,$03		;Octave 1 and Trigger OFF
.db -1