;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; VDP control for Sega Master System FMV demo
; Written by Alex Marshall <trap15@raidenii.net>
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; A = Reg
; L = Data
.macro	vdp_wr
	or	$80
	ld	h, a
	rst	$10
.endm

vdp_init:
; Setup the basic display
; Mode 4, Line interrupt on
	ld	a, $00
	ld	l, $14
	vdp_wr

; Frame interrupt and display on
	ld	a, $01
	ld	l, $60
	vdp_wr

; Nametable Base = $3800
	ld	a, $02
	ld	l, $0D
	vdp_wr

; Do important things
	ld	a, $03
	ld	l, $FF
	vdp_wr
	ld	a, $04
	ld	l, $03
	vdp_wr

; Sprite Attr Table Base = $0000
	ld	a, $05
	ld	l, $01
	vdp_wr

; Sprite Pattern Gen Base = $0000
	ld	a, $06
	ld	l, $03
	vdp_wr

; Overscan color = 0
	ld	a, $07
	ld	l, $00
	vdp_wr

; BG scroll = 0,0
	ld	a, $08
	ld	l, $00
	vdp_wr
	ld	a, $09
	ld	l, $00
	vdp_wr

	ld	a, $0A
.if HEIGHT2X == 1
	ld	l, $01
.else
	ld	l, $03
.endif
	vdp_wr

	ret


