/*
 * Copyright (c) 2011, Harley Laue
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    * Neither the name of the <organization> nor the
 *      names of its contributors may be used to endorse or promote products
 *      derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/io.h>
#include <sys/tms9918a.h>

void tms9918a_vram_set_write_address(uint16_t addr) {
	tms9918a_ctrl(0x00FF & addr);          /* write the first (lower) byte */
	tms9918a_ctrl((0x4000 | (0x3F00 & addr)) >> 8); /* write the second (upper) byte */
}

void tms9918a_vram_set_read_address(uint16_t addr) {
	tms9918a_ctrl(0x00FF & addr); /* write the first (lower) byte */
	tms9918a_ctrl((0x3F00 & addr) >> 8); /* write the second (upper) byte */
}

void tms9918a_cram_set_address(uint8_t addr) {
	tms9918a_ctrl(0x00FF & addr); /* write the first (lower) byte */
	tms9918a_ctrl((0xC000 | addr) >> 8); /* write the second (upper) byte */
}

uint8_t tms9918a_vram_read() {
	return tms9918a_read();
}

void tms9918a_ram_write(uint8_t data) {
	tms9918a_write(data);
}

void tms9918a_register_write(uint8_t reg, uint8_t data) {
	tms9918a_ctrl(data); /* write the first (lower) byte which is data */
	/*
	 * Here we make sure that the first two bits are 0, even though it shouldn't
	 * matter since they're supposed to be unused.
	 */
	tms9918a_ctrl(0x80 | (reg & 0x0F)); /* write the second (upper) byte which is a register 0-15 */
}

