/*
 * Copyright (c) 2011, Harley Laue
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    * Neither the name of the <organization> nor the
 *      names of its contributors may be used to endorse or promote products
 *      derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/io.h>

uint8_t in(uint8_t addr) {
	/* this should actually do nothing but appease the C compiler... */
	uint8_t rv = addr;

	__asm
	ld c, 4(ix) /* addr */
	in a, (c)
	ld l, a
	__endasm;

	/* returns l, but our asm should have over rode when addr was loaded into l */
	return rv;
}

void out(uint8_t addr, uint8_t value) {
	addr; value; /* silence C compiler warnings */

	__asm
	ld c, 4(ix) /* addr */
	ld b, 5(ix) /* vaule */
	out (c), b
	__endasm;
}

#ifdef SDCC
/* These should automatically generate assembly that's at least as optimal as above */
#define in_sdcc(name, addr) uint8_t name() { return addr; }
#define out_sdcc(name, addr) void name(uint8_t value) { addr = value; }

in_sdcc(in_mem_ctrl, io_mem_ctrl)
in_sdcc(in_io_ctrl, io_ctrl)
in_sdcc(in_psg, io_psg)
in_sdcc(in_vcnt, io_vcnt)
in_sdcc(in_hcnt, io_hcnt)
in_sdcc(in_vdp_data, io_vdp_data)
in_sdcc(in_vdp_ctrl, io_vdp_ctrl)
in_sdcc(in_ab_reg, io_ab_reg)
in_sdcc(in_bmisc_reg, io_bmisc_reg)

out_sdcc(out_mem_ctrl, io_mem_ctrl)
out_sdcc(out_io_ctrl, io_ctrl)
out_sdcc(out_psg, io_psg)
out_sdcc(out_vcnt, io_vcnt)
out_sdcc(out_hcnt, io_hcnt)
out_sdcc(out_vdp_data, io_vdp_data)
out_sdcc(out_vdp_ctrl, io_vdp_ctrl)
out_sdcc(out_ab_reg, io_ab_reg)
out_sdcc(out_bmisc_reg, io_bmisc_reg)

#undef in_sdcc
#undef out_sdcc
#endif

