/*
 * Copyright (c) 2011, Harley Laue
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    * Neither the name of the <organization> nor the
 *      names of its contributors may be used to endorse or promote products
 *      derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * These are the low level VDP functions for interfacing with the TMS9918a.
 */

#ifndef __TMS9918A_H__
#define __TMS9918A_H__
#include <stdint.h>
#include <sys/io.h>

#ifdef SDCC
#define tms9918a_ctrl(d) io_vdp_ctrl = d
#define tms9918a_write(d) io_vdp_data = d
#define tms9918a_read() io_vdp_data
#else
#define tms9918a_ctrl(d) out(VDP_CTRL, d)
#define tms9918a_write(d) out(VDP_DATA, d)
#define tms9918a_read() in(VDP_DATA)
#endif

/**
 * Set the VRAM address for writing
 * addr: 0-0x3FFF (but it wraps around)
 */
void tms9918a_vram_set_write_address(uint16_t addr);
/**
 * Set the VRAM address for reading
 * addr: 0-0x3FFF (but it wraps around)
 */
void tms9918a_vram_set_read_address(uint16_t addr);
/**
 * Set the CRAM address for reading or writing
 * addr: 0-32 or 0-64 depending on the hardware (but it wraps around)
 */
void tms9918a_cram_set_address(uint8_t addr);

/**
 * Read a byte from the VRAM
 * returned bit meaning:
 * bit:       7    |       6         |       5          | 4-0
 * meaning: vblank | sprite overflow | sprite collision | fifth sprite
 *
 * Check the documentation for more info.
 */
uint8_t tms9918a_vram_read();

/**
 * Write a byte to the VRAM or CRAM depending on the current mode
 */
void tms9918a_ram_write(uint8_t dat);

/**
 * Set one of the registers to data
 * reg: 0-0xF, technically though, 0-0xa and the rest are unused.
 * data: check the documentation for what's valid for each register.
 */
void tms9918a_register_write(uint8_t reg, uint8_t dat);


#endif

