#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sms.h>
#include "sk_core.h"
#include "sk_levelpack.h"
#include "sk_display.h"
#include "menu.h"
#include "mfs.h"

// Joypad related constants
#define REPEAT_START_DELAY 3
#define REPEAT_DELAY 0

#define SKIN_COUNT 6
#define LEVELPACK_COUNT 23

typedef struct _joy_repeat_rec {
    UBYTE prev_joy;
    UBYTE start_delay, delay;
    UBYTE tmr;
} joy_repeat_rec;

extern UBYTE menu_tile_apk[];
extern UBYTE menu_map_apk[];
extern UBYTE menu_pal[];
extern UBYTE skinsel_map_apk[];

/*UBYTE pal1[] = {0x00, 0x20, 0x08, 0x28, 0x02, 0x22, 0x0A, 0x2A,
				0x15, 0x35, 0x1E, 0x3E, 0x17, 0x37, 0x0F, 0x3F};*/
UBYTE pal1[] = {0x06, 0x3F, 0x08, 0x28, 0x02, 0x22, 0x0A, 0x2A,
				0x15, 0x35, 0x1E, 0x3E, 0x17, 0x37, 0x0F, 0x3F};

char classic_info[] = "Classic Sokoban levels";
char david_skinner[] = "by David Skinner\n sasquatch@bentonrea.com";
char francois_marques[] = "by Franois Marques\n sokoban@online.fr";
char grigorusha[] = "by GRIGoRusha\n grigr@yandex.ru";
char haroldo_o_p[] = "by Haroldo O. Pinheiro\n haroldoop@gmail.com";

char *levelpack_names[] = {
	"Classic",
	"Microban",
	"Mas Microban",
	"Sasquatch",
	"Mas Sasquatch",
	"Sasquatch III",
	"Sasquatch IV",
	"Sasquatch V",
	"Sasquatch VI",
	"Sasquatch VII",
	"Sokoban Online",
	"Soloban",
	"Novoban",
	"Numbers",
	"Sokolate",
	"Sokompact",
	"Kokoban",
	"100 boxes",
	"Grigr 2001",
	"Grigr 2002",
	"Grigr Comet",
	"Grigr Special",
	"Grigr Star",
};

char *levelpack_files[] = {
	"CLASSIC.LPK",
	"MICBAN.LPK",
	"MICBAN2.LPK",
	"SASQ1.LPK",
	"SASQ2.LPK",
	"SASQ3.LPK",
	"SASQ4.LPK",
	"SASQ5.LPK",
	"SASQ6.LPK",
	"SASQ7.LPK",
	"SOKOON.LPK",
	"SOLOBAN.LPK",
	"NOVOBAN.LPK",
	"NUMBERS.LPK",
	"SOKOLATE.LPK",
	"SOKOMPAC.LPK",
	"KOKOBAN.LPK",
	"100BOXES.LPK",
	"GRIG2001.LPK",
	"GRIG2002.LPK",
	"GRIGCOM.LPK",
	"GRIGSPEC.LPK",
	"GRIGSTAR.LPK",
};

char *skin_files[] = {
	"SOKO",
	"PAC",
	"MAC",
	"BULLDOZE",
	"SOKO2",
	"WIRE",
};

char *levelpack_infos[] = {
	classic_info, // Classic
	david_skinner, // Microban
	david_skinner, // Mas Microban
	david_skinner, // Sasquatch
	david_skinner, // Mas Sasquatch
	david_skinner, // Sasquatch III
	david_skinner, // Sasquatch IV
	david_skinner, // Sasquatch V
	david_skinner, // Sasquatch VI
	david_skinner, // Sasquatch VII
	francois_marques, // Sokoban Online
	francois_marques, // Soloban
	francois_marques, // Novoban
	francois_marques, // Numbers
	francois_marques, // Sokolate
	francois_marques, // Sokompact
	francois_marques, // Kokoban
	francois_marques, // 100 boxes
	grigorusha, // Grigr 2001
	grigorusha, // Grigr 2002
	grigorusha, // Grigr Comet
	grigorusha, // Grigr Special
	grigorusha, // Grigr Star
};

void clear_canvas() {
/*	UBYTE i;
	UWORD line[MAX_MAP_W];

	memset(line, 0, sizeof(line));
	for (i = 0; i != MAX_MAP_H; i++) {
		set_bkg_map(line, 0, i, MAX_MAP_W, 1);
	}*/
	clear_area(0, 0, 32, 24);
}

void init_joy_repeat(joy_repeat_rec *rpt) {
    rpt->prev_joy = 0;
    rpt->start_delay = REPEAT_START_DELAY;
    rpt->delay = REPEAT_DELAY;
}

void init_joy_repeat_dly(joy_repeat_rec *rpt, int delay) {
	init_joy_repeat(rpt);
    rpt->start_delay = delay << 2;
    rpt->delay = delay;
}

int read_joy_repeat(joy_repeat_rec *rpt) {
    UBYTE joy = read_joypad1();
    if (joy != rpt->prev_joy) {
       rpt->prev_joy = joy;
       rpt->tmr = rpt->start_delay;
    } else if (!rpt->tmr) {
       rpt->tmr = rpt->delay;
    } else {
       joy = 0;
       rpt->tmr--;
    }
    return joy;
}

void wait_joy_press(int mask) {
    wait_vblank_noint();
    while (!(read_joypad1() & mask)) {
        wait_vblank_noint();
    }
}

void wait_joy_release(int mask) {
    wait_vblank_noint();
    while (read_joypad1() & mask) {
        wait_vblank_noint();
    }
}

void load_skin(char *name) {
	unsigned char buffer[2048];
	char fname[12];
	UBYTE *p;

	strcpy(fname, name);
	strcat(fname, ".TLC");
	p = mfs_fetch_file(fname);

	aplib_depack(p, buffer);
	load_tiles(buffer, 256, 64, 4);

	strcpy(fname, name);
	strcat(fname, ".PAL");
	p = mfs_fetch_file(fname);

	load_palette(p, 0, 16);
}

void load_main_tileset() {
	unsigned char buffer[2048];

	load_tiles(standard_font, 0, 255, 1);

	aplib_depack(menu_tile_apk, buffer);
	load_tiles(buffer, 0xB0, 32, 4);
}

void draw_menu_bkg() {
	unsigned char buffer[2048];
	UWORD i;
	UBYTE *p;

	aplib_depack(menu_map_apk, buffer);
	for (i = sizeof(buffer), p = buffer; i; i--, p++) {
		*p += 0xB0
	}
	set_bkg_map(buffer, 0, 0, 32, 24);
}

void draw_skin_bkg() {
	unsigned char buffer[2048];

	aplib_depack(skinsel_map_apk, buffer);
	set_bkg_map(buffer, 0, 0, 32, 24);
}

void title_screen() {
	load_main_tileset();
	load_skin("SOKO");

	draw_skin_bkg();

	gotoxy(0, 19);
	printf(" %s\n %s\n Press any button to start.",
			"SokoMaster v1.0", haroldo_o_p);

	wait_joy_press(JOY_FIREA | JOY_FIREB);
	wait_joy_release(JOY_FIREA | JOY_FIREB);
}

UBYTE skin_select(UBYTE option) {
	UBYTE joy;
    joy_repeat_rec rpt;
    UBYTE origbank;

	origbank = PAGE2_BANK;

    init_joy_repeat_dly(&rpt, 14);

	reset_sprites();

	load_main_tileset();
	load_skin(skin_files[option]);

	draw_skin_bkg();

	gotoxy(0, 19);
	printf(" Press \x11 or \x10 to select skin\n Pres fire to confirm");

	joy = 0;
    while (!(joy & (JOY_FIREA | JOY_FIREB))) {
		if (joy & (JOY_LEFT | JOY_UP)) {
			if (option) {
				option--;
			} else {
				option = SKIN_COUNT-1;
			}
			load_skin(skin_files[option]);
		}
		if (joy & (JOY_RIGHT | JOY_DOWN)) {
			option++;
			if (option >= SKIN_COUNT) {
				option = 0;
			}
			load_skin(skin_files[option]);
		}

		joy = read_joy_repeat(&rpt);
	}
	wait_joy_release(JOY_FIREA | JOY_FIREB);

	PAGE2_BANK = origbank;

	return option;
}

UBYTE levelpack_select() {
	UBYTE joy;
	UWORD option, prev_option;
    joy_repeat_rec rpt;
    menu_state menu;
    mfs_dir_entry *entry;

    init_joy_repeat_dly(&rpt, 7);
    reset_sprites();

    menu_init(&menu, 2, 2, levelpack_names, 28, 15, LEVELPACK_COUNT);
    menu_draw(&menu);
    gotoxy(2, 1);
    puts("\x1E More...");
    gotoxy(2, 17);
    puts("\x1F More...");

	joy = 0;
	prev_option = 0xFF;
    while (!(joy & JOY_FIREA)) {
		option = menu_handler(&menu, joy);

		wait_vblank_noint();
		menu_update(&menu);

		if (option != prev_option) {
			clear_area(0, 19, 32, 4);
			gotoxy(0, 19);
			printf(" %s\n %s\n %d levels",
					levelpack_names[option], levelpack_infos[option],
					lpk_count_maps(mfs_fetch_file(levelpack_files[option])));
		}

		prev_option = option;
		joy = read_joy_repeat(&rpt);
    }
    reset_sprites();

    return option;
}

UBYTE level_select(UBYTE *levelpack, UBYTE *skinnumber) {
	UBYTE i;
	UBYTE x, y;
	sk_levelmap level;
	icon_menu_state menu;

	UBYTE joy;
    joy_repeat_rec rpt;
    UBYTE baselevel, sel, levelcount;

	draw_menu_bkg();
    reset_sprites();

	icon_menu_init(&menu, 2, 3, 7, 5, 6*8, 4*8, 4, 12);

    init_joy_repeat_dly(&rpt, 7);
    wait_joy_release(JOY_FIREA | JOY_FIREB);
    baselevel = 0;
    sel = 0;
    levelcount = lpk_count_maps(levelpack);
	do {
		for (i = 0; i != 8; i++) {
			x = (i & 0x03) * 7 + 2;
			y = (i >> 2) * 5 + 3;

			lpk_load_map(&level, levelpack, baselevel + i);
			sk_render_thumbnail(&level, x, y, i, /*i < 3*/TRUE);
		}

		joy = 0;
		while (!(joy & JOY_FIREA)) {
			joy = read_joy_repeat(&rpt);

			sel = icon_menu_handler(&menu, joy);

			wait_vblank_noint();
			icon_menu_update(&menu);
		}

		if (sel > 7) {
			if (sel == 8) {
				if (baselevel) {
					baselevel -= 8;
				}
			} else if (sel == 9) {
				*skinnumber = skin_select(*skinnumber);

				load_palette(menu_pal, 0, 16);
				load_palette(pal1, 16, 16);
				load_main_tileset();
				draw_menu_bkg();
			} else if (sel == 11) {
				if (baselevel + 8 < levelcount) {
					baselevel += 8;
				}
			}
		}
	} while ((sel > 7) || (baselevel + sel >= levelcount));

    reset_sprites();

    return baselevel + sel;
}

void main() {
	UBYTE joy;
	joy_repeat_rec joyrec;

    UBYTE levelpackno, *levelpack;
	UBYTE levelno;
	sk_levelmap level;

	UBYTE skinnumber;

	for (;;) {
		set_vdp_reg(VDP_REG_FLAGS1, VDP_REG_FLAGS1_SCREEN);

		title_screen();

		load_palette(menu_pal, 0, 16);
		load_palette(pal1, 16, 16);
		load_main_tileset();
		draw_menu_bkg();

		levelno = 0;

		levelpackno = levelpack_select();
		levelpack = mfs_fetch_file(levelpack_files[levelpackno]);

		skinnumber=0;

		levelno = level_select(levelpack, &skinnumber);

		load_main_tileset();
		load_skin(skin_files[skinnumber]);
		levelpack = mfs_fetch_file(levelpack_files[levelpackno]);

		for (;;) {
			clear_canvas();

			init_joy_repeat(&joyrec);

			lpk_load_map(&level, levelpack, levelno);

			gotoxy(0, 20);
			printf(" Level %d\n %s\n", levelno + 1, level->title);
			printf(" To restart, press both buttons");

			while(!sk_check_level_end(&level)) {
				joy = read_joy_repeat(&joyrec);

				if (joy & JOY_FIREA) {
					if (joy & JOY_UP) {
						if (levelno > 0) {
							levelno--;
							clear_canvas();
							lpk_load_map(&level, levelpack, levelno);
						}
					}
					if (joy & JOY_DOWN) {
						levelno++;
						clear_canvas();
						lpk_load_map(&level, levelpack, levelno);
					}
					if (joy & JOY_FIREB) {
						lpk_load_map(&level, levelpack, levelno);
					}
				} else {
					if (joy & JOY_UP) {
						sk_move_player(&level, 0, -1);
						level.lastdir = 0;
					}
					if (joy & JOY_DOWN) {
						sk_move_player(&level, 0, 1);
						level.lastdir = 2;
					}
					if (joy & JOY_LEFT) {
						sk_move_player(&level, -1, 0);
						level.lastdir = 3;
					}
					if (joy & JOY_RIGHT) {
						sk_move_player(&level, 1, 0);
						level.lastdir = 1;
					}
				}

				wait_vblank_noint();
				sk_render_map(&level);
			}

			levelno++;
		}
	}
}


#asm
._menu_tile_apk
	BINARY	"menu_t.apk"
._menu_map_apk
	BINARY	"menu_m.apk"
._menu_pal
	BINARY	"menu.pal"
._skinsel_map_apk
	BINARY	"skinsel.apk"
#endasm
