#ifndef _SK_CORE_
#define _SK_CORE_

// Map related constants
#define MAX_MAP_W 32
#define MAX_MAP_H 20
#define MAP_LINE_SHIFT 5
#define REFRESH_MASK 0x80
#define REFRESH_UNMASK (~REFRESH_MASK)

typedef struct _sk_levelmap {
	UBYTE w, h;
	UBYTE ply_x, ply_y;
	UBYTE lastdir;
	UBYTE data[MAX_MAP_W*MAX_MAP_H];
	char title[32];
} sk_levelmap;

extern UBYTE *sk_select_line(sk_levelmap *level, UBYTE y);
extern UBYTE *sk_select_cell(sk_levelmap *level, UBYTE x, UBYTE y);
extern void sk_load_map(sk_levelmap *level, UBYTE *map);
extern void sk_shove_it(sk_levelmap *level, BYTE x, BYTE y, BYTE xofs, BYTE yofs, char offender);
extern void sk_move_player(sk_levelmap *level, BYTE xofs, BYTE yofs);
extern UBYTE sk_check_level_end(sk_levelmap *level);

#endif /*_SK_CORE_*/