# Builds a random map for use with "Digger Chan".
#
# Aypok - 2006-03-11
#

import sys
import random

# The output file's name must be passed as an argument.
if len(sys.argv) < 3:
    print "Not enough args. Use like: 'python map_builder_tiny.py map_random.inc 500 R G B Y'."
    exit()

# Setup some strings needed.
deep = int(sys.argv[2])
rand = []
upto = ((len(sys.argv) - 3) * 20) + 1

# Copy the args into a useful list.
for j in range(0, 20):                      # Add it multiple times to increase the chances of
    for i in range(3, len(sys.argv)):       # it being chosen over a blank or milk.
        rand.append(sys.argv[i])            
rand.append(" ")                            # Empty blocks.
rand.append("M")                            # Milk.



# Open the file to which we shall write the map.
output_file = open(sys.argv[1], "w+")

# Add the starting space.
for i in range(0, 6):
    output_file.write(".db $00,$00,$00,$00,$00,$00,$00,$00,$00\n")
    
# Main loop to create the map
for line in range(0, deep):                 # Each line in the file.
    out_line = ""                           # Top line to write to the file.
    
    for j in range(0, 9):                   # Do a line's worth.
        c = rand[random.randint(0, upto)]   # Randomly choose a block.
        
        if j > 0:
            out_line += ","
        
        if c == " ":                        # Empty block?
            out_line += "$00"
            continue
            
        if c == "R":                        # Red block?
            out_line += "$01"
            continue
        
        if c == "G":                        # Green block?
            out_line += "$05"
            continue
            
        if c == "B":                        # Blue block?
            out_line += "$09"
            continue
        
        if c == "Y":                        # Yellow block?
            out_line += "$0d"
            continue
        
        if c == "M":                        # Milk?
            # Make a milk less likely to show.
            if random.randint(0, 3) == random.randint(0, 3):
                out_line += "$14"
            else:
                out_line += "$00"
            continue
            
#        if c == "W":                       # Wooden block?
#            out_line += ",$15"
#            continue
#            
#        if c == "S":                       # Steel block?
#            out_line += ",$19"
#            continue
            
    # Write the line to the output file, then start the loop again.
    output_file.write(".db " + out_line1 + "\n")

# Add the ending space.
for i in range(0,6):
    output_file.write(".db $18,$18,$18,$18,$18,$18,$18,$18,$18\n")

# Close files and end.
output_file.write(".db $ff")
output_file.close()
