	DEVICE ZXSPECTRUM48
	ORG 40000

	
Start
	DI
	CALL PreparePlayerSprites
	
Start2	
	LD SP,65000
;clearing game variables
	XOR A
	LD HL,CurrentWall
	LD B,50
Start3
	LD (HL),A
	INC HL
	DJNZ Start3	

	CALL ClearScreen

	CALL DrawBorder
	;JP GameWin
	
	LD HL,9*256+1				;row=10,col=1
	LD (LocationX),HL			;initial position in maze
	CALL DrawLocation
	
	LD BC,42*256+80				;set player initial data and draw him for the first time
	LD (PlayerPos),BC
	LD A,1
	LD (AnimFrame),A
	EI
	CALL DrawPlayer
;----------------	
MainLoop
	HALT
	HALT
	
	LD HL,Enemy1Status
	CALL MoveEnemy
	
	LD HL,Enemy2Status
	CALL MoveEnemy
	
	
	CALL MoveBullet
	CALL CheckEnemyCollisions
	
	LD BC,(PlayerPos)
	CALL DrawPlayer				;clear player at old position
	
	CALL MovePlayer				;read keyboard and determine new position
		
	CALL CheckObstacles			;did player bump after his move into something with other attribute
						;than white on black

MainLoop1								
	CALL ChangeAnimFrame
	LD (PlayerPos),BC			;store new position
	CALL DrawPlayer				;draw player at new position
	
	
	LD A,(Sound)				;play jingle at the end if rescued man or opened door
	OR A
	CALL NZ,PlaySound

;check game winning
	LD HL,PeopleStatus
	LD B,6					;check six people
MainLoop2
	LD A,(HL)
	OR A
	JR Z,MainLoop				;still people to be rescued
	INC HL
	DJNZ MainLoop2
	
	
	
;-------------------
GameWin	
	CALL ClearScreen
	
	LD HL,18432+7
	LD B,6
GameWin2
	LD DE,Man1

	PUSH BC
	PUSH HL
	CALL DrawXor2Wide
	POP HL
	POP BC
	INC L
	INC L
	INC L
	DJNZ GameWin2
	
	;LD HL,18432+142
	;LD DE,GoodJob
	;CALL DrawXor2Wide	
	
	LD B,250
GameWin4
	HALT
	DJNZ GameWin4
	JP Start2
			
;-------------------
;game data
AnimSequence	.BYTE 1,1,1,1,1,2,2,2,3,3,3,3,3,2,2,2	

CrystalData
;crystals, doors and people orered by their number
	.WORD 10*256+10		;location row*256+col
	.WORD 6*256+6
	.WORD 5*256+10
	.WORD 4*256+1
	.WORD 4*256+7
	.WORD 3*256+4
DoorsData
	.WORD 9*256+6		
	.WORD 9*256+7
	.WORD 8*256+1
	.WORD 6*256+8
	.WORD 3*256+3
	.WORD 2*256+10
PeopleData
	.WORD 1*256+1		
	.WORD 1*256+5
	.WORD 3*256+8
	.WORD 6*256+4
	.WORD 6*256+9
	.WORD 7*256+3
	
Map
 .BYTE 38,54,86,70,45,93,111,95,111,95
 .BYTE 96,80,230,214,109,157,143,239,159,196
 .BYTE 192,224,144,134,173,125,93,143,68,196
 .BYTE 128,192,99,115,83,205,141,100,244,148
 .BYTE 101,149,163,147,227,179,51,211,196,74
 .BYTE 229,53,53,21,131,76,106,154,132,202
 .BYTE 197,66,44,60,124,220,234,58,58,218
 .BYTE 194,226,50,82,172,220,202,97,17,138
 .BYTE 194,194,107,155,43,251,219,193,97,81
 .BYTE 162,146,171,59,59,155,161,177,145,129	


;-------------------
;definitions of game variables 
CurrentWall		.EQU 46100
AnimFrame		.EQU 46102		;1,2,3 for left     4,5,6 for up
FrameInSequence		.EQU 46103
Movement		.EQU 46104		;is player moving?
Horizontal		.EQU 46105		; 255- player walking horizontal (left/right), 0 -not horizontal
Mirrored		.EQU 46106		;0 - player walking left, 255-right

PlayerPos		.EQU 46107

BulletDirection		.EQU 46109
BulletPos		.EQU 46110

LocationX		.EQU 46112
LocationY		.EQU 46113
ManInCurrentLoc		.EQU 46114		;number of man in current location
Sound			.EQU 46115		;should jingle sound be played


Enemy1Status		.EQU 46116
Enemy1Pos		.EQU 46117
Enemy1XSpeed		.EQU 46119
Enemy1YSpeed		.EQU 46120
Enemy1Frame		.EQU 46121

Enemy2Status		.EQU 46122
Enemy2Pos		.EQU 46123
Enemy2XSpeed		.EQU 46125
Enemy2YSpeed		.EQU 46126
Enemy2Frame		.EQU 46127


	
DoorStatus		.EQU 46128
	
PeopleStatus		.EQU 46128+6
	

	INCLUDE <Graphics.asm>
	INCLUDE <Player.asm>
	INCLUDE <Enemy.asm>
	SAVESNA "Infestation.sna",Start
	SAVEBIN "Infestation.bin",40000,2430

