DrawPlayer
;draws player sprite at any position
;BC-XY position

;sprite structure:
;from address 43000 	 		 	 frame 1,2,3 left unshifted,
;						 frame 1,2,3 up unshifted
;					  	 frame 1 left shifted 2,4,6 pixels
;					  	 frame 2 left shifted 2,4,6 pixels
;					  	 frame 3 left shifted 2,4,6 pixels
;					  	 frame 1 up shifted 2,4,6 pixels
;					  	 frame 2 up shifted 2,4,6 pixels
;					  	 frame 3 up shifted 2,4,6 pixels
;from address 45000 - the same for mirrored sprites, facing right and mirrored up sprites, used as down sprites
;decision:		-mirrored/not mirrored
;				-shifted/not shifted
;				-frame number
;				-shift (for shifted)
				
	CALL XYtoHL			;HL-XY position, A-Shift
	LD B,A				;store shift
	LD IX,43000-32
	LD DE, 2000
	LD A,(Mirrored)
	OR A
	JR Z,DrawPlayer2
	ADD IX,DE			;adjust address for mirrored sprites
	LD A,B				;when sprite is mirrored shift 2 becomes 6 and 6 becomes 2
	CP 2
	JR Z,DrawPlayer11	
	CP 6
	JR Z,DrawPlayer12	
	JR DrawPlayer2		;otherwise don't change anything
	
DrawPlayer11	
	LD B,6
	JR DrawPlayer2
DrawPlayer12	
	LD B,2
	
DrawPlayer2
	LD A,B				;restore shift
	OR A
	JR NZ,DrawPlayer_Shifted
	
;---------	
DrawPlayer_NotShifted
	PUSH HL					;store screen position
	PUSH IX
	POP HL					;sprite offset
	LD A,(AnimFrame)			;find proper frame
	LD DE,32				;32 bytes per frames
	
DrawPlayer_NotShifted2		
	ADD HL,DE				
	DEC A
	JR NZ,DrawPlayer_NotShifted2
	EX HL, DE				;frame address in DE
	POP HL					;restore screen address
	
	CALL DrawXor2Wide
	RET		
;---------
	
DrawPlayer_Shifted
	PUSH HL
	PUSH IX
	POP HL					;read sprite offset
	LD DE,7*32-144-48			;HL was (start of first unshifted sprite -24) and unshifted sprites take 6*32 bytes
	ADD HL,DE				;now we have start of first shifted sprite -144 (size of shifted frame)	-48 (one shifted sprite)
	
;adjust for frame	
	PUSH AF					;store shift
	LD A,(AnimFrame)			;find proper frame
	LD DE,48*3				;144 bytes per frame (3 shifted sprites 48 bytes each)
DrawPlayer_Shifted2
	ADD HL,DE				
	DEC A
	JR NZ,DrawPlayer_Shifted2
	
;adjust for shift	
	POP AF					;restore shift
	RRA					;A was 2,4,6, now it is 1,2,3 
	LD DE,48				;one shifted sprite size
DrawPlayer_Shifted3
	ADD HL,DE
	DEC A
	JR NZ,DrawPlayer_Shifted3
	
	EX HL,DE				;frame address in DE
	POP HL					;restore screen address
	CALL DrawXor3Wide
	RET

;----------------------------
MovePlayer
	LD BC,#EFFE				;input - Sinclair joystick
	LD HL,Movement
	LD (HL),C				;assume that movement is not 0
	
	IN A,(C)
	LD BC,(PlayerPos)
	
	BIT 0,A					;test fire
	JR Z,Shoot
	
;go left	
	BIT 4,A					;test input
	JR NZ,MovePlayer3			;no left pressed
MovePlayer2
	XOR A
	LD (Mirrored),A				;mirrored=0
	LD HL,Horizontal
	LD (HL),H				;horizontal - yes
	DEC B					;change position
	DEC B	
	RET

;go right	
MovePlayer3
	BIT 3,A
	JR NZ,MovePlayer4
	LD HL,Mirrored
	LD (HL),H				;mirrored >0 = yes
	LD HL,Horizontal
	LD (HL),H				;horizontal - yes
	INC B	
	INC B	
	RET

;go down
MovePlayer4
	BIT 2,A
	JR NZ,MovePlayer5
	XOR A					;horizontal no, mirrored no
	LD (Mirrored),A
	LD (Horizontal),A
	INC C
	INC C	
	RET
	
MovePlayer5
	BIT 1,A
	JR NZ,MovePlayer6
;go up	
	XOR A					;horizontal no, mirrored yes
	LD (Horizontal),A
	LD HL,Mirrored
	LD (HL),H
	DEC C
	DEC C	
	RET
	
MovePlayer6
	XOR A
	LD (Movement),A				;this code reached = player not moving
	RET


;----------------------
Shoot
	XOR A
	LD (Movement),A				;when shooting, no legs moving
	LD HL,BulletDirection
	OR (HL)					;just checking if (HL)=0
	RET NZ					;(hl)<>0 - the bullet is already fired
	
	OUT (254),A				;sound
	LD A,4					;change bullet direction
	LD (HL),A
	
	LD A,(Mirrored)				;shooting left or right
	OR A
	JR NZ,Shoot2
	LD A,252
	LD (HL),A
	
Shoot2
	PUSH BC
	LD BC,(PlayerPos)
;adjust position to point to player gun, not his head
	LD A,C
	ADD A,6
	LD C,A
	
	LD A,(Mirrored)				;shooting left or right
	OR A
	JR Z,Shoot3
	LD A,B					;adjust for shooting right
	ADD A,16
	LD B,A	

Shoot3
	LD (BulletPos),BC
	CALL XYtoHL
	LD A,16	
	OUT (254),A				;sound				
	XOR (HL)
	LD (HL),A				;draw bullet which graphics are also a=16  for the first time
	POP BC
	RET
	
;----------------
MoveBullet
	LD A,(BulletDirection)	;no bullet
	OR A
	RET Z	
	
;clear bullet at old position
	LD BC,(BulletPos)
	CALL XYtoHL
	LD A,16					;pixel representing the bullet
	XOR (HL)
	LD (HL),A
	
;check if bullet reached screen edge - end
	LD A,B					;B still contains coordinate
	CP 42
	JR C,MoveBullet3			;left wall
	CP 206
	JR NC,MoveBullet3			;right wall
	
;draw bullet at new position
MoveBullet2	
	LD BC,(BulletPos)
	LD A,(BulletDirection)
	ADD A,B					;change bulet position, left or right)
	LD B,A
	
MoveBullet21					;called by clearing non existing bullet
	LD (BulletPos),BC
	CALL XYtoHL
	LD A,16					;pixel representing the bullet
	XOR (HL)
	LD (HL),A
	RET

;wall reached, destroy bullet
MoveBullet3
	XOR A
	LD (BulletDirection),A
	RET
	
	
;--------------
ChangeAnimFrame	
	LD A,(Movement)
	OR A					;no walking = no animation
	RET Z
	
	;change animation frame
	LD HL,FrameInSequence
	INC (HL)				;next frame
	LD A,(HL)
	AND 00001111b				;0-15
	LD HL,AnimSequence
	LD D,0
	LD E,A
	ADD HL,DE
	LD D,(HL)

;frames 1-3 become 4-6 for walking up/down
	LD A,(Horizontal)
	OR A
	JR NZ,ChangeAnimFrame2		
	INC D					;adjust frame
	INC D
	INC D	
	
ChangeAnimFrame2		
	LD A,D
	LD (AnimFrame),A			;store frame
	RET
	
;--------------------------
CheckObstacles
;BC new position
	PUSH BC
	CALL XYtoHL
;transform graphic address to attribute address
		LD A,80
		SRL H
		SRL H
		SRL H
		ADD A,H
		LD H,A
		
;check attributes of new player position
;if there is something different than white on black		
		LD DE,30			
		LD BC,3*256+71					;B=3 (rows),C=71(attribute)
CheckObstacle1			
		LD A,(HL)					;check 3*3 squares
		CP C						;left upper corner of the sprite
		JR NZ,CheckObstacles2			
		INC L						;go right
		LD A,(HL)					
		CP C
		JR NZ,CheckObstacles2
		INC L						;go right
		LD A,(HL)					
		CP C
		JR NZ,CheckObstacles2
		ADD HL,DE					;go down
		DJNZ CheckObstacle1
		
	;no collision, do nothing	
	POP BC
	RET
		
CheckObstacles2			
;collision (a-attribute)
	POP BC							;restore position
	
	CP 7							;attribute 7 - man
	JR Z,CheckObstacles_Man
	
	BIT 6,A							;bright - crystal
	JR NZ,CheckObstacles_Crystal
	
	OR A							;attribute 0 - door
	JR Z,CheckObstacles_Door

;this code reached - touching wall or door,movement is blocked	
;restore old position = cancel movement
	LD BC,(PlayerPos)	
	RET
	
;------------
;meeting woman
CheckObstacles_Man
	PUSH BC						;store position

;change woman status
	LD A,(ManInCurrentLoc)
	LD B,A
	LD HL,PeopleStatus-1
CheckObstacles_Man2
	INC HL						;find proper data about our man
	DJNZ CheckObstacles_Man2
	LD (HL),A					;A<>0 - mark that our man was collected

;clear woman sprite
	EX AF,AF'					;required, the called routine reads alternate A
	CALL Location_Man1				;clear the sprite	
	LD A,71
	CALL Location_Man3				;clear the attribute
	
	LD (Sound),A					;set jingle to be played
	POP BC						;restore position
	RET

;------------
;touching crystal
CheckObstacles_Crystal
	LD HL,DoorStatus-1				;find crystal data
	SUB 64						;A=color, it was bright, now it is 1-6
	LD B,A
CheckObstacles_Crystal2
	INC HL
	DJNZ CheckObstacles_Crystal2
	LD A,(HL)					;check status
	OR A
	JR NZ,CheckObstacles_Crystal3			;crystal already touched
	
	LD (HL),H					;(hl)<>0 - change crystal status - open door
	LD A,H
	LD (Sound),A					;make sound
CheckObstacles_Crystal3	
	LD BC,(PlayerPos)				;cancel movement
	RET
	
;------------	
;going door	
CheckObstacles_Door
;change location
;based on player position, determine which door is player going
	
	LD A,B
	CP 40
	JR C,GoLocationLeft			;left edge
	CP 194
	JR NC,GoLocationRight			;right	edge
	
	LD A,C
	CP 30
	JR C,GoLocationUp
	CP 160
	JR NC,GoLocationDown		
	RET

;------------------------
GoLocationLeft
	LD HL,LocationX
	DEC (HL)				;change map position
	CALL DrawLocation
	LD BC,192*256+88			;player position in new location
	RET
	
GoLocationRight
	LD HL,LocationX
	INC (HL)
	CALL DrawLocation
	LD BC,44*256+88
	RET
	
GoLocationUp
	LD HL,LocationY
	DEC (HL)
	CALL DrawLocation
	LD BC,122*256+166
	RET

GoLocationDown
	LD HL,LocationY
	INC (HL)
	CALL DrawLocation
	LD BC,122*256+28
	RET
	
	
;----------------
PlaySound
	LD BC,28*256+30
	LD HL,312
	LD DE,16
PlaySound2
	PUSH HL
	PUSH DE
	PUSH BC
	CALL 949
	POP BC
	POP DE
	POP HL
	LD A,L
	SUB C
	LD L,A
	DJNZ PlaySound2
	
	XOR A			;reset sound playing in next frame
	LD (Sound),A
	RET