DrawLocation
	XOR A
	LD (BulletDirection),A			;bullet if existed in prevoius location, disappears now

;find location byte in the map
	LD HL,Map-10-1
	LD DE,10
	
	LD A,(LocationY)
DrawLocation11
	ADD HL,DE
	DEC A
	JR NZ,DrawLocation11
	
	LD A,(LocationX)
DrawLocation12
	INC HL
	DEC A
	JR NZ,DrawLocation12
	LD A,(HL)				;get location byte
	


;A- byte coding the location
;format (8 bits): TDRLWWCC
;C -color, W-wall type, TDRL-top down right left door (1-exists,0-no)

	PUSH AF
	CALL ClearPlayingArea
	CALL InitialiseEnemy
	POP AF
	
;two bits code colour
	PUSH AF
	AND 00000011b	;0-3
	ADD A,3			;3-6
	CP 3			;3 means navy, the rest are the same as number
	JR NZ,DrawLocation2	
	LD A,1
	
DrawLocation2
	LD HL,22532
	LD BC,24*256+24
	CALL AttrBlock	;paint walls attribute
	
	LD A,71
	LD HL,22528+101
	LD BC,22*256+20
	CALL AttrBlock	;paint playing area white
	POP AF
	
;two bits for wall type
	PUSH AF
	AND 00001100b
	RRA
	RRA				;0-3
	INC A				;1-4
	LD HL,Wall1-32
	LD DE,32
DrawLocation3
	ADD HL,DE		;find address
	DEC A
	JR NZ,DrawLocation3
	LD (CurrentWall),HL
	CALL DrawWall
	POP AF
	
;doors based on remaining 4 bits
	LD DE,32
	LD C,D			;c=0

;left door	
	BIT 4,A	
	JR Z,DrawLocation4	
	LD HL,22528+356
	LD (HL),C
	ADD HL,DE
	LD (HL),C
	
;right door
DrawLocation4
	BIT 5,A	
	JR Z,DrawLocation5	
	LD HL,22528+379
	LD (HL),C
	ADD HL,DE
	LD (HL),C
	
;down door
DrawLocation5
	BIT 6,A	
	JR Z,DrawLocation6
	LD HL,22528+751
	LD (HL),C
	INC L
	LD (HL),C

;top door
DrawLocation6
	BIT 7,A	
	JR Z,DrawLocation7
	LD HL,22528+15
	XOR A
	LD BC,2*256+3
	CALL AttrBlock


;special elements - doors, people crystals
DrawLocation7


	LD BC,(LocationX)
	LD HL,CrystalData			;start of object data
	EX AF,AF'
	LD A,1
	EX AF,AF'
	
DrawLocation71
	LD E,(HL)
	INC HL
	LD D, (HL)
	INC HL					;next object data
	LD A,B					;check one coordinate
	CP D
	JR NZ,DrawLocation72			;not equal = no object
	LD A,C
	CP E
	JR NZ,DrawLocation72			;not equal = no object

;object found, determine its nature
	EX AF,AF'				;object number
	CP 7
	JR C,Location_Crystal			;objects 1:6 -crystals 
	CP 13
	JR NC,Location_Man			;objects 13:18 - people
	JR Location_Door			;the rest 7:12 - doors
	
	
;no object yet
DrawLocation72
	EX AF,AF'
	INC A					;next object number
	CP 19					;6 crystals+6 doors+6 people=18, 19 is over it
	RET Z					;end of objects, no object in this room
	
	EX AF,AF'
	JR DrawLocation71			;check next object

;-------------	
Location_Crystal
;there is crystal in this room	
	EX AF,AF'				;store alternate A
	LD HL,18432+111
	LD DE,Crystal
	CALL DrawXor2Wide			;graphics
	
	EX AF,AF'				;alternate A - color
	ADD A,64				;bright
	LD HL,22528+367
	LD BC,2*256+2
	CALL AttrBlock
	RET
	
;---------------
Location_Door	
;there is door in this room	
	SUB 6					;door number 7:12 become 1:6
	LD HL,DoorStatus-1			;check status - is door opened
	LD E,A
	LD D,0
	ADD HL,DE				;door status address
	EX AF,AF'				;store alternate A - color
	
	LD A,(HL)				;read door status address
	OR A
	RET NZ					;0-closed, 1 - opened, don't draw opened door

	LD HL,16384+47
	PUSH HL
	LD DE,(CurrentWall)		;clear wall graphics
	CALL DrawXor2Wide		
	
	POP HL
	LD DE,Door
	CALL DrawXor2Wide		;draw door
	
	EX AF,AF'			;alternate A - color
	LD HL,22528+47
	LD BC,2*256+2
	CALL AttrBlock
	RET	
	
;-----------------
Location_Man	
;there is man in this room	
	SUB 12					;man nr 13:18 becomes 1:6
	LD (ManInCurrentLoc),A			;store number of man for further uses
	LD HL,PeopleStatus-1			;check status - is man present
	LD E,A
	LD D,0
	ADD HL,DE				;man status address
	
	LD A,(HL)				;test status
	OR A
	RET NZ					;0-present, 1 -absent

;drawing the man
Location_Man1	
	LD DE,Man1				;two types of people	
	LD HL,18432+111
	CALL DrawXor2Wide			;draw man
	
	LD A,7					;man-dark white
Location_Man3
	LD HL,22528+367
	LD BC,2*256+2
	CALL AttrBlock
	RET
	

;----------------------

AttrBlock
;A- attribute, HL-corner, BC-size
	LD DE,32	
	
AttrBlock2
	PUSH BC
	PUSH HL
AttrBlock3			;one line
	LD (HL),A
	INC L
	DJNZ AttrBlock3
	
	POP HL			;back to line beginning
	POP BC
	ADD HL,DE		;go one line down
	DEC C
	JR NZ,AttrBlock2
	RET
		

	
;------------------------	
DrawBorder	
	LD HL,16388
		
;lu corner	
	LD DE,LocationBorder
	CALL DrawBorder_Char	

;up line	
	LD B,23
	LD DE,LocationBorder+8
DrawBorder2				
	INC L
	CALL DrawBorder_Char
	DJNZ DrawBorder2
	
;ru corner
	LD DE,LocationBorder+16		
	CALL DrawBorder_Char	
	
;right line
	LD DE,LocationBorder+32
	LD B,23
DrawBorder3
	CALL OneCharDown
	CALL DrawBorder_Char
	DJNZ DrawBorder3
	
;rb corner
	LD DE,LocationBorder+56		
	CALL DrawBorder_Char	

;bottom line
	LD DE,LocationBorder+48
	LD B,23
DrawBorder4
	DEC L
	CALL DrawBorder_Char
	DJNZ DrawBorder4
			
;lb corner
	LD DE,LocationBorder+40		
	CALL DrawBorder_Char
	
;left line
	LD HL,16384+36
	LD DE,LocationBorder+24
	LD B,22
DrawBorder5
	CALL DrawBorder_Char
	CALL OneCharDown
	DJNZ DrawBorder5	
	RET		
	
;------
DrawBorder_Char
	PUSH HL
	PUSH DE
	LD C,8
DrawBorder_Char2
	LD A,(DE)
	LD (HL),A
	INC H
	INC DE
	DEC C
	JR NZ,DrawBorder_Char2
	POP DE
	POP HL
	RET
;------------------
DrawWall
	LD HL,16384+37
	LD B,11
	
DrawWall2	
	PUSH BC
	PUSH HL
	LD DE,(CurrentWall)
	CALL DrawXor2Wide
	POP HL
	POP BC
	INC L
	INC L
	DJNZ DrawWall2	
	RET
		
;----------
OneCharDown
	LD A,L
	ADD A,32
	LD L,A
	RET NC
	LD A,H
	ADD A,8
	LD H,A
	RET
	
	
;--------------
OnePixelLineDown
;requires HL as screen address
	INC H 			;go to new line
	LD A,H
	AND 00000111B
	OR A 			;h=0 -> going to new character line
	RET NZ			; new line belongs to the same character line
	
	LD A,L 			;going to new character line
	ADD A,32
	LD L,A
	RET C			;going to new screen segment, if e.g h was 71, now it is 72
	
	LD A,H
	SUB 8
	LD H,A			;decrease h if we are in the same screen segment
	RET

;----------------	
XYtoHL
;turn XY into HL screen coordinates
;B contains X, C contains Y 
;doesn't destroy BC
 
	LD  A,C
	AND  00000111b
	LD  H,A
 	LD  A,C
 	RRA 
 	RRA 
 	RRA 
 	AND  00011000b
 	OR  H
 	OR  01000000b
 	LD  H,A					;H found
 
 	LD  A,B
 	RRA 
 	RRA 
 	RRA 
 	AND  00011111b
 	LD  L,A
 	LD  A,C
 	RLA 
 	RLA 
 	AND  11100000b
 	OR  L
 	LD  L,A					;L found
 	
 	LD A,B
 	AND 00000111b				;shift found
  	RET

;----------
ClearScreen
	XOR A
	LD (23624),A 
	OUT (254),A
	LD A,70
	LD (23693),A				;Basic system variable
	CALL 3435				;Rom CLS
	RET	
	
;---------
ClearPlayingArea

;clear graphics
	LD HL,16384+37
	LD E,0
	LD C,176						;nr of lines
	
ClearPlayingArea2	
	LD B,22							;bytes in one line
	LD D,L
	
ClearPlayingArea3
	LD (HL),E						;one pixel line
	INC L
	DJNZ ClearPlayingArea3
	
	LD L,D							;restore line beginning
	CALL OnePixelLineDown					;go down
	DEC C
	JR NZ,ClearPlayingArea2
	
;white attribute
	LD HL,22528+99
	LD BC,20*256+18
	LD A,71
	CALL AttrBlock	
	RET
	

	
	
;---------------------
DrawXor2Wide
;draw sprite 16 pixel lines, two bytes wide
;DE-source, HL-address
	LD B,16
	
DrawXor2Wide2
	LD A,(DE)		;first byte in line
	XOR (HL)
	LD (HL),A
	INC DE
	INC L
	
	LD A,(DE)		;second byte in line
	XOR (HL)
	LD (HL),A
	INC DE
	DEC L
	CALL OnePixelLineDown
	DJNZ DrawXor2Wide2
	RET
	
;---------------------
DrawXor3Wide
;draw sprite 16 pixel lines, three bytes wide
;DE-source, HL-address
	LD B,16
	
DrawXor3Wide2
	LD A,(DE)	;first byte	
	XOR (HL)
	LD (HL),A
	INC DE
	INC L
	
	LD A,(DE)	;second byte	
	XOR (HL)
	LD (HL),A
	INC DE
	INC L
	
	LD A,(DE)	;third byte	
	XOR (HL)
	LD (HL),A
	INC DE
	DEC L
	DEC L
	
	CALL OnePixelLineDown
	DJNZ DrawXor3Wide2
	RET

		
PreparePlayerSprites
;copy not shifted sprites to new position
	LD HL,PlayerLeft1				;first unshifted sprite
	LD DE,43000					;adress for new sprites
	LD BC,6*32
	LDIR

;------------	
;create shifted versions of player sprites
;enemy shifted sprites are included too
	LD DE,PlayerLeft1				;first unshifted sprite
	LD HL,43000+6*32				;start of memory for shifted frames 
	LD B,8						;number of frames of animation (6 player, 2 enemy)
	
PreparePlayerSprites2
 PUSH BC
 PUSH DE
 PUSH HL
	CALL PrepareOneFrame				;deal with one frame of animation
	
 POP HL
	LD DE,3*48
	ADD HL,DE					;adjust adress of shifted sprites
	
	LD B,H						;adress of shifted sprites in BC
	LD C,L
 POP HL							;read into B original sprite address (from PUSH DE)
	LD DE,32					;sprite size
	ADD HL,DE
	EX HL,DE					;new original sprite adress into DE
	LD H,B				
	LD L,C						;adress of shifted sprites in HL
 POP BC							;restore counter
	
	DJNZ PreparePlayerSprites2			;repeat 3 times
	
;-------
;and now create mirror versions of copied sprites	

;mirrors of 2 byte wide sprites
	LD HL,43000				;HL	-original sprites start 
	LD DE,43000+2000+1			;DE - mirrored sprite start+1 (point to right byte)
	LD B,16*6				;BC - number of lines
	
CreateMirrorSprites2
	;left byte
	PUSH BC
	LD A,(HL)
	CALL MirrorByte
	LD (DE),A
	
	;right byte
	INC HL
	DEC DE
	LD A,(HL)
	CALL MirrorByte
	LD (DE),A
	
	INC HL
	INC DE
	INC DE
	INC DE
	
	POP BC
	DJNZ CreateMirrorSprites2
	
;---------	
;mirrors of 3 byte wide sprites
	LD HL,43000+6*32			;HL-original sprites start
	LD DE,43000+6*32+2000+2			;DE - mirrored sprite start+2 (point to right bte of first line)
	LD BC,16*6*3				;BC - number of lines

CreateMirrorSprites3
	;left byte
	PUSH BC
	LD A,(HL)
	CALL MirrorByte
	LD (DE),A
	
	;middle byte
	INC HL
	DEC DE
	LD A,(HL)
	CALL MirrorByte
	LD (DE),A
	
	;right byte
	INC HL
	DEC DE
	LD A,(HL)
	CALL MirrorByte
	LD (DE),A
	
	INC HL			;go to next line
	INC DE			;HL points to left byte of next line in source
	INC DE			;DE points to right byte of next line in destination
	INC DE
	INC DE
	INC DE
	
	POP BC
	DEC BC
	LD A,B
	OR C
	JR NZ,CreateMirrorSprites3	
	RET
	
;-------------
PrepareOneFrame
;create 3 rotates sprites, by 2,4 and 6 pixels
;DE -original sprite address
;HL -address for shifted sprite
	LD BC,3*256+2			;B=3,C=2
	
PrepareOneFrame2	
	PUSH BC
	PUSH DE
	PUSH HL
	CALL PrepareOneSprite
	
	POP HL
	LD DE,48			;position of next sprite
	ADD HL,DE	
	
	POP DE				;restore original address
	POP BC
	INC C				;new rotation
	INC C
	DJNZ PrepareOneFrame2		;repeat 3 times
	RET	
	
;-----------	
PrepareOneSprite
;DE -original sprite address
;HL -address for shifted sprite
;C - number of pixel shifts
	
	PUSH HL
	CALL SpriteToBuffer			;copy sprite to buffer
	POP HL
	EX HL,DE				;adress for shifted sprite
	
	CALL RotateBuffer			;shift pixels in buffer
	
	LD HL,47000				;buffer - source for copying to DE - destiny address
	LD BC,16*3				;buffer size
	LDIR					;copy to destination
	RET
	
;-----
SpriteToBuffer	
;DE - sprite start
	LD HL,47000				;buffer start
	LD B,16
	
SpriteToBuffer2	
	LD A,(DE)				;two byte of sprite in the line
	LD (HL),A
	INC HL
	INC DE
	
	LD A,(DE)
	LD (HL),A
	INC HL
	INC DE
	
	XOR A					;third empty byte for shifting
	LD (HL),A
	INC HL
	DJNZ SpriteToBuffer2	
	RET
	
;------
RotateBuffer
;C - number of rotates
	LD B,16					;lines

;one buffer rotate
RotateBuffer1	
	LD HL,47000				;buffer start
RotateBuffer2
	OR A					;carry=0
	RR (HL)					;rotate right one byte
	INC HL
	RR (HL)
	INC HL
	RR (HL)
	INC HL					;3 bytes
	DJNZ RotateBuffer2
	
	DEC C					;repeat C times
	JR NZ, RotateBuffer1	
	RET


;--------------	
MirrorByte
		LD C,0
		LD B,8
MirrorByte2
		RLCA
		RR C
		DJNZ MirrorByte2		
		LD A,C
		RET


	
;-------------------------
;GRAPHICS

LocationBorder
	.BYTE	 10, 32, 74, 21,168, 19,167, 22;up left
	.BYTE	170,  0,170, 85,  0,255,255,  0;u 
	.BYTE	168,  2,168, 85,  8,197,232,101;ur
	.BYTE	166, 22,166, 22,166, 22,166, 22;l
	
	.BYTE	104,101,104,101,104,101,104,101;r
	.BYTE	166, 23,163, 16,170, 21, 64, 21;dl
	.BYTE	  0,255,255,  0,170, 85,  0, 85;d
	.BYTE	104,229,200, 21,168, 82,  4, 80;dr
	
Wall1
	.BYTE	254,255,  2,128,250,191,250,181
	.BYTE	218,171,186,183,250,175,210,191
	.BYTE	170,191,210,191,162,190, 66,189
	.BYTE	146,170, 34,148,  2,128,254,255
	
Wall2:
	.BYTE	244,  7,169,251, 83,253,  7,252
	.BYTE	251,169,253, 83,244,  7,169,251
	.BYTE	 83,253,  7,252,251,169,253, 83
	.BYTE	244,  7,169,251, 83,253,  0,  0
	
Wall3:
	.BYTE	223,253,223,253,223,253,192,  1
	.BYTE	255,221,255,221,255,221,  0, 28
	.BYTE	223,253,223,253,223,253,220,  1
	.BYTE	221,255,221,255,221,255,  0,  0
	
Wall4:
	.BYTE	239,239,235,175,239,239,175,235
	.BYTE	239,239, 15,224,239,239,175,235
	.BYTE	235,175,239,239,224, 15,239,239
	.BYTE	235,175,239,239,175,235,239,239
	
Door:
	.BYTE	127,252,192,  6,213, 86,202,182
	.BYTE	223,246,192,  6,213, 86,202,182
	.BYTE	223,246,192,  6,213, 86,202,182
	.BYTE	223,246,192,  6,255,254,127,252
	
Man1:
	.BYTE	  1,224,  2,112,  5,176,  5,216
	.BYTE	  4, 24,  1,208,  3,224,  7,240
	.BYTE	  5,208,  9,200, 11,232,  0,  0
	.BYTE	  3, 96,  3, 96,  2, 32,  6, 48
	
Crystal
	.BYTE	  0,  0,  1,128,  3, 64,  7,160
	.BYTE	  7,192,  7,160,  7,192, 23,168
	.BYTE	 39,204, 87,174,119,202, 87,174
	.BYTE	123,218, 60, 52, 31,248,  7,224
	
;GoodJob
	;.BYTE	240,  1,128,  1,128,  1,183,119
	;.BYTE	149, 85,149, 85,247,119,  0,  0
	;.BYTE	  0, 66, 16, 66,  0, 66, 23,114
	;.BYTE	 21, 82, 21, 80, 23,114, 48,  0
	
PlayerLeft1
	.BYTE	  1,192,  0, 32,  1,192,  1,192
	.BYTE	  0,  0,  1,208,243,176, 24, 96
	.BYTE	 27,192,  0,  0,  3,224,  2,224
	.BYTE	  7,112,  6, 48,  0,  8, 14, 48
	
PlayerLeft2
	.BYTE	  1,192,  0, 32,  1,192,  1,192
	.BYTE	  0,  0,  1,208,243,176, 24, 96
	.BYTE	 27,192,  0,  0,  3,224,  2,224
	.BYTE	  3, 96,  3, 96,  0,  0,  6,224
	
PlayerLeft3
	.BYTE	  1,192,  0, 32,  1,192,  1,192
	.BYTE	  0,  0,  1,208,243,176, 24, 96
	.BYTE	 27,192,  0,  0,  3,224,  2,224
	.BYTE	  2,192,  1,192,  0,  0,  3,128
	

PlayerUp1:
	.BYTE	  0,224,  0, 16,  0,224,  0,224
	.BYTE	  0,  0,  1,224,  3,240,247,248
	.BYTE	 29,236, 24, 12,  1,232,  1,224
	.BYTE	  3,112,  0, 48,  7,  0,  0, 56
	
PlayerUp2:
	.BYTE	  0,224,  0, 16,  0,224,  0,224
	.BYTE	  0,  0,  1,224,  3,240,247,248
	.BYTE	 29,236, 24, 12,  1,232,  1,224
	.BYTE	  3,112,  3, 48,  0,  0,  7, 56
	
PlayerUp3:
	.BYTE	  0,224,  0, 16,  0,224,  0,224
	.BYTE	  0,  0,  1,224,  3,240,247,248
	.BYTE	 29,236, 24, 12,  1,232,  1,224
	.BYTE	  3, 48,  3,  0,  0, 56,  7,  0

Enemy1:
	.BYTE	 32,  6, 32, 12, 48, 56, 56, 48
	.BYTE	 19,208,  4,224,  9,208, 11,176
	.BYTE	 15, 80, 15,160, 22,192, 59, 16
	.BYTE	240, 48,  0, 56,  0, 24,  0, 12
	
Enemy2:
	.BYTE	  0,  0,128,  0,192, 15,120, 60
	.BYTE	 51,216, 20,224,  9,208, 11,176
	.BYTE	 15, 80, 15,160,  6,216, 11, 60
	.BYTE	 12,  7, 24,  0,112,  0,  0,  0
	
