DrawEnemy
;BC - enemy position,IX - frame address
	CALL XYtoHL			;HL-XY position, A-Shift
	PUSH HL				;store position
	
	OR A				;sprite shifted?
	JR NZ,DrawEnemyShifted

;-----	
DrawEnemyUnshifted
	;determinine frame
	LD DE,Enemy1
	LD A,(IX+0)			;enemy frame
	BIT 3,A
	JR Z,DrawEnemyUnshifted2
	LD DE,Enemy2

DrawEnemyUnshifted2
	POP HL				;restore position
	CALL DrawXor2Wide
	RET
;-----
DrawEnemyShifted
	
	LD B,A					;shift
	RR B					;2,4,6 turns into 1,2,3
	LD HL,44056-48				;address for start of shifted enemy frames
	LD DE,48				;one sprite size
	LD A,(IX+0)				;get frame counter
	BIT 3,A
	JR Z,DrawEnemyShifted2
	LD HL,44056-48+144			;shifted sprites of second frame
	
DrawEnemyShifted2
	ADD HL,DE				;find proper frame
	DJNZ DrawEnemyShifted2
	EX HL,DE				;frame in DE
	
	POP HL					;restore position
	CALL DrawXor3Wide
	RET
	
;-----------------------
MoveEnemy
	;HL - adress of enemy status
	LD A,(HL)				;read enemy status
	OR A
	RET Z					;no enemy
	
	INC HL					;read enemy position
	LD C,(HL)
	INC HL
	LD B,(HL)
	
	
	INC HL
	PUSH HL					;store X speed address
	INC HL
	INC HL					;go to frame address
	
	PUSH HL					;enemy frame into IX
	POP IX
	PUSH BC
	
	CALL DrawEnemy				;clear enemy

;change position
	POP BC					;position
	POP HL					;X speed
		
;HL - enemy X speed	
;check bouncing of the walls
	LD A,B
	CP 42
	JR Z,MoveEnemy21			;change sign
	CP 196
	JR Z,MoveEnemy21		
	JR MoveEnemy22				;no sign change
;change speed sign
MoveEnemy21	
	LD A,(HL)
	CPL
	INC A
	LD (HL),A				;standard way of changing byte sign	
	
MoveEnemy22	
	LD A,(HL)
	ADD A,B
	LD B,A

		
	INC HL
;HL - enemy Y speed	
	LD A,C
	CP 30
	JR Z,MoveEnemy31
	CP 160
	JR Z,MoveEnemy31
	JR MoveEnemy32
;change speed sign
MoveEnemy31
	LD A,(HL)
	CPL
	INC A
	LD (HL),A				;standard way of changing byte sign	
MoveEnemy32
	LD A,(HL)
	ADD A,C
	LD C,A
	
;change enemy animation frame
	INC HL
	INC (HL)
	PUSH HL
	POP IX					;enemy frame for "draw enemy" routine
	
;store new position
	DEC HL
	DEC HL
	DEC HL
	LD (HL),B
	DEC HL
	LD (HL),C
	
	CALL DrawEnemy				;BC holds new position
	RET

;---------------------
InitialiseEnemy
	LD HL,Enemy1Status
	
	LD E,104				;offset for enemy1 X,a bit different to avoid equal positions=dissapear of enemy sprites
	CALL InitialiseEnemy2		
	
	LD E,106				;offset for enemy2 X
	LD HL,Enemy2Status
	CALL InitialiseEnemy2
	RET
	
;-------
InitialiseEnemy2
	LD (HL),H				;status<>0 - enemy exists
	INC HL
	
	CALL WriteRandomCoord			;Y coordinate
	LD C,A
	
	LD A,E					;center point for payfield is at 128,106 (105=128-22)
	ADD A,22				;change Y offset to X offset
	LD E,A
	
	CALL WriteRandomCoord			;X coordinate
	LD B,A
	
	CALL WriteRandomSpeed			;X speed
	CALL WriteRandomSpeed			;X speed
	
	PUSH HL					;get enemy frame
	POP IX
	CALL DrawEnemy				;draw for the first time
	
	RET

	
;-------	
WriteRandomCoord
	LD A,R
	AND 00010100B				;not bigger than 40, even
	LD D,A
	
	LD A,E
	ADD A,D
	BIT 3,A					;randomly left or right from start point
	JR Z,WriteRandomCoord2
	SUB D
	SUB D
WriteRandomCoord2
	LD (HL),A					
	INC HL
	RET
	
WriteRandomSpeed
	LD A,R
	BIT 1,A
	LD A,2
	JR Z,WriteRandomSpeed2
	LD A,254
	
WriteRandomSpeed2
	LD (HL),A
	INC HL						;change to next byte of enemy data
	RET
	
;--------------------
CheckEnemyCollisions	
	XOR A
	LD (COEC_SMC+1),A				;self modyfying code - comparing top of enemy to top of player

	LD HL,Enemy1Status			
	CALL CheckCollision_EnemyPlayer		
	LD HL,Enemy2Status			
	CALL CheckCollision_EnemyPlayer	
	
	LD A,(BulletDirection)				;bullet doesn't exist, no more check
	OR A
	RET Z
	
	LD A,10
	LD (COEC_SMC+1),A				;self modyfying code - comparing middle of enemy to top of player
	
	LD HL,Enemy1Status+1
	CALL CheckCollisionEnemyBullet
	
	LD HL,Enemy2Status+1
	CALL CheckCollisionEnemyBullet
	
	RET
	
	
;---------	
CheckCollision_EnemyPlayer
	LD A,(HL)			;does enemy exist -hl points to status
	OR A
	RET	Z
	
	INC HL
	LD E,(HL)			;enemy position
	INC HL
	LD D,(HL)
	
	LD BC,(PlayerPos)
	CALL CheckOneEnemyCollision
	OR A
	JR NZ,CheckEnemyCollisions_GameOver
	RET


CheckEnemyCollisions_GameOver
	LD B,150
CheckEnemyCollisions_GameOver2
	HALT
	LD A,R
	OUT (254),A
	DJNZ CheckEnemyCollisions_GameOver2	
	JP Start2			;new game	
	
;----------
CheckCollisionEnemyBullet
	LD E,(HL)
	INC HL
	LD D,(HL)			;enemy position
	LD BC,(BulletPos)		;bullet position
	CALL CheckOneEnemyCollision
	OR A
	RET Z				;no collision
	DEC HL
	DEC HL				;go to status
	XOR A
	LD (HL),A			;enemy shot=change status to not existing
	LD (BulletDirection),A		;bullet not existing
	CALL MoveBullet21		;clear bullet pixel
	RET
	
;-------------
CheckOneEnemyCollision
;BC	- enemy coordinates
;DE - other object coordinates

	LD A,B
	ADD A,10
	CP D
	JR C,CheckEnemyCollision2	;X too small
	SUB 20
	CP D
	JR NC,CheckEnemyCollision2	;X too big
	
	LD A,C
	ADD A,10
COEC_SMC	
	SUB 0				;self modyfing code  - player must have the same corner as enemy while bullet must strike in the middle
	CP E
	JR C,CheckEnemyCollision2	;Y too small
	SUB 20
	CP E
	JR NC,CheckEnemyCollision2	;Y too big
	
	LD A,255			;mark collision
	RET
	
CheckEnemyCollision2
;no collision
	XOR A				;0 means no colision
	RET
