﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
namespace SpaceRescueMapper
{
    class Room : Button
    {
        Form parentForm;
        public int Color;
        public int WallType;

        //konstruktor
        public Room(Form pForm)
        {
            this.Size = new System.Drawing.Size(20, 20);
            parentForm = pForm;                 //wskazanie na formularz nadrzędny
            
            //zdarzenie obsługi kliknięcia myszą
            //MouseDown w przeciwieństwie do MouseClick obsługuje wszystkie przyciski
            this.MouseDown += new MouseEventHandler(this.Room_MouseDown); 
            Color = 0;
            WallType = 0;
            SetProperties();
        }

        public void SetProperties()
        {
            //ustaw kolor i typ podłogi przycisku
            switch (Color)
            {
                case 0:
                    this.BackColor = System.Drawing.Color.Navy;
                    this.ForeColor = System.Drawing.Color.White;
                    break;
                case 1:
                    this.BackColor = System.Drawing.Color.Green;
                    this.ForeColor = System.Drawing.Color.Black;
                    break;
                case 2:
                    this.BackColor = System.Drawing.Color.Cyan;
                    this.ForeColor = System.Drawing.Color.Black;
                    break;
                case 3:
                    this.BackColor = System.Drawing.Color.Yellow;
                    this.ForeColor = System.Drawing.Color.Black;
                    break;
            }

            //ustaw kolor i typ podłogi przycisku
            switch (WallType)
            {
                case 0:
                    this.Text = "1";
                    break;
                case 1:
                    this.Text = "2";
                    break;
                case 2:
                    this.Text = "3";
                    break;
                case 3:
                    this.Text = "4";
                    break;
            }


        }

        public void Room_MouseDown(object sender, MouseEventArgs e)
        {

            switch (e.Button) //klikniecie myszą, LPM - zmień kolor, RPM-zmień typ
            {
                case MouseButtons.Left:
                    Color++;
                    if (Color == 4) Color = 0;
                    break;

                case MouseButtons.Right:
                    WallType++;
                    if (WallType == 4) WallType = 0;
                    break;
            }
            SetProperties();

        }
    }
}
