;
; "Higgs boson in the LHC", a <1K game by Deanysoft(c)
;
; 27th April - 16th June 2011
;
;
; v1.0		Version sent for evaluation
; v1.1		More optimisation done to include all-in-one basic loader/execution
;
	CODE

;EXEADDR:	EQU	49152	; (had it here originally)
EXEADDR:	EQU	23766	; (default exe address with bin2rem)
ZXSCREEN:	EQU	16384	; real screen
VARS:		EQU	23296	; start of game variables
SCREEN:		EQU	18432	; start of game area
ROWTBL:		EQU	32768	; (8000H) must have LSB = 0

			; reverse of [16, 14, 12, 11, 10, 9, 8, 6, 4, 2]
TAP_H:		EQU	01010101B	; a maximal set of taps for the linear feedback
TAP_L:		EQU	11110101B	; shift register (GALOIS)

CLKPOSN:	EQU	4011H	; where to start drawing the timer

PERIOD_INIT	EQU	80	; initial period to wait before we try and create a proton

;------------------------------------------------------------------------------

FRC:		EQU	VARS	; the ubiquitous free running counter
TICK:		EQU	VARS+1
SECS:		EQU	VARS+2
MINS:		EQU	VARS+3
PERIOD:		EQU	VARS+4
PERIOD_DEC:	EQU	VARS+5


HB_Y:		EQU	VARS+10	; Higgsy's Y position
HB_DIR:		EQU	VARS+11	; Higgsy direction 0-stopped, 1-down, 2-up


GALOIS:		EQU	VARS+14	; 16 bit Galois LFSR
;		EQU	VARS+15


; Higgsy's neutrinos
;
; structure for one neutrino
;
SIZEOF_NEUTRINO:	EQU	5

NEUT_ACTIVE:	EQU	0	; 0 = inactive, 17...1 = firing
NEUT_X:		EQU	1
NEUT_Y:		EQU	2
NEUT_SCREEN:	EQU	3	; last screen posn for erasing with
;		EQU	4

NEUTRINOS:	EQU	VARS+19


; The Protons
;
COLLISIONS:	EQU	VARS+29	; the proton collision counter
DIR_TOGGLE:	EQU	VARS+32	; toggles the direction for each new proton

MAX_PROTONS:	EQU	12	; poke this until it chugs
PROTONS:	EQU	VARS+33	; base address of the Protons

; structure for one proton
SIZEOF_PROTON:	EQU	6

PROT_DIR:	EQU	0	; 0-dead, 1-left, 2-right
PROT_X:		EQU	1
PROT_Y:		EQU	2
PROT_SPEED:	EQU	3	; pixels to move, 0-N, (0=half speed)
PROT_SCREEN:	EQU	4	; last screen position (for quick erase)
; ............	EQU	5

ENDVARS:	EQU	VARS+256
;------------------------------------------------------------------------------

PROTON_GFX:	EQU	49152	; the address where the proton graphics will be



	ORG	EXEADDR

;****************************

START:	DI
	LD	SP,65020

; The Interupt
	LD	A,18H		; JR
	LD	(FFFFH),A
	LD	A,C3H
	LD	(FFF4H),A	; JP
	LD	HL,RUPTS
	LD	(FFF5H),HL	; RUPTS
	LD	A,39H		; use 48K ROM block of FFs
	LD	I,A
	IM	2

	EXX
	LD	HL,TICK		; use HL' as a cheap clock
	EXX

	EI

; create the screen rowtable for Y position look-up
	LD	HL,SCREEN
	LD	DE,ROWTBL
	LD	B,64

1$	LD	A,L
	LD	(DE),A
	INC	DE
	LD	A,H
	LD	(DE),A
	INC	DE
	CALL	DWNLN
	DJNZ	1$


; create proton graphics
CREATE_PROTONS:			; (wow!)

	LD	HL,THE_PROTON	; first, copy the 8 byte graphic into an 8 x 2 sized space
	LD	DE,PROTON_GFX
	PUSH	DE		; (keep for shifting, below)
	LD	A,8
1$:	LDI
	INC	DE
	DEC	A
	JR	NZ,1$

; now shift and copy that 8 x 2 graphic to create the others cumulatively
	POP	HL		; recover PROTON_GFX
	LD	DE,PROTON_GFX+16
	LD	B,64
2$	LD	A,(HL)
	INC	HL
	LD	C,(HL)
	SRL	A		; shift lsbit into carry
	RR	C		; rotate carry into msbit
	LD	(DE),A
	INC	DE
	LD	A,C
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	2$

; game restarts here
WARMSTART:
;
; clear real screen
;
	LD	HL,ZXSCREEN
	LD	DE,ZXSCREEN+1
	LD	(HL),L
	LD	BC,6144
	LD	A,L
	LDIR
	LD	(HL),71		; bright white on black
	LD	BC,767
	LDIR

	OUT	(254),A		; black border

; HL and DE are now -> VARS & VARS+1
	LD	(HL),C			; C = 0 at this point
	LD	BC,ENDVARS-VARS-1
	LDIR				; continue to reset variables

	LD	(GALOIS),HL		; may as well initialise the LFSR to this value
;
	LD	HL,0218H			; set Higgsy's Y pos (24) and make him stationary (2)
	LD	(HB_Y),HL
	LD	A,L
;
	LD	HL,CLKPOSN-2+512		; draw ':' between MM:SS
	LD	(HL),A
	INC	H
	INC	H
	INC	H
	LD	(HL),A
;
	LD	HL,5050H			; initialise the 'proton creation' period
	LD	(PERIOD),HL		; put 80 into PERIOD and PERIOD_DEC

;
; Main loop
;
MAIN:
	LD	HL,FRC			; do the FRC
	INC	(HL)
	INC	HL			; now HL -> TICK

	LD	A,(HL)			; check the timer
	CP	50
	JR	C,RANDOM			; not yet a second if < 50...
	XOR	A
	LD	(HL),A			; else 1s has elapsed, reset the tick

	INC	HL			; now, HL -> SECS

; entering here, HL must -> SECS
INC_CLOCK:
	LD	A,(HL)
	INC	A			; count the seconds
	DAA
	LD	(HL),A
	CP	60H			; a minute gone?
	JR	C,SHOW_CLK		; no, show clock anyway
	XOR	A
	LD	(HL),A			; yes, zero the seconds
	INC	HL			; HL -> mins
	LD	A,(HL)
	INC	A			; count the mins
	DAA
	LD	(HL),A
	DEC	HL			; HL -> seconds

; entering here, HL -> SECS
SHOW_CLK:
	LD	DE,CLKPOSN		; draw the clock here
	LD	B,2			; 2 pairs of digits
	
5$	PUSH	BC

	LD	A,(HL)
	AND	0FH
	CALL	DIGIT_R			; draw the right digit of the pair

	LD	A,(HL)
	AND	F0H
	SRL	A
	CALL	DIGIT_L			; now the left digit of the pair

	INC	HL			; now do the mins
	DEC	E			; hop over the ':' screen position
	POP	BC
	DJNZ	5$

; NB, as we leave the above routine, HL now -> PERIOD
; increase difficulty by shortening the period

	LD	A,(HL)			; get PERIOD
	CP	8			; < 9?
	JR	C,RANDOM			; yes, don't decrease it further (or it gets silly)
	DEC	A			; 
	LD	(HL),A			; else store the decrease

; do some 'randomising'
RANDOM:	LD	HL,(GALOIS)		; get LFSR
	ADD	HL,HL			; shift it up
	JR	NC,1$
	LD	A,TAP_H			; do feedback on carry
	XOR	H
	LD	H,A
	LD	A,TAP_L
	XOR	L
	LD	L,A

1$	LD	(GALOIS),HL

; conjure a new Proton if need be
;
NEWPROTON:
	LD	HL,PERIOD_DEC
	DEC	(HL)		; decrease the period counter
	JR	NZ,READKBD	; non-zero means no new protons for now...

	LD	A,(PERIOD)
	LD	(HL),A		; reload PERIOD_DEC when it reaches 0

	LD	A,(GALOIS)	; get a random-ish number
	CP	128		; is tap > threshold ?
	JR	NC,READKBD	; no...

; yes, try and conjure a proton
	LD	HL,PROTONS
	LD	DE,SIZEOF_PROTON

	LD	B,MAX_PROTONS	; look through all possible protons

2$	LD	A,(HL)		; get dir setting (PROT_DIR)
	AND	A		; a dead proton?
	JR	Z,1$		; yes...
	ADD	HL,DE		; else try the next one
	DJNZ	2$
	JR	READKBD		; all protons are busy...
	
; this one is dead/free, start it up...
1$	LD	C,A		; C=0, (the starting X position if moving right)
	LD	A,(DIR_TOGGLE)
	XOR	1		; switch direction for each new proton
	JR	NZ,3$
	LD	C,248		; the starting X position if moving left
3$	LD	(DIR_TOGGLE),A	; toggle the direction for next time
	INC	A		; A now = 1 or 2
	LD	(HL),A		; set PROT_DIR
	INC	HL
	LD	(HL),C		; init X pos (PROT_X)  (0 for moving right, 248 for left)

	INC	HL
	LD	A,R		; get a random-ish Y posn
	AND	00111111B	; from 0-63 
	LD	(HL),A		; set PROT_Y
	LD	A,(GALOIS)
	AND	3		; random speed from 0-3
	INC	HL
	LD	(HL),A		; set PROT_SPEED
	INC	HL
	INC	HL
	LD	(HL),A		; null PROT_SCREEN (set high byte to safe/ROM off screen value)

; control Higgsy.  Once he starts moving, he can't stop...!
;
READKBD:
	LD	HL,HB_DIR

	LD	A,251
	IN	A,(254)
	BIT	0,A		; 'q' pressed?
	JR	NZ,2$
11$	LD	(HL),0		; set dir to 'up'
	JR	3$
	
2$:	LD	A,253
	IN	A,(254)
	BIT	0,A		; 'a'?
	JR	NZ,3$
22$:	LD	(HL),1		; set dir to 'down'

3$:	XOR	A
	CP	(HL)		; moving up?
	JR	NZ,4$		; no...

; try to move up
	LD	A,(HB_Y)
	AND	A
	JR	Z,22$		; can't move, change dir!
	DEC	A
	LD	(HB_Y),A	
	JR	8$

4$:	INC	A
	CP	(HL)		; moving down?
	JR	NZ,8$		; no...

; try to move down
	LD	A,(HB_Y)
	CP	54
	JR	Z,11$		; can't move, change dir!
	INC	A
	LD	(HB_Y),A	

; fire neutrinos?
8$:	LD	HL,NEUTRINOS
	LD	B,120		; X posn of neutrino (if we fire)
	LD	A,223
	IN	A,(254)
	BIT	0,A		; 'p' = fire right?
	CALL	Z,FIRE

5$:	LD	HL,NEUTRINOS+SIZEOF_NEUTRINO
	LD	B,128
	LD	A,223
	IN	A,(254)
	BIT	1,A		; 'o' = fire left?
	CALL	Z,FIRE


TIMING:	HALT			; wait for frame flyback interrupt

; Process the Protons
;
PUT_PROTS:
	LD	IX,PROTONS

	LD	C,MAX_PROTONS	; C = proton counter (don't trash it!)

; move a proton
5$	LD	A,(IX+PROT_DIR)
	AND	A		; is this proton dead?
	JP	Z,9$		; yes, check the next...

	LD	A,(IX+PROT_SPEED)	; get speed
	LD	E,A
	AND	A		; on half speed? (==0)
	JR	NZ,1$		; no...

	LD	A,(FRC)		; use FRC to check for half speed
	AND	1
	JR	Z,7$		; don't move this time, just re-draw...
	
	LD	E,A		; one pixel, but half the time

1$:	LD	A,(IX+PROT_X)
	BIT	0,(IX+PROT_DIR)	; what direction is it going? (1-left, 2-right)
	JR	Z,4$
	SUB	E		; move left
	JR	NC,44$		; if > 0...

	LD	A,R		; get a random-ish Y posn
	AND	00111111B	; from 0-63 
	LD	(IX+PROT_Y),A	; set Y posn
	LD	A,248		; else wrap to the right
	JR	44$

4$:	ADD	A,E		; move right
	CP	249		; < 248
	JR	C,44$		; yes...

	LD	A,R		; get a random-ish Y posn
	AND	00111111B	; from 0-63 
	LD	(IX+PROT_Y),A	; set Y posn
	XOR	A		; else wrap to the left
44$:	LD	(IX+PROT_X),A	; store new position

; before we draw it, rub out the old one...
7$:	LD	L,(IX+PROT_SCREEN)	; retrieve previous screen posn
	LD	H,(IX+PROT_SCREEN+1)

	LD	E,0
	LD	B,8

22$:	LD	(HL),E			; and erase
	INC	HL
	LD	(HL),E
	DEC	HL
	CALL	DWNLN
	DJNZ	22$

; get new coords and graphic for this proton
	LD	A,(IX+PROT_Y)
	CALL	Y_TO_ROW
	LD	E,(IX+PROT_X)
	LD	B,E		; keep X pos
	SRL	E
	SRL	E
	SRL	E
	LD	D,0
	ADD	HL,DE		; HL -> dest on screen	

	LD	(IX+PROT_SCREEN),L	; keep for erasing on the next pass
	LD	(IX+PROT_SCREEN+1),H

	PUSH	HL
	LD	A,B		; recover X pos
	AND	00000111B	; mask off to get graphic frame 0-7
	SLA	A		; x2
	SLA	A		; x4
	SLA	A		; x8
	SLA	A		; x16 bytes per frame
	LD	HL,PROTON_GFX
	LD	E,A		; D is still 0
	ADD	HL,DE		; HL -> graphic frame

	POP	DE
	EX	DE,HL		; DE = graphic, HL = screen
; blit an 8 x 2 sized proton
	LD	B,8

2$:	LD	A,(DE)
	OR	(HL)
	LD	(HL),A
	INC	HL
	INC	DE

	LD	A,(DE)
	OR	(HL)
	LD	(HL),A
	DEC	HL
	INC	DE

	CALL	DWNLN
	DJNZ	2$
	
9$:	LD	DE,SIZEOF_PROTON
	ADD	IX,DE

	DEC	C
	JP	NZ,5$	; loop for all protons
	
; draw Higgsy
;
PUT_HIGS:
	LD	A,(HB_Y)		; get Y position
	CALL	Y_TO_ROW		; convert to row
	LD	BC,15
	ADD	HL,BC		; move to screen centre

	LD	DE,HIG1		; DE -> graphic

	LD	B,16		; blit 16 x 2 boson

1$	LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE

	LD	A,(DE)
	LD	(HL),A
	DEC	HL
	INC	DE
	
	CALL	DWNLN

	DJNZ	1$

; move any active neutrino until it hits the side (i.e. counter = 0)
;
MOVE_NEUTRINOS:
	LD	BC,0208H		; B=2 neutrinos to move, C=8 (the right one first)
	LD	HL,NEUTRINOS

2$	LD	A,(HL)		; NEUT_ACTIVE
	AND	A
	JR	Z,1$		; (not active...)
	DEC	(HL)		; decrease movement counter
	JR	NZ,11$		; it's still moving...

	INC	HL		; else it's reach the screen edge
	INC	HL
	INC	HL
	LD	E,(HL)		; screen posn Lo
	INC	HL
	LD	D,(HL)		; screen posn Hi
	EX	DE,HL
	LD	(HL),0		; wipe old one here as the put routine won't once it's dead
	INC	HL		; next neutrino
	JR	3$

11$	INC	HL
	LD	A,(HL)		; NEUT_X
	ADD	A,C		; move C pixels
	LD	(HL),A
	DEC	HL

1$	LD	DE,5
	ADD	HL,DE

3$	LD	C,-8		; next, the left one...
	DJNZ	2$

; draw active neutrinos
;
PUT_NEUTRINOS:
	LD	C,B		; C=B=0
	LD	B,2		; 2 neutrinos to draw

	LD	IX,NEUTRINOS

2$	LD	A,(IX+NEUT_ACTIVE)
	AND	A
	JR	Z,1$			; don't draw if not active...

	LD	L,(IX+NEUT_SCREEN)	; wipe the old one
	LD	H,(IX+NEUT_SCREEN+1)
	LD	(HL),C

	LD	A,(IX+NEUT_Y)
	CALL	Y_TO_ROW			; Y coord to row start in HL
	LD	E,(IX+NEUT_X)
	SRL	E
	SRL	E
	SRL	E
	LD	D,C
	ADD	HL,DE			; HL -> dest on screen	
	LD	(HL),255			; draw neutrino
	LD	(IX+NEUT_SCREEN),L	; and remember where we did it
	LD	(IX+NEUT_SCREEN+1),H

1$	LD	DE,SIZEOF_NEUTRINO
	ADD	IX,DE
	DJNZ	2$

; when...
;
PROTONS_COLLIDE:
	LD	C,MAX_PROTONS-1	; check all protons against all on-coming protons
	
	LD	IX,PROTONS
	LD	DE,SIZEOF_PROTON	; E=6, D=0 (used below)

2$	LD	A,(IX+PROT_DIR)	; IX -> proton A
	AND	A		; is this proton dead?
	JR	Z,1$		; yes, move on...

; inner loop, check proton C against all others...
	LD	B,C
	PUSH	IX
	POP	IY
	ADD	IY,DE		; IY -> proton B

3$	LD	A,(IY+PROT_DIR)	; is proton B dead?
	AND	A
	JR	Z,4$		; yes...

	CP	A,(IX+PROT_DIR)	; proton B direction same as proton C?
	JR	Z,4$		; yes, ignore it...

; now check coords
	LD	A,(IX+PROT_X)	; overlap at left edge of protons?
	LD	H,A
	ADD	A,8
	LD	L,(IY+PROT_X)
	CP	L
	JR	C,4$		; nope...

	LD	A,L		
	ADD	A,8
	CP	H		; right edge?
	JR	C,4$		; nope...
	
; there is a collision in the vertical, check horizontal...
	LD	A,(IX+PROT_Y)
	LD	H,A
	ADD	A,8
	LD	L,(IY+PROT_Y)
	CP	L
	JR	C,4$		; no...

	LD	A,L		
	ADD	A,8
	CP	H
	JR	C,4$		; no...

; protons have collided!  kill and wipe them from the screen
	LD	(IX+PROT_DIR),D	; set 0 direction to kill off both protons
	LD	(IY+PROT_DIR),D
	PUSH	BC

	LD	L,(IX+PROT_SCREEN)
	LD	H,(IX+PROT_SCREEN+1)	; get last screen position and erase
	CALL	WIPE_PROTON
	LD	L,(IY+PROT_SCREEN)
	LD	H,(IY+PROT_SCREEN+1)
	CALL	WIPE_PROTON

; increase the collision bar
;	LD	B,A		; (B=0 already)
	LD	HL,22752		; an ATTR position, left of screen
	LD	A,(COLLISIONS)
	LD	C,A
	ADD	HL,BC
	LD	(HL),80		; make it bright red and increase for next time
	INC	A
	LD	(COLLISIONS),A
	CP	32		; too may collisions?
	JR	Z,GAME_OVER	; yep, you've lost!

	POP	BC
	JR	1$		; else, check for more collisions...

4$	ADD	IY,DE
	DJNZ	3$		; inner loop

1$	ADD	IX,DE
	DEC	C
	JR	NZ,2$		; outer loop

; see if Higgsy has shot a proton with a neutrino...
;
SHOOT_PROTONS:
	LD	HL,NEUTRINOS
	CALL	CHECK_HIT

	LD	HL,NEUTRINOS+SIZEOF_NEUTRINO
	CALL	CHECK_HIT

	JP	MAIN		; let's do that... again...


; "Game Over Man!".  Indicate game over with red colouring and a short pause
;
GAME_OVER
	LD	HL,22784
	LD	DE,22785
	LD	B,E			; BC now = 288 (C already = 32, B = E = 1)
	LD	(HL),66			; red
	LDIR

	LD	HL,TICK
	LD	(HL),B			; B=0 at this point
9$	LD	A,(HL)			; check the timer
	CP	200			; wait around 4s
	JR	C,9$
	POP	BC			; throw this away
	JP	WARMSTART		; new game...


; Check for protons being shot by neutrinos
;
; Pass HL -> neutrino
CHECK_HIT:
	LD	A,(HL)		; (NEUT_ACTIVE)
	AND	A
	RET	Z

	PUSH	HL		; get this into IY
	POP	IY

	LD	IX,PROTONS
	LD	DE,SIZEOF_PROTON	; E=6, D=0 (used if there's a hit, below)

	LD	BC,0C07H		; B=MAX_PROTONS, C=7

2$	LD	A,(IX+PROT_DIR)	; IX -> proton A
	AND	A		; is this proton dead?
	JR	Z,1$		; yes, move on...

	LD	A,(IY+NEUT_X)	; compare X coords
	LD	H,A
	ADD	A,C
	LD	L,(IX+PROT_X)
	CP	L
	JR	C,1$

	LD	A,L		
	ADD	A,C
	CP	H
	JR	C,1$
	
; there is a collision in the vertical, check horizontal...
	LD	A,(IY+NEUT_Y)
	LD	H,A
	LD	L,(IX+PROT_Y)
	CP	L		; is neutrino Y < proton Y?
	JR	C,1$		; no...

	LD	A,L		
	ADD	A,C
	CP	H		; is proton Y+7 < neutrino Y?
	JR	C,1$		; no...

; a hit!
	LD	(IY+NEUT_ACTIVE),D	; stop the neutrino
	LD	(IX+PROT_DIR),D		; and kill the proton
	LD	L,(IX+PROT_SCREEN)
	LD	H,(IX+PROT_SCREEN+1)
	JR	WIPE_PROTON		; erase it too

1$	ADD	IX,DE
	DJNZ	2$			; next proton...
	RET


; HL -> screen address
;
WIPE_PROTON:
	LD	BC,0800H	; B=8, C=0
1$:	LD	(HL),C
	INC	HL
	LD	(HL),C
	DEC	HL
	CALL	DWNLN
	DJNZ	1$
	RET

; Y coord to ROW
;
; Pass:    A as the Y coord
; Returns: HL as the start of the row
Y_TO_ROW:
	LD	DE,ROWTBL
	LD	H,E		; H=0
	LD	L,A
	ADD	HL,HL
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	RET

; the olde standarde, 'next pixel line down on the oddball Spectrum screen' routine
;
DWNLN:	INC	H
	LD	A,H
	AND	7
	RET	NZ
	LD	A,L
	ADD	A,32
	LD	L,A
	RET	C
	LD	A,H
	SUB	8
	LD	H,A
	RET

; Try and fire a neutrino
;
; pass HL -> neutrino, B = X posn
FIRE:	LD	A,(HL)
	AND	A
	RET	NZ		; don't allow if already firing

	LD	(HL),17		; else set 17 steps to move
	INC	HL
	LD	(HL),B		; set the X position of the neutrino
	INC	HL
	LD	A,(HB_Y)
	ADD	A,8		; make neutrino Y posn = Higgsy's Y+8
	LD	(HL),A
	RET


; Draw digit in A (0-9) to the screen at DE
;
DIGIT_R:			; entry point for right digit
	SLA	A
	SLA	A
	SLA	A
DIGIT_L:			; or for the left digit
	PUSH	DE
	PUSH	HL
	LD	HL,3D80H		; 0-9 digit bitmaps in ROM
	LD	C,A
	LD	B,0
	ADD	HL,BC		; index to correct digit
	LD	B,8		; it's 8 pixels high

1$	LD	A,(HL)
	LD	(DE),A		; copy to screen
	INC	HL
	INC	D
	DJNZ	1$

	POP	HL
	POP	DE
	DEC	DE
	RET

;
; The interrupt:
;
RUPTS:	DI

	EXX
	INC	(HL)	; cheap clock
	EXX

	EI
	RETI


; the master proton bitmap
;
THE_PROTON:
	DB	24,102,66,129,129,66,102,24

;
; Higgsy
;
HIG1:	DW	0000000000000000B
	DW	1111100000011111B
	DW	1111111001111111B
	DW	1111111001111111B
	DW	1100011111100011B
	DW	1001001111001001B
	DW	1010101111010101B
	DW	1011101111011101B
	DW	1011101111011101B
	DW	1001001111001001B
	DW	1100011111100011B
	DW	1111111111111111B
	DW	1111111001111111B
	DW	1111111001111110B
	DW	1111100000011111B
	DW	0000000000000000B



;------
; dump protons to screen to test the shifty thing works (which it did!)
;TESTY:	LD	IX,PROTON_GFX
;	LD	IY,16384
;	LD	C,8	
;2$:	LD	B,8
;	PUSH	IY
;1$:	LD	A,(IX+0)
;	LD	E,(IX+1)
;	LD	(IY+0),A
;	LD	(IY+1),E
;	INC	IX
;	INC	IX
;	LD	DE,256
;	ADD	IY,DE
;	DJNZ	1$
;	POP	IY
;	INC	IY
;	INC	IY
;	DEC	C
;	JR	NZ,2$


	END