GameControl
	LD DE,(CrosshairY)	

	LD BC,#EFFE						;input - Sinclair joystick
	IN A,(C)
	LD C,A
	
	BIT 0,A							;testing fire
	JR Z,Shoot

;go right
	BIT 3,A					
	JR NZ,GameControl2		
	LD A,D
	CP 30
	RET Z							;right edge reached
	
	INC D							;change position right
	JR GameControl3					;go to testing up down to enable moving diagonals

;go left	
GameControl2

	BIT 4,A					
	JR NZ,GameControl3		
	LD A,D
	CP 1
	RET Z							;left edge reached
	
	DEC D							;change position left
	
	
;go up	
GameControl3
	LD A,C
	BIT 1,A					
	JR NZ,GameControl4		
	LD A,E
	CP 1
	RET Z							;top edge reached
	
	DEC E							;change position up
	JR GameControl5
	
;go down
GameControl4
	BIT 2,A					
	JR NZ,GameControl5		
	LD A,E
	CP 18
	RET Z							;down edge reached
	
	INC E							;change position up
		
	
GameControl5
	LD (CrosshairY),DE
	RET
	
;---------------------------	
Shoot
	CALL Sound
	LD A,(BackgroundCopy+10)		;attribute behind crosshair
	CP 7							;gangster attribute
	JR NZ,Shoot10					;gangster not hit
	
;gangster is hit
;redraw window in his place	
	CALL FindCrosshairPos
	LD A,L							;(left upper corners window Ls are even and belong to lines
	BIT 0,A							;whe first character has L=0 or L=128)
	JR NZ, Shoot2
	DEC L							;if L ends with 1, decrease to make even
Shoot2	
	AND 01100000b
	OR A
	JR Z,Shoot3						;if bottom window row, go one row up
	LD A,L
	SUB 32
	LD L,A
	
Shoot3								;left upper corner found
	PUSH HL
	LD DE,Window					;gangster dissapears
	CALL DrawSprite
	POP DE							;position into DE

;find window nr
	LD HL,WindowPosList
	LD B,1
Shoot4
	LD A,E							;compare 2 bytes of position address
	CP (HL)
	JR NZ,Shoot5
	INC HL
	
	LD A,D
	CP (HL)
	JR NZ,Shoot6

	JR Shoot7						;nr of window found

Shoot5
	INC HL
Shoot6
	INC HL
	INC B							;next window nr
	JR Shoot4
	
;change window status
Shoot7								;B - nr of window where ganster was shot
	LD HL,Window1Nr					
	LD DE,Window1Time				;find this window in window table	
Shoot8
	LD A,(HL)						;compare window number
	CP B
	JR Z,Shoot9	
	INC HL							;next window in table
	INC HL
	INC DE							;next time
	JR Shoot8
	
Shoot9
	XOR A							;window found, erase it from table
	LD (HL),A						;set window nr to 0	
	
	LD A,WaitingTime
	LD (DE),A						;set waiting time for new person to appear
	
	LD HL,Score						;increase score 
	INC (HL)
	CALL TypeScore2
	
	LD A,(Score)
	CP 100							;100 gangsters - end of game
	LD A,79
	JP Z,GameOver1
	RET
	
;---------------	
;ganster not hit
Shoot10	
	CP 71							;shoot innocent (check attribute)?
	JP Z,GameOver					;yes - game over
	RET								;shooting empty space, do nothing
	
	
	
;-------------------------------------
MenInWindows
	LD HL,Window1Time				
	LD DE,Window1Nr					
	LD B,3							;nr of windows
	
MenInWindows2
	PUSH BC
	PUSH HL
	PUSH DE
	DEC (HL)						;decrease time for the window
	
	LD A,(HL)
	PUSH AF
	CP AppearTime					;time when someone in the window appears
	CALL Z,MenInWindows3
	POP AF
	
	OR A							;time=0 for the window
	CALL Z,EndOfTime				;game over for gangster, nothing for innocent

	POP DE
	POP HL
	POP BC
	INC HL							;next window time
	INC DE							;next window nr
	INC DE
	DJNZ MenInWindows2				;do 3 windows
	RET					

;-------
MenInWindows3					
;get random nr
	LD A,R
	XOR L
	AND 00011111b					;0-31
	CP 20							;random nr 0-19	
	JR NC,MenInWindows3
	INC A							;A - window nr 1-20
	
;check if window with this nr is free
	LD HL,Window1Nr
	LD C,A
	LD B,3	
MenInWindows31
	LD A,(HL)				
	CP C							;compare to windows in table
	JR Z,MenInWindows3				;window already occupied, repeat searching for random nr			
	INC HL
	INC HL							;next window nr
	DJNZ MenInWindows31				;check 3 windows
	
	LD A,C
	LD (DE),A						;write window nr to windows table	
	
;find window position
	LD HL,WindowPosList-2			
MenInWindows4
	INC HL							;next window position 
	INC HL
	DEC A
	JR NZ,MenInWindows4
	
	
	LD A,(HL)						;window position into HL
	INC HL
	LD H,(HL)
	LD L,A
	
	INC DE							;DE - man in window status
	LD A,R							;random - gangster or innocent?
	CP 40
	JR NC,MenInWindows5
	
	XOR A							;draw innocent
	LD (DE),A						;0 - innocent status
	LD DE,Innocent
	JR MenInWindows6			
	
	
MenInWindows5						;draw gangster
	LD A,255
	LD (DE),A						;255 - gangster status
	LD DE,Gangster
MenInWindows6
	CALL DrawSprite
	RET

	
;-------------------------
EndOfTime
	INC DE							;man in window status
	
	LD A,(DE)
	OR A
	JR NZ,GameOver					;gangster=game over
	
;end of time for innocent - innocent dissapears	
	LD A,WaitingTime
	LD (HL),A						;set time to waiting for new person to appear
	
	DEC DE
	LD A,(DE)
	LD B,A							;read window nr
	XOR A
	LD (DE),A						;set window nr to 0

;find window position
	LD HL,WindowPosList-2
EndOfTime2
	INC HL	
	INC HL	
	DJNZ EndOfTime2
	
	LD A,(HL)						;read window position
	INC HL
	LD H,(HL)
	LD L,A
	
	LD DE,Window					;innocent dissapears, draw window
	CALL DrawSprite
	RET	


;------------	
GameOver
	LD A,66
GameOver1	
	LD HL,22528						;paint screen with attribute
	LD (HL),A
	LD DE,22529
	LD BC,767
	LDIR
	

	LD B,50
GameOver2	
	PUSH BC
	CALL Sound						;sound in a loop
	POP BC
	DJNZ GameOver2
	
	LD BC,13*256+21					;"GAME OVER" text
	CALL 3545						;PRINT AT X,Y (BC - coordinates)

	LD BC,0*256+9					;text length
	LD DE,Text2
	CALL 8252
	
GameOver3	
	LD BC,#EFFE						;input - Sinclair joystick
	IN A,(C)		
	BIT 0,A
	JR NZ,GameOver3					;waiting for fire to restart
	JP Start

	
	
;--------------------------	
Sound
	LD B,100
Sound2
	LD A,16
	OUT (254),A

	LD C,B
Sound3	
	DEC C
	JR NZ,Sound3	
	
	XOR A
	OUT (254),A
	DJNZ Sound2
	RET
