; Little Sara Sister 1.5 (2 restricted version)
; by Stefano Tognon
; (C) 2006 Ice Team
; version 1.00

; Well, this game is dedicated to "little ketty"
; This is my 12 game for C64 

; game is organizer as in EFNY source dissect:
; all done in a loop with only interrupt for syncronization
; map are done of block of 4x4 chars
; a screen is done by 5xN block and scroll goes from right to left
; color are the same for each block; we manage to change the color map every 4 columns
; many peace of code are rewrited expecially for fit the engine in low space

; Screen layout
;  0*8      
;  1*8   " SCORE, LIVES, POINTS, ..."
;  2*8
;  3*8   IRQ0: play music, set IRQ1, set graphics for scroll
;  4*8
;  ..    5 blocks  
;  23*8  IRQ1: set IRQ0, set graphics for title screen, let performs scrolling
;  24*8  "LITTLE SARA SISTER 1.5       by ICE TEAM 2006" 


; Memory map
;
; 2000 2700  sprites copy 1 (already in place)
; 28f0       main program
; 3700 3800  routine for chars
; 3800 3a00  free space for copy kernal chars  
; 3a00 4000  custom chars defnition
; 4000       music
; 5000       color blocks and map definition 
; A000 Axxxx sprites copy 2 (to copy)


       processor 6502
       
  include include.s                      ; include constant definitions

  include sprite.s
  ;include blocks.s
 
 org $28f0
      jsr  erase2Screen          ; clearing the screen with color     
      jsr  erase3Screen          ; clean screen in bank 3 


      ;jsr level0                 ; set $d020/21 to $0e
      lda  #$00
      sta  $D020
      sta  $D021

      jsr  copyChar              ; copy chars to the banks 
                                 ; switch to new chars
      lda  #31
      sta  $D018
                                 ; MCM char mode

      ldx  #7
      stx  $D025                 ; set sprites common colors
      inx ; 8
      stx  $D022                 ; set common char multicolor
      inx ; 9
      stx  $D023

      ldx  #2
      stx  $D026


      ldx  #$FF                  ; set sprites multicolor
      stx  $D01C

      lda  #SA_SARA              ; initial sprite address for sara
      sta  actFrame                    
      
      lda  #10                   ; set color for Sara
      sta  actColor
      
      lda  #0                    ; no expansion  
      sta  actExpX
      sta  actExpY
      sta  actPrior              ; no prority      
      lda  #1                    ; multicolor  
      sta  actMultic     
           
      lda  #$06
      sta  xScroll      
            
      lda  $01
      and  #$FE                  ; disable BASIC rom
      sta  $01
               
      jsr  spriteCopy            ; copy sprite into bank 2      
      jsr  installIRQ            ; install irq routines

mainLoop:
      lda  #0                    ; fill black the screen
      sta  53280
      sta  53281
      sta  effect                ; enable color effect
      jsr  vicBank3              ; goto bank 3       
      jsr  writeCredits      
      
      lda  #MS_INTRO             ; init music for intro
      jsr  initMusic

      jsr  waitFire              ; write press fire button for going

;*****************
; secret features
;*****************
      ldx  #150
      jsr  getJoystick
      and  #$0F
      bne  jumpOver
      ldx  #200
jumpOver:
      stx  SCR+1

      inc effect                 ; disable effect

      ;jsr  disableGraphics 
      jsr  vicBank0              ; goto bank 0  
      jsr  erase2Screen          ; clearing the screen with color       
      jsr  writeGameTitle
      jsr  writeScoreTitle          

      lda  #STARTLIFES
      sta  lifes                 ; set intial lifes

      lda  #0                    ; start from level 1
      sta  level
      sta  score                 ; clear score
      sta  score+1
      sta  score+2
      sta  bonus
      ;sta  xMap
      sta  restart

      ;lda  #8                    ; start from level 1
      ;sta  level
extLoop:
      lda  #MS_GETREADY
      jsr  initMusic

      jsr  removeActor           ; remove all actor
      jsr  drawSprites           ; be sure they are not now visible
      lda  $D01E                 ; clear sprite collision check
      jsr  selectMap             ; select the map to show according to level
      
      jsr  writeGetReady
      
      ldx  #130
      jsr  wasteTime
     
      lda  musicToPlay             
      jsr  initMusic             ; play music for this level     
      
      lda  restart               
      sta  xMap
      clc  
      adc  #10
      sta  cmpVal+1              ; we have to scroll 10 position from the restart point 

initialScroll:
      jsr  waitIRQ
      lda  #4
      jsr  madeScroll            ; show the fad-in scrolling
      lda  xMap
cmpVal:      
      cmp  #10                   ; that is of 10 blocks
      bcc  initialScroll

      lda  #1
      cmp  status                ; is killed?
      bne  skipB

      lda  #0
      sta  bonus                 ; reset bonus if killed
skipB:

      lda  #0
      sta  jump
      sta  timeDl
      sta  status
      sta  yActSpeed
      sta  xActHi
      lda  #$99                  ; 99 seconds
      sta  time

      lda  #50                   ; put actor to his x/y position
      sta  xActLo
      ;lda  #00
      ;sta  xActHi
      lda  #168
      sta  yAct
      lda  #ACT_SARA             ; and make it visible
      sta  actType

intLoop
      jsr  getJoystick           ; get user joystick movements
      jsr  moveActor0            ; move Sara
      jsr  moveMonster           ; move all the monsters

      jsr  waitIRQ               ; attend syncronization for madding the scroll

      jsr  checkScroll
      jsr  madeScroll

      jsr  insertEnemy           ; insert one enemy if map says that
      jsr  drawSprites           ; draw all the actors
      jsr  removeEnemy

      jsr  ckeckDiamond          ; check if one diamond is taken by Sara
      jsr  checkEnemy            ; check Sara/monsters collision

      jsr  decTime               ; decrement the time
      jsr  testScore             ; test if this score is the highscore
      jsr  writeScore            ; write the score

      lda  status                ; test if screen is passed
      cmp  #2
      beq  screenPassed

      ;lda  yAct                  ; test if we go under 3 chars from the bottom of the screen
      ;cmp  #172
      ;bcc  notToKill

      ;jsr  moveActor0            ; move Sara again (so spourious aligment will be avoided)

      ;lda  yAct                  ; test if we go under 3 chars from the bottom of the screen
      ;cmp  #172
      ;bcc  notToKill

      ;lda  #1                    ; kill Sara (now I can't do otherwise...)
      ;sta  status

;notToKill
      ;lda  status
      cmp  #1                    ; is Sara killed?
      bne  intLoop

      lda  #MS_DIED
      jsr  initMusic
      
      jsr  diedAnimation         ; performe a died animation      

      dec  lifes                 ; we lose one life
      beq  gameOver              ; game over if we reach 0

      jsr  clearScreen
      jmp  extLoop

screenPassed:
      lda  #0
      sta  restart
      jsr  clearScreen

      lda  time
      jsr  giveBonus             ; give bonus according with this time

      inc  level                 ; go to next level
      lda  level                 ; check if we have win
      cmp  #MAXLEVEL
      beq  win

      jmp  extLoop

win:    
      lda  #MS_WIN
      jsr  initMusic             ; play win music
      lda  lifes      
      sta  score                 ; give 10000 point for every lives
      jsr  clearScreen
      jsr  testScore      
      jsr  writeWin              ; write win string
      lda  #0                    ; fill black the screen
      sta  effect
      
      jsr  writeFire
      jsr  waitFire

      jmp mainLoop

gameOver:
      lda  #MS_GAMEOVER
      jsr  initMusic             ; play game over music
      jsr  clearScreen
      jsr  writeGameOver         ; write game over screen
      
      ldx  #170                  ; delay for listen to the music
      jsr  wasteTime
      
      ;lda  #MS_HIGHSCORE
      ;jsr  initMusic
      
                                 ; make highscore  
      ;jsr  clearScreen
      ;jsr  generateTxtScore
      ;jsr  writeTableScore       ; write the score table 
      
      ;jsr  testBestScore         ; test for new best score 
      ;bcc  noBestScore
      
      ;jsr  calculatePosition     ; calculate position of score
      ;jsr  shiftBestScore        ; shift the best score and put the new score
      ;jsr  readName              ; read name of player in the right position
      ;jsr  generateTxtScore
      ;jsr  writeTableScore       ; write the score table       
      
;noBestScore:      
     ;jsr  waitFire ;;; temp
      
      jmp mainLoop
                 
  include actor.s                   ; manage actor routines    
  include char.s                    ; manage chars

  

 org $4000
  incbin 2.bin
 
  include map.s
  include irq.s
  include vary.s 
  include io.s                      ; manage i/o routines    
  include scroll.s                  ; manage scroll routines
  include blocks.s
  .byte "GOOD 'SID' HALLOWEEN!!!"