; install custom chars

  org $3700
;================================
; copy chars to bank 1 e 3
;================================
copyChar:
                                  ; transfer characters codes to 14336
      sei

      lda  #$33
      sta  $01
      
      ldx  #00 
      lda  #$38
      sta  CTO+1
      lda  #$D0
      sta  CFROM+1
      lda  #0
      sta  CTO
      sta  CFROM
copy1:                            ; copy the chars
      lda  (CFROM,x)
      sta  (CTO,x)
      inc  CFROM
      inc  CTO
      bne  copy1
      inc  CFROM+1
      inc  CTO+1
      lda  CTO+1
      cmp  #$3A
      bne  copy1
      
      lda  #$37                   ; restore pcr
      sta  $01
      cli       
      
                                  ; copy into bank 2
      lda  #$00
      sta  CFROM
      lda  #$38
      sta  CFROM+1
      lda  #$00                   ; from char 64
      sta  CTO
      lda  #$B8
      sta  CTO+1
copy2:                            ; put the new chars in bank 2
      lda  (CFROM,x)
      sta  (CTO,x)
      inc  CFROM
      inc  CTO
      bne  copy2
      inc  CFROM+1
      inc  CTO+1
      lda  CTO+1
      cmp  #$C0
      bne  copy2      
      
                                  ; copy into bank 3
      lda  #$00
      sta  CFROM
      lda  #$38
      sta  CFROM+1
      lda  #$00                   ; from char 64
      sta  CTO
      lda  #$f8
      sta  CTO+1
copy3:                            ; put the new chars in bank 2
      lda  (CFROM,x)
      sta  (CTO,x)
      inc  CFROM
      inc  CTO
      bne  copy3
      inc  CFROM+1
      inc  CTO+1
      lda  CTO+1
      cmp  #$ff
      bne  copy3            
              
      rts    
      
DELAYDA = 6         ; delay animation for diamond
DELAYFA = 8         ; delay animation for fork

delayDA: .byte DELAYDA           ; delay counter for diamond
delayFA: .byte DELAYFA           ; delay counter for fork
      
;================================
; performe a diamon animation 
; using CH_DIAM1 e CH_DIAM2 char
;================================
diamondAnim:
      dec  delayDA
      bne  exitDA
      
      lda  #DELAYDA
      sta  delayDA

      ldx  #7
loopC:
      lda  B1CHAR+CH_DIAM1*8,x
      ldy  B1CHAR+CH_DIAM2*8,x 
      sta  B1CHAR+CH_DIAM2*8,x
      tya
      sta  B1CHAR+CH_DIAM1*8,x
      
      lda  B2CHAR+CH_DIAM1*8,x
      ldy  B2CHAR+CH_DIAM2*8,x 
      sta  B2CHAR+CH_DIAM2*8,x
      tya
      sta  B2CHAR+CH_DIAM1*8,x      
      
      dex
      bpl  loopC      
exitDA:     
      rts 


;================================
; performe a fork animation 
; using CH_FORK1..CH_FORK4 chars
;================================
forkAnim:
      dec  delayFA
      bne  exitFA
      
      lda  #DELAYFA
      sta  delayFA

      ldx  #7
loopC1:
      ldy  B1CHAR+CH_FORK4*8,x 
      lda  B1CHAR+CH_FORK3*8,x
      sta  B1CHAR+CH_FORK4*8,x
      lda  B1CHAR+CH_FORK2*8,x
      sta  B1CHAR+CH_FORK3*8,x
      lda  B1CHAR+CH_FORK1*8,x
      sta  B1CHAR+CH_FORK2*8,x
      tya
      sta  B1CHAR+CH_FORK1*8,x

      ldy  B2CHAR+CH_FORK4*8,x 
      lda  B2CHAR+CH_FORK3*8,x
      sta  B2CHAR+CH_FORK4*8,x
      lda  B2CHAR+CH_FORK2*8,x
      sta  B2CHAR+CH_FORK3*8,x
      lda  B2CHAR+CH_FORK1*8,x
      sta  B2CHAR+CH_FORK2*8,x
      tya
      sta  B2CHAR+CH_FORK1*8,x

      dex
      bpl  loopC1
exitFA:     
      rts

    org $3800  ; here will go rom chars
    
    org $3a00  ; redefined chars are already in place!
char:
  .incbin chars.bin

CH_SPACE  = 64       ; null char: use the C= one to save some bytes

;***********************************
; in the map, monster must be in
; sequence as we use optimizations
CH_FIRST  = 89

CH_MONST  = 89       ; monster: wolf
CH_MONST2 = 90       ; monster: ape
CH_MONST3 = 91       ; monster: ragno 
CH_BOSS   = 92       ; boss: car 
CH_MONST4 = 93       ; monster: lum
CH_MONST5 = 94       ; monster: spa
CH_MONST6 = 95       ; monster: mouse

CH_LAST   = 96
;***********************************

CH_DIAM1  = 74       ; diamond
CH_DIAM2  = 75
CHS_DIAM1 = 105
CH_FLOW   = 79       ; flowers (can firing)

; char for fork animation
CH_FORK1  = 250
CH_FORK2  = 251
CH_FORK3  = 252
CH_FORK4  = 253

; char for bridge
CH_BRIDGE1 = 219
CH_BRIDGE2 = 220
CH_BRIDGE3 = 221
CH_BRIDGE4 = 64


CHARLIMIT = 96       ; below this we can walk; over we collide
CHARKILL  = 249      ; above this we are killed
CH_RESTART = 88      ; sara restart point

