;============================================
;Defuze. (C)2005 Richard Bayliss
;Written for fun
;============================================

;Variables
screenloc = $0400 ;That is the default screen pos
sync 	   = $0340
objpos	   = $0370
collision = $03f0

liftdir1 = $02
liftdir2 = $03
liftdir3 = $04
liftdir4 = $05
p1dir = $06
onlift = $07
onplatform = $08
animct = $09
animdelay = $0a
timedelay = $0b
randxpos = $1c
randypos = $2d
randct = $0e
elephantdelay = $0f
bombtime	 = $0426
level = $1f
collected = $21
count1 = $66
count2 = $67
			
			processor 6502
			org $3000
restart:		sei
			lda #$0b
			sta $d011
			lda #$00	;Black
			sta p1dir ;Left
			sta timedelay
			sta $d020	;Frame colour
			sta $d021	;Background colour
			sta onplatform 
			sta onlift
			sta animct
			sta animdelay
			sta randct
			
			lda #$0c
			sta objpos+$00
			lda #$3e
			sta objpos+$01
			lda playerdefault
			sta $07f8
			lda #$0d
			sta $d027
			
			lda #$10
			sta objpos+$02
			lda #$e4
			sta objpos+$03
			lda bomb
			sta $07f9
			lda #$07
			sta $d028
			
			lda #$20
			sta objpos+$04
			lda #$40
			sta objpos+$05
			lda lift
			sta $07fa
			lda #$0a
			sta $d029
			
			lda #$44
			sta objpos+$06
			lda #$de
			sta objpos+$07
			lda lift
			sta $07fb
			lda #$0e
			sta $d02a
			
			lda #$68
			sta objpos+$08
			lda #$40
			sta objpos+$09
			lda lift
			sta $07fc
			lda #$03
			sta $d02b
			
			lda #$8c
			sta objpos+$0a
			lda #$de
			sta objpos+$0b
			lda lift
			sta $07fd
			lda #$05
			sta $d02c
			lda elephantleft
			sta $07fe
			lda elephantright
			sta $07ff
			lda #$0a
			sta $d02d
			sta $d02e
			lda #$00
			sta objpos+$0c
			sta objpos+$0e
			lda #$6c
			sta objpos+$0d
			lda #$e4
			sta objpos+$0f
			
			
			lda #$00
			ldx #$30
			sta $0318
			stx $0319
			lda #<int1
			sta $0314
			lda #>int1
			sta $0315
			;lda #<nmi
			;sta $fffa
			;lda #>nmi
			;sta $fffb
			lda #$7f
			sta $dc0d
			lda #$1b
			sta $d011
			lda #$01
			sta $d01a
			
			
			
			lda #$16
			sta $d018
			
			
			
			
;Clear the whole screen, using software mode
;(as hardware clearing is lame).	
			
loopme:		ldx #$00	
clear:		lda #$20    
			sta screenloc+$00,x
			sta screenloc+$100,x
			sta screenloc+$200,x
			sta screenloc+$300,x
			sta screenloc+$3e8,x
			inx			
			bne clear

			
	
			
;Create screen for the game	
			ldx #$00	
copyscrn:	lda gamescreen,x
			sta screenloc,x
			lda gamescreen+$100,x
			sta screenloc+$100,x
			lda gamescreen+$200,x
			sta screenloc+$200,x
			lda gamescreen+$02e8,x
			sta screenloc+$02e8,x
			lda #$0f
			sta $d800,x
			sta $d900,x
			sta $da00,x
			sta $dae8,x
			inx
			bne copyscrn
			lda #$01
			sta level
			lda #$00
			sta collected
			lda #$30
			sta count2
			sta $0427
			lda #$33
			sta $0426
			sta count1
			
			lda #$02
			sta $d022
			lda #$0a
			sta $d023
			
			lda #$ff
			sta $d015
			sta $d01c
			lda #$01
			sta $d025
			lda #$0b
			sta $d026
			
			ldx #$00
puthisc:		lda hiscore,x
			sta $0419,x
			inx
			cpx #$06
			bne puthisc
			lda #$00
			jsr $1000
			
;Initialize all the logical arrays/variables
;apart from those arrays/variables that do
;not need to be initialized

			lda #$00
			sta liftdir1
			sta liftdir3
			sta elephantdelay
			lda #$01
			sta liftdir2
			sta liftdir4
			
			cli
gameloop:	lda #$00
			sta sync
			lda sync
syncwait:		cmp sync
			beq syncwait
			
			jsr expand
			
			jsr movelifts
			jsr joyread
			jsr liftcollision
			jsr gravity
			jsr bgrcollision
			jsr animate
			jsr clock
			jsr randomizer
			jsr move_elephant
			jmp gameloop
			
expand:		ldx #$00
expandloop:	lda objpos+$01,x
			sta $d001,x
			lda objpos+$00,x
			asl
			ror $d010
			sta $d000,x
			inx
			inx
			cpx #$10
			bne expandloop
			rts
			
;Move those lifts according to the direction the lift counter is reading

movelifts:	jsr checklift1
			jsr checklift2
			jsr checklift3
			jsr checklift4
			rts
			
;Check the value of lift 1. Positive = move down, Negative = move up

checklift1: 	lda liftdir1
				cmp #$00
				beq liftup1
				cmp #$01
				beq liftdown1
				rts

liftup1:		lda objpos+$05
				sec
				sbc #$01
				sta objpos+$05
				lda objpos+$05
				cmp #$40
				bcs nochange1a
				lda #$01
				sta liftdir1
nochange1a:		rts

liftdown1:		lda objpos+$05
				clc
				adc #$01
				sta objpos+$05
				lda objpos+$05
				cmp #$de
				bcc nochange1b
				lda #$00
				sta liftdir1
nochange1b:		rts
			
checklift2:		lda liftdir2
				cmp #$00
				beq liftup2
				cmp #$01
				beq liftdown2
				rts	
				
liftup2:		lda objpos+$07
				sec
				sbc #$01
				sta objpos+$07
				lda objpos+$07
				cmp #$40
				bcs nochange2a
				lda #$01
				sta liftdir2
nochange2a:		rts

liftdown2:		lda objpos+$07
				clc
				adc #$01
				sta objpos+$07
				lda objpos+$07
				cmp #$de
				bcc nochange2b
				lda #$00
				sta liftdir2
nochange2b:		rts

checklift3:		lda liftdir3
				cmp #$00
				beq liftup3
				cmp #$01
				beq liftdown3
				rts
				
liftup3:		lda objpos+$09
				sec
				sbc #$01
				sta objpos+$09
				lda objpos+$09
				cmp #$40
				bcs nochange3a
				lda #$01
				sta liftdir3
nochange3a:		rts

liftdown3:		lda objpos+$09
				clc
				adc #$01
				sta objpos+$09
				lda objpos+$09
				cmp #$de
				bcc nochange3b
				lda #$00
				sta liftdir3
nochange3b:		rts

checklift4:		lda liftdir4
				cmp #$00
				beq liftup4
				cmp #$01
				beq liftdown4
				rts
				
liftup4:		lda objpos+$0b
				sec
				sbc #$01
				sta objpos+$0b
				lda objpos+$0b
				cmp #$40
				bcs nochange4a
				lda #$01
				sta liftdir4
nochange4a:		rts

liftdown4:		lda objpos+$0b
				clc
				adc #$01
				sta objpos+$0b
				lda objpos+$0b
				cmp #$de
				bcc nochange4b
				lda #$00
				sta liftdir4
nochange4b:		rts

;Lift and bomb collision

liftcollision: 
				lda objpos+$00
				sec
				sbc #$06
				sta collision+$00
				clc
				adc #$0c
				sta collision+$01
				lda objpos+$01
				sec
				sbc #$0c
				sta collision+$02
				clc
				adc #$18
				sta collision+$03
				
				jsr checkliftcol1
				jsr checkliftcol2
				jsr checkliftcol3
				jsr checkliftcol4
				jsr checkbombcol
				jsr checkelephant
				
				rts
				
checkliftcol1: 	lda objpos+$04
				cmp collision+$00
				bcc nol1col
				cmp collision+$01
				bcs nol1col
				lda objpos+$05
				cmp collision+$02
				bcc nol1col
				cmp collision+$03
				bcs nol1col
				lda objpos+$04
				sta objpos+$00
				lda objpos+$05
				sta objpos+$01
				lda #$01
				sta onlift
nol1col:		rts

checkliftcol2:
				lda objpos+$06
				cmp collision+$00
				bcc nol2col
				cmp collision+$01
				bcs nol2col
				lda objpos+$07
				cmp collision+$02
				bcc nol2col
				cmp collision+$03
				bcs nol2col
				lda objpos+$06
				sta objpos+$00
				lda objpos+$07
				sta objpos+$01
				lda #$01
				sta onlift
nol2col:		rts

checkliftcol3:
				lda objpos+$08
				cmp collision+$00
				bcc nol3col
				cmp collision+$01
				bcs nol3col
				lda objpos+$09
				cmp collision+$02
				bcc nol3col		
				cmp collision+$03
				bcs nol3col
				lda objpos+$08
				sta objpos+$00
				lda objpos+$09
				sta objpos+$01
				lda #$01
				sta onlift
nol3col:		rts		

checkliftcol4:
				lda objpos+$0a
				cmp collision+$00
				bcc nol4col
				cmp collision+$01
				bcs nol4col
				lda objpos+$0b
				cmp collision+$02
				bcc nol4col
				cmp collision+$03
				bcs nol4col
				lda objpos+$0a
				sta objpos+$00
				lda objpos+$0b
				sta objpos+$01
				lda #$01
				sta onlift
nol4col:			rts
checkbombcol:		lda objpos+$02
				cmp collision+$00
				bcc nobcol
				cmp collision+$01
				lda objpos+$03
				bcs nobcol
				cmp collision+$02
				bcc nobcol
				cmp collision+$03
				bcs nobcol
				lda count2
				sta bombtime+1
				lda count1
				sta bombtime+0
				lda randxpos
				sta objpos+$02
				lda randypos
				sta objpos+$03
				jsr addscore
			
nobcol:			rts
checkelephant:		lda objpos+$0c
				cmp collision+$00
				bcc noecol
				cmp collision+$01
				bcs noecol
				lda objpos+$0d
				cmp collision+$02
				bcc noecol
				cmp collision+$03
				bcs noecol
				lda #<endmsg2
				sta pasted+1
				lda #>endmsg2
				sta pasted+2
				
				jmp gameover
noecol:			lda objpos+$0e
				cmp collision+$00
				bcc noecol2
				cmp collision+$01
				bcs noecol2
				lda objpos+$0f
				cmp collision+$02
				bcc noecol2
				cmp collision+$03
				bcs noecol2
				lda #<endmsg2
				sta pasted+1
				lda #>endmsg2
				sta pasted+2
				
				jmp gameover
noecol2:			rts

				

			

;Perform the colour wash routine (My favourite fun part)

colroll:		lda colours+$00
				sta colours+$28
				ldx #$00
doroll:		lda colours+$01,x
				sta colours+$00,x
				lda colours+$00,x
				sta $d800,x
				inx
				cpx #$28
				bne doroll
				rts
				
;Read joystick plugged in port 2

joyread:		lda $dc00
up:			lsr
down:			lsr
left:			lsr
				bcs right
				ldx objpos+$00
				dex
				cpx #$0c
				bcs setleft
				ldx #$0c
setleft:		stx objpos+$00
				lda #$00
				sta p1dir
				rts
right:		lsr
				bcs fire
				ldx objpos+$00
				inx
				cpx #$a4
				bcc setright
				ldx #$a4
setright:		stx objpos+$00
				lda #$01
				sta p1dir
fire:			lsr		
				bcs nojoy
				lda onlift
				cmp #$01
				beq shift
nojoy:		rts
shift:		lda p1dir
				cmp #$01
				beq shiftright
				cmp #$00
				beq shiftleft
				rts
shiftright:	lda objpos+$00
				clc
				adc #$0c
				sta objpos+$00
				lda #$00
				sta onlift
				rts
				
shiftleft:		lda objpos+$00
				sec
				sbc #$0c
				sta objpos+$00
				lda #$00
				sta onlift
				rts

bgrcollision:          lda $d01f
				lsr
				bcc nothit
				lda #$01
				sta onplatform
				dec objpos+$01
				rts
nothit:			lda #$00
				sta onplatform
				rts
				

;Main IRQ

int1:	
			inc $d019
			lda #$00
			sta $d012
			;lda #$00
			;sta $d020
			;sta $d021
			lda #$12
			sta $d018
			lda #$18
			sta $d016
			lda #<int2
			sta $0314
			lda #>int2
			sta $0315
			jmp $ea81
int2:		
			inc $d019
			lda #$3c
			sta $d012
			;lda #$06
			;sta $d020
			;sta $d021
			lda #$16
			sta $d018
			lda #$08
			sta $d016
			lda #<int1
			sta $0314
			lda #>int1
			sta $0315
			lda #$01
			sta sync
			jsr colroll
			jsr $1003
			jmp $ea31
gravity:	lda onplatform
			cmp #$01
			beq nograv
			lda onlift
			cmp #$01
			beq nograv

			lda objpos+$01
			clc
			adc #$03
			sta objpos+$01
 			rts
nograv:	rts

;Animate the player

animate:	lda animdelay
			cmp #$08
			beq noanimdelay
			inc animdelay
			rts
noanimdelay:
			lda #$00
			sta animdelay
			ldx animct
			lda playerframe,x
			sta $07f8
			lda bomb,x
			sta $07f9
			lda elephantleft,x
			sta $07fe
			lda elephantright,x
			sta $07ff
			lda lift
			sta $07fa
			sta $07fb
			sta $07fc
			sta $07fd
			inx
			cpx #4
			beq resetanimct
			inc animct
			rts
resetanimct:
			lda #$00
			sta animct
			rts
			
;The time for each bomb to defuse

clock:		inc timedelay
			lda timedelay
			cmp #50
			beq resetdelay
			rts
resetdelay:	lda #$00
			sta timedelay
			dec bombtime+1
			lda bombtime+1
			cmp #$2f
			beq setdigit
			rts
setdigit:		lda #$39
			sta bombtime+1
			dec bombtime+0
			lda bombtime+0
			cmp #$2f
			beq timeout
			rts
timeout:		lda #$30
			sta $0427
			sta $0426
			lda #<endmsg1
			sta pasted+1
			lda #>endmsg1
			sta pasted+2
gameover:		lda #$00
			sta $d015
			ldx #$00
clr:			lda #$20			
			sta $0428,x
			sta $0500,x
			sta $0600,x
			sta $06e8,x
			inx
			bne clr
			lda $0406
			sec
			lda hiscore+5
			sbc $040b
			lda hiscore+4
			sbc $040a
			lda hiscore+3
			sbc $0409
			lda hiscore+2
			sbc $0408
			lda hiscore+1
			sbc $0407
			lda hiscore
			sbc $0406
			bpl nohiscore
			ldx #$00
copyhsc:		lda $0406,x
			sta $0419,x
			sta hiscore,x
			inx
			cpx #$06
			bne copyhsc
			

nohiscore:		sei
			lda #$16
			sta $d018
			lda #$08
			sta $d016
goseton:		lda #$fc
rloop:		cmp $d012
			bne rloop
			jsr $1003
			jsr colroll		
			ldx #$00
pasted:		lda endmsg1,x
 			sta $0590,x
			lda colours
			sta $d990,x
			inx
			cpx #$c8
			bne pasted
			lda $dc01
			cmp #$ef
			bne goseton
			jmp restart
			
;Our loop to randomize the starting positions for the bombs and enemies

randomizer:	ldy randct
			lda randytbl+$00,y
			sta randypos
			lda randxtbl+$00,y
			sta randxpos
			iny
			cpy #$27
			beq resetrand
			inc randct
			rts
resetrand:		ldy #$01
			sty randct
			rts
			
;Move those elephants across the screen - to make gameplay slightly more challenging

move_elephant:	lda elephantdelay
			cmp #$01
			beq delayend
			inc elephantdelay
			rts
delayend:		lda #$00
			sta elephantdelay
			lda objpos+$0c
			sec
			sbc #$01
			cmp #$02
			bcs newepos1
			lda randypos
			sta objpos+$0d
			lda #$00
newepos1:		sta objpos+$0c
			lda objpos+$0e
			clc
			adc #$01
			cmp #$bc
			bcc newepos2
			lda randypos
			sta objpos+$0f
			lda #$00
newepos2:		sta objpos+$0e
			rts
			
addscore:		inc $040a
			inc $040a
			ldx #$05
scloop:		lda $0406,x
			cmp #$3a
			bne changesc
			lda #$30
			sta $0406,x
			inc $0405,x
changesc:		dex
			bne scloop
			inc collected
			lda collected
			cmp #10
			beq nextlev
			rts
nextlev:		lda #$00
			sta collected
			inc level
			lda level
			cmp #$02
			beq setlev2
			cmp #$03
			beq setlev3
			cmp #$04
			beq setlev4
			cmp #$05
			beq setlev1
			rts
setlev1:		jmp dolev1
setlev2:		jmp dolev2
setlev3:		jmp dolev3
setlev4:		jmp dolev4
			

dolev1:		lda #$02
			sta $d022
			lda #$0a
			sta $d023
			ldx #$00
cyan:		lda #$0f
			sta $d828,x
			sta $d900,x
			sta $da00,x
			sta $dae8,x
			inx
			bne cyan
			lda #$33
			sta count1
			lda #$30
			sta count2
			rts
			
dolev2:		lda #$06
			sta $d022
			lda #$0e
			sta $d023
			ldx #$00
tur:			lda #$0b
			sta $d828,x
			sta $d900,x
			sta $da00,x
			sta $dae8,x
			inx
			bne tur		
			lda #$32
			sta count1
			lda #$35
			sta count2	
			rts
			
dolev3:		lda #$09
			sta $d022
			lda #$08
			sta $d023
			ldx #$00
yellow:		lda #$0f
			sta $d828,x
			sta $d900,x
			sta $da00,x
			sta $dae8,x
			inx
			bne yellow
			lda #$32
			sta count1
			lda #$30
			sta count2
			rts
			
dolev4:		lda #$0b
			sta $d022
			lda #$0c
			sta $d023
			ldx #$00
white:		lda #$09
			sta $d800,x
			sta $d900,x
			sta $da00,x
			sta $dae8,x
			inx
			bne white
			lda #$31
			sta count1
			lda #$30
			sta count2
			rts
			
			
			
			
			
			
			
			
			
			


			
			
			
			



	
			

;The screen for the game screen.

gamescreen: 	dc.b "SCORE:000000  HIGH SCORE:000000  BOMB:--"
				dc.b "                                        "
				dc.b "                                        "
				dc.b "                                        "
				dc.b "$$$$     $$$$     $$$$     $$$$     $$$$"
				dc.b "                                        "
				dc.b "                                        "
				dc.b "                                        "
				dc.b "                                        "
				dc.b "$$$$     $$$$     $$$$     $$$$     $$$$"
				dc.b "                                        "
				dc.b "                                        "
				dc.b "                                        "
				dc.b "                                        "
				dc.b "$$$$     $$$$     $$$$     $$$$     $$$$"
				dc.b "                                        "
				dc.b "                                        "
				dc.b "                                        "
				dc.b "                                        "
				dc.b "$$$$     $$$$     $$$$     $$$$     $$$$"
				dc.b "                                        "
				dc.b "                                        "
				dc.b "                                        "
				dc.b "                                        "
				dc.b "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"
endmsg1:			dc.b "         THE GAME'S UP MATEY!           "
				dc.b " YOU WERE THAT STUPID ENOUGH TO LET THE "
				dc.b "BOMBS EXPLODE. WHAT A BRAINLESS FOOL YOU"
				dc.b "ARE. OH, JUST BLAME THE AUTHOR WHY DON'T"
				dc.b "       YOU. I THOUGHT YOU WOULD!        "
				
endmsg2:			dc.b "          THE GAME'S UP MATEY!          "
				dc.b " YOU JUST GOT CAPTURED BY A FLYING PINK "
				dc.b " ELEPHANT, AND THEN YOU GET DROPPED INTO"
				dc.b "     A POND AND GET SOAKING WET.        "
				dc.b " YOU CAN'T BLAME THE AUTHOR FOR THAT :P "
				
				
playerdefault:	dc.b $84
lift:		dc.b $88,$88,$88,$88
fall:		dc.b $89
bomb:            dc.b $8a,$8b,$8a,$8b

elephantleft:  dc.b $80,$81,$80,$81
elephantright:	dc.b $82,$83,$82,$83


playerframe:	dc.b $84,$85,$86,$87		


;Data tables for the colour roll over the score

colours:			dc.b $0b,$0b,$09,$09,$02,$02,$08,$08
				dc.b $0a,$0a,$07,$07,$01,$01,$01,$01
				dc.b $01,$01,$01,$01,$01,$01,$01,$01
				dc.b $01,$01,$01,$01,$0d,$0d,$05,$05
				dc.b $0e,$0e,$04,$04,$06,$06,$0b,$0b
				
randxtbl:			dc.b $32,$7a,$12,$9a,$7a,$32,$12,$7a
				dc.b $7a,$12,$9a,$12,$7a,$32,$12,$7a
				dc.b $7a,$32,$7a,$12,$32,$7a,$12,$32
				dc.b $9a,$32,$7a,$32,$7a,$12,$12,$9a
			 	dc.b $12,$9a,$7a,$12,$9a,$7a,$32,$32
				dc.b $7a,$9a,$32,$12,$9a,$7a,$9a,$12
				
randytbl:			dc.b $6c,$44,$94,$e4,$bc,$94,$44,$6c
				dc.b $6c,$bc,$bc,$94,$e4,$94,$6c,$44
				dc.b $94,$bc,$6c,$44,$bc,$44,$6c,$e4
				dc.b $bc,$44,$6c,$e4,$bc,$e4,$e4,$6c
				dc.b $e4,$44,$bc,$44,$e4,$94,$6c,$e4
				dc.b $bc,$44,$6c,$e4,$bc,$e4,$e4,$6c

				
hiscore:			dc.b $30,$30,$30,$30,$30,$30
			
			