.MEMORYMAP
DEFAULTSLOT 0
SLOTSIZE $10000
SLOT 0 $0000
.ENDME

.ROMBANKMAP
BANKSTOTAL 1
BANKSIZE $10000
BANKS 1
.ENDRO

.BANK 0

;****************************************************************************
;*****
;*****
;*****  1K Venus Express - entry to Minigame Competition 2005
;*****
;*****  aleksi.eeben@gmail.com
;*****
;*****
;****************************************************************************


;-----  Zeropage variables

.DEFINE SXMSB   $02                     ; scroll x msb
.DEFINE SYMSB   $04                     ; scroll y msb
.DEFINE SXLSB   $05                     ; scroll x lsb (5 decimals)
.DEFINE SYLSB   $06                     ; scroll y lsb (5 decimals)

.DEFINE ADDX    $07                     ; signed scroll x add
.DEFINE ADDY    $08                     ; signed scroll y add

.DEFINE map     $02                     ; map address (lsb = scroll x msb)
.DEFINE maph    $03

.DEFINE scr     $09                     ; screen address
.DEFINE scrh    $0a

.DEFINE bits1   $0b                     ; fill bits
.DEFINE bits2   $0c

.DEFINE run     $0d                     ; running frame count

.DEFINE sco10   $0e                     ; score
.DEFINE sco1000 $0f

.DEFINE temp    $10

.DEFINE level   $11                     ; level number

.DEFINE rnd0    $12                     ; pseudo-random generator
.DEFINE rnd1    $13
.DEFINE rnd2    $14

.DEFINE lives   $15                     ; 0 = first ship, 2 = last ship

.DEFINE cavesl  $16                     ; number of caves lsb
.DEFINE caves   $17                     ; number of caves msb
.DEFINE cavelen $18                     ; length of current cave
.DEFINE gen     $19
.DEFINE genh    $1a

.DEFINE putitem $1b

.DEFINE bonus   $20                     ; bonus time (BCD)
.DEFINE items   $40                     ; number of items collected (BCD)


;-----  Load address

.SECTION "BANKHEADER"
        .DW     $0801
.ENDS

.ORG $0801
.SECTION "Main" FORCE

;-----  Basic line

        .DB     $0b,$08,$01,$00,$9e,$32,$30,$35,$39,$00


;-----  Entry to start new game

NewGame:
        ldy     #$00
        sei


;-      Init VIC-II and SID

        ldx     #$2e
_inilp
        lda.w   vicinit-1,x             ; VIC-II
        sta     $d000-1,x
        lda.w   sidinit-1,x             ; SID
        sta     $d400-1,x
        lda.w   shapes-$28,x            ; sprite shapes
        sta.w   $07f8-$28,x
        sty     $02,x                   ; init zero page variables

        dex
        bne     _inilp

        tya
_clrslp
        sta     $0c00,x                 ; clear space char & text sprites
        inx
        bne     _clrslp


;-----  Entry to new level

NewLevel:
        inc     level

SameLevel:


;-      Init color memory

        lda     #$d8
        sta     scrh
        ldy     #$00
        sty     scr
        sty     ADDX
        sty     ADDY
        sty     bits1
        sty     bits2
        lda     #$0f
        ldx     #$04
        jsr     Block


;-----  Init map & new ship

;-      Clear space region of map

        lda     #$10                    ; space $1000-$29ff
        sta     scrh
        sta     SYMSB                   ; also ship starting y-position
        ldx     #$1a
        lda     #$80
        sta     $d412                   ; also explosion gate off
        sta     gen                     ; also starting x-coordinate of gen
        jsr     Block


;-      Fill ground region of map

        lda     #$01                    ; ground $2a00-$cfff
        sta     bits1                   ; bits changed every char
        asl
        sta     bits2                   ; bits changed every line
        lda     #$70                    ; base char for block fill
        sta     bonus                   ; also bonus timer
        sta     SXMSB                   ; also ship starting x-position
        ldx     #$a6
        jsr     Block


;-      Get ready

        sty     $d408                   ; stop thrust sound (y = 0)
        ldy     #$42
        jsr     WriteNumber             ; write 'fake' zero (a = $x0)

        jsr     Draw                    ; note: scr must be zero


;-      Create level

        lda     #$37
        sta     $01

        ldx     level                   ; level random seed
        stx     rnd0
        lda     $e700,x
        sta     rnd1
        lda     $ef00,x
        sta     rnd2

        txa
        and     #$07
        tax
        lda.w   colors,x                ; level palette
        sta     $d022
        lsr
        lsr
        lsr
        lsr
        sta     $d023

        lda     #$29
        sta     genh
        asl
        sta     cavelen                 ; $52

        lda     #$05
        sta     $01
        sta     caves
        ldx     #$02
        bne     _cavestart

_nextcave
        jsr     Random                  ; random cave length
        and     #$03
        sta     cavelen
        jsr     Random                  ; random cave dir
        and     #$03
        tax
_cavestart
        lda.w   caveadd1,x              ; instruction ($e6 = inc, $c6 = dec)
        sta.w   caveadd_
        lda.w   caveadd2,x              ; memory location (gen or genh)
        sta.w   caveadd_+1

_caveon
        lda     #$80                    ; draw cave loop
        ldx     #$07

        jsr     Round                   ; fill top of cave cell
        inc     genh

_cblk1
        ldy     #$06
_cblk3
        sta     (gen),y                 ; fill middle of cave cell
        dey
        bpl     _cblk3

        inc     genh
        dex
        bne     _cblk1

        jsr     Round                   ; fill bottom of cave cell

        lda     genh
        sec
        sbc     #$08
        sta     genh

caveadd_
        inc     genh                    ; modified by cave dir

        lda     genh                    ; check level bounds
        cmp     #$2c
        bne     _notop
        inc     genh
_notop
        cmp     #$b8
        bne     _nobot
        dec     genh
_nobot
        lda     gen
        cmp     #$28
        bne     _noleft
        inc     gen
_noleft
        cmp     #$d0
        bne     _noright
        dec     gen
_noright
        dec     cavelen
        bpl     _caveon

        dec     cavesl
        bne     _nextcave
        dec     caves
        bne     _nextcave


;-      Place items

        sty     items                   ; y = 0 after Round

        lda     level
        sta     putitem


_nextitem
_newic
        jsr     Random                  ; new item place
        sta     gen
        jsr     Random
        and     #$7f
        adc     #$40
        sta     genh

        lda     #$80

_icdrop
        ldy     #$02
_ispc
        cmp     (gen),y                 ; check neighbor space
        bne     _newic                  ; try another location if wall hit
        dey
        bpl     _ispc

        ldy     #$01
        inc     genh
        cmp     (gen),y                 ; check floor
        beq     _icdrop                 ; if space drop item to floor

        dec     genh                    ; place item on floor
        lda     #$81
        sta     (gen),y

        ldx     #items
        tya
        jsr     AddBCD

        dec     putitem
        bne     _nextitem
        

;-      Check lives

        ldx     lives                   ; lives sprites
        lda.w   livespr,x
        bpl     _notlast

_waitfire
        lda     $dc00                   ; game over
        and     #$10
        bne     _waitfire
        jmp     NewGame

_notlast
        sta     $d015

        lda     $d01f                   ; clear collisions


;-----  Main loop

MainLoop:
        lda     ADDX
        eor     #$80
        lsr
        lsr
        clc
        adc     #$8b
        sta     $d000

        lda     ADDY
        eor     #$80
        lsr
        lsr
        clc
        adc     #$60
        sta     $d001

        ldy     #$00                    ; ADDX sign-extend
        lda     ADDX
        bpl     _xpos
        dey
_xpos
        clc                             ; scroll x LSB
        adc     SXLSB
        sta     SXLSB
        tya
        adc     SXMSB                   ; scroll x MSB
        cmp     #$00
        bne     _nolw
        lda     #$d6
        bne     _norw
_nolw
        cmp     #$d8
        bne     _norw
        lda     #$02
_norw
        sta     SXMSB

        ldy     #$00                    ; ADDY sign-extend
        lda     ADDY
        bpl     _ypos
        dey
_ypos
        clc                             ; scroll y LSB
        adc     SYLSB
        sta     SYLSB
        tya
        adc     SYMSB                   ; scroll y MSB
        cmp     #$0f
        bne     _nobounc

        lda     items                   ; check if all items collected
        bne     _notcompleted

        lda     bonus                   ; level completed bonus
        ldx     #sco10
        jsr     AddBCD

        jmp     NewLevel

_notcompleted
        lda     #$10                    ; bounce back
_nobounc
        sta     SYMSB


;-      check joystick

        lda     $dc00                   ; read joystick bits
        ldy     #$01                    ; gravity
        ldx     #$00                    ; thrust sound flag
        stx     scr                     ; zero scr lsb (for check item below)

        lsr                             ; joy up
        bcs     _notup
        ldy     #$fc
        dex
_notup
        lsr                             ; joy down
        pha
        bcs     _notdown
        ldy     #$04
        dex
_notdown
        tya
        clc
        adc     ADDY
        bvs     _yover                  ; no change if overflow
        sta     ADDY
_yover

        ldy     #$00                    ; slow down horizontal movement
        lda     ADDX
        beq     _xslok
        bpl     _xslod
        iny                             ; addx negative, slow down
        iny
_xslod
        dey                             ; addx positive, slow down
_xslok
        pla

        lsr                             ; joy left
        bcs     _notleft
        ldy     #$fc
        dex
_notleft
        lsr                             ; joy right
        bcs     _notright
        ldy     #$04
        dex
_notright
        tya
        clc
        adc     ADDX
        bvs     _xover                  ; no change if overflow
        sta     ADDX
_xover
        stx     $d408                   ; play thrust sound or mute it


;-      check collision

        lsr     $d01f                   ; sprite 1/bg collision to carry
        bcs     _crash


;-      check item

        lda     SYMSB                   ; calculate map location
        adc     #$0d
        sta     scrh
        lda     SXMSB
        adc     #$13
        tay


        lda     (scr),y                 ; check location below player ship
        cmp     #$81
        bne     _notitem

        sta     $d404                   ; trig pick up sound
        lda     #$80
        sta     (scr),y                 ; pick up item

        lda     #$14                    ; pick up sound gate off & waveform
        sta     $d404

        ldx     #items
        jsr     DecBCD
        ldx     #sco10
        lda     #$10
        jsr     AddBCD

_toofast
_notitem

;-      draw screen

        jsr     Draw                    ; note: scr must be zero

        jmp     MainLoop


;-      crash

_crash
        lda     #$81
        sta     $d412
        asl
        sta     $d000
        inc     lives

        jmp     SameLevel


;-----  draw screen

Draw:
        lda     items                   ; write number of items
        ldy     #$01+3*8
        jsr     WriteBCD

        lda     bonus
        ldy     #$41+3*8                ; write bonus
        jsr     WriteBCD

        lda     sco1000                 ; write score
        ldy     #$01
        jsr     WriteBCD
        lda     sco10
        ldy     #$40
        jsr     WriteBCD

        inc     run                     ; running frame count
        lda     run
        and     #$3f
        bne     _nobon

        lda     bonus
        beq     _nobon

        ldx     #bonus
        jsr     DecBCD                  ; returns a = 0

_nobon
        and     #$0c                    ; item animation
        asl
        tax
        cpx     #$18
        bne     _nf

        ldx     #$08
_nf
        ldy     #$06
_imlp
        lda.w   chars+32,x              ; copy item animation char
        sta     $0c08,y
        inx
        dey
        bpl     _imlp

_sync
        cpy     $d012                   ; frame sync
        bne     _sync

        lda     #$04
        sta     scrh


        lda     SYLSB                   ; fine scroll y
        lsr
        lsr
        lsr
        lsr
        lsr
        eor     #$17
        sta     $d011

        lda     SXLSB                   ; fine scroll x
        lsr
        lsr
        lsr
        lsr
        lsr
        eor     #$17
        sta     $d016

        lda     SYMSB                   ; map y-coordinate
        sta     maph

        ldx     #$19                    ; number of lines

_drawlp
        ldy     #$27                    ; copy one line from map
_linelp
        lda     (map),y
        sta     (scr),y
        dey
        lda     (map),y
        sta     (scr),y
        dey
        bpl     _linelp

        inc     maph                    ; next map line

        lda     scr                     ; next screen line
        clc
        adc     #$28
        sta     scr
        bcc     _dnoc
        inc     scrh
_dnoc
        dex                             
        bne     _drawlp                 ; copy rest of lines

        rts


;-----  Fill x block s of memory

Block:
        sta     (scr),y
        eor     bits1                   ; bits changed every char
        iny
        bne     Block
        inc     scrh
        eor     bits2                   ; bits changed every line
        dex
        bne     Block
        rts


;-----  Decrement BCD number by one

DecBCD:
        lda     #$99
        ;

;-----  Add A to a BCD number

AddBCD:
        sed

        clc
_bcdc
        adc     $00,x
        sta     $00,x
        lda     #$00
        inx
        bcs     _bcdc

        cld
        rts


;-----  Write two digits BCD a to sprite at y

WriteBCD:
        pha
        lsr
        lsr
        lsr
        lsr
        sty     temp
        jsr     WriteNumber
        pla
        ldy     temp
        iny
        ;

;-----  Write number a to sprite at y

WriteNumber:
        ora     #$10
        asl
        asl
        asl
        tax

        lda     #$33
        sta     $01

        lda     #$07
        sta     bits1

_wrlp
        lda     $d100,x
        sta     $0c40,y
        inx
        iny
        iny
        iny
        dec     bits1
        bne     _wrlp

        lda     #$35
        sta     $01
        rts


;-----  Fill round top or bottom line of cave cell

Round:
        ldy     #$05
_rnlp
        sta     (gen),y                 ; fill block top
        dey
        bne     _rnlp
        rts


;-----  Generate pseudo-random number

Random:
        inc     rnd2
        lda     rnd2
        clc
        adc     rnd1
        adc     rnd2
        sta     rnd1
        eor     rnd2
        sta     rnd2
        sbc     rnd0
        sta     rnd0

        rts


;-----  VIC-II init table

vicinit:
        .DB     $ef,$3c,$2f,$3c,$0f,$3c,$17,$3c ; $d000-$d007
        .DB     $47,$3c,$19,$3d,$49,$3d,$00,$00 ; $d008-$d00f
        .DB     $06,$00,$00,$00,$00,$7f,$00,$00 ; $d010-$d017
        .DB     $12,$00,$00,$00,$07,$78,$00,$00 ; $d018-$d01f
        .DB     $00,$00,$04,$0f,$00,$06,$0e,$01 ; $d020-$d027
        .DB     $01,$01                         ; $d028-$d029
;        .DB     $01,$01,$00,$00                ; $d02a-$d02d

;-----  SID init table

sidinit:
        .DB     $21,$21,$00,$00,$14,$09,$09     ; pick up item
        .DB     $00,$00,$00,$00,$81,$00,$10     ; thrust
        .DB     $80,$10,$00,$00,$80,$0b,$0b     ; explosion
        .DB     $00,$50                         ; filter cutoff
        .DB     $f6,$3f                         ; filter & volume


;-----  Misc. tables

livespr:
        .DB     $7f,$7b,$79                     ; to $d015 sprite enable reg.
                                                ; next value must be >$80

caveadd1:                                       ; cave direction tables
        .DB     $c6,$e6,$e6,$c6                 
caveadd2:
        .DB     genh,gen,genh,gen

shapes:
        .DB     $2f,$2f,$2f,$31,$32,$31,$32     ; 3 ships, text, shadow

.ENDS


;-----  Graphics

.ORG    $0b80
.SECTION "Graphics" FORCE

chars:
        .INCBIN "chars.bin"
colors:
        .DB     $e6,$a2,$f4,$89,$58,$fc,$56,$c9
sprite:
        .INCBIN "sprite.bin"
.ENDS
