; 
; Copyright (c) 2014, Antonio Nio Daz (AntonioND)
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
; 
; * Redistributions of source code must retain the above copyright notice, this
;   list of conditions and the following disclaimer.
; 
; * Redistributions in binary form must reproduce the above copyright notice,
;   this list of conditions and the following disclaimer in the documentation
;   and/or other materials provided with the distribution.
; 
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
; CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
; OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
; OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
; 

	INCLUDE	"hardware.inc"
	INCLUDE "header.inc"

MAP_TEMP			EQU	$D400
ATTR_MAP_TEMP		EQU	$D800 ;($D400 + 32*32)

;-------------------------------------------------------------------------------------------------

	SECTION "TUNNEL_DATA", DATA, BANK[3]

tunnel_palettes:
	DW $6FFB,$4EF3,$2DEB,$0CE3
	DW $63D9,$42D1,$21C9,$00C1
	DW $57B7,$36AF,$15A7,$00A0
	DW $4B95,$2A8D,$0985,$0080
	DW $3F73,$1E6B,$0163,$0060
	DW $3351,$1249,$0141,$0040
	DW $272F,$0627,$0120,$0020
	DW $0000,$0000,$0000,$0000 ;DW $1B0D,$0205,$0100,$0000

tunnel_sprites_palette:
	DW	$0000,$7FFF,$3DEF,$0000

tunnel_sprite_tiles: ; 14 tiles
DB $FF,$FF,$FF,$80,$FF,$80,$FF,$F3
DB $1E,$12,$1E,$12,$1E,$12,$1E,$12
DB $1E,$12,$1E,$12,$1E,$12,$1E,$12
DB $1E,$12,$1E,$12,$1E,$12,$1E,$1E
DB $F9,$F9,$F9,$49,$F9,$49,$F9,$C9
DB $79,$49,$79,$49,$79,$49,$79,$49
DB $79,$49,$79,$49,$79,$49,$79,$49
DB $76,$4F,$5F,$60,$2F,$30,$1F,$1F
DB $FC,$FC,$FC,$24,$FC,$24,$FA,$26
DB $FE,$22,$FD,$23,$FF,$21,$FE,$25
DB $FD,$26,$FF,$26,$FE,$27,$FD,$25
DB $FD,$25,$BC,$64,$7C,$E4,$BC,$BC
DB $FE,$FE,$FE,$92,$FE,$92,$FD,$93
DB $FF,$91,$FE,$91,$FF,$90,$FF,$92
DB $FE,$93,$FF,$13,$FF,$13,$FE,$12
DB $7E,$92,$FE,$92,$FE,$92,$FE,$FE
DB $7F,$7F,$7F,$48,$7F,$48,$7F,$49
DB $7F,$49,$FF,$C9,$FF,$C9,$7F,$C8
DB $FF,$48,$FF,$09,$7F,$89,$FF,$89
DB $BF,$C9,$7F,$48,$7F,$48,$7F,$7F
DB $FF,$FF,$FF,$04,$FF,$04,$FF,$FC
DB $07,$04,$07,$04,$FF,$FC,$FF,$04
DB $FF,$04,$FF,$FC,$07,$04,$07,$04
DB $FF,$FC,$FF,$04,$FF,$04,$FF,$FF
DB $80,$80,$80,$80,$80,$80,$80,$80
DB $80,$80,$80,$80,$80,$80,$80,$80
DB $80,$80,$80,$80,$80,$80,$80,$80
DB $FE,$FE,$FE,$02,$FE,$02,$FE,$FE

	SECTION "TUNNEL_DATA_2",ROMX[$6000],BANK[3]

tunnel_texture:
DB $02,$02,$02,$02,$02,$02,$02,$02,$03,$03
DB $03,$03,$03,$03,$03,$03,$01,$01,$01,$01
DB $01,$01,$01,$01,$03,$03,$03,$03,$03,$03
DB $03,$03,$02,$01,$01,$01,$01,$01,$01,$02
DB $03,$02,$02,$02,$02,$02,$02,$03,$01,$00
DB $00,$00,$00,$00,$00,$01,$03,$02,$02,$02
DB $02,$02,$02,$03,$02,$01,$01,$01,$01,$01
DB $01,$02,$03,$02,$02,$02,$02,$02,$02,$03
DB $01,$00,$00,$00,$00,$00,$00,$01,$03,$02
DB $02,$02,$02,$02,$02,$03,$02,$01,$01,$01
DB $01,$01,$01,$02,$03,$02,$02,$02,$02,$02
DB $02,$03,$01,$00,$00,$00,$00,$00,$00,$01
DB $03,$02,$02,$02,$02,$02,$02,$03,$02,$01
DB $01,$01,$01,$01,$01,$02,$03,$02,$02,$02
DB $02,$02,$02,$03,$01,$00,$00,$00,$00,$00
DB $00,$01,$03,$02,$02,$02,$02,$02,$02,$03
DB $02,$01,$01,$01,$01,$01,$01,$02,$03,$02
DB $02,$02,$02,$02,$02,$03,$01,$00,$00,$00
DB $00,$00,$00,$01,$03,$02,$02,$02,$02,$02
DB $02,$03,$02,$01,$01,$01,$01,$01,$01,$02
DB $03,$02,$02,$02,$02,$02,$02,$03,$01,$00
DB $00,$00,$00,$00,$00,$01,$03,$02,$02,$02
DB $02,$02,$02,$03,$02,$02,$02,$02,$02,$02
DB $02,$02,$03,$03,$03,$03,$03,$03,$03,$03
DB $01,$01,$01,$01,$01,$01,$01,$01,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$02,$02,$02,$02,$02,$02
DB $02,$02,$03,$03,$03,$03,$03,$03,$03,$03
DB $02,$02,$02,$02,$02,$02,$02,$02,$03,$02
DB $02,$02,$02,$02,$02,$03,$02,$01,$01,$01
DB $01,$01,$01,$02,$03,$02,$02,$02,$02,$02
DB $02,$03,$02,$01,$01,$01,$01,$01,$01,$02
DB $03,$02,$02,$02,$02,$02,$02,$03,$02,$01
DB $01,$01,$01,$01,$01,$02,$03,$02,$02,$02
DB $02,$02,$02,$03,$02,$01,$01,$01,$01,$01
DB $01,$02,$03,$02,$02,$02,$02,$02,$02,$03
DB $02,$01,$01,$01,$01,$01,$01,$02,$03,$02
DB $02,$02,$02,$02,$02,$03,$02,$01,$01,$01
DB $01,$01,$01,$02,$03,$02,$02,$02,$02,$02
DB $02,$03,$02,$01,$01,$01,$01,$01,$01,$02
DB $03,$02,$02,$02,$02,$02,$02,$03,$02,$01
DB $01,$01,$01,$01,$01,$02,$03,$02,$02,$02
DB $02,$02,$02,$03,$02,$01,$01,$01,$01,$01
DB $01,$02,$03,$02,$02,$02,$02,$02,$02,$03
DB $02,$01,$01,$01,$01,$01,$01,$02,$03,$02
DB $02,$02,$02,$02,$02,$03,$02,$01,$01,$01
DB $01,$01,$01,$02,$03,$02,$02,$02,$02,$02
DB $02,$03,$02,$01,$01,$01,$01,$01,$01,$02
DB $03,$03,$03,$03,$03,$03,$03,$03,$02,$02
DB $02,$02,$02,$02,$02,$02,$03,$03,$03,$03
DB $03,$03,$03,$03,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $03,$03,$03,$03,$03,$03,$03,$03,$02,$02
DB $02,$02,$02,$02,$02,$02,$03,$03,$03,$03
DB $03,$03,$03,$03,$02,$01,$01,$01,$01,$01
DB $01,$02,$03,$03,$03,$03,$03,$03,$03,$03
DB $02,$01,$01,$01,$01,$01,$01,$02,$03,$02
DB $02,$02,$02,$02,$02,$03,$02,$01,$01,$01
DB $01,$01,$01,$02,$03,$03,$03,$03,$03,$03
DB $03,$03,$02,$01,$01,$01,$01,$01,$01,$02
DB $03,$02,$02,$02,$02,$02,$02,$03,$02,$01
DB $01,$01,$01,$01,$01,$02,$03,$03,$03,$03
DB $03,$03,$03,$03,$02,$01,$01,$01,$01,$01
DB $01,$02,$03,$02,$02,$02,$02,$02,$02,$03
DB $02,$01,$01,$01,$01,$01,$01,$02,$03,$03
DB $03,$03,$03,$03,$03,$03,$02,$01,$01,$01
DB $01,$01,$01,$02,$03,$02,$02,$02,$02,$02
DB $02,$03,$02,$01,$01,$01,$01,$01,$01,$02
DB $03,$03,$03,$03,$03,$03,$03,$03,$02,$01
DB $01,$01,$01,$01,$01,$02,$03,$02,$02,$02
DB $02,$02,$02,$03,$02,$01,$01,$01,$01,$01
DB $01,$02,$03,$03,$03,$03,$03,$03,$03,$03
DB $02,$01,$01,$01,$01,$01,$01,$02,$03,$02
DB $02,$02,$02,$02,$02,$03,$02,$02,$02,$02
DB $02,$02,$02,$02,$03,$03,$03,$03,$03,$03
DB $03,$03,$02,$02,$02,$02,$02,$02,$02,$02
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$02,$02,$02,$02
DB $02,$02,$02,$02,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$02,$02,$02,$02,$02,$02,$03,$02,$01
DB $01,$01,$01,$01,$01,$02,$03,$02,$02,$02
DB $02,$02,$02,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$02,$02,$02,$02,$02,$02,$03
DB $02,$01,$01,$01,$01,$01,$01,$02,$03,$02
DB $02,$02,$02,$02,$02,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$02,$02,$02,$02,$02
DB $02,$03,$02,$01,$01,$01,$01,$01,$01,$02
DB $03,$02,$02,$02,$02,$02,$02,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$02,$02,$02
DB $02,$02,$02,$03,$02,$01,$01,$01,$01,$01
DB $01,$02,$03,$02,$02,$02,$02,$02,$02,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$02
DB $02,$02,$02,$02,$02,$03,$02,$01,$01,$01
DB $01,$01,$01,$02,$03,$02,$02,$02,$02,$02
DB $02,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$02,$02,$02,$02,$02,$02,$03,$02,$01
DB $01,$01,$01,$01,$01,$02,$03,$02,$02,$02
DB $02,$02,$02,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $02,$02,$02,$02,$02,$02,$02,$02,$03,$03
DB $03,$03,$03,$03,$03,$03,$03,$03,$03,$03
DB $03,$03,$03,$03

	SECTION "TUNNEL_DATA_DISTANCE_PALETTES",ROMX[$6400],BANK[3]
	
tunnel_distance_palettes:
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$02,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$01,$01,$01,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$01,$01,$01,$00,$00,$00
DB $00,$00,$01,$01,$01,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$01,$01,$01,$00,$00
DB $00,$01,$01,$01,$02,$02,$02,$02,$03,$03,$03,$03,$04,$04,$04,$04,$04,$04,$04,$04,$03,$03,$03,$03,$02,$02,$02,$02,$01,$01,$01,$00
DB $00,$01,$01,$01,$02,$02,$02,$03,$03,$03,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$03,$03,$03,$02,$02,$02,$01,$01,$01,$00
DB $01,$01,$01,$02,$02,$02,$03,$03,$03,$04,$04,$04,$04,$04,$05,$05,$05,$05,$04,$04,$04,$04,$04,$03,$03,$03,$02,$02,$02,$01,$01,$01
DB $01,$01,$01,$02,$02,$03,$03,$03,$04,$04,$04,$04,$05,$05,$05,$05,$05,$05,$05,$05,$04,$04,$04,$04,$03,$03,$03,$02,$02,$01,$01,$01
DB $01,$01,$02,$02,$02,$03,$03,$03,$04,$04,$04,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$04,$04,$04,$03,$03,$03,$02,$02,$02,$01,$01
DB $01,$01,$02,$02,$02,$03,$03,$04,$04,$04,$05,$05,$05,$06,$06,$06,$06,$06,$06,$05,$05,$05,$04,$04,$04,$03,$03,$02,$02,$02,$01,$01
DB $01,$01,$02,$02,$03,$03,$03,$04,$04,$04,$05,$05,$06,$06,$06,$06,$06,$06,$06,$06,$05,$05,$04,$04,$04,$03,$03,$03,$02,$02,$01,$01
DB $01,$01,$02,$02,$03,$03,$03,$04,$04,$05,$05,$05,$06,$06,$06,$07,$07,$06,$06,$06,$05,$05,$05,$04,$04,$03,$03,$03,$02,$02,$01,$01
DB $01,$01,$02,$02,$03,$03,$03,$04,$04,$05,$05,$05,$06,$06,$07,$07,$07,$07,$06,$06,$05,$05,$05,$04,$04,$03,$03,$03,$02,$02,$01,$01
DB $01,$01,$02,$02,$03,$03,$03,$04,$04,$05,$05,$05,$06,$06,$07,$07,$07,$07,$06,$06,$05,$05,$05,$04,$04,$03,$03,$03,$02,$02,$01,$01
DB $01,$01,$02,$02,$03,$03,$03,$04,$04,$05,$05,$05,$06,$06,$06,$07,$07,$06,$06,$06,$05,$05,$05,$04,$04,$03,$03,$03,$02,$02,$01,$01
DB $01,$01,$02,$02,$03,$03,$03,$04,$04,$04,$05,$05,$06,$06,$06,$06,$06,$06,$06,$06,$05,$05,$04,$04,$04,$03,$03,$03,$02,$02,$01,$01
DB $01,$01,$02,$02,$02,$03,$03,$04,$04,$04,$05,$05,$05,$06,$06,$06,$06,$06,$06,$05,$05,$05,$04,$04,$04,$03,$03,$02,$02,$02,$01,$01
DB $01,$01,$02,$02,$02,$03,$03,$03,$04,$04,$04,$05,$05,$05,$05,$05,$05,$05,$05,$05,$05,$04,$04,$04,$03,$03,$03,$02,$02,$02,$01,$01
DB $01,$01,$01,$02,$02,$03,$03,$03,$04,$04,$04,$04,$05,$05,$05,$05,$05,$05,$05,$05,$04,$04,$04,$04,$03,$03,$03,$02,$02,$01,$01,$01
DB $01,$01,$01,$02,$02,$02,$03,$03,$03,$04,$04,$04,$04,$04,$05,$05,$05,$05,$04,$04,$04,$04,$04,$03,$03,$03,$02,$02,$02,$01,$01,$01
DB $00,$01,$01,$01,$02,$02,$02,$03,$03,$03,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$03,$03,$03,$02,$02,$02,$01,$01,$01,$00
DB $00,$01,$01,$01,$02,$02,$02,$02,$03,$03,$03,$03,$04,$04,$04,$04,$04,$04,$04,$04,$03,$03,$03,$03,$02,$02,$02,$02,$01,$01,$01,$00
DB $00,$00,$01,$01,$01,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$01,$01,$01,$00,$00
DB $00,$00,$00,$01,$01,$01,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$01,$01,$01,$00,$00,$00
DB $00,$00,$00,$00,$01,$01,$01,$02,$02,$02,$02,$02,$02,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$01,$01,$01,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00

	SECTION "TUNNEL_DATA_DISTANCE",ROMX[$4000],BANK[3]

tunnel_distance:
DB $05,$05,$05,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08
DB $08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$05,$05,$05
DB $05,$05,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08
DB $08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$05,$05
DB $05,$06,$06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08
DB $08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06,$06,$05
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08
DB $08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$09
DB $09,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09
DB $09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$0A,$0A
DB $0A,$0A,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0A,$0A,$0A
DB $0A,$0A,$0A,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A
DB $0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06
DB $06,$06,$06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0B,$0B,$0B
DB $0B,$0B,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06,$06,$06
DB $06,$06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
DB $0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06,$06
DB $06,$06,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0B,$0B,$0C,$0C,$0C,$0C,$0C,$0C
DB $0C,$0C,$0C,$0C,$0C,$0C,$0B,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$06,$06
DB $06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0B,$0C,$0C,$0C,$0C,$0C,$0C,$0D,$0D,$0D
DB $0D,$0D,$0D,$0C,$0C,$0C,$0C,$0C,$0C,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06
DB $07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0C,$0C,$0C,$0C,$0D,$0D,$0D,$0D,$0D,$0D,$0D
DB $0D,$0D,$0D,$0D,$0D,$0D,$0D,$0C,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0D,$0D,$0E,$0E,$0E,$0E,$0E
DB $0E,$0E,$0E,$0E,$0E,$0D,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0D,$0E,$0E,$0E,$0E,$0F,$0F,$0F,$0F
DB $0F,$0F,$0F,$0F,$0E,$0E,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0E,$0E,$0E,$0F,$0F,$0F,$10,$10,$10,$10
DB $10,$10,$10,$10,$0F,$0F,$0F,$0E,$0E,$0E,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07
DB $07,$07,$07,$08,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0E,$0E,$0F,$0F,$10,$10,$10,$11,$11,$11,$11
DB $11,$11,$11,$11,$10,$10,$10,$0F,$0F,$0E,$0E,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07
DB $07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0E,$0E,$0F,$10,$10,$11,$11,$11,$12,$12,$12,$12
DB $12,$12,$12,$12,$11,$11,$11,$10,$10,$0F,$0E,$0E,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07
DB $07,$07,$07,$08,$08,$08,$09,$09,$09,$09,$0A,$0A,$0B,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0F,$0F,$10,$10,$11,$12,$12,$13,$13,$14,$14,$14
DB $14,$14,$14,$13,$13,$12,$12,$11,$10,$10,$0F,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$07,$07,$07
DB $07,$07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0F,$0F,$10,$11,$11,$12,$13,$14,$14,$15,$15,$16,$16
DB $16,$16,$15,$15,$14,$14,$13,$12,$11,$11,$10,$0F,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07
DB $07,$07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0E,$0F,$10,$11,$12,$12,$13,$14,$15,$16,$17,$17,$18,$18
DB $18,$18,$17,$17,$16,$15,$14,$13,$12,$12,$11,$10,$0F,$0E,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07
DB $07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0E,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1A,$1A
DB $1A,$1A,$1A,$19,$18,$17,$16,$15,$14,$13,$12,$11,$10,$0F,$0E,$0E,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07
DB $07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0F,$10,$10,$11,$12,$14,$15,$16,$17,$19,$1A,$1B,$1C,$1D,$1E
DB $1E,$1D,$1C,$1B,$1A,$19,$17,$16,$15,$14,$12,$11,$10,$10,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07
DB $07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0E,$0E,$0F,$10,$11,$12,$13,$15,$16,$18,$19,$1B,$1D,$1E,$20,$21,$22
DB $22,$21,$20,$1E,$1D,$1B,$19,$18,$16,$15,$13,$12,$11,$10,$0F,$0E,$0E,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07
DB $07,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$13,$14,$16,$17,$19,$1B,$1E,$20,$22,$24,$26,$27
DB $27,$26,$24,$22,$20,$1E,$1B,$19,$17,$16,$14,$13,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$07
DB $08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$14,$15,$17,$19,$1B,$1E,$20,$24,$27,$2A,$2C,$2E
DB $2E,$2C,$2A,$27,$24,$20,$1E,$1B,$19,$17,$15,$14,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0E,$0E,$0F,$10,$11,$13,$14,$16,$18,$1A,$1D,$20,$24,$28,$2C,$31,$35,$38
DB $38,$35,$31,$2C,$28,$24,$20,$1D,$1A,$18,$16,$14,$13,$11,$10,$0F,$0E,$0E,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$15,$17,$19,$1B,$1E,$22,$27,$2C,$33,$3B,$43,$48
DB $48,$43,$3B,$33,$2C,$27,$22,$1E,$1B,$19,$17,$15,$13,$12,$11,$10,$0F,$0E,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$14,$15,$17,$1A,$1C,$20,$24,$2A,$31,$3B,$48,$57,$64
DB $64,$57,$48,$3B,$31,$2A,$24,$20,$1C,$1A,$17,$15,$14,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$14,$16,$18,$1A,$1D,$21,$26,$2C,$35,$43,$57,$78,$A1
DB $A1,$78,$57,$43,$35,$2C,$26,$21,$1D,$1A,$18,$16,$14,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$14,$16,$18,$1A,$1E,$22,$27,$2E,$38,$48,$64,$A1,$6A
DB $6A,$A1,$64,$48,$38,$2E,$27,$22,$1E,$1A,$18,$16,$14,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$14,$16,$18,$1A,$1E,$22,$27,$2E,$38,$48,$64,$A1,$6A
DB $6A,$A1,$64,$48,$38,$2E,$27,$22,$1E,$1A,$18,$16,$14,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$14,$16,$18,$1A,$1D,$21,$26,$2C,$35,$43,$57,$78,$A1
DB $A1,$78,$57,$43,$35,$2C,$26,$21,$1D,$1A,$18,$16,$14,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$14,$15,$17,$1A,$1C,$20,$24,$2A,$31,$3B,$48,$57,$64
DB $64,$57,$48,$3B,$31,$2A,$24,$20,$1C,$1A,$17,$15,$14,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$15,$17,$19,$1B,$1E,$22,$27,$2C,$33,$3B,$43,$48
DB $48,$43,$3B,$33,$2C,$27,$22,$1E,$1B,$19,$17,$15,$13,$12,$11,$10,$0F,$0E,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0E,$0E,$0F,$10,$11,$13,$14,$16,$18,$1A,$1D,$20,$24,$28,$2C,$31,$35,$38
DB $38,$35,$31,$2C,$28,$24,$20,$1D,$1A,$18,$16,$14,$13,$11,$10,$0F,$0E,$0E,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08
DB $08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$14,$15,$17,$19,$1B,$1E,$20,$24,$27,$2A,$2C,$2E
DB $2E,$2C,$2A,$27,$24,$20,$1E,$1B,$19,$17,$15,$14,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08
DB $07,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0D,$0D,$0E,$0F,$10,$11,$12,$13,$14,$16,$17,$19,$1B,$1E,$20,$22,$24,$26,$27
DB $27,$26,$24,$22,$20,$1E,$1B,$19,$17,$16,$14,$13,$12,$11,$10,$0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$07
DB $07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0E,$0E,$0F,$10,$11,$12,$13,$15,$16,$18,$19,$1B,$1D,$1E,$20,$21,$22
DB $22,$21,$20,$1E,$1D,$1B,$19,$18,$16,$15,$13,$12,$11,$10,$0F,$0E,$0E,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07
DB $07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0F,$10,$10,$11,$12,$14,$15,$16,$17,$19,$1A,$1B,$1C,$1D,$1E
DB $1E,$1D,$1C,$1B,$1A,$19,$17,$16,$15,$14,$12,$11,$10,$10,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07
DB $07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0E,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1A,$1A
DB $1A,$1A,$1A,$19,$18,$17,$16,$15,$14,$13,$12,$11,$10,$0F,$0E,$0E,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07
DB $07,$07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0E,$0F,$10,$11,$12,$12,$13,$14,$15,$16,$17,$17,$18,$18
DB $18,$18,$17,$17,$16,$15,$14,$13,$12,$12,$11,$10,$0F,$0E,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07
DB $07,$07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0F,$0F,$10,$11,$11,$12,$13,$14,$14,$15,$15,$16,$16
DB $16,$16,$15,$15,$14,$14,$13,$12,$11,$11,$10,$0F,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07
DB $07,$07,$07,$08,$08,$08,$09,$09,$09,$09,$0A,$0A,$0B,$0B,$0B,$0C,$0C,$0D,$0D,$0E,$0F,$0F,$10,$10,$11,$12,$12,$13,$13,$14,$14,$14
DB $14,$14,$14,$13,$13,$12,$12,$11,$10,$10,$0F,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$07,$07,$07
DB $07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0E,$0E,$0F,$10,$10,$11,$11,$11,$12,$12,$12,$12
DB $12,$12,$12,$12,$11,$11,$11,$10,$10,$0F,$0E,$0E,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07
DB $07,$07,$07,$08,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0E,$0E,$0F,$0F,$10,$10,$10,$11,$11,$11,$11
DB $11,$11,$11,$11,$10,$10,$10,$0F,$0F,$0E,$0E,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07
DB $07,$07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$09,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0E,$0E,$0E,$0F,$0F,$0F,$10,$10,$10,$10
DB $10,$10,$10,$10,$0F,$0F,$0F,$0E,$0E,$0E,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0D,$0E,$0E,$0E,$0E,$0F,$0F,$0F,$0F
DB $0F,$0F,$0F,$0F,$0E,$0E,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0C,$0C,$0C,$0D,$0D,$0D,$0D,$0E,$0E,$0E,$0E,$0E
DB $0E,$0E,$0E,$0E,$0E,$0D,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07
DB $07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0C,$0C,$0C,$0C,$0D,$0D,$0D,$0D,$0D,$0D,$0D
DB $0D,$0D,$0D,$0D,$0D,$0D,$0D,$0C,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07
DB $06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0B,$0C,$0C,$0C,$0C,$0C,$0C,$0D,$0D,$0D
DB $0D,$0D,$0D,$0C,$0C,$0C,$0C,$0C,$0C,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06
DB $06,$06,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0B,$0B,$0C,$0C,$0C,$0C,$0C,$0C
DB $0C,$0C,$0C,$0C,$0C,$0C,$0B,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$06,$06
DB $06,$06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B
DB $0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06,$06
DB $06,$06,$06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0A,$0A,$0B,$0B,$0B,$0B,$0B,$0B
DB $0B,$0B,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06,$06,$06
DB $06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A
DB $0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$09,$0A,$0A,$0A,$0A,$0A,$0A,$0A
DB $0A,$0A,$0A,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$0A,$0A
DB $0A,$0A,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$09,$09,$09,$09
DB $09,$09,$09,$09,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$08,$09,$09,$09,$09,$09,$09,$09
DB $09,$09,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06
DB $06,$06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08
DB $08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06,$06
DB $05,$06,$06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08
DB $08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06,$06,$05
DB $05,$05,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08,$08,$08,$08,$08
DB $08,$08,$08,$08,$08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$05,$05
DB $05,$05,$05,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$08,$08,$08,$08,$08,$08
DB $08,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$05,$05,$05

	SECTION "TUNNEL_DATA_ANGLE",ROMX[$5000],BANK[3]

tunnel_angle:
DB $18,$17,$17,$17,$17,$17,$16,$16,$16,$16,$16,$15,$15,$15,$15,$14,$14,$14,$14,$13,$13,$13,$12,$12,$12,$12,$11,$11,$11,$10,$10,$10
DB $0F,$0F,$0F,$0E,$0E,$0E,$0D,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08
DB $18,$18,$17,$17,$17,$17,$17,$16,$16,$16,$16,$16,$15,$15,$15,$15,$14,$14,$14,$13,$13,$13,$13,$12,$12,$12,$11,$11,$11,$10,$10,$10
DB $0F,$0F,$0F,$0E,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$07
DB $18,$18,$18,$17,$17,$17,$17,$17,$16,$16,$16,$16,$15,$15,$15,$15,$14,$14,$14,$14,$13,$13,$13,$12,$12,$12,$11,$11,$11,$10,$10,$10
DB $0F,$0F,$0F,$0E,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$07,$07
DB $18,$18,$18,$18,$17,$17,$17,$17,$17,$16,$16,$16,$16,$15,$15,$15,$15,$14,$14,$14,$13,$13,$13,$12,$12,$12,$11,$11,$11,$10,$10,$10
DB $0F,$0F,$0F,$0E,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$08,$08,$07,$07,$07
DB $18,$18,$18,$18,$18,$17,$17,$17,$17,$16,$16,$16,$16,$16,$15,$15,$15,$14,$14,$14,$14,$13,$13,$13,$12,$12,$12,$11,$11,$10,$10,$10
DB $0F,$0F,$0F,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07
DB $18,$18,$18,$18,$18,$18,$17,$17,$17,$17,$16,$16,$16,$16,$15,$15,$15,$15,$14,$14,$14,$13,$13,$13,$12,$12,$12,$11,$11,$10,$10,$10
DB $0F,$0F,$0F,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07
DB $19,$18,$18,$18,$18,$18,$18,$17,$17,$17,$17,$16,$16,$16,$16,$15,$15,$15,$14,$14,$14,$13,$13,$13,$12,$12,$12,$11,$11,$10,$10,$10
DB $0F,$0F,$0F,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$06
DB $19,$19,$18,$18,$18,$18,$18,$18,$17,$17,$17,$17,$16,$16,$16,$16,$15,$15,$15,$14,$14,$14,$13,$13,$13,$12,$12,$11,$11,$11,$10,$10
DB $0F,$0F,$0E,$0E,$0E,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$06,$06
DB $19,$19,$19,$18,$18,$18,$18,$18,$18,$17,$17,$17,$17,$16,$16,$16,$15,$15,$15,$14,$14,$14,$13,$13,$13,$12,$12,$11,$11,$11,$10,$10
DB $0F,$0F,$0E,$0E,$0E,$0D,$0D,$0C,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$07,$06,$06,$06
DB $19,$19,$19,$19,$19,$18,$18,$18,$18,$18,$17,$17,$17,$17,$16,$16,$16,$15,$15,$15,$14,$14,$14,$13,$13,$12,$12,$12,$11,$11,$10,$10
DB $0F,$0F,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$08,$07,$07,$07,$07,$06,$06,$06,$06,$06
DB $19,$19,$19,$19,$19,$19,$18,$18,$18,$18,$18,$17,$17,$17,$16,$16,$16,$16,$15,$15,$15,$14,$14,$13,$13,$12,$12,$12,$11,$11,$10,$10
DB $0F,$0F,$0E,$0E,$0D,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06
DB $1A,$19,$19,$19,$19,$19,$19,$18,$18,$18,$18,$18,$17,$17,$17,$16,$16,$16,$15,$15,$15,$14,$14,$14,$13,$13,$12,$12,$11,$11,$10,$10
DB $0F,$0F,$0E,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$06,$06,$06,$06,$06,$06,$05
DB $1A,$1A,$1A,$19,$19,$19,$19,$19,$18,$18,$18,$18,$18,$17,$17,$17,$16,$16,$16,$15,$15,$15,$14,$14,$13,$13,$12,$12,$11,$11,$10,$10
DB $0F,$0F,$0E,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$06,$06,$06,$06,$06,$05,$05,$05
DB $1A,$1A,$1A,$1A,$19,$19,$19,$19,$19,$18,$18,$18,$18,$18,$17,$17,$17,$16,$16,$16,$15,$15,$14,$14,$13,$13,$12,$12,$11,$11,$10,$10
DB $0F,$0F,$0E,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$08,$07,$07,$07,$07,$06,$06,$06,$06,$06,$05,$05,$05,$05
DB $1A,$1A,$1A,$1A,$1A,$1A,$19,$19,$19,$19,$19,$18,$18,$18,$18,$17,$17,$17,$16,$16,$15,$15,$15,$14,$14,$13,$13,$12,$12,$11,$10,$10
DB $0F,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$0A,$09,$09,$08,$08,$08,$08,$07,$07,$07,$06,$06,$06,$06,$06,$05,$05,$05,$05,$05,$05
DB $1B,$1A,$1A,$1A,$1A,$1A,$1A,$19,$19,$19,$19,$19,$18,$18,$18,$18,$17,$17,$16,$16,$16,$15,$15,$14,$14,$13,$13,$12,$12,$11,$10,$10
DB $0F,$0F,$0E,$0D,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$07,$07,$07,$06,$06,$06,$06,$06,$05,$05,$05,$05,$05,$05,$04
DB $1B,$1B,$1B,$1A,$1A,$1A,$1A,$1A,$1A,$19,$19,$19,$19,$18,$18,$18,$18,$17,$17,$16,$16,$16,$15,$15,$14,$14,$13,$12,$12,$11,$10,$10
DB $0F,$0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$0A,$09,$09,$09,$08,$08,$08,$07,$07,$07,$06,$06,$06,$06,$05,$05,$05,$05,$05,$05,$04,$04,$04
DB $1B,$1B,$1B,$1B,$1B,$1A,$1A,$1A,$1A,$1A,$19,$19,$19,$19,$18,$18,$18,$18,$17,$17,$16,$16,$15,$15,$14,$14,$13,$13,$12,$11,$11,$10
DB $0F,$0E,$0E,$0D,$0C,$0C,$0B,$0B,$0A,$0A,$09,$09,$08,$08,$08,$07,$07,$07,$06,$06,$06,$06,$05,$05,$05,$05,$05,$04,$04,$04,$04,$04
DB $1B,$1B,$1B,$1B,$1B,$1B,$1B,$1A,$1A,$1A,$1A,$1A,$19,$19,$19,$19,$18,$18,$18,$17,$17,$16,$16,$15,$15,$14,$13,$13,$12,$11,$11,$10
DB $0F,$0E,$0E,$0D,$0C,$0C,$0B,$0A,$0A,$09,$09,$08,$08,$08,$07,$07,$06,$06,$06,$06,$05,$05,$05,$05,$05,$04,$04,$04,$04,$04,$04,$04
DB $1C,$1C,$1B,$1B,$1B,$1B,$1B,$1B,$1B,$1A,$1A,$1A,$1A,$19,$19,$19,$19,$18,$18,$18,$17,$17,$16,$16,$15,$14,$14,$13,$12,$12,$11,$10
DB $0F,$0E,$0D,$0D,$0C,$0B,$0B,$0A,$09,$09,$08,$08,$08,$07,$07,$06,$06,$06,$06,$05,$05,$05,$05,$04,$04,$04,$04,$04,$04,$04,$03,$03
DB $1C,$1C,$1C,$1C,$1B,$1B,$1B,$1B,$1B,$1B,$1A,$1A,$1A,$1A,$1A,$19,$19,$19,$18,$18,$18,$17,$17,$16,$15,$15,$14,$13,$13,$12,$11,$10
DB $0F,$0E,$0D,$0C,$0C,$0B,$0A,$0A,$09,$08,$08,$08,$07,$07,$06,$06,$06,$05,$05,$05,$05,$05,$04,$04,$04,$04,$04,$04,$03,$03,$03,$03
DB $1C,$1C,$1C,$1C,$1C,$1C,$1C,$1B,$1B,$1B,$1B,$1B,$1A,$1A,$1A,$1A,$19,$19,$19,$18,$18,$18,$17,$16,$16,$15,$14,$14,$13,$12,$11,$10
DB $0F,$0E,$0D,$0C,$0B,$0B,$0A,$09,$09,$08,$08,$07,$07,$06,$06,$06,$05,$05,$05,$05,$04,$04,$04,$04,$04,$03,$03,$03,$03,$03,$03,$03
DB $1D,$1C,$1C,$1C,$1C,$1C,$1C,$1C,$1C,$1B,$1B,$1B,$1B,$1B,$1A,$1A,$1A,$1A,$19,$19,$18,$18,$18,$17,$16,$16,$15,$14,$13,$12,$11,$10
DB $0F,$0E,$0D,$0C,$0B,$0A,$09,$09,$08,$08,$07,$07,$06,$06,$05,$05,$05,$05,$04,$04,$04,$04,$04,$03,$03,$03,$03,$03,$03,$03,$03,$02
DB $1D,$1D,$1D,$1D,$1C,$1C,$1C,$1C,$1C,$1C,$1C,$1B,$1B,$1B,$1B,$1B,$1A,$1A,$1A,$19,$19,$19,$18,$18,$17,$16,$15,$14,$13,$12,$11,$10
DB $0F,$0E,$0D,$0C,$0B,$0A,$09,$08,$08,$07,$06,$06,$06,$05,$05,$05,$04,$04,$04,$04,$04,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02
DB $1D,$1D,$1D,$1D,$1D,$1D,$1D,$1C,$1C,$1C,$1C,$1C,$1C,$1C,$1B,$1B,$1B,$1B,$1A,$1A,$1A,$19,$19,$18,$18,$17,$16,$15,$14,$13,$12,$10
DB $0F,$0D,$0C,$0B,$0A,$09,$08,$08,$07,$06,$06,$05,$05,$05,$04,$04,$04,$04,$03,$03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$02
DB $1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1C,$1C,$1C,$1C,$1C,$1B,$1B,$1B,$1B,$1A,$1A,$19,$19,$18,$18,$17,$16,$15,$13,$12,$10
DB $0F,$0D,$0C,$0A,$09,$08,$08,$07,$06,$06,$05,$05,$04,$04,$04,$04,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $1E,$1E,$1E,$1E,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1C,$1C,$1C,$1C,$1C,$1B,$1B,$1B,$1A,$1A,$19,$18,$18,$16,$15,$14,$12,$10
DB $0F,$0D,$0B,$0A,$09,$08,$07,$06,$05,$05,$04,$04,$04,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01
DB $1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1C,$1C,$1C,$1C,$1B,$1B,$1B,$1A,$19,$19,$18,$16,$15,$13,$11
DB $0E,$0C,$0A,$09,$08,$06,$06,$05,$04,$04,$04,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1D,$1D,$1D,$1D,$1D,$1D,$1C,$1C,$1C,$1C,$1B,$1A,$1A,$19,$18,$16,$14,$11
DB $0E,$0B,$09,$08,$06,$05,$05,$04,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01
DB $1F,$1F,$1F,$1F,$1F,$1F,$1F,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1D,$1D,$1D,$1D,$1D,$1C,$1C,$1B,$1A,$19,$18,$15,$12
DB $0D,$0A,$08,$06,$05,$04,$03,$03,$02,$02,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00
DB $1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1E,$1E,$1E,$1E,$1E,$1E,$1E,$1D,$1D,$1D,$1C,$1B,$1A,$18,$13
DB $0C,$08,$05,$04,$03,$02,$02,$02,$01,$01,$01,$01,$01,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1E,$1E,$1D,$1C,$18
DB $08,$03,$02,$01,$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$21,$21,$22,$23,$28
DB $38,$3C,$3D,$3E,$3E,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F
DB $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$21,$21,$21,$21,$21,$21,$21,$22,$22,$22,$23,$24,$25,$28,$2C
DB $33,$38,$3A,$3B,$3C,$3D,$3D,$3D,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F
DB $20,$20,$20,$20,$20,$20,$20,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$22,$22,$22,$22,$22,$23,$23,$24,$25,$26,$28,$2A,$2D
DB $32,$35,$38,$39,$3A,$3B,$3C,$3C,$3D,$3D,$3D,$3D,$3D,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3F,$3F,$3F,$3F,$3F,$3F,$3F
DB $21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$21,$22,$22,$22,$22,$22,$22,$23,$23,$23,$23,$24,$25,$25,$26,$28,$29,$2B,$2E
DB $31,$34,$36,$38,$39,$3A,$3A,$3B,$3C,$3C,$3C,$3C,$3D,$3D,$3D,$3D,$3D,$3D,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E
DB $21,$21,$21,$21,$21,$21,$21,$21,$21,$22,$22,$22,$22,$22,$22,$22,$22,$23,$23,$23,$23,$24,$24,$24,$25,$26,$26,$28,$29,$2A,$2C,$2E
DB $31,$33,$35,$36,$38,$39,$39,$3A,$3B,$3B,$3B,$3C,$3C,$3C,$3C,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3E
DB $21,$21,$21,$21,$22,$22,$22,$22,$22,$22,$22,$22,$22,$22,$23,$23,$23,$23,$23,$24,$24,$24,$25,$25,$26,$27,$28,$29,$2A,$2B,$2D,$2F
DB $30,$32,$34,$35,$36,$38,$38,$39,$3A,$3A,$3B,$3B,$3B,$3C,$3C,$3C,$3C,$3C,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3E,$3E,$3E,$3E
DB $22,$22,$22,$22,$22,$22,$22,$22,$22,$22,$22,$23,$23,$23,$23,$23,$24,$24,$24,$24,$25,$25,$26,$26,$27,$28,$28,$29,$2A,$2C,$2D,$2F
DB $30,$32,$33,$35,$36,$37,$38,$38,$39,$39,$3A,$3A,$3B,$3B,$3B,$3B,$3C,$3C,$3C,$3C,$3C,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3D
DB $22,$22,$22,$22,$22,$22,$22,$23,$23,$23,$23,$23,$23,$23,$24,$24,$24,$24,$25,$25,$25,$26,$26,$27,$28,$28,$29,$2A,$2B,$2C,$2D,$2F
DB $30,$32,$33,$34,$35,$36,$37,$38,$38,$39,$39,$3A,$3A,$3A,$3B,$3B,$3B,$3B,$3C,$3C,$3C,$3C,$3C,$3C,$3C,$3D,$3D,$3D,$3D,$3D,$3D,$3D
DB $22,$22,$22,$22,$23,$23,$23,$23,$23,$23,$23,$24,$24,$24,$24,$24,$25,$25,$25,$26,$26,$26,$27,$28,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F
DB $30,$31,$32,$33,$34,$35,$36,$37,$38,$38,$39,$39,$39,$3A,$3A,$3A,$3B,$3B,$3B,$3B,$3B,$3C,$3C,$3C,$3C,$3C,$3C,$3C,$3D,$3D,$3D,$3D
DB $22,$23,$23,$23,$23,$23,$23,$23,$23,$24,$24,$24,$24,$24,$25,$25,$25,$25,$26,$26,$27,$27,$28,$28,$29,$29,$2A,$2B,$2C,$2D,$2E,$2F
DB $30,$31,$32,$33,$34,$35,$36,$36,$37,$38,$38,$38,$39,$39,$3A,$3A,$3A,$3A,$3B,$3B,$3B,$3B,$3B,$3C,$3C,$3C,$3C,$3C,$3C,$3C,$3C,$3D
DB $23,$23,$23,$23,$23,$23,$23,$24,$24,$24,$24,$24,$25,$25,$25,$25,$26,$26,$26,$27,$27,$28,$28,$29,$29,$2A,$2B,$2B,$2C,$2D,$2E,$2F
DB $30,$31,$32,$33,$34,$34,$35,$36,$36,$37,$38,$38,$38,$39,$39,$39,$3A,$3A,$3A,$3A,$3B,$3B,$3B,$3B,$3B,$3C,$3C,$3C,$3C,$3C,$3C,$3C
DB $23,$23,$23,$23,$24,$24,$24,$24,$24,$24,$25,$25,$25,$25,$25,$26,$26,$26,$27,$27,$28,$28,$28,$29,$2A,$2A,$2B,$2C,$2C,$2D,$2E,$2F
DB $30,$31,$32,$33,$33,$34,$35,$35,$36,$37,$37,$38,$38,$38,$39,$39,$39,$3A,$3A,$3A,$3A,$3A,$3B,$3B,$3B,$3B,$3B,$3B,$3C,$3C,$3C,$3C
DB $23,$23,$24,$24,$24,$24,$24,$24,$24,$25,$25,$25,$25,$26,$26,$26,$26,$27,$27,$28,$28,$28,$29,$29,$2A,$2B,$2B,$2C,$2D,$2D,$2E,$2F
DB $30,$31,$32,$32,$33,$34,$34,$35,$36,$36,$37,$37,$38,$38,$38,$39,$39,$39,$39,$3A,$3A,$3A,$3A,$3B,$3B,$3B,$3B,$3B,$3B,$3B,$3C,$3C
DB $24,$24,$24,$24,$24,$24,$24,$25,$25,$25,$25,$25,$26,$26,$26,$26,$27,$27,$28,$28,$28,$29,$29,$2A,$2A,$2B,$2C,$2C,$2D,$2E,$2E,$2F
DB $30,$31,$31,$32,$33,$33,$34,$35,$35,$36,$36,$37,$37,$38,$38,$38,$39,$39,$39,$39,$3A,$3A,$3A,$3A,$3A,$3B,$3B,$3B,$3B,$3B,$3B,$3B
DB $24,$24,$24,$24,$24,$25,$25,$25,$25,$25,$26,$26,$26,$26,$27,$27,$27,$28,$28,$28,$29,$29,$2A,$2A,$2B,$2B,$2C,$2C,$2D,$2E,$2E,$2F
DB $30,$31,$31,$32,$33,$33,$34,$34,$35,$35,$36,$36,$37,$37,$38,$38,$38,$38,$39,$39,$39,$39,$3A,$3A,$3A,$3A,$3A,$3B,$3B,$3B,$3B,$3B
DB $24,$24,$24,$25,$25,$25,$25,$25,$25,$26,$26,$26,$26,$27,$27,$27,$28,$28,$28,$29,$29,$29,$2A,$2A,$2B,$2B,$2C,$2D,$2D,$2E,$2F,$2F
DB $30,$30,$31,$32,$32,$33,$34,$34,$35,$35,$36,$36,$36,$37,$37,$38,$38,$38,$38,$39,$39,$39,$39,$3A,$3A,$3A,$3A,$3A,$3A,$3B,$3B,$3B
DB $24,$25,$25,$25,$25,$25,$25,$26,$26,$26,$26,$26,$27,$27,$27,$28,$28,$28,$29,$29,$29,$2A,$2A,$2B,$2B,$2C,$2C,$2D,$2D,$2E,$2F,$2F
DB $30,$30,$31,$32,$32,$33,$33,$34,$34,$35,$35,$36,$36,$36,$37,$37,$38,$38,$38,$38,$39,$39,$39,$39,$39,$3A,$3A,$3A,$3A,$3A,$3A,$3B
DB $25,$25,$25,$25,$25,$25,$26,$26,$26,$26,$26,$27,$27,$27,$28,$28,$28,$28,$29,$29,$2A,$2A,$2A,$2B,$2B,$2C,$2C,$2D,$2D,$2E,$2F,$2F
DB $30,$30,$31,$32,$32,$33,$33,$34,$34,$35,$35,$35,$36,$36,$37,$37,$37,$38,$38,$38,$38,$39,$39,$39,$39,$39,$3A,$3A,$3A,$3A,$3A,$3A
DB $25,$25,$25,$25,$26,$26,$26,$26,$26,$27,$27,$27,$27,$28,$28,$28,$28,$29,$29,$29,$2A,$2A,$2B,$2B,$2C,$2C,$2D,$2D,$2E,$2E,$2F,$2F
DB $30,$30,$31,$31,$32,$32,$33,$33,$34,$34,$35,$35,$36,$36,$36,$37,$37,$37,$38,$38,$38,$38,$38,$39,$39,$39,$39,$39,$3A,$3A,$3A,$3A
DB $25,$25,$25,$26,$26,$26,$26,$26,$27,$27,$27,$27,$28,$28,$28,$28,$29,$29,$29,$2A,$2A,$2A,$2B,$2B,$2C,$2C,$2D,$2D,$2E,$2E,$2F,$2F
DB $30,$30,$31,$31,$32,$32,$33,$33,$34,$34,$35,$35,$35,$36,$36,$36,$37,$37,$37,$38,$38,$38,$38,$38,$39,$39,$39,$39,$39,$3A,$3A,$3A
DB $25,$26,$26,$26,$26,$26,$26,$27,$27,$27,$27,$28,$28,$28,$28,$29,$29,$29,$2A,$2A,$2A,$2B,$2B,$2B,$2C,$2C,$2D,$2D,$2E,$2E,$2F,$2F
DB $30,$30,$31,$31,$32,$32,$33,$33,$34,$34,$34,$35,$35,$35,$36,$36,$36,$37,$37,$37,$38,$38,$38,$38,$38,$39,$39,$39,$39,$39,$39,$3A
DB $26,$26,$26,$26,$26,$26,$27,$27,$27,$27,$28,$28,$28,$28,$29,$29,$29,$29,$2A,$2A,$2A,$2B,$2B,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2F,$2F
DB $30,$30,$31,$31,$32,$32,$32,$33,$33,$34,$34,$35,$35,$35,$36,$36,$36,$36,$37,$37,$37,$38,$38,$38,$38,$38,$39,$39,$39,$39,$39,$39
DB $26,$26,$26,$26,$26,$27,$27,$27,$27,$28,$28,$28,$28,$28,$29,$29,$29,$2A,$2A,$2A,$2B,$2B,$2B,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2F,$2F
DB $30,$30,$31,$31,$32,$32,$32,$33,$33,$34,$34,$34,$35,$35,$35,$36,$36,$36,$37,$37,$37,$37,$38,$38,$38,$38,$38,$39,$39,$39,$39,$39
DB $26,$26,$26,$27,$27,$27,$27,$27,$28,$28,$28,$28,$28,$29,$29,$29,$2A,$2A,$2A,$2B,$2B,$2B,$2C,$2C,$2C,$2D,$2D,$2E,$2E,$2E,$2F,$2F
DB $30,$30,$31,$31,$31,$32,$32,$33,$33,$33,$34,$34,$34,$35,$35,$35,$36,$36,$36,$37,$37,$37,$37,$38,$38,$38,$38,$38,$38,$39,$39,$39
DB $26,$26,$27,$27,$27,$27,$27,$28,$28,$28,$28,$28,$29,$29,$29,$29,$2A,$2A,$2A,$2B,$2B,$2B,$2C,$2C,$2C,$2D,$2D,$2E,$2E,$2E,$2F,$2F
DB $30,$30,$31,$31,$31,$32,$32,$33,$33,$33,$34,$34,$34,$35,$35,$35,$36,$36,$36,$36,$37,$37,$37,$37,$38,$38,$38,$38,$38,$38,$39,$39
DB $26,$27,$27,$27,$27,$27,$28,$28,$28,$28,$28,$29,$29,$29,$29,$2A,$2A,$2A,$2B,$2B,$2B,$2C,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2F,$2F,$2F
DB $30,$30,$30,$31,$31,$32,$32,$32,$33,$33,$33,$34,$34,$34,$35,$35,$35,$36,$36,$36,$36,$37,$37,$37,$37,$38,$38,$38,$38,$38,$38,$39
DB $27,$27,$27,$27,$27,$28,$28,$28,$28,$28,$29,$29,$29,$29,$2A,$2A,$2A,$2A,$2B,$2B,$2B,$2C,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2F,$2F,$2F
DB $30,$30,$30,$31,$31,$32,$32,$32,$33,$33,$33,$34,$34,$34,$35,$35,$35,$35,$36,$36,$36,$36,$37,$37,$37,$37,$38,$38,$38,$38,$38,$38
DB $27,$27,$27,$27,$28,$28,$28,$28,$28,$29,$29,$29,$29,$29,$2A,$2A,$2A,$2B,$2B,$2B,$2B,$2C,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2F,$2F,$2F
DB $30,$30,$30,$31,$31,$32,$32,$32,$33,$33,$33,$34,$34,$34,$34,$35,$35,$35,$36,$36,$36,$36,$36,$37,$37,$37,$37,$38,$38,$38,$38,$38
DB $27,$27,$27,$28,$28,$28,$28,$28,$28,$29,$29,$29,$29,$2A,$2A,$2A,$2A,$2B,$2B,$2B,$2C,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2E,$2F,$2F,$2F
DB $30,$30,$30,$31,$31,$31,$32,$32,$32,$33,$33,$33,$34,$34,$34,$35,$35,$35,$35,$36,$36,$36,$36,$37,$37,$37,$37,$37,$38,$38,$38,$38
DB $27,$27,$28,$28,$28,$28,$28,$28,$29,$29,$29,$29,$2A,$2A,$2A,$2A,$2B,$2B,$2B,$2B,$2C,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2E,$2F,$2F,$2F
DB $30,$30,$30,$31,$31,$31,$32,$32,$32,$33,$33,$33,$34,$34,$34,$34,$35,$35,$35,$35,$36,$36,$36,$36,$37,$37,$37,$37,$37,$38,$38,$38
DB $27,$28,$28,$28,$28,$28,$28,$29,$29,$29,$29,$29,$2A,$2A,$2A,$2A,$2B,$2B,$2B,$2C,$2C,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2E,$2F,$2F,$2F
DB $30,$30,$30,$31,$31,$31,$32,$32,$32,$33,$33,$33,$33,$34,$34,$34,$35,$35,$35,$35,$36,$36,$36,$36,$36,$37,$37,$37,$37,$37,$38,$38
DB $28,$28,$28,$28,$28,$28,$29,$29,$29,$29,$29,$2A,$2A,$2A,$2A,$2B,$2B,$2B,$2B,$2C,$2C,$2C,$2D,$2D,$2D,$2D,$2E,$2E,$2E,$2F,$2F,$2F
DB $30,$30,$30,$31,$31,$31,$32,$32,$32,$32,$33,$33,$33,$34,$34,$34,$34,$35,$35,$35,$35,$36,$36,$36,$36,$36,$37,$37,$37,$37,$37,$38

;-------------------------------------------------------------------------------------------------

	SECTION	"Tunnel_Vars",BSS

; ---------------------------

tunnel_exit_demo:	DS	1 ; set to 1 to exit this effect
tunnel_event_count:	DS	2
tunnel_current_event:	DS	2 ; pointer to the next event

tunnel_has_to_refresh_oam:	DS	1
tunnel_has_to_update_bgs_dma:	DS	1

tunnel_angle_increment:	DS	1 ; add to angle
tunnel_distance_increment:	DS	1 ; add to distance
tunnel_angle_increment_speed:	DS	1 ; add to tunnel_angle_increment
tunnel_distance_increment_speed:	DS	1 ; add to tunnel_distance_increment

tunnel_x_increment:	DS	1 ; add to x
tunnel_y_increment:	DS	1 ; add to y
tunnel_x_increment_speed:	DS	1 ; add to tunnel_x_increment
tunnel_y_increment_speed:	DS	1 ; add to tunnel_y_increment

tunnel_temp_rSCX:	DS	1 ; saved for the moment of the map update
tunnel_temp_rSCY:	DS	1 ; saved for the moment of the map update

tunnel_window_increment:	DS	1 ; value to add to WX and WY each frame

tunnel_temp_distances:	DS	4
tunnel_temp_angles:		DS	4

;-------------------------------------------------------------------------------------------------

	SECTION "Tunnel", CODE, BANK[3]

;----------------------------------------------

tunnel_init_variables:

	ld	a,0
	ld	[tunnel_exit_demo],a
	
	ld	[tunnel_has_to_update_bgs_dma],a
	ld	[tunnel_has_to_refresh_oam],a
	
	ld	[tunnel_x_increment],a
	ld	[tunnel_y_increment],a
	ld	[tunnel_temp_rSCX],a
	ld	[tunnel_temp_rSCY],a
	ld	[tunnel_distance_increment],a
	ld	[tunnel_angle_increment],a
	
	ld	a,2
	ld	[tunnel_x_increment_speed],a
	ld	a,1
	ld	[tunnel_y_increment_speed],a
	ld	a,2
	ld	[tunnel_angle_increment_speed],a
	ld	a,1
	ld	[tunnel_distance_increment_speed],a
	
	ld	a,0
	ld	[tunnel_event_count],a
	ld	[tunnel_event_count+1],a
	
	ld	a,0
	ld	[tunnel_window_increment],a
	ld	[rWX],a
	ld	[rWY],a
	
	ld	hl,_event_table_tunnel
	ld	a,h
	ld	[tunnel_current_event],a
	ld	a,l
	ld	[tunnel_current_event+1],a

	ret

;----------------------------------------------

_event_exit_tunnel_demo:
	ld	a,1
	ld	[tunnel_exit_demo],a
	ret

_event_tunnel_window_hide:
	ld	a,2
	ld	[tunnel_window_increment],a
	ret

_event_tunnel_window_show:
	ld	a,-2
	ld	[tunnel_window_increment],a
	ret

_event_tunnel_window_stop:
	ld	a,0
	ld	[tunnel_window_increment],a
	ret

;-------------------

_event_table_tunnel:

	DW	1,_event_tunnel_window_hide
	DW	19,_event_tunnel_window_stop
	
	DW	164,_event_tunnel_window_show
	DW	182,_event_tunnel_window_stop
	DW	183,_event_exit_tunnel_demo
	
	DW	$FFFF,$0000 ; No more events! Don't remove this line!

;----------------------------------------------

tunnel_handle_events:
	
	; Handle events
	; -------------
	
	ld	a,[tunnel_event_count]
	ld	e,a
	ld	a,[tunnel_event_count+1]
	ld	d,a
	
	; Start of checking
	
	ld	a,[tunnel_current_event]
	ld	h,a
	ld	a,[tunnel_current_event+1]
	ld	l,a
	
	ld	c,[hl]
	inc hl
	ld	b,[hl] ; bc = event counter trigger
	ld	a,c
	and	a,b
	cp	a,$FF ; if both are $FF, exit checking
	jr	z,._exit_check_events
	
	ld	a,d
	cp	a,b
	jr	nz,._exit_check_events
	
	ld	a,e
	cp	a,c
	jr	nz,._exit_check_events
	
	inc	hl
	
	ld	c,[hl]
	inc hl
	ld	b,[hl] ; bc = ptr to function
	inc	hl ; hl = ptr to next event
	
	ld	a,h
	ld	[tunnel_current_event],a
	ld	a,l
	ld	[tunnel_current_event+1],a ; save pointer to next event
	
	ld	h,b
	ld	l,c ; hl = ptr to function
	
	call	._call_event_function
	jr	._exit_check_events
	
._call_event_function
	jp	hl

._exit_check_events

	; Now, handle functions...
	; ------------------------
	
	; More checks here
	
	; ...
	
	; Increase counter
	; ----------------
	
	ld	a,[tunnel_event_count]
	ld	l,a
	ld	a,[tunnel_event_count+1]
	ld	h,a
	
	inc	hl
	
	ld	a,l
	ld	[tunnel_event_count],a
	ld	a,h
	ld	[tunnel_event_count+1],a
	
	ret

;----------------------------------------------

tunnel_palettes_load:

	ld	hl,tunnel_palettes
	
	ld	a,$80 ; auto increment
	ld	[rBCPS],a
	
	ld	c,(rBCPD&$FF)
	REPT	4*8
	ld	a,[hl+]
	ld	[$FF00+c],a
	ld	a,[hl+]
	ld	[$FF00+c],a
	ENDR
	
	; -------
	
	ld	hl,tunnel_sprites_palette
	
	ld	a,$80 ; auto increment
	ld	[rOCPS],a
	
	ld	c,(rOCPD&$FF)
	REPT	4
	ld	a,[hl+]
	ld	[$FF00+c],a
	ld	a,[hl+]
	ld	[$FF00+c],a
	ENDR
	
	ret

;----------------------------------------------

TUNNEL_SET_TILE: MACRO ; b = x, c = y, a = tile
	
	ld	d,MAP_TEMP >> 8
	ld	e,b ; de = base + x
	
	ld	l,c
	ld	h,$00 ; hl = y
	
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl ; hl = y * 32
	
	add	hl,de ; hl = base + x + (y * 32)
	
	ld	[hl],a

ENDM

;-------------------------------------------------------------------------------------

tunnel_map_update_scroll:

	ld	a,[tunnel_temp_rSCX]
	ld	[rSCX],a
	
	ld	a,[tunnel_temp_rSCY]
	ld	[rSCY],a
	
	ret

;---------------------------------

tunnel_map_handle:
	
	ld	a,[tunnel_has_to_update_bgs_dma]
	and	a,a
	jr	z,.continue ; wait until last frame is copied
	
	halt
	jr	tunnel_map_handle
	
.continue:

	; Calculate effect
	; ----------------
	
	ld	a,[tunnel_y_increment]
	sra	a
	sra	a
	sra	a
	ld	c,a ; c = min y
	add	a,18+1
	ld	e,a ; e = max y
.loopy
	ld	a,[tunnel_x_increment]
	sra	a
	sra	a
	sra	a
	ld	b,a ; b = min x
	add	a,20+1
	ld	d,a ; d = max x
.loopx
	push	de ; de first!!!!
	push	bc
	
	;----
	
	; Get 4 subtiles
	
	sla	b
	sla	c
	
	ld	e,b
	
	ld	l,c
	ld	h,0
	
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	
	push	hl
	push	de
	
	; Calculate distances
	
	ld	d,tunnel_distance>>8
	add	hl,de
	
	ld	a,[tunnel_distance_increment]
	ld	c,a ; c = tunnel_distance_increment
	ld	b,31
	
	ld	a,[hl+]
	add	a,c
	and	a,b
	ld	[tunnel_temp_distances+0],a
	
	ld	a,[hl]
	add	a,c
	and	a,b
	ld	[tunnel_temp_distances+1],a
	
	ld	de,64-1
	add	hl,de
	
	ld	a,[hl+]
	add	a,c
	and	a,b
	ld	[tunnel_temp_distances+2],a
	
	ld	a,[hl]
	add	a,c
	and	a,b
	ld	[tunnel_temp_distances+3],a
	
	; Calculate angles
	
	pop	de
	pop	hl
	
	ld	d,tunnel_angle>>8
	add	hl,de
	
	ld	a,[tunnel_angle_increment]
	ld	c,a ; c = tunnel_angle_increment
	;ld	b,31
	
	ld	a,[hl+]
	add	a,c
	and	a,b
	ld	[tunnel_temp_angles+0],a
	
	ld	a,[hl]
	add	a,c
	and	a,b
	ld	[tunnel_temp_angles+1],a
	
	ld	de,64-1
	add	hl,de
	
	ld	a,[hl+]
	add	a,c
	and	a,b
	ld	[tunnel_temp_angles+2],a
	
	ld	a,[hl]
	add	a,c
	and	a,b
	ld	[tunnel_temp_angles+3],a

	; Get texture coordinate from distance and angle
	
	; Distance -> Y -> b
	; Angle -> X -> a
	
	; Subtile 1
	
	ld	d,tunnel_texture>>8
	ld	a,[tunnel_temp_angles+0]
	ld	e,a
	
	ld	h,0
	ld	a,[tunnel_temp_distances+0]
	ld	l,a
	
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	
	add	hl,de
	
	ld	b,[hl] ; b = subtile1
	
	; Subtile 2
	
	;ld	d,tunnel_texture>>8
	ld	a,[tunnel_temp_angles+1]
	ld	e,a
	
	ld	h,0
	ld	a,[tunnel_temp_distances+1]
	ld	l,a
	
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	
	add	hl,de
	
	ld	a,[hl] ; a = subtile2
	rla
	rla
	or	a,b
	ld	b,a ; b = subtile1 | (subtile2<<2)

	; Subtile 3
	
	;ld	d,tunnel_texture>>8
	ld	a,[tunnel_temp_angles+2]
	ld	e,a
	
	ld	h,0
	ld	a,[tunnel_temp_distances+2]
	ld	l,a
	
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	
	add	hl,de
	
	ld	a,[hl] ; a = subtile3
	swap	a
	or	a,b
	ld	b,a ; b = subtile1 | (subtile2<<2) | (subtile3<<4)

	; Subtile 4
	
	;ld	d,tunnel_texture>>8
	ld	a,[tunnel_temp_angles+3]
	ld	e,a
	
	ld	h,0
	ld	a,[tunnel_temp_distances+3]
	ld	l,a
	
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	
	add	hl,de
	
	ld	a,[hl] ; a = subtile4
	rrca
	rrca
	or	a,b ; a = subtile1 | (subtile2<<2) | (subtile3<<4) | (subtile4<<6)

	; Write tile to temp buffer
	
	pop	bc
	push	bc

	TUNNEL_SET_TILE
	
	;----
	
	pop	bc
	pop	de
	
	inc	b
	ld	a,d
	cp	a,b
	jp	nz,.loopx
	
	inc	c
	ld	a,e
	cp	a,c
	jp	nz,.loopy
	
	; Increment variables for next frame
	
	ld	a,[tunnel_angle_increment]
	ld	hl,tunnel_angle_increment_speed
	add	a,[hl]
	and	a,31
	ld	[tunnel_angle_increment],a
	
	ld	a,[tunnel_distance_increment]
	ld	hl,tunnel_distance_increment_speed
	add	a,[hl]
	and	a,31
	ld	[tunnel_distance_increment],a
	
	; Update temp scroll values
	
	ld	a,[tunnel_x_increment]
	and	a,~3
	ld	[tunnel_temp_rSCX],a
	
	ld	a,[tunnel_y_increment]
	and	a,~3
	ld	[tunnel_temp_rSCY],a
	
	; X scroll
	
	ld	a,[tunnel_x_increment]
	ld	hl,tunnel_x_increment_speed
	add	a,[hl]
	add	a,[hl]
	ld	[tunnel_x_increment],a
	
	cp	a,0
	jr	nz,._not_x_zero
	ld	[hl],1
._not_x_zero

	cp	a,(32-20)*8 ; MAX SCROLL X
	jr	nz,._not_x_max
	ld	[hl],-1
._not_x_max

	; Y scroll

	ld	a,[tunnel_y_increment]
	ld	hl,tunnel_y_increment_speed
	add	a,[hl]
	add	a,[hl]
	ld	[tunnel_y_increment],a
	
	cp	a,0
	jr	nz,._not_y_zero
	ld	[hl],1
._not_y_zero

	cp	a,(32-18)*8 ; MAX SCROLL Y
	jr	nz,._not_y_max
	ld	[hl],-1
._not_y_max

	; Tell the VBL handler to update screen
	
	ld	a,1
	ld	[tunnel_has_to_update_bgs_dma],a
	
	ret

;----------------------------------------------

tunnel_update_bg:
	
	ld	a,[tunnel_has_to_update_bgs_dma]
	and	a,a
	ret	z
	
	call	tunnel_map_update_scroll
	
	ld	a,0
	ld	[tunnel_has_to_update_bgs_dma],a
	
	ld	a,0
	ld	[rVBK],a ; should be 20*18, but as there is space between rows, use 32
	DMA_COPY	MAP_TEMP,$9800,32*32,0 ; src, dst, size, is_hdma
	
	ret

;----------------------------------------------

tunnel_setup_sprites:
	
	; TUNNEL
	
	ld	bc,((113-2)<<8)|(144-2)
	ld	l,0
	call	sprite_set_xy
	ld	bc,((121-2)<<8)|(144-2)
	ld	l,1
	call	sprite_set_xy
	ld	bc,((129-2)<<8)|(144-2)
	ld	l,2
	call	sprite_set_xy
	ld	bc,((137-2)<<8)|(144-2)
	ld	l,3
	call	sprite_set_xy
	ld	bc,((145-2)<<8)|(144-2)
	ld	l,4
	call	sprite_set_xy
	ld	bc,((153-2)<<8)|(144-2)
	ld	l,5
	call	sprite_set_xy
	ld	bc,((161-2)<<8)|(144-2)
	ld	l,6
	call	sprite_set_xy
	
	ld	a,0
	ld	l,0
	call	sprite_set_tile
	ld	a,2
	ld	l,1
	call	sprite_set_tile
	ld	a,4
	ld	l,2
	call	sprite_set_tile
	ld	a,6
	ld	l,3
	call	sprite_set_tile
	ld	a,8
	ld	l,4
	call	sprite_set_tile
	ld	a,10
	ld	l,5
	call	sprite_set_tile
	ld	a,12
	ld	l,6
	call	sprite_set_tile
	
	; Done!
	
	ld	a,1
	ld	[tunnel_has_to_refresh_oam],a
	
	ret

;----------------------------------------------

tunnel_load_sprites:
	
	ld	a,[tunnel_has_to_refresh_oam]
	and	a,a
	ret	z
	
	xor	a,a
	ld	[tunnel_has_to_refresh_oam],a
	
	call	refresh_OAM
	
	ret
	
;-------------------------------------------------------------------
;-                              OTHER                              -
;-------------------------------------------------------------------

tunnel_vbl_handler:

	; --------------------
	
	call	tunnel_load_sprites
	
	; --------------------
	
	call	tunnel_update_bg
	
	; --------------------
	
	; Window increments
	
	ld	hl,tunnel_window_increment
	ld	a,[rWX]
	add	a,[hl]
	ld	[rWX],a
	
	ld	a,[rWY]
	add	a,[hl]
	ld	[rWY],a
	
	; --------------------
	
	LONG_CALL	gbt_update
	
	; --------------------
	
	ret

;----------------------------------------------
	
	GLOBAL Tunnel
	
Tunnel:
	
	xor	a,a ; hide things with window
	ld	[rWX],a
	ld	[rWY],a
	ld	[rSCY],a
	ld	[rSCX],a

	ld	a,LCDCF_ON|LCDCF_WINON|LCDCF_WIN9C00 ; use window to hide things
	ld	[rLCDC],a
	
	; ---- set window to palette 7, tile = 0 (all colors are black)
	
	ld	a,1
	ld	[rVBK],a
	
	ld	bc,32*32
	ld	d,7
	ld	hl,$9C00
	call	vram_memset ; bc = size    d = value    hl = dest address

	ld	a,0
	ld	[rVBK],a
	
	ld	bc,32*32
	ld	d,0
	ld	hl,$9C00
	call	vram_memset ; bc = size    d = value    hl = dest address
	
	; ----	
	
	call	tunnel_init_variables
	
	ld	a,0
	ld	[rVBK],a
	
	LONG_CALL	demo_load_4x4_tiles

	ld	bc,14
	ld	hl,tunnel_sprite_tiles
	ld	de,0 ;  de = start index
	call	vram_copy_tiles
	
	ld	a,1
	ld	[rVBK],a
	
	ld	bc,32*32
	ld	de,$9800
	ld	hl,tunnel_distance_palettes
	call	vram_copy ; bc = size    hl = source address    de = dest address
	
	call	tunnel_setup_sprites
	
	call	wait_vbl
	
	call	tunnel_map_update_scroll
	
	call	wait_vbl
	
	call	tunnel_map_handle
	
	ld	a,LCDCF_ON|LCDCF_BG8800|LCDCF_BG9800|LCDCF_WINON|LCDCF_WIN9C00|LCDCF_OBJ16|LCDCF_OBJON
	ld	[rLCDC],a ; configuration
	
	ld	a,0
	ld	[rWY],a ; reset window
	ld	a,7
	ld	[rWX],a
	
	; Load palettes
	
	call	wait_vbl
	
	call	tunnel_palettes_load
	
	; Configure IRQs
	
	ld	a,$01
	ld	[rIE],a
	
	ld	bc,tunnel_vbl_handler
	call	irq_set_VBL
	
	; START	
	
.loop: ; Main loop
	
	call	tunnel_handle_events
	call	tunnel_map_handle
	
	call	wait_vbl

	ld	a,[tunnel_exit_demo]
	and	a,a
	jr	z,.loop

	; Exit...
	; -------
	
	call	demo_config_default
	
	ret

