; 
; Copyright (c) 2014, Antonio Nio Daz (AntonioND)
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions are met:
; 
; * Redistributions of source code must retain the above copyright notice, this
;   list of conditions and the following disclaimer.
; 
; * Redistributions in binary form must reproduce the above copyright notice,
;   this list of conditions and the following disclaimer in the documentation
;   and/or other materials provided with the distribution.
; 
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
; AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
; CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
; OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
; OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
; 

	INCLUDE	"hardware.inc"
	INCLUDE "header.inc"
	INCLUDE	"gbt_player.inc"

	GLOBAL	demo_config_default

;-------------------------------------------------------------------------------------------------

	SECTION "FAKE3D_DATA", DATA[$4000], BANK[6]

fake3d_y_and_w_table: ; y = fake3d_y_and_w_table[angle 0..255][dist 32..63][0] -> sin(angle) * dist
DB $00,$00,$01,$02,$03,$03,$04,$05,$06,$07,$07,$08,$09,$0A,$0A,$0B,$0C,$0C,$0D,$0E,$0F,$0F,$10,$11,$11,$12,$13,$13,$14,$14,$15,$16
DB $16,$17,$17,$18,$18,$19,$19,$1A,$1A,$1B,$1B,$1B,$1C,$1C,$1C,$1D,$1D,$1D,$1E,$1E,$1E,$1E,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F
DB $20,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1F,$1E,$1E,$1E,$1E,$1D,$1D,$1D,$1C,$1C,$1C,$1B,$1B,$1B,$1A,$1A,$19,$19,$18,$18,$17,$17
DB $16,$16,$15,$14,$14,$13,$13,$12,$11,$11,$10,$0F,$0F,$0E,$0D,$0C,$0C,$0B,$0A,$0A,$09,$08,$07,$07,$06,$05,$04,$03,$03,$02,$01,$00
DB $00,$00,$FF,$FE,$FD,$FD,$FC,$FB,$FA,$F9,$F9,$F8,$F7,$F6,$F6,$F5,$F4,$F4,$F3,$F2,$F1,$F1,$F0,$EF,$EF,$EE,$ED,$ED,$EC,$EC,$EB,$EA
DB $EA,$E9,$E9,$E8,$E8,$E7,$E7,$E6,$E6,$E5,$E5,$E5,$E4,$E4,$E4,$E3,$E3,$E3,$E2,$E2,$E2,$E2,$E1,$E1,$E1,$E1,$E1,$E1,$E1,$E1,$E1,$E1
DB $E0,$E1,$E1,$E1,$E1,$E1,$E1,$E1,$E1,$E1,$E1,$E2,$E2,$E2,$E2,$E3,$E3,$E3,$E4,$E4,$E4,$E5,$E5,$E5,$E6,$E6,$E7,$E7,$E8,$E8,$E9,$E9
DB $EA,$EA,$EB,$EC,$EC,$ED,$ED,$EE,$EF,$EF,$F0,$F1,$F1,$F2,$F3,$F4,$F4,$F5,$F6,$F6,$F7,$F8,$F9,$F9,$FA,$FB,$FC,$FD,$FD,$FE,$FF,$00
DB $00,$00,$01,$02,$03,$04,$04,$05,$06,$07,$08,$08,$09,$0A,$0B,$0B,$0C,$0D,$0E,$0E,$0F,$10,$10,$11,$12,$13,$13,$14,$14,$15,$16,$16
DB $17,$17,$18,$18,$19,$1A,$1A,$1A,$1B,$1B,$1C,$1C,$1D,$1D,$1D,$1E,$1E,$1E,$1F,$1F,$1F,$1F,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
DB $21,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$1F,$1F,$1F,$1F,$1E,$1E,$1E,$1D,$1D,$1D,$1C,$1C,$1B,$1B,$1A,$1A,$1A,$19,$18,$18,$17
DB $17,$16,$16,$15,$14,$14,$13,$13,$12,$11,$10,$10,$0F,$0E,$0E,$0D,$0C,$0B,$0B,$0A,$09,$08,$08,$07,$06,$05,$04,$04,$03,$02,$01,$00
DB $00,$00,$FF,$FE,$FD,$FC,$FC,$FB,$FA,$F9,$F8,$F8,$F7,$F6,$F5,$F5,$F4,$F3,$F2,$F2,$F1,$F0,$F0,$EF,$EE,$ED,$ED,$EC,$EC,$EB,$EA,$EA
DB $E9,$E9,$E8,$E8,$E7,$E6,$E6,$E6,$E5,$E5,$E4,$E4,$E3,$E3,$E3,$E2,$E2,$E2,$E1,$E1,$E1,$E1,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0
DB $DF,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E1,$E1,$E1,$E1,$E2,$E2,$E2,$E3,$E3,$E3,$E4,$E4,$E5,$E5,$E6,$E6,$E6,$E7,$E8,$E8,$E9
DB $E9,$EA,$EA,$EB,$EC,$EC,$ED,$ED,$EE,$EF,$F0,$F0,$F1,$F2,$F2,$F3,$F4,$F5,$F5,$F6,$F7,$F8,$F8,$F9,$FA,$FB,$FC,$FC,$FD,$FE,$FF,$00
DB $00,$00,$01,$02,$03,$04,$04,$05,$06,$07,$08,$09,$09,$0A,$0B,$0C,$0D,$0D,$0E,$0F,$10,$10,$11,$12,$12,$13,$14,$14,$15,$16,$16,$17
DB $18,$18,$19,$19,$1A,$1A,$1B,$1B,$1C,$1C,$1D,$1D,$1D,$1E,$1E,$1F,$1F,$1F,$20,$20,$20,$20,$20,$21,$21,$21,$21,$21,$21,$21,$21,$21
DB $22,$21,$21,$21,$21,$21,$21,$21,$21,$21,$20,$20,$20,$20,$20,$1F,$1F,$1F,$1E,$1E,$1D,$1D,$1D,$1C,$1C,$1B,$1B,$1A,$1A,$19,$19,$18
DB $18,$17,$16,$16,$15,$14,$14,$13,$12,$12,$11,$10,$10,$0F,$0E,$0D,$0D,$0C,$0B,$0A,$09,$09,$08,$07,$06,$05,$04,$04,$03,$02,$01,$00
DB $00,$00,$FF,$FE,$FD,$FC,$FC,$FB,$FA,$F9,$F8,$F7,$F7,$F6,$F5,$F4,$F3,$F3,$F2,$F1,$F0,$F0,$EF,$EE,$EE,$ED,$EC,$EC,$EB,$EA,$EA,$E9
DB $E8,$E8,$E7,$E7,$E6,$E6,$E5,$E5,$E4,$E4,$E3,$E3,$E3,$E2,$E2,$E1,$E1,$E1,$E0,$E0,$E0,$E0,$E0,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF
DB $DE,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$DF,$E0,$E0,$E0,$E0,$E0,$E1,$E1,$E1,$E2,$E2,$E3,$E3,$E3,$E4,$E4,$E5,$E5,$E6,$E6,$E7,$E7,$E8
DB $E8,$E9,$EA,$EA,$EB,$EC,$EC,$ED,$EE,$EE,$EF,$F0,$F0,$F1,$F2,$F3,$F3,$F4,$F5,$F6,$F7,$F7,$F8,$F9,$FA,$FB,$FC,$FC,$FD,$FE,$FF,$00
DB $00,$00,$01,$02,$03,$04,$05,$05,$06,$07,$08,$09,$0A,$0A,$0B,$0C,$0D,$0E,$0E,$0F,$10,$11,$11,$12,$13,$14,$14,$15,$16,$16,$17,$18
DB $18,$19,$19,$1A,$1B,$1B,$1C,$1C,$1D,$1D,$1E,$1E,$1E,$1F,$1F,$1F,$20,$20,$20,$21,$21,$21,$21,$22,$22,$22,$22,$22,$22,$22,$22,$22
DB $23,$22,$22,$22,$22,$22,$22,$22,$22,$22,$21,$21,$21,$21,$20,$20,$20,$1F,$1F,$1F,$1E,$1E,$1E,$1D,$1D,$1C,$1C,$1B,$1B,$1A,$19,$19
DB $18,$18,$17,$16,$16,$15,$14,$14,$13,$12,$11,$11,$10,$0F,$0E,$0E,$0D,$0C,$0B,$0A,$0A,$09,$08,$07,$06,$05,$05,$04,$03,$02,$01,$00
DB $00,$00,$FF,$FE,$FD,$FC,$FB,$FB,$FA,$F9,$F8,$F7,$F6,$F6,$F5,$F4,$F3,$F2,$F2,$F1,$F0,$EF,$EF,$EE,$ED,$EC,$EC,$EB,$EA,$EA,$E9,$E8
DB $E8,$E7,$E7,$E6,$E5,$E5,$E4,$E4,$E3,$E3,$E2,$E2,$E2,$E1,$E1,$E1,$E0,$E0,$E0,$DF,$DF,$DF,$DF,$DE,$DE,$DE,$DE,$DE,$DE,$DE,$DE,$DE
DB $DD,$DE,$DE,$DE,$DE,$DE,$DE,$DE,$DE,$DE,$DF,$DF,$DF,$DF,$E0,$E0,$E0,$E1,$E1,$E1,$E2,$E2,$E2,$E3,$E3,$E4,$E4,$E5,$E5,$E6,$E7,$E7
DB $E8,$E8,$E9,$EA,$EA,$EB,$EC,$EC,$ED,$EE,$EF,$EF,$F0,$F1,$F2,$F2,$F3,$F4,$F5,$F6,$F6,$F7,$F8,$F9,$FA,$FB,$FB,$FC,$FD,$FE,$FF,$00
DB $00,$00,$01,$02,$03,$04,$05,$06,$07,$07,$08,$09,$0A,$0B,$0C,$0C,$0D,$0E,$0F,$10,$10,$11,$12,$13,$14,$14,$15,$16,$16,$17,$18,$18
DB $19,$1A,$1A,$1B,$1B,$1C,$1C,$1D,$1D,$1E,$1E,$1F,$1F,$20,$20,$20,$21,$21,$21,$22,$22,$22,$22,$23,$23,$23,$23,$23,$23,$23,$23,$23
DB $24,$23,$23,$23,$23,$23,$23,$23,$23,$23,$22,$22,$22,$22,$21,$21,$21,$20,$20,$20,$1F,$1F,$1E,$1E,$1D,$1D,$1C,$1C,$1B,$1B,$1A,$1A
DB $19,$18,$18,$17,$16,$16,$15,$14,$14,$13,$12,$11,$10,$10,$0F,$0E,$0D,$0C,$0C,$0B,$0A,$09,$08,$07,$07,$06,$05,$04,$03,$02,$01,$00
DB $00,$00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F9,$F8,$F7,$F6,$F5,$F4,$F4,$F3,$F2,$F1,$F0,$F0,$EF,$EE,$ED,$EC,$EC,$EB,$EA,$EA,$E9,$E8,$E8
DB $E7,$E6,$E6,$E5,$E5,$E4,$E4,$E3,$E3,$E2,$E2,$E1,$E1,$E0,$E0,$E0,$DF,$DF,$DF,$DE,$DE,$DE,$DE,$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD
DB $DC,$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DE,$DE,$DE,$DE,$DF,$DF,$DF,$E0,$E0,$E0,$E1,$E1,$E2,$E2,$E3,$E3,$E4,$E4,$E5,$E5,$E6,$E6
DB $E7,$E8,$E8,$E9,$EA,$EA,$EB,$EC,$EC,$ED,$EE,$EF,$F0,$F0,$F1,$F2,$F3,$F4,$F4,$F5,$F6,$F7,$F8,$F9,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$00
DB $00,$00,$01,$02,$03,$04,$05,$06,$07,$08,$08,$09,$0A,$0B,$0C,$0D,$0E,$0E,$0F,$10,$11,$12,$13,$13,$14,$15,$16,$16,$17,$18,$18,$19
DB $1A,$1A,$1B,$1C,$1C,$1D,$1D,$1E,$1E,$1F,$1F,$20,$20,$21,$21,$21,$22,$22,$22,$23,$23,$23,$23,$24,$24,$24,$24,$24,$24,$24,$24,$24
DB $25,$24,$24,$24,$24,$24,$24,$24,$24,$24,$23,$23,$23,$23,$22,$22,$22,$21,$21,$21,$20,$20,$1F,$1F,$1E,$1E,$1D,$1D,$1C,$1C,$1B,$1A
DB $1A,$19,$18,$18,$17,$16,$16,$15,$14,$13,$13,$12,$11,$10,$0F,$0E,$0E,$0D,$0C,$0B,$0A,$09,$08,$08,$07,$06,$05,$04,$03,$02,$01,$00
DB $00,$00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F8,$F8,$F7,$F6,$F5,$F4,$F3,$F2,$F2,$F1,$F0,$EF,$EE,$ED,$ED,$EC,$EB,$EA,$EA,$E9,$E8,$E8,$E7
DB $E6,$E6,$E5,$E4,$E4,$E3,$E3,$E2,$E2,$E1,$E1,$E0,$E0,$DF,$DF,$DF,$DE,$DE,$DE,$DD,$DD,$DD,$DD,$DC,$DC,$DC,$DC,$DC,$DC,$DC,$DC,$DC
DB $DB,$DC,$DC,$DC,$DC,$DC,$DC,$DC,$DC,$DC,$DD,$DD,$DD,$DD,$DE,$DE,$DE,$DF,$DF,$DF,$E0,$E0,$E1,$E1,$E2,$E2,$E3,$E3,$E4,$E4,$E5,$E6
DB $E6,$E7,$E8,$E8,$E9,$EA,$EA,$EB,$EC,$ED,$ED,$EE,$EF,$F0,$F1,$F2,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$00
DB $00,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0B,$0C,$0D,$0E,$0F,$10,$11,$11,$12,$13,$14,$15,$15,$16,$17,$18,$18,$19,$1A
DB $1A,$1B,$1C,$1C,$1D,$1D,$1E,$1F,$1F,$20,$20,$21,$21,$21,$22,$22,$23,$23,$23,$24,$24,$24,$24,$25,$25,$25,$25,$25,$25,$25,$25,$25
DB $26,$25,$25,$25,$25,$25,$25,$25,$25,$25,$24,$24,$24,$24,$23,$23,$23,$22,$22,$21,$21,$21,$20,$20,$1F,$1F,$1E,$1D,$1D,$1C,$1C,$1B
DB $1A,$1A,$19,$18,$18,$17,$16,$15,$15,$14,$13,$12,$11,$11,$10,$0F,$0E,$0D,$0C,$0B,$0B,$0A,$09,$08,$07,$06,$05,$04,$03,$02,$01,$00
DB $00,$00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F8,$F7,$F6,$F5,$F5,$F4,$F3,$F2,$F1,$F0,$EF,$EF,$EE,$ED,$EC,$EB,$EB,$EA,$E9,$E8,$E8,$E7,$E6
DB $E6,$E5,$E4,$E4,$E3,$E3,$E2,$E1,$E1,$E0,$E0,$DF,$DF,$DF,$DE,$DE,$DD,$DD,$DD,$DC,$DC,$DC,$DC,$DB,$DB,$DB,$DB,$DB,$DB,$DB,$DB,$DB
DB $DA,$DB,$DB,$DB,$DB,$DB,$DB,$DB,$DB,$DB,$DC,$DC,$DC,$DC,$DD,$DD,$DD,$DE,$DE,$DF,$DF,$DF,$E0,$E0,$E1,$E1,$E2,$E3,$E3,$E4,$E4,$E5
DB $E6,$E6,$E7,$E8,$E8,$E9,$EA,$EB,$EB,$EC,$ED,$EE,$EF,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$00
DB $00,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0E,$0F,$10,$11,$12,$13,$14,$14,$15,$16,$17,$17,$18,$19,$1A,$1A
DB $1B,$1C,$1C,$1D,$1E,$1E,$1F,$1F,$20,$20,$21,$21,$22,$22,$23,$23,$24,$24,$24,$25,$25,$25,$25,$26,$26,$26,$26,$26,$26,$26,$26,$26
DB $27,$26,$26,$26,$26,$26,$26,$26,$26,$26,$25,$25,$25,$25,$24,$24,$24,$23,$23,$22,$22,$21,$21,$20,$20,$1F,$1F,$1E,$1E,$1D,$1C,$1C
DB $1B,$1A,$1A,$19,$18,$17,$17,$16,$15,$14,$14,$13,$12,$11,$10,$0F,$0E,$0E,$0D,$0C,$0B,$0A,$09,$08,$07,$06,$05,$04,$03,$02,$01,$00
DB $00,$00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F8,$F7,$F6,$F5,$F4,$F3,$F2,$F2,$F1,$F0,$EF,$EE,$ED,$EC,$EC,$EB,$EA,$E9,$E9,$E8,$E7,$E6,$E6
DB $E5,$E4,$E4,$E3,$E2,$E2,$E1,$E1,$E0,$E0,$DF,$DF,$DE,$DE,$DD,$DD,$DC,$DC,$DC,$DB,$DB,$DB,$DB,$DA,$DA,$DA,$DA,$DA,$DA,$DA,$DA,$DA
DB $D9,$DA,$DA,$DA,$DA,$DA,$DA,$DA,$DA,$DA,$DB,$DB,$DB,$DB,$DC,$DC,$DC,$DD,$DD,$DE,$DE,$DF,$DF,$E0,$E0,$E1,$E1,$E2,$E2,$E3,$E4,$E4
DB $E5,$E6,$E6,$E7,$E8,$E9,$E9,$EA,$EB,$EC,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$00
DB $00,$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$11,$12,$13,$14,$15,$16,$17,$17,$18,$19,$1A,$1A,$1B
DB $1C,$1C,$1D,$1E,$1E,$1F,$20,$20,$21,$21,$22,$22,$23,$23,$24,$24,$24,$25,$25,$25,$26,$26,$26,$27,$27,$27,$27,$27,$27,$27,$27,$27
DB $28,$27,$27,$27,$27,$27,$27,$27,$27,$27,$26,$26,$26,$25,$25,$25,$24,$24,$24,$23,$23,$22,$22,$21,$21,$20,$20,$1F,$1E,$1E,$1D,$1C
DB $1C,$1B,$1A,$1A,$19,$18,$17,$17,$16,$15,$14,$13,$12,$11,$11,$10,$0F,$0E,$0D,$0C,$0B,$0A,$09,$08,$07,$06,$05,$04,$03,$02,$01,$00
DB $00,$00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F8,$F7,$F6,$F5,$F4,$F3,$F2,$F1,$F0,$EF,$EF,$EE,$ED,$EC,$EB,$EA,$E9,$E9,$E8,$E7,$E6,$E6,$E5
DB $E4,$E4,$E3,$E2,$E2,$E1,$E0,$E0,$DF,$DF,$DE,$DE,$DD,$DD,$DC,$DC,$DC,$DB,$DB,$DB,$DA,$DA,$DA,$D9,$D9,$D9,$D9,$D9,$D9,$D9,$D9,$D9
DB $D8,$D9,$D9,$D9,$D9,$D9,$D9,$D9,$D9,$D9,$DA,$DA,$DA,$DB,$DB,$DB,$DC,$DC,$DC,$DD,$DD,$DE,$DE,$DF,$DF,$E0,$E0,$E1,$E2,$E2,$E3,$E4
DB $E4,$E5,$E6,$E6,$E7,$E8,$E9,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$00
DB $00,$01,$02,$03,$04,$05,$06,$07,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$15,$16,$17,$18,$19,$1A,$1A,$1B,$1C
DB $1C,$1D,$1E,$1F,$1F,$20,$20,$21,$22,$22,$23,$23,$24,$24,$25,$25,$25,$26,$26,$26,$27,$27,$27,$28,$28,$28,$28,$28,$28,$28,$28,$28
DB $29,$28,$28,$28,$28,$28,$28,$28,$28,$28,$27,$27,$27,$26,$26,$26,$25,$25,$25,$24,$24,$23,$23,$22,$22,$21,$20,$20,$1F,$1F,$1E,$1D
DB $1C,$1C,$1B,$1A,$1A,$19,$18,$17,$16,$15,$15,$14,$13,$12,$11,$10,$0F,$0E,$0D,$0C,$0B,$0A,$09,$08,$07,$07,$06,$05,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F9,$F8,$F7,$F6,$F5,$F4,$F3,$F2,$F1,$F0,$EF,$EE,$ED,$EC,$EB,$EB,$EA,$E9,$E8,$E7,$E6,$E6,$E5,$E4
DB $E4,$E3,$E2,$E1,$E1,$E0,$E0,$DF,$DE,$DE,$DD,$DD,$DC,$DC,$DB,$DB,$DB,$DA,$DA,$DA,$D9,$D9,$D9,$D8,$D8,$D8,$D8,$D8,$D8,$D8,$D8,$D8
DB $D7,$D8,$D8,$D8,$D8,$D8,$D8,$D8,$D8,$D8,$D9,$D9,$D9,$DA,$DA,$DA,$DB,$DB,$DB,$DC,$DC,$DD,$DD,$DE,$DE,$DF,$E0,$E0,$E1,$E1,$E2,$E3
DB $E4,$E4,$E5,$E6,$E6,$E7,$E8,$E9,$EA,$EB,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$F9,$FA,$FB,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$11,$12,$13,$14,$15,$16,$17,$18,$19,$19,$1A,$1B,$1C,$1C
DB $1D,$1E,$1F,$1F,$20,$21,$21,$22,$22,$23,$24,$24,$25,$25,$25,$26,$26,$27,$27,$27,$28,$28,$28,$28,$29,$29,$29,$29,$29,$29,$29,$29
DB $2A,$29,$29,$29,$29,$29,$29,$29,$29,$28,$28,$28,$28,$27,$27,$27,$26,$26,$25,$25,$25,$24,$24,$23,$22,$22,$21,$21,$20,$1F,$1F,$1E
DB $1D,$1C,$1C,$1B,$1A,$19,$19,$18,$17,$16,$15,$14,$13,$12,$11,$11,$10,$0F,$0E,$0D,$0C,$0B,$0A,$09,$08,$07,$06,$05,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F8,$F7,$F6,$F5,$F4,$F3,$F2,$F1,$F0,$EF,$EF,$EE,$ED,$EC,$EB,$EA,$E9,$E8,$E7,$E7,$E6,$E5,$E4,$E4
DB $E3,$E2,$E1,$E1,$E0,$DF,$DF,$DE,$DE,$DD,$DC,$DC,$DB,$DB,$DB,$DA,$DA,$D9,$D9,$D9,$D8,$D8,$D8,$D8,$D7,$D7,$D7,$D7,$D7,$D7,$D7,$D7
DB $D6,$D7,$D7,$D7,$D7,$D7,$D7,$D7,$D7,$D8,$D8,$D8,$D8,$D9,$D9,$D9,$DA,$DA,$DB,$DB,$DB,$DC,$DC,$DD,$DE,$DE,$DF,$DF,$E0,$E1,$E1,$E2
DB $E3,$E4,$E4,$E5,$E6,$E7,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$17,$18,$19,$1A,$1B,$1C,$1C,$1D
DB $1E,$1F,$1F,$20,$21,$21,$22,$23,$23,$24,$24,$25,$25,$26,$26,$27,$27,$28,$28,$28,$29,$29,$29,$29,$2A,$2A,$2A,$2A,$2A,$2A,$2A,$2A
DB $2B,$2A,$2A,$2A,$2A,$2A,$2A,$2A,$2A,$29,$29,$29,$29,$28,$28,$28,$27,$27,$26,$26,$25,$25,$24,$24,$23,$23,$22,$21,$21,$20,$1F,$1F
DB $1E,$1D,$1C,$1C,$1B,$1A,$19,$18,$17,$17,$16,$15,$14,$13,$12,$11,$10,$0F,$0E,$0D,$0C,$0B,$0A,$09,$08,$07,$06,$05,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F8,$F7,$F6,$F5,$F4,$F3,$F2,$F1,$F0,$EF,$EE,$ED,$EC,$EB,$EA,$E9,$E9,$E8,$E7,$E6,$E5,$E4,$E4,$E3
DB $E2,$E1,$E1,$E0,$DF,$DF,$DE,$DD,$DD,$DC,$DC,$DB,$DB,$DA,$DA,$D9,$D9,$D8,$D8,$D8,$D7,$D7,$D7,$D7,$D6,$D6,$D6,$D6,$D6,$D6,$D6,$D6
DB $D5,$D6,$D6,$D6,$D6,$D6,$D6,$D6,$D6,$D7,$D7,$D7,$D7,$D8,$D8,$D8,$D9,$D9,$DA,$DA,$DB,$DB,$DC,$DC,$DD,$DD,$DE,$DF,$DF,$E0,$E1,$E1
DB $E2,$E3,$E4,$E4,$E5,$E6,$E7,$E8,$E9,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1B,$1C,$1D,$1E
DB $1F,$1F,$20,$21,$22,$22,$23,$23,$24,$25,$25,$26,$26,$27,$27,$28,$28,$29,$29,$29,$2A,$2A,$2A,$2A,$2B,$2B,$2B,$2B,$2B,$2B,$2B,$2B
DB $2C,$2B,$2B,$2B,$2B,$2B,$2B,$2B,$2B,$2A,$2A,$2A,$2A,$29,$29,$29,$28,$28,$27,$27,$26,$26,$25,$25,$24,$23,$23,$22,$22,$21,$20,$1F
DB $1F,$1E,$1D,$1C,$1B,$1B,$1A,$19,$18,$17,$16,$15,$14,$13,$12,$11,$10,$0F,$0E,$0D,$0C,$0B,$0A,$09,$08,$07,$06,$05,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F8,$F7,$F6,$F5,$F4,$F3,$F2,$F1,$F0,$EF,$EE,$ED,$EC,$EB,$EA,$E9,$E8,$E7,$E6,$E5,$E5,$E4,$E3,$E2
DB $E1,$E1,$E0,$DF,$DE,$DE,$DD,$DD,$DC,$DB,$DB,$DA,$DA,$D9,$D9,$D8,$D8,$D7,$D7,$D7,$D6,$D6,$D6,$D6,$D5,$D5,$D5,$D5,$D5,$D5,$D5,$D5
DB $D4,$D5,$D5,$D5,$D5,$D5,$D5,$D5,$D5,$D6,$D6,$D6,$D6,$D7,$D7,$D7,$D8,$D8,$D9,$D9,$DA,$DA,$DB,$DB,$DC,$DD,$DD,$DE,$DE,$DF,$E0,$E1
DB $E1,$E2,$E3,$E4,$E5,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$19,$1A,$1B,$1C,$1D,$1E,$1F
DB $1F,$20,$21,$22,$22,$23,$24,$24,$25,$26,$26,$27,$27,$28,$28,$29,$29,$29,$2A,$2A,$2B,$2B,$2B,$2B,$2C,$2C,$2C,$2C,$2C,$2C,$2C,$2C
DB $2D,$2C,$2C,$2C,$2C,$2C,$2C,$2C,$2C,$2B,$2B,$2B,$2B,$2A,$2A,$29,$29,$29,$28,$28,$27,$27,$26,$26,$25,$24,$24,$23,$22,$22,$21,$20
DB $1F,$1F,$1E,$1D,$1C,$1B,$1A,$19,$19,$18,$17,$16,$15,$14,$13,$12,$11,$10,$0F,$0E,$0D,$0C,$0A,$09,$08,$07,$06,$05,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F8,$F7,$F6,$F4,$F3,$F2,$F1,$F0,$EF,$EE,$ED,$EC,$EB,$EA,$E9,$E8,$E7,$E7,$E6,$E5,$E4,$E3,$E2,$E1
DB $E1,$E0,$DF,$DE,$DE,$DD,$DC,$DC,$DB,$DA,$DA,$D9,$D9,$D8,$D8,$D7,$D7,$D7,$D6,$D6,$D5,$D5,$D5,$D5,$D4,$D4,$D4,$D4,$D4,$D4,$D4,$D4
DB $D3,$D4,$D4,$D4,$D4,$D4,$D4,$D4,$D4,$D5,$D5,$D5,$D5,$D6,$D6,$D7,$D7,$D7,$D8,$D8,$D9,$D9,$DA,$DA,$DB,$DC,$DC,$DD,$DE,$DE,$DF,$E0
DB $E1,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$05,$06,$07,$08,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1E,$1F
DB $20,$21,$22,$22,$23,$24,$24,$25,$26,$26,$27,$28,$28,$29,$29,$2A,$2A,$2A,$2B,$2B,$2C,$2C,$2C,$2C,$2D,$2D,$2D,$2D,$2D,$2D,$2D,$2D
DB $2E,$2D,$2D,$2D,$2D,$2D,$2D,$2D,$2D,$2C,$2C,$2C,$2C,$2B,$2B,$2A,$2A,$2A,$29,$29,$28,$28,$27,$26,$26,$25,$24,$24,$23,$22,$22,$21
DB $20,$1F,$1E,$1E,$1D,$1C,$1B,$1A,$19,$18,$17,$16,$15,$14,$13,$12,$11,$10,$0F,$0E,$0D,$0C,$0B,$0A,$08,$07,$06,$05,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FB,$FA,$F9,$F8,$F6,$F5,$F4,$F3,$F2,$F1,$F0,$EF,$EE,$ED,$EC,$EB,$EA,$E9,$E8,$E7,$E6,$E5,$E4,$E3,$E2,$E2,$E1
DB $E0,$DF,$DE,$DE,$DD,$DC,$DC,$DB,$DA,$DA,$D9,$D8,$D8,$D7,$D7,$D6,$D6,$D6,$D5,$D5,$D4,$D4,$D4,$D4,$D3,$D3,$D3,$D3,$D3,$D3,$D3,$D3
DB $D2,$D3,$D3,$D3,$D3,$D3,$D3,$D3,$D3,$D4,$D4,$D4,$D4,$D5,$D5,$D6,$D6,$D6,$D7,$D7,$D8,$D8,$D9,$DA,$DA,$DB,$DC,$DC,$DD,$DE,$DE,$DF
DB $E0,$E1,$E2,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$05,$06,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1B,$1C,$1D,$1E,$1F,$20
DB $21,$22,$22,$23,$24,$25,$25,$26,$27,$27,$28,$28,$29,$29,$2A,$2A,$2B,$2B,$2C,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
DB $2F,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2D,$2D,$2D,$2C,$2C,$2C,$2B,$2B,$2A,$2A,$29,$29,$28,$28,$27,$27,$26,$25,$25,$24,$23,$22,$22
DB $21,$20,$1F,$1E,$1D,$1C,$1B,$1B,$1A,$19,$18,$17,$16,$15,$14,$13,$11,$10,$0F,$0E,$0D,$0C,$0B,$0A,$09,$08,$06,$05,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FB,$FA,$F8,$F7,$F6,$F5,$F4,$F3,$F2,$F1,$F0,$EF,$ED,$EC,$EB,$EA,$E9,$E8,$E7,$E6,$E5,$E5,$E4,$E3,$E2,$E1,$E0
DB $DF,$DE,$DE,$DD,$DC,$DB,$DB,$DA,$D9,$D9,$D8,$D8,$D7,$D7,$D6,$D6,$D5,$D5,$D4,$D4,$D4,$D3,$D3,$D3,$D2,$D2,$D2,$D2,$D2,$D2,$D2,$D2
DB $D1,$D2,$D2,$D2,$D2,$D2,$D2,$D2,$D2,$D3,$D3,$D3,$D4,$D4,$D4,$D5,$D5,$D6,$D6,$D7,$D7,$D8,$D8,$D9,$D9,$DA,$DB,$DB,$DC,$DD,$DE,$DE
DB $DF,$E0,$E1,$E2,$E3,$E4,$E5,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$FA,$FB,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$05,$07,$08,$09,$0A,$0B,$0C,$0D,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21
DB $21,$22,$23,$24,$25,$25,$26,$27,$27,$28,$29,$29,$2A,$2A,$2B,$2B,$2C,$2C,$2D,$2D,$2D,$2E,$2E,$2E,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F
DB $30,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E,$2D,$2D,$2D,$2C,$2C,$2B,$2B,$2A,$2A,$29,$29,$28,$27,$27,$26,$25,$25,$24,$23,$22
DB $21,$21,$20,$1F,$1E,$1D,$1C,$1B,$1A,$19,$18,$17,$16,$15,$14,$13,$12,$11,$10,$0F,$0D,$0C,$0B,$0A,$09,$08,$07,$05,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FB,$F9,$F8,$F7,$F6,$F5,$F4,$F3,$F1,$F0,$EF,$EE,$ED,$EC,$EB,$EA,$E9,$E8,$E7,$E6,$E5,$E4,$E3,$E2,$E1,$E0,$DF
DB $DF,$DE,$DD,$DC,$DB,$DB,$DA,$D9,$D9,$D8,$D7,$D7,$D6,$D6,$D5,$D5,$D4,$D4,$D3,$D3,$D3,$D2,$D2,$D2,$D1,$D1,$D1,$D1,$D1,$D1,$D1,$D1
DB $D0,$D1,$D1,$D1,$D1,$D1,$D1,$D1,$D1,$D2,$D2,$D2,$D3,$D3,$D3,$D4,$D4,$D5,$D5,$D6,$D6,$D7,$D7,$D8,$D9,$D9,$DA,$DB,$DB,$DC,$DD,$DE
DB $DF,$DF,$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FB,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$05,$07,$08,$09,$0A,$0B,$0D,$0E,$0F,$10,$11,$12,$13,$14,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$20,$21
DB $22,$23,$24,$25,$25,$26,$27,$28,$28,$29,$2A,$2A,$2B,$2B,$2C,$2C,$2D,$2D,$2E,$2E,$2E,$2F,$2F,$2F,$30,$30,$30,$30,$30,$30,$30,$30
DB $31,$30,$30,$30,$30,$30,$30,$30,$30,$2F,$2F,$2F,$2E,$2E,$2E,$2D,$2D,$2C,$2C,$2B,$2B,$2A,$2A,$29,$28,$28,$27,$26,$25,$25,$24,$23
DB $22,$21,$20,$20,$1F,$1E,$1D,$1C,$1B,$1A,$19,$18,$17,$16,$14,$13,$12,$11,$10,$0F,$0E,$0D,$0B,$0A,$09,$08,$07,$05,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FB,$F9,$F8,$F7,$F6,$F5,$F3,$F2,$F1,$F0,$EF,$EE,$ED,$EC,$EA,$E9,$E8,$E7,$E6,$E5,$E4,$E3,$E2,$E1,$E0,$E0,$DF
DB $DE,$DD,$DC,$DB,$DB,$DA,$D9,$D8,$D8,$D7,$D6,$D6,$D5,$D5,$D4,$D4,$D3,$D3,$D2,$D2,$D2,$D1,$D1,$D1,$D0,$D0,$D0,$D0,$D0,$D0,$D0,$D0
DB $CF,$D0,$D0,$D0,$D0,$D0,$D0,$D0,$D0,$D1,$D1,$D1,$D2,$D2,$D2,$D3,$D3,$D4,$D4,$D5,$D5,$D6,$D6,$D7,$D8,$D8,$D9,$DA,$DB,$DB,$DC,$DD
DB $DE,$DF,$E0,$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F5,$F6,$F7,$F8,$F9,$FB,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$06,$07,$08,$09,$0A,$0C,$0D,$0E,$0F,$10,$11,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22
DB $23,$24,$25,$25,$26,$27,$28,$28,$29,$2A,$2A,$2B,$2C,$2C,$2D,$2D,$2E,$2E,$2F,$2F,$2F,$30,$30,$30,$31,$31,$31,$31,$31,$31,$31,$31
DB $32,$31,$31,$31,$31,$31,$31,$31,$31,$30,$30,$30,$2F,$2F,$2F,$2E,$2E,$2D,$2D,$2C,$2C,$2B,$2A,$2A,$29,$28,$28,$27,$26,$25,$25,$24
DB $23,$22,$21,$20,$1F,$1E,$1D,$1C,$1B,$1A,$19,$18,$17,$16,$15,$14,$13,$11,$10,$0F,$0E,$0D,$0C,$0A,$09,$08,$07,$06,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FA,$F9,$F8,$F7,$F6,$F4,$F3,$F2,$F1,$F0,$EF,$ED,$EC,$EB,$EA,$E9,$E8,$E7,$E6,$E5,$E4,$E3,$E2,$E1,$E0,$DF,$DE
DB $DD,$DC,$DB,$DB,$DA,$D9,$D8,$D8,$D7,$D6,$D6,$D5,$D4,$D4,$D3,$D3,$D2,$D2,$D1,$D1,$D1,$D0,$D0,$D0,$CF,$CF,$CF,$CF,$CF,$CF,$CF,$CF
DB $CE,$CF,$CF,$CF,$CF,$CF,$CF,$CF,$CF,$D0,$D0,$D0,$D1,$D1,$D1,$D2,$D2,$D3,$D3,$D4,$D4,$D5,$D6,$D6,$D7,$D8,$D8,$D9,$DA,$DB,$DB,$DC
DB $DD,$DE,$DF,$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EF,$F0,$F1,$F2,$F3,$F4,$F6,$F7,$F8,$F9,$FA,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$04,$06,$07,$08,$09,$0B,$0C,$0D,$0E,$0F,$11,$12,$13,$14,$15,$16,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23
DB $24,$24,$25,$26,$27,$28,$28,$29,$2A,$2B,$2B,$2C,$2C,$2D,$2E,$2E,$2F,$2F,$30,$30,$30,$31,$31,$31,$32,$32,$32,$32,$32,$32,$32,$32
DB $33,$32,$32,$32,$32,$32,$32,$32,$32,$31,$31,$31,$30,$30,$30,$2F,$2F,$2E,$2E,$2D,$2C,$2C,$2B,$2B,$2A,$29,$28,$28,$27,$26,$25,$24
DB $24,$23,$22,$21,$20,$1F,$1E,$1D,$1C,$1B,$1A,$19,$18,$16,$15,$14,$13,$12,$11,$0F,$0E,$0D,$0C,$0B,$09,$08,$07,$06,$04,$03,$02,$01
DB $00,$FF,$FE,$FD,$FC,$FA,$F9,$F8,$F7,$F5,$F4,$F3,$F2,$F1,$EF,$EE,$ED,$EC,$EB,$EA,$E8,$E7,$E6,$E5,$E4,$E3,$E2,$E1,$E0,$DF,$DE,$DD
DB $DC,$DC,$DB,$DA,$D9,$D8,$D8,$D7,$D6,$D5,$D5,$D4,$D4,$D3,$D2,$D2,$D1,$D1,$D0,$D0,$D0,$CF,$CF,$CF,$CE,$CE,$CE,$CE,$CE,$CE,$CE,$CE
DB $CD,$CE,$CE,$CE,$CE,$CE,$CE,$CE,$CE,$CF,$CF,$CF,$D0,$D0,$D0,$D1,$D1,$D2,$D2,$D3,$D4,$D4,$D5,$D5,$D6,$D7,$D8,$D8,$D9,$DA,$DB,$DC
DB $DC,$DD,$DE,$DF,$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$EA,$EB,$EC,$ED,$EE,$EF,$F1,$F2,$F3,$F4,$F5,$F7,$F8,$F9,$FA,$FC,$FD,$FE,$FF
DB $00,$01,$02,$03,$05,$06,$07,$08,$0A,$0B,$0C,$0D,$0F,$10,$11,$12,$13,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23
DB $24,$25,$26,$27,$28,$28,$29,$2A,$2B,$2B,$2C,$2D,$2D,$2E,$2F,$2F,$30,$30,$30,$31,$31,$32,$32,$32,$33,$33,$33,$33,$33,$33,$33,$33
DB $34,$33,$33,$33,$33,$33,$33,$33,$33,$32,$32,$32,$31,$31,$30,$30,$30,$2F,$2F,$2E,$2D,$2D,$2C,$2B,$2B,$2A,$29,$28,$28,$27,$26,$25
DB $24,$23,$22,$21,$20,$1F,$1E,$1D,$1C,$1B,$1A,$19,$18,$17,$16,$15,$13,$12,$11,$10,$0F,$0D,$0C,$0B,$0A,$08,$07,$06,$05,$03,$02,$01
DB $00,$FF,$FE,$FD,$FB,$FA,$F9,$F8,$F6,$F5,$F4,$F3,$F1,$F0,$EF,$EE,$ED,$EB,$EA,$E9,$E8,$E7,$E6,$E5,$E4,$E3,$E2,$E1,$E0,$DF,$DE,$DD
DB $DC,$DB,$DA,$D9,$D8,$D8,$D7,$D6,$D5,$D5,$D4,$D3,$D3,$D2,$D1,$D1,$D0,$D0,$D0,$CF,$CF,$CE,$CE,$CE,$CD,$CD,$CD,$CD,$CD,$CD,$CD,$CD
DB $CC,$CD,$CD,$CD,$CD,$CD,$CD,$CD,$CD,$CE,$CE,$CE,$CF,$CF,$D0,$D0,$D0,$D1,$D1,$D2,$D3,$D3,$D4,$D5,$D5,$D6,$D7,$D8,$D8,$D9,$DA,$DB
DB $DC,$DD,$DE,$DF,$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$ED,$EE,$EF,$F0,$F1,$F3,$F4,$F5,$F6,$F8,$F9,$FA,$FB,$FD,$FE,$FF
DB $00,$01,$02,$03,$05,$06,$07,$09,$0A,$0B,$0C,$0E,$0F,$10,$11,$13,$14,$15,$16,$17,$18,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23,$24
DB $25,$26,$27,$28,$28,$29,$2A,$2B,$2C,$2C,$2D,$2E,$2E,$2F,$2F,$30,$30,$31,$31,$32,$32,$33,$33,$33,$33,$34,$34,$34,$34,$34,$34,$34
DB $35,$34,$34,$34,$34,$34,$34,$34,$33,$33,$33,$33,$32,$32,$31,$31,$30,$30,$2F,$2F,$2E,$2E,$2D,$2C,$2C,$2B,$2A,$29,$28,$28,$27,$26
DB $25,$24,$23,$22,$21,$20,$1F,$1E,$1D,$1C,$1B,$1A,$18,$17,$16,$15,$14,$13,$11,$10,$0F,$0E,$0C,$0B,$0A,$09,$07,$06,$05,$03,$02,$01
DB $00,$FF,$FE,$FD,$FB,$FA,$F9,$F7,$F6,$F5,$F4,$F2,$F1,$F0,$EF,$ED,$EC,$EB,$EA,$E9,$E8,$E6,$E5,$E4,$E3,$E2,$E1,$E0,$DF,$DE,$DD,$DC
DB $DB,$DA,$D9,$D8,$D8,$D7,$D6,$D5,$D4,$D4,$D3,$D2,$D2,$D1,$D1,$D0,$D0,$CF,$CF,$CE,$CE,$CD,$CD,$CD,$CD,$CC,$CC,$CC,$CC,$CC,$CC,$CC
DB $CB,$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CD,$CD,$CD,$CD,$CE,$CE,$CF,$CF,$D0,$D0,$D1,$D1,$D2,$D2,$D3,$D4,$D4,$D5,$D6,$D7,$D8,$D8,$D9,$DA
DB $DB,$DC,$DD,$DE,$DF,$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E8,$E9,$EA,$EB,$EC,$ED,$EF,$F0,$F1,$F2,$F4,$F5,$F6,$F7,$F9,$FA,$FB,$FD,$FE,$FF
DB $00,$01,$02,$03,$05,$06,$07,$09,$0A,$0B,$0D,$0E,$0F,$10,$12,$13,$14,$15,$17,$18,$19,$1A,$1B,$1C,$1E,$1F,$20,$21,$22,$23,$24,$25
DB $26,$27,$28,$28,$29,$2A,$2B,$2C,$2C,$2D,$2E,$2E,$2F,$30,$30,$31,$31,$32,$32,$33,$33,$34,$34,$34,$34,$35,$35,$35,$35,$35,$35,$35
DB $36,$35,$35,$35,$35,$35,$35,$35,$34,$34,$34,$34,$33,$33,$32,$32,$31,$31,$30,$30,$2F,$2E,$2E,$2D,$2C,$2C,$2B,$2A,$29,$28,$28,$27
DB $26,$25,$24,$23,$22,$21,$20,$1F,$1E,$1C,$1B,$1A,$19,$18,$17,$15,$14,$13,$12,$10,$0F,$0E,$0D,$0B,$0A,$09,$07,$06,$05,$03,$02,$01
DB $00,$FF,$FE,$FD,$FB,$FA,$F9,$F7,$F6,$F5,$F3,$F2,$F1,$F0,$EE,$ED,$EC,$EB,$E9,$E8,$E7,$E6,$E5,$E4,$E2,$E1,$E0,$DF,$DE,$DD,$DC,$DB
DB $DA,$D9,$D8,$D8,$D7,$D6,$D5,$D4,$D4,$D3,$D2,$D2,$D1,$D0,$D0,$CF,$CF,$CE,$CE,$CD,$CD,$CC,$CC,$CC,$CC,$CB,$CB,$CB,$CB,$CB,$CB,$CB
DB $CA,$CB,$CB,$CB,$CB,$CB,$CB,$CB,$CC,$CC,$CC,$CC,$CD,$CD,$CE,$CE,$CF,$CF,$D0,$D0,$D1,$D2,$D2,$D3,$D4,$D4,$D5,$D6,$D7,$D8,$D8,$D9
DB $DA,$DB,$DC,$DD,$DE,$DF,$E0,$E1,$E2,$E4,$E5,$E6,$E7,$E8,$E9,$EB,$EC,$ED,$EE,$F0,$F1,$F2,$F3,$F5,$F6,$F7,$F9,$FA,$FB,$FD,$FE,$FF
DB $00,$01,$02,$04,$05,$06,$08,$09,$0A,$0C,$0D,$0E,$0F,$11,$12,$13,$15,$16,$17,$18,$19,$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23,$24,$25
DB $26,$27,$28,$29,$2A,$2B,$2C,$2C,$2D,$2E,$2F,$2F,$30,$31,$31,$32,$32,$33,$33,$34,$34,$35,$35,$35,$35,$36,$36,$36,$36,$36,$36,$36
DB $37,$36,$36,$36,$36,$36,$36,$36,$35,$35,$35,$35,$34,$34,$33,$33,$32,$32,$31,$31,$30,$2F,$2F,$2E,$2D,$2C,$2C,$2B,$2A,$29,$28,$27
DB $26,$25,$24,$23,$22,$21,$20,$1F,$1E,$1D,$1C,$1B,$19,$18,$17,$16,$15,$13,$12,$11,$0F,$0E,$0D,$0C,$0A,$09,$08,$06,$05,$04,$02,$01
DB $00,$FF,$FE,$FC,$FB,$FA,$F8,$F7,$F6,$F4,$F3,$F2,$F1,$EF,$EE,$ED,$EB,$EA,$E9,$E8,$E7,$E5,$E4,$E3,$E2,$E1,$E0,$DF,$DE,$DD,$DC,$DB
DB $DA,$D9,$D8,$D7,$D6,$D5,$D4,$D4,$D3,$D2,$D1,$D1,$D0,$CF,$CF,$CE,$CE,$CD,$CD,$CC,$CC,$CB,$CB,$CB,$CB,$CA,$CA,$CA,$CA,$CA,$CA,$CA
DB $C9,$CA,$CA,$CA,$CA,$CA,$CA,$CA,$CB,$CB,$CB,$CB,$CC,$CC,$CD,$CD,$CE,$CE,$CF,$CF,$D0,$D1,$D1,$D2,$D3,$D4,$D4,$D5,$D6,$D7,$D8,$D9
DB $DA,$DB,$DC,$DD,$DE,$DF,$E0,$E1,$E2,$E3,$E4,$E5,$E7,$E8,$E9,$EA,$EB,$ED,$EE,$EF,$F1,$F2,$F3,$F4,$F6,$F7,$F8,$FA,$FB,$FC,$FE,$FF
DB $00,$01,$02,$04,$05,$06,$08,$09,$0A,$0C,$0D,$0E,$10,$11,$12,$14,$15,$16,$17,$19,$1A,$1B,$1C,$1D,$1F,$20,$21,$22,$23,$24,$25,$26
DB $27,$28,$29,$2A,$2B,$2C,$2C,$2D,$2E,$2F,$30,$30,$31,$32,$32,$33,$33,$34,$34,$35,$35,$35,$36,$36,$36,$37,$37,$37,$37,$37,$37,$37
DB $38,$37,$37,$37,$37,$37,$37,$37,$36,$36,$36,$35,$35,$35,$34,$34,$33,$33,$32,$32,$31,$30,$30,$2F,$2E,$2D,$2C,$2C,$2B,$2A,$29,$28
DB $27,$26,$25,$24,$23,$22,$21,$20,$1F,$1D,$1C,$1B,$1A,$19,$17,$16,$15,$14,$12,$11,$10,$0E,$0D,$0C,$0A,$09,$08,$06,$05,$04,$02,$01
DB $00,$FF,$FE,$FC,$FB,$FA,$F8,$F7,$F6,$F4,$F3,$F2,$F0,$EF,$EE,$EC,$EB,$EA,$E9,$E7,$E6,$E5,$E4,$E3,$E1,$E0,$DF,$DE,$DD,$DC,$DB,$DA
DB $D9,$D8,$D7,$D6,$D5,$D4,$D4,$D3,$D2,$D1,$D0,$D0,$CF,$CE,$CE,$CD,$CD,$CC,$CC,$CB,$CB,$CB,$CA,$CA,$CA,$C9,$C9,$C9,$C9,$C9,$C9,$C9
DB $C8,$C9,$C9,$C9,$C9,$C9,$C9,$C9,$CA,$CA,$CA,$CB,$CB,$CB,$CC,$CC,$CD,$CD,$CE,$CE,$CF,$D0,$D0,$D1,$D2,$D3,$D4,$D4,$D5,$D6,$D7,$D8
DB $D9,$DA,$DB,$DC,$DD,$DE,$DF,$E0,$E1,$E3,$E4,$E5,$E6,$E7,$E9,$EA,$EB,$EC,$EE,$EF,$F0,$F2,$F3,$F4,$F6,$F7,$F8,$FA,$FB,$FC,$FE,$FF
DB $00,$01,$02,$04,$05,$06,$08,$09,$0B,$0C,$0D,$0F,$10,$11,$13,$14,$15,$17,$18,$19,$1A,$1C,$1D,$1E,$1F,$20,$21,$23,$24,$25,$26,$27
DB $28,$29,$2A,$2B,$2C,$2C,$2D,$2E,$2F,$30,$30,$31,$32,$32,$33,$34,$34,$35,$35,$36,$36,$36,$37,$37,$37,$38,$38,$38,$38,$38,$38,$38
DB $39,$38,$38,$38,$38,$38,$38,$38,$37,$37,$37,$36,$36,$36,$35,$35,$34,$34,$33,$32,$32,$31,$30,$30,$2F,$2E,$2D,$2C,$2C,$2B,$2A,$29
DB $28,$27,$26,$25,$24,$23,$21,$20,$1F,$1E,$1D,$1C,$1A,$19,$18,$17,$15,$14,$13,$11,$10,$0F,$0D,$0C,$0B,$09,$08,$06,$05,$04,$02,$01
DB $00,$FF,$FE,$FC,$FB,$FA,$F8,$F7,$F5,$F4,$F3,$F1,$F0,$EF,$ED,$EC,$EB,$E9,$E8,$E7,$E6,$E4,$E3,$E2,$E1,$E0,$DF,$DD,$DC,$DB,$DA,$D9
DB $D8,$D7,$D6,$D5,$D4,$D4,$D3,$D2,$D1,$D0,$D0,$CF,$CE,$CE,$CD,$CC,$CC,$CB,$CB,$CA,$CA,$CA,$C9,$C9,$C9,$C8,$C8,$C8,$C8,$C8,$C8,$C8
DB $C7,$C8,$C8,$C8,$C8,$C8,$C8,$C8,$C9,$C9,$C9,$CA,$CA,$CA,$CB,$CB,$CC,$CC,$CD,$CE,$CE,$CF,$D0,$D0,$D1,$D2,$D3,$D4,$D4,$D5,$D6,$D7
DB $D8,$D9,$DA,$DB,$DC,$DD,$DF,$E0,$E1,$E2,$E3,$E4,$E6,$E7,$E8,$E9,$EB,$EC,$ED,$EF,$F0,$F1,$F3,$F4,$F5,$F7,$F8,$FA,$FB,$FC,$FE,$FF
DB $00,$01,$02,$04,$05,$07,$08,$09,$0B,$0C,$0E,$0F,$10,$12,$13,$14,$16,$17,$18,$1A,$1B,$1C,$1D,$1F,$20,$21,$22,$23,$24,$25,$26,$27
DB $29,$2A,$2A,$2B,$2C,$2D,$2E,$2F,$30,$31,$31,$32,$33,$33,$34,$35,$35,$36,$36,$37,$37,$37,$38,$38,$38,$39,$39,$39,$39,$39,$39,$39
DB $3A,$39,$39,$39,$39,$39,$39,$39,$38,$38,$38,$37,$37,$37,$36,$36,$35,$35,$34,$33,$33,$32,$31,$31,$30,$2F,$2E,$2D,$2C,$2B,$2A,$2A
DB $29,$27,$26,$25,$24,$23,$22,$21,$20,$1F,$1D,$1C,$1B,$1A,$18,$17,$16,$14,$13,$12,$10,$0F,$0E,$0C,$0B,$09,$08,$07,$05,$04,$02,$01
DB $00,$FF,$FE,$FC,$FB,$F9,$F8,$F7,$F5,$F4,$F2,$F1,$F0,$EE,$ED,$EC,$EA,$E9,$E8,$E6,$E5,$E4,$E3,$E1,$E0,$DF,$DE,$DD,$DC,$DB,$DA,$D9
DB $D7,$D6,$D6,$D5,$D4,$D3,$D2,$D1,$D0,$CF,$CF,$CE,$CD,$CD,$CC,$CB,$CB,$CA,$CA,$C9,$C9,$C9,$C8,$C8,$C8,$C7,$C7,$C7,$C7,$C7,$C7,$C7
DB $C6,$C7,$C7,$C7,$C7,$C7,$C7,$C7,$C8,$C8,$C8,$C9,$C9,$C9,$CA,$CA,$CB,$CB,$CC,$CD,$CD,$CE,$CF,$CF,$D0,$D1,$D2,$D3,$D4,$D5,$D6,$D6
DB $D7,$D9,$DA,$DB,$DC,$DD,$DE,$DF,$E0,$E1,$E3,$E4,$E5,$E6,$E8,$E9,$EA,$EC,$ED,$EE,$F0,$F1,$F2,$F4,$F5,$F7,$F8,$F9,$FB,$FC,$FE,$FF
DB $00,$01,$02,$04,$05,$07,$08,$0A,$0B,$0C,$0E,$0F,$11,$12,$13,$15,$16,$17,$19,$1A,$1B,$1D,$1E,$1F,$20,$21,$23,$24,$25,$26,$27,$28
DB $29,$2A,$2B,$2C,$2D,$2E,$2F,$30,$31,$31,$32,$33,$34,$34,$35,$35,$36,$37,$37,$38,$38,$38,$39,$39,$39,$3A,$3A,$3A,$3A,$3A,$3A,$3A
DB $3B,$3A,$3A,$3A,$3A,$3A,$3A,$3A,$39,$39,$39,$38,$38,$38,$37,$37,$36,$35,$35,$34,$34,$33,$32,$31,$31,$30,$2F,$2E,$2D,$2C,$2B,$2A
DB $29,$28,$27,$26,$25,$24,$23,$21,$20,$1F,$1E,$1D,$1B,$1A,$19,$17,$16,$15,$13,$12,$11,$0F,$0E,$0C,$0B,$0A,$08,$07,$05,$04,$02,$01
DB $00,$FF,$FE,$FC,$FB,$F9,$F8,$F6,$F5,$F4,$F2,$F1,$EF,$EE,$ED,$EB,$EA,$E9,$E7,$E6,$E5,$E3,$E2,$E1,$E0,$DF,$DD,$DC,$DB,$DA,$D9,$D8
DB $D7,$D6,$D5,$D4,$D3,$D2,$D1,$D0,$CF,$CF,$CE,$CD,$CC,$CC,$CB,$CB,$CA,$C9,$C9,$C8,$C8,$C8,$C7,$C7,$C7,$C6,$C6,$C6,$C6,$C6,$C6,$C6
DB $C5,$C6,$C6,$C6,$C6,$C6,$C6,$C6,$C7,$C7,$C7,$C8,$C8,$C8,$C9,$C9,$CA,$CB,$CB,$CC,$CC,$CD,$CE,$CF,$CF,$D0,$D1,$D2,$D3,$D4,$D5,$D6
DB $D7,$D8,$D9,$DA,$DB,$DC,$DD,$DF,$E0,$E1,$E2,$E3,$E5,$E6,$E7,$E9,$EA,$EB,$ED,$EE,$EF,$F1,$F2,$F4,$F5,$F6,$F8,$F9,$FB,$FC,$FE,$FF
DB $00,$01,$02,$04,$05,$07,$08,$0A,$0B,$0D,$0E,$10,$11,$12,$14,$15,$16,$18,$19,$1A,$1C,$1D,$1E,$20,$21,$22,$23,$24,$26,$27,$28,$29
DB $2A,$2B,$2C,$2D,$2E,$2F,$30,$31,$31,$32,$33,$34,$34,$35,$36,$36,$37,$37,$38,$38,$39,$39,$3A,$3A,$3A,$3B,$3B,$3B,$3B,$3B,$3B,$3B
DB $3C,$3B,$3B,$3B,$3B,$3B,$3B,$3B,$3A,$3A,$3A,$39,$39,$38,$38,$37,$37,$36,$36,$35,$34,$34,$33,$32,$31,$31,$30,$2F,$2E,$2D,$2C,$2B
DB $2A,$29,$28,$27,$26,$24,$23,$22,$21,$20,$1E,$1D,$1C,$1A,$19,$18,$16,$15,$14,$12,$11,$10,$0E,$0D,$0B,$0A,$08,$07,$05,$04,$02,$01
DB $00,$FF,$FE,$FC,$FB,$F9,$F8,$F6,$F5,$F3,$F2,$F0,$EF,$EE,$EC,$EB,$EA,$E8,$E7,$E6,$E4,$E3,$E2,$E0,$DF,$DE,$DD,$DC,$DA,$D9,$D8,$D7
DB $D6,$D5,$D4,$D3,$D2,$D1,$D0,$CF,$CF,$CE,$CD,$CC,$CC,$CB,$CA,$CA,$C9,$C9,$C8,$C8,$C7,$C7,$C6,$C6,$C6,$C5,$C5,$C5,$C5,$C5,$C5,$C5
DB $C4,$C5,$C5,$C5,$C5,$C5,$C5,$C5,$C6,$C6,$C6,$C7,$C7,$C8,$C8,$C9,$C9,$CA,$CA,$CB,$CC,$CC,$CD,$CE,$CF,$CF,$D0,$D1,$D2,$D3,$D4,$D5
DB $D6,$D7,$D8,$D9,$DA,$DC,$DD,$DE,$DF,$E0,$E2,$E3,$E4,$E6,$E7,$E8,$EA,$EB,$EC,$EE,$EF,$F0,$F2,$F3,$F5,$F6,$F8,$F9,$FB,$FC,$FE,$FF
DB $00,$01,$02,$04,$05,$07,$08,$0A,$0B,$0D,$0E,$10,$11,$13,$14,$15,$17,$18,$1A,$1B,$1C,$1E,$1F,$20,$21,$23,$24,$25,$26,$27,$28,$2A
DB $2B,$2C,$2D,$2E,$2F,$30,$30,$31,$32,$33,$34,$35,$35,$36,$37,$37,$38,$38,$39,$39,$3A,$3A,$3B,$3B,$3B,$3C,$3C,$3C,$3C,$3C,$3C,$3C
DB $3D,$3C,$3C,$3C,$3C,$3C,$3C,$3C,$3B,$3B,$3B,$3A,$3A,$39,$39,$38,$38,$37,$37,$36,$35,$35,$34,$33,$32,$31,$30,$30,$2F,$2E,$2D,$2C
DB $2B,$2A,$28,$27,$26,$25,$24,$23,$21,$20,$1F,$1E,$1C,$1B,$1A,$18,$17,$15,$14,$13,$11,$10,$0E,$0D,$0B,$0A,$08,$07,$05,$04,$02,$01
DB $00,$FF,$FE,$FC,$FB,$F9,$F8,$F6,$F5,$F3,$F2,$F0,$EF,$ED,$EC,$EB,$E9,$E8,$E6,$E5,$E4,$E2,$E1,$E0,$DF,$DD,$DC,$DB,$DA,$D9,$D8,$D6
DB $D5,$D4,$D3,$D2,$D1,$D0,$D0,$CF,$CE,$CD,$CC,$CB,$CB,$CA,$C9,$C9,$C8,$C8,$C7,$C7,$C6,$C6,$C5,$C5,$C5,$C4,$C4,$C4,$C4,$C4,$C4,$C4
DB $C3,$C4,$C4,$C4,$C4,$C4,$C4,$C4,$C5,$C5,$C5,$C6,$C6,$C7,$C7,$C8,$C8,$C9,$C9,$CA,$CB,$CB,$CC,$CD,$CE,$CF,$D0,$D0,$D1,$D2,$D3,$D4
DB $D5,$D6,$D8,$D9,$DA,$DB,$DC,$DD,$DF,$E0,$E1,$E2,$E4,$E5,$E6,$E8,$E9,$EB,$EC,$ED,$EF,$F0,$F2,$F3,$F5,$F6,$F8,$F9,$FB,$FC,$FE,$FF
DB $00,$01,$03,$04,$06,$07,$09,$0A,$0C,$0D,$0F,$10,$11,$13,$14,$16,$17,$19,$1A,$1B,$1D,$1E,$1F,$21,$22,$23,$24,$26,$27,$28,$29,$2A
DB $2B,$2C,$2D,$2E,$2F,$30,$31,$32,$33,$34,$35,$35,$36,$37,$38,$38,$39,$39,$3A,$3A,$3B,$3B,$3C,$3C,$3C,$3D,$3D,$3D,$3D,$3D,$3D,$3D
DB $3E,$3D,$3D,$3D,$3D,$3D,$3D,$3D,$3C,$3C,$3C,$3B,$3B,$3A,$3A,$39,$39,$38,$38,$37,$36,$35,$35,$34,$33,$32,$31,$30,$2F,$2E,$2D,$2C
DB $2B,$2A,$29,$28,$27,$26,$24,$23,$22,$21,$1F,$1E,$1D,$1B,$1A,$19,$17,$16,$14,$13,$11,$10,$0F,$0D,$0C,$0A,$09,$07,$06,$04,$03,$01
DB $00,$FF,$FD,$FC,$FA,$F9,$F7,$F6,$F4,$F3,$F1,$F0,$EF,$ED,$EC,$EA,$E9,$E7,$E6,$E5,$E3,$E2,$E1,$DF,$DE,$DD,$DC,$DA,$D9,$D8,$D7,$D6
DB $D5,$D4,$D3,$D2,$D1,$D0,$CF,$CE,$CD,$CC,$CB,$CB,$CA,$C9,$C8,$C8,$C7,$C7,$C6,$C6,$C5,$C5,$C4,$C4,$C4,$C3,$C3,$C3,$C3,$C3,$C3,$C3
DB $C2,$C3,$C3,$C3,$C3,$C3,$C3,$C3,$C4,$C4,$C4,$C5,$C5,$C6,$C6,$C7,$C7,$C8,$C8,$C9,$CA,$CB,$CB,$CC,$CD,$CE,$CF,$D0,$D1,$D2,$D3,$D4
DB $D5,$D6,$D7,$D8,$D9,$DA,$DC,$DD,$DE,$DF,$E1,$E2,$E3,$E5,$E6,$E7,$E9,$EA,$EC,$ED,$EF,$F0,$F1,$F3,$F4,$F6,$F7,$F9,$FA,$FC,$FD,$FF
DB $00,$01,$03,$04,$06,$07,$09,$0A,$0C,$0D,$0F,$10,$12,$13,$15,$16,$18,$19,$1A,$1C,$1D,$1F,$20,$21,$23,$24,$25,$26,$27,$29,$2A,$2B
DB $2C,$2D,$2E,$2F,$30,$31,$32,$33,$34,$35,$36,$36,$37,$38,$38,$39,$3A,$3A,$3B,$3B,$3C,$3C,$3D,$3D,$3D,$3E,$3E,$3E,$3E,$3E,$3E,$3E
DB $3F,$3E,$3E,$3E,$3E,$3E,$3E,$3E,$3D,$3D,$3D,$3C,$3C,$3B,$3B,$3A,$3A,$39,$38,$38,$37,$36,$36,$35,$34,$33,$32,$31,$30,$2F,$2E,$2D
DB $2C,$2B,$2A,$29,$27,$26,$25,$24,$23,$21,$20,$1F,$1D,$1C,$1A,$19,$18,$16,$15,$13,$12,$10,$0F,$0D,$0C,$0A,$09,$07,$06,$04,$03,$01
DB $00,$FF,$FD,$FC,$FA,$F9,$F7,$F6,$F4,$F3,$F1,$F0,$EE,$ED,$EB,$EA,$E8,$E7,$E6,$E4,$E3,$E1,$E0,$DF,$DD,$DC,$DB,$DA,$D9,$D7,$D6,$D5
DB $D4,$D3,$D2,$D1,$D0,$CF,$CE,$CD,$CC,$CB,$CA,$CA,$C9,$C8,$C8,$C7,$C6,$C6,$C5,$C5,$C4,$C4,$C3,$C3,$C3,$C2,$C2,$C2,$C2,$C2,$C2,$C2
DB $C1,$C2,$C2,$C2,$C2,$C2,$C2,$C2,$C3,$C3,$C3,$C4,$C4,$C5,$C5,$C6,$C6,$C7,$C8,$C8,$C9,$CA,$CA,$CB,$CC,$CD,$CE,$CF,$D0,$D1,$D2,$D3
DB $D4,$D5,$D6,$D7,$D9,$DA,$DB,$DC,$DD,$DF,$E0,$E1,$E3,$E4,$E6,$E7,$E8,$EA,$EB,$ED,$EE,$F0,$F1,$F3,$F4,$F6,$F7,$F9,$FA,$FC,$FD,$FF

fake3d_pal_red:
DW $0014,$0014,$0014,$0014,$0015,$0015,$0015,$0015,$0016,$0016,$0016,$0016,$0017,$0017,$0017,$0017
DW $0018,$0018,$0018,$0018,$0019,$0019,$0019,$0019,$001A,$001A,$001A,$001A,$001A,$001B,$001B,$001B
DW $001B,$001B,$001C,$001C,$001C,$001C,$001C,$001C,$001D,$001D,$001D,$001D,$001D,$001D,$001D,$001E
DW $001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E
DW $001F,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E,$001E
DW $001E,$001E,$001D,$001D,$001D,$001D,$001D,$001D,$001D,$001C,$001C,$001C,$001C,$001C,$001C,$001B
DW $001B,$001B,$001B,$001B,$001A,$001A,$001A,$001A,$001A,$0019,$0019,$0019,$0019,$0018,$0018,$0018
DW $0018,$0017,$0017,$0017,$0017,$0016,$0016,$0016,$0016,$0015,$0015,$0015,$0015,$0014,$0014,$0014
DW $0014,$0013,$0013,$0013,$0012,$0012,$0012,$0012,$0011,$0011,$0011,$0011,$0010,$0010,$0010,$0010
DW $000F,$000F,$000F,$000F,$000E,$000E,$000E,$000E,$000D,$000D,$000D,$000D,$000D,$000C,$000C,$000C
DW $000C,$000C,$000B,$000B,$000B,$000B,$000B,$000B,$000A,$000A,$000A,$000A,$000A,$000A,$000A,$0009
DW $0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009
DW $0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009,$0009
DW $0009,$0009,$000A,$000A,$000A,$000A,$000A,$000A,$000A,$000B,$000B,$000B,$000B,$000B,$000B,$000C
DW $000C,$000C,$000C,$000C,$000D,$000D,$000D,$000D,$000D,$000E,$000E,$000E,$000E,$000F,$000F,$000F
DW $000F,$0010,$0010,$0010,$0010,$0011,$0011,$0011,$0011,$0012,$0012,$0012,$0012,$0013,$0013,$0013

fake3d_pal_green:
DW $0280,$0280,$0280,$0280,$02A0,$02A0,$02A0,$02A0,$02C0,$02C0,$02C0,$02C0,$02E0,$02E0,$02E0,$02E0
DW $0300,$0300,$0300,$0300,$0320,$0320,$0320,$0320,$0340,$0340,$0340,$0340,$0340,$0360,$0360,$0360
DW $0360,$0360,$0380,$0380,$0380,$0380,$0380,$0380,$03A0,$03A0,$03A0,$03A0,$03A0,$03A0,$03A0,$03C0
DW $03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0
DW $03E0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0,$03C0
DW $03C0,$03C0,$03A0,$03A0,$03A0,$03A0,$03A0,$03A0,$03A0,$0380,$0380,$0380,$0380,$0380,$0380,$0360
DW $0360,$0360,$0360,$0360,$0340,$0340,$0340,$0340,$0340,$0320,$0320,$0320,$0320,$0300,$0300,$0300
DW $0300,$02E0,$02E0,$02E0,$02E0,$02C0,$02C0,$02C0,$02C0,$02A0,$02A0,$02A0,$02A0,$0280,$0280,$0280
DW $0280,$0260,$0260,$0260,$0240,$0240,$0240,$0240,$0220,$0220,$0220,$0220,$0200,$0200,$0200,$0200
DW $01E0,$01E0,$01E0,$01E0,$01C0,$01C0,$01C0,$01C0,$01A0,$01A0,$01A0,$01A0,$01A0,$0180,$0180,$0180
DW $0180,$0180,$0160,$0160,$0160,$0160,$0160,$0160,$0140,$0140,$0140,$0140,$0140,$0140,$0140,$0120
DW $0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120
DW $0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120,$0120
DW $0120,$0120,$0140,$0140,$0140,$0140,$0140,$0140,$0140,$0160,$0160,$0160,$0160,$0160,$0160,$0180
DW $0180,$0180,$0180,$0180,$01A0,$01A0,$01A0,$01A0,$01A0,$01C0,$01C0,$01C0,$01C0,$01E0,$01E0,$01E0
DW $01E0,$0200,$0200,$0200,$0200,$0220,$0220,$0220,$0220,$0240,$0240,$0240,$0240,$0260,$0260,$0260

fake3d_pal_blue:
DW $5000,$5000,$5000,$5000,$5400,$5400,$5400,$5400,$5800,$5800,$5800,$5800,$5C00,$5C00,$5C00,$5C00
DW $6000,$6000,$6000,$6000,$6400,$6400,$6400,$6400,$6800,$6800,$6800,$6800,$6800,$6C00,$6C00,$6C00
DW $6C00,$6C00,$7000,$7000,$7000,$7000,$7000,$7000,$7400,$7400,$7400,$7400,$7400,$7400,$7400,$7800
DW $7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800
DW $7C00,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800,$7800
DW $7800,$7800,$7400,$7400,$7400,$7400,$7400,$7400,$7400,$7000,$7000,$7000,$7000,$7000,$7000,$6C00
DW $6C00,$6C00,$6C00,$6C00,$6800,$6800,$6800,$6800,$6800,$6400,$6400,$6400,$6400,$6000,$6000,$6000
DW $6000,$5C00,$5C00,$5C00,$5C00,$5800,$5800,$5800,$5800,$5400,$5400,$5400,$5400,$5000,$5000,$5000
DW $5000,$4C00,$4C00,$4C00,$4800,$4800,$4800,$4800,$4400,$4400,$4400,$4400,$4000,$4000,$4000,$4000
DW $3C00,$3C00,$3C00,$3C00,$3800,$3800,$3800,$3800,$3400,$3400,$3400,$3400,$3400,$3000,$3000,$3000
DW $3000,$3000,$2C00,$2C00,$2C00,$2C00,$2C00,$2C00,$2800,$2800,$2800,$2800,$2800,$2800,$2800,$2400
DW $2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400
DW $2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400,$2400
DW $2400,$2400,$2800,$2800,$2800,$2800,$2800,$2800,$2800,$2C00,$2C00,$2C00,$2C00,$2C00,$2C00,$3000
DW $3000,$3000,$3000,$3000,$3400,$3400,$3400,$3400,$3400,$3800,$3800,$3800,$3800,$3C00,$3C00,$3C00
DW $3C00,$4000,$4000,$4000,$4000,$4400,$4400,$4400,$4400,$4800,$4800,$4800,$4800,$4C00,$4C00,$4C00

fake3d_pal_yellow:
DW $0294,$0294,$0294,$0294,$02B5,$02B5,$02B5,$02B5,$02D6,$02D6,$02D6,$02D6,$02F7,$02F7,$02F7,$02F7
DW $0318,$0318,$0318,$0318,$0339,$0339,$0339,$0339,$035A,$035A,$035A,$035A,$035A,$037B,$037B,$037B
DW $037B,$037B,$039C,$039C,$039C,$039C,$039C,$039C,$03BD,$03BD,$03BD,$03BD,$03BD,$03BD,$03BD,$03DE
DW $03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE
DW $03FF,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE,$03DE
DW $03DE,$03DE,$03BD,$03BD,$03BD,$03BD,$03BD,$03BD,$03BD,$039C,$039C,$039C,$039C,$039C,$039C,$037B
DW $037B,$037B,$037B,$037B,$035A,$035A,$035A,$035A,$035A,$0339,$0339,$0339,$0339,$0318,$0318,$0318
DW $0318,$02F7,$02F7,$02F7,$02F7,$02D6,$02D6,$02D6,$02D6,$02B5,$02B5,$02B5,$02B5,$0294,$0294,$0294
DW $0294,$0273,$0273,$0273,$0252,$0252,$0252,$0252,$0231,$0231,$0231,$0231,$0210,$0210,$0210,$0210
DW $01EF,$01EF,$01EF,$01EF,$01CE,$01CE,$01CE,$01CE,$01AD,$01AD,$01AD,$01AD,$01AD,$018C,$018C,$018C
DW $018C,$018C,$016B,$016B,$016B,$016B,$016B,$016B,$014A,$014A,$014A,$014A,$014A,$014A,$014A,$0129
DW $0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129
DW $0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129,$0129
DW $0129,$0129,$014A,$014A,$014A,$014A,$014A,$014A,$014A,$016B,$016B,$016B,$016B,$016B,$016B,$018C
DW $018C,$018C,$018C,$018C,$01AD,$01AD,$01AD,$01AD,$01AD,$01CE,$01CE,$01CE,$01CE,$01EF,$01EF,$01EF
DW $01EF,$0210,$0210,$0210,$0210,$0231,$0231,$0231,$0231,$0252,$0252,$0252,$0252,$0273,$0273,$0273

fake3d_pal_cyan:
DW $5280,$5280,$5280,$5280,$56A0,$56A0,$56A0,$56A0,$5AC0,$5AC0,$5AC0,$5AC0,$5EE0,$5EE0,$5EE0,$5EE0
DW $6300,$6300,$6300,$6300,$6720,$6720,$6720,$6720,$6B40,$6B40,$6B40,$6B40,$6B40,$6F60,$6F60,$6F60
DW $6F60,$6F60,$7380,$7380,$7380,$7380,$7380,$7380,$77A0,$77A0,$77A0,$77A0,$77A0,$77A0,$77A0,$7BC0
DW $7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0
DW $7FE0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0,$7BC0
DW $7BC0,$7BC0,$77A0,$77A0,$77A0,$77A0,$77A0,$77A0,$77A0,$7380,$7380,$7380,$7380,$7380,$7380,$6F60
DW $6F60,$6F60,$6F60,$6F60,$6B40,$6B40,$6B40,$6B40,$6B40,$6720,$6720,$6720,$6720,$6300,$6300,$6300
DW $6300,$5EE0,$5EE0,$5EE0,$5EE0,$5AC0,$5AC0,$5AC0,$5AC0,$56A0,$56A0,$56A0,$56A0,$5280,$5280,$5280
DW $5280,$4E60,$4E60,$4E60,$4A40,$4A40,$4A40,$4A40,$4620,$4620,$4620,$4620,$4200,$4200,$4200,$4200
DW $3DE0,$3DE0,$3DE0,$3DE0,$39C0,$39C0,$39C0,$39C0,$35A0,$35A0,$35A0,$35A0,$35A0,$3180,$3180,$3180
DW $3180,$3180,$2D60,$2D60,$2D60,$2D60,$2D60,$2D60,$2940,$2940,$2940,$2940,$2940,$2940,$2940,$2520
DW $2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520
DW $2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520,$2520
DW $2520,$2520,$2940,$2940,$2940,$2940,$2940,$2940,$2940,$2D60,$2D60,$2D60,$2D60,$2D60,$2D60,$3180
DW $3180,$3180,$3180,$3180,$35A0,$35A0,$35A0,$35A0,$35A0,$39C0,$39C0,$39C0,$39C0,$3DE0,$3DE0,$3DE0
DW $3DE0,$4200,$4200,$4200,$4200,$4620,$4620,$4620,$4620,$4A40,$4A40,$4A40,$4A40,$4E60,$4E60,$4E60

fake3d_background_palette:
	DW	(7<<10)|(7<<5)|(7),$0000,$0000,$0000
	
fake3d_round_and_round_palette:
	DW	$0000,$7FFF,$3DEF,$0000

fake3d_round_and_round_tiles: ; 20 tiles
DB $FF,$FF,$FE,$81,$FF,$80,$FD,$9E
DB $F3,$92,$F3,$92,$F3,$92,$FD,$9E
DB $FF,$80,$FE,$81,$FF,$99,$FA,$9D
DB $F7,$94,$F5,$96,$F3,$92,$F3,$F3
DB $1F,$1F,$AF,$B0,$5F,$E0,$F6,$4F
DB $F9,$49,$F9,$49,$F9,$49,$F9,$49
DB $79,$C9,$F9,$C9,$79,$49,$F9,$C9
DB $F6,$CF,$5F,$E0,$EF,$70,$DF,$DF
DB $BC,$BC,$7C,$E4,$BC,$64,$FC,$24
DB $FC,$24,$FC,$24,$FC,$24,$FC,$24
DB $FC,$24,$FC,$24,$FC,$24,$FC,$24
DB $FB,$27,$AF,$70,$57,$D8,$8F,$8F
DB $FE,$FE,$FE,$92,$FE,$92,$FD,$93
DB $FF,$91,$FE,$91,$FF,$90,$FF,$92
DB $FE,$93,$FF,$93,$FF,$93,$FE,$92
DB $7E,$92,$DE,$32,$BE,$72,$DE,$DE
DB $7F,$7F,$7F,$48,$7F,$48,$7F,$49
DB $7F,$49,$FF,$C9,$FF,$C9,$7F,$C9
DB $FF,$49,$FF,$09,$7F,$89,$FF,$89
DB $BF,$C9,$7F,$48,$7F,$48,$7F,$7F
DB $F0,$F0,$E8,$18,$F4,$0C,$DC,$E4
DB $3C,$24,$3C,$24,$3C,$24,$3C,$24
DB $3C,$24,$3C,$24,$3C,$24,$3C,$24
DB $DC,$E4,$F4,$0C,$E8,$18,$F0,$F0
DB $3F,$3F,$5E,$61,$BF,$C0,$ED,$9E
DB $F3,$92,$F3,$92,$F3,$92,$F3,$92
DB $FF,$9E,$FF,$80,$FF,$80,$FF,$9E
DB $F3,$92,$F3,$92,$F3,$92,$F3,$F3
DB $79,$79,$F9,$C9,$79,$C9,$F5,$4D
DB $FD,$45,$FB,$47,$FF,$43,$FD,$4B
DB $FB,$4D,$FF,$4C,$FD,$4E,$FB,$4A
DB $FA,$4B,$F9,$49,$F9,$49,$F9,$F9
DB $FF,$FF,$FF,$20,$FF,$20,$FF,$27
DB $FC,$24,$FC,$24,$FC,$24,$FC,$24
DB $FC,$24,$FC,$24,$FC,$24,$FC,$24
DB $FF,$27,$FF,$20,$FF,$20,$FF,$FF
DB $C0,$C0,$A0,$60,$D0,$30,$70,$90
DB $F0,$90,$F0,$90,$F0,$90,$F0,$90
DB $F0,$90,$F0,$90,$F0,$90,$F0,$90
DB $70,$90,$D0,$30,$A0,$60,$C0,$C0

fake3d_tiles: ; 4 tiles
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$01,$01,$03,$03,$07,$07
DB $0F,$0F,$1F,$1F,$3F,$3F,$7F,$7F
DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
DB $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
DB $00,$00,$80,$80,$C0,$C0,$E0,$E0
DB $F0,$F0,$F8,$F8,$FC,$FC,$FE,$FE

fake3d_map: ; 20 * 10
DB $00,$00,$00,$00,$00,$00,$00,$00,$00,$01
DB $03,$00,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$00,$01,$02
DB $02,$03,$00,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$00,$01,$02,$02
DB $02,$02,$03,$00,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$00,$01,$02,$02,$02
DB $02,$02,$02,$03,$00,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$00,$01,$02,$02,$02,$02
DB $02,$02,$02,$02,$03,$00,$00,$00,$00,$00
DB $00,$00,$00,$00,$01,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$03,$00,$00,$00,$00
DB $00,$00,$00,$01,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$03,$00,$00,$00
DB $00,$00,$01,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$03,$00,$00
DB $00,$01,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$03,$00
DB $01,$02,$02,$02,$02,$02,$02,$02,$02,$02
DB $02,$02,$02,$02,$02,$02,$02,$02,$02,$03

	; Dist -> 32..64
	; Angle -> 0..255
	
fake3d_vertices_list_pentagon:
	DB	63,0
	DB	63,256*1/5
	DB	63,256*2/5
	DB	63,256*3/5
	DB	63,256*4/5
	DB	63,0

fake3d_norm_list_pentagon
	DB	( 0 + (256/10) )
	DB	( (256*1/5) + (256/10) )
	DB	( (256*2/5) + (256/10) )
	DB	( (256*3/5) + (256/10) )
	DB	( (256*4/5) + (256/10) )

fake3d_vertices_list_star:
	DB	63,0
	DB	32,(256*1)/10
	DB	63,(256*2)/10
	DB	32,(256*3)/10
	DB	63,(256*4)/10
	DB	32,(256*5)/10
	DB	63,(256*6)/10
	DB	32,(256*7)/10
	DB	63,(256*8)/10
	DB	32,(256*9)/10
	DB	63,0

fake3d_norm_list_star:
	DB	0+19
	DB	((256*2)/10)-19
	DB	((256*2)/10)+19
	DB	((256*4)/10)-19
	DB	((256*4)/10)+19
	DB	((256*6)/10)-19
	DB	((256*6)/10)+19
	DB	((256*8)/10)-19
	DB	((256*8)/10)+19
	DB	0-19

	DB	0+19
	DB	((256*2)/10)-19
	DB	((256*2)/10)+19
	DB	((256*4)/10)-19
	DB	((256*4)/10)+19
	DB	((256*6)/10)-19
	DB	((256*6)/10)+19
	DB	((256*8)/10)-19
	DB	((256*8)/10)+19
	DB	0-19
	
fake3d_vertices_list_planes:
	DB	63,0
	DB	63,$80
	
	DB	63,$40
	DB	63,$C0
	
	DB	63,$20
	DB	63,$A0
	
	DB	63,$60
	DB	63,$E0

fake3d_norm_list_planes:
	DB	$40
	
	DB	$80
	
	DB	$60
	
	DB	$A0

fake3d_vertices_list_prisms:
	DB	63,0
	DB	63,$20
	DB	63,$80
	DB	63,$A0
	DB	63,0
	
	DB	63,$40
	DB	63,$60
	DB	63,$C0
	DB	63,$E0
	DB	63,$40

fake3d_norm_list_prisms:
	DB	$10
	DB	$50
	DB	$90
	DB	$D0
	
	DB	$50
	DB	$90
	DB	$D0
	DB	$10

fake3d_vertices_list_2blocks:
	DB	45,$08 ; 36 = (50/sqrt(2)) / cos($8)
	DB	63,$20 ; 45 = (63/sqrt(2)) / cos($8)
	DB	63,$60
	DB	45,$78
	DB	45,$08
	
	DB	45,$88
	DB	63,$A0
	DB	63,$D0
	DB	45,$E8
	DB	45,$88

fake3d_norm_list_2blocks:
	DB	0
	DB	$40
	DB	$80
	DB	$40

	DB	$80
	DB	$C0
	DB	0
	DB	$C0

fake3d_norm_list_ram_vertices:
	DB	$20
	DB	$60
	DB	$A0
	DB	$E0

;-------------------------------------------------------------------------------------------------

	SECTION	"FAKE3D_Vars",BSS

fake3d_ly_scy:	DS	128 ; starts at ly = $10 = 16
fake3d_ly_scy_temp:	DS	128 ; starts at ly = $10 = 16

fake3d_ly_pal:	DS	128*2
fake3d_ly_pal_temp:	DS	128*2

fake3d_drawing_color:	DS	2 ; color output to fake3d_ly_pal_temp

fake3d_rotation_angle_temp:	DS	1 ; 0 - 255
fake3d_rotation_angle:	DS	1 ; 0 - 255
fake3d_rotation_angle_speed:	DS	1 ; added to fake3d_rotation_angle_temp

fake3d_light_angle_offset:	DS	1 ; angle to add to the light
fake3d_light_angle_offset_temp:	DS	1
fake3d_light_angle_offset_speed:	DS	1 ; angle to add to fake3d_light_angle_offset_temp

fake3d_vertex_y:	DS	11 ; up to 11 vertices
fake3d_vertex_w:	DS	11

fake3d_vertices_list_ptr:	DS	2 ; pointer to a list of vertices

fake3d_exit_demo:	DS	1 ; set to 1 to exit this effect
fake3d_event_count:	DS	2
fake3d_current_event:	DS	2 ; pointer to the next event

fake3d_draw_function:	DS	2 ; pointer to a function that calculates vertices and faces

fake3d_ram_vertices_list:	DS	5*2 ; max 5 vertices
fake3d_ram_vertices_radius_increment:	DS	1 ; value to add to radius each frame

;-------------------------------------------------------------------------------------------------

	SECTION "Fake_3D_Bank5_1", CODE, BANK[6]

;-------------------------------------------------------------------------------------------------

fake3d_init_variables:
	
	ld	bc,128
	ld	d,0
	ld	hl,fake3d_ly_scy
	call	memset ; d = value    hl = start address    bc = size
	
	ld	bc,128
	ld	d,0
	ld	hl,fake3d_ly_scy_temp
	call	memset ; d = value    hl = start address    bc = size
	
	ld	bc,128*2
	ld	d,0
	ld	hl,fake3d_ly_pal
	call	memset ; d = value    hl = start address    bc = size
	
	ld	bc,128*2
	ld	d,0
	ld	hl,fake3d_ly_pal_temp
	call	memset ; d = value    hl = start address    bc = size
	
	ld	a,0
	ld	[fake3d_rotation_angle],a
	ld	[fake3d_rotation_angle_temp],a
	
	ld	de,fake3d_vertices_list_pentagon
	call	fake3d_set_vertices_list
	
	ld	de,fake3d_draw_function_nothing
	call	fake3d_set_draw_function
	
	ld	a,-2
	ld	[fake3d_rotation_angle_speed],a
	
	ld	a,$C0
	ld	[fake3d_light_angle_offset],a
	ld	[fake3d_light_angle_offset_temp],a
	
	ld	a,0
	ld	[fake3d_light_angle_offset_speed],a
	
	; ----
	
	; Load vertices to ram
	
	ld	hl,fake3d_ram_vertices_list
	ld	a,32
	ld	[hl+],a
	ld	a,0
	ld	[hl+],a
	ld	a,32
	ld	[hl+],a
	ld	a,$40
	ld	[hl+],a
	ld	a,32
	ld	[hl+],a
	ld	a,$80
	ld	[hl+],a
	ld	a,32
	ld	[hl+],a
	ld	a,$C0
	ld	[hl+],a
	
	ld	a,0
	ld	[fake3d_ram_vertices_radius_increment],a
	
	; ----
	
	ld	a,0
	ld	[fake3d_event_count],a
	ld	[fake3d_event_count+1],a
	
	ld	a,0
	ld	[fake3d_exit_demo],a
	
	ld	hl,_event_table_fake3d
	ld	a,h
	ld	[fake3d_current_event],a
	ld	a,l
	ld	[fake3d_current_event+1],a
	
	ret

;----------------------------------------------

_event_exit_fake3d_demo:
	ld	a,1
	ld	[fake3d_exit_demo],a
	ret

_event_draw_nothing:
	ld	de,fake3d_vertices_list_pentagon
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_nothing
	call	fake3d_set_draw_function
	ret

_event_draw_pentagon_1faces:
	ld	de,fake3d_vertices_list_pentagon
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_pentagon_1faces
	call	fake3d_set_draw_function
	ret

_event_draw_pentagon_2faces:
	ld	de,fake3d_vertices_list_pentagon
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_pentagon_2faces
	call	fake3d_set_draw_function
	ret

_event_draw_pentagon_3faces:
	ld	de,fake3d_vertices_list_pentagon
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_pentagon_3faces
	call	fake3d_set_draw_function
	ret
	
_event_draw_pentagon_4faces:
	ld	de,fake3d_vertices_list_pentagon
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_pentagon_4faces
	call	fake3d_set_draw_function
	ret

_event_draw_pentagon_5faces:
	ld	de,fake3d_vertices_list_pentagon
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_pentagon_5faces
	call	fake3d_set_draw_function
	ret

_event_draw_star:
	ld	de,fake3d_vertices_list_star
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_star
	call	fake3d_set_draw_function
	ret

_event_draw_2planes:
	ld	de,fake3d_vertices_list_planes
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_2planes
	call	fake3d_set_draw_function
	ret

_event_draw_4planes:
	ld	de,fake3d_vertices_list_planes
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_4planes
	call	fake3d_set_draw_function
	ret

_event_draw_2blocks:
	ld	de,fake3d_vertices_list_2blocks
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_2blocks
	call	fake3d_set_draw_function
	ret

_event_draw_2prisms:
	ld	de,fake3d_vertices_list_prisms
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_2prisms
	call	fake3d_set_draw_function
	ret

_event_draw_ram_vertices:
	ld	de,fake3d_ram_vertices_list
	call	fake3d_set_vertices_list
	ld	de,fake3d_draw_function_ram_vertices
	call	fake3d_set_draw_function
	ret

_event_ram_vertices_grow:
	ld	a,1
	ld	[fake3d_ram_vertices_radius_increment],a
	ret

_event_ram_vertices_shrink:
	ld	a,-1
	ld	[fake3d_ram_vertices_radius_increment],a
	ret

_event_ram_vertices_hold:
	ld	a,0
	ld	[fake3d_ram_vertices_radius_increment],a
	ret	

;_event_angle_rotation_speed_stop:
;	ld	a,0
;	ld	[fake3d_rotation_angle_speed],a
;	ret

;_event_angle_rotation_speed_set_minus_2:
;	ld	a,-2
;	ld	[fake3d_rotation_angle_speed],a
;	ret

;_event_angle_rotation_speed_set_plus_2:
;	ld	a,2
;	ld	[fake3d_rotation_angle_speed],a
;	ret

_event_light_rotation_speed_stop:
	ld	a,0
	ld	[fake3d_light_angle_offset_speed],a
	ld	a,$C0
	ld	[fake3d_light_angle_offset],a
	ret

_event_light_rotation_speed_set_minus_2:
	ld	a,-2
	ld	[fake3d_light_angle_offset_speed],a
	ret

_event_light_rotation_speed_set_plus_2:
	ld	a,2
	ld	[fake3d_light_angle_offset_speed],a
	ret

;-------------------

_event_table_fake3d:

	DW	10,_event_draw_pentagon_1faces
	DW	25,_event_draw_pentagon_2faces
	DW	40,_event_draw_pentagon_3faces
	DW	55,_event_draw_pentagon_4faces
	DW	70,_event_draw_pentagon_5faces

	DW	130,_event_draw_2planes
	
	DW	180,_event_draw_4planes
	
	DW	230,_event_draw_ram_vertices
	
	DW	260,_event_ram_vertices_grow
	DW	291,_event_ram_vertices_hold
	DW	330,_event_ram_vertices_shrink
	DW	361,_event_ram_vertices_hold

	DW	400,_event_draw_star
	
	DW	420,_event_light_rotation_speed_set_minus_2

	DW	612,_event_light_rotation_speed_stop
	DW	650,_event_draw_2prisms
	
	DW	750,_event_draw_2blocks
	
	DW	880,_event_draw_nothing
	DW	881,_event_exit_fake3d_demo

	DW	$FFFF,$0000 ; No more events! Don't remove this line!

;----------------------------------------------

fake3d_handle_events:
	
;	ld	hl,fake3d_rotation_angle
;	dec	[hl]
;	dec	[hl]
;	dec	[hl]
;	dec	[hl]
	
	; Handle events
	; -------------
	
	ld	a,[fake3d_event_count]
	ld	e,a
	ld	a,[fake3d_event_count+1]
	ld	d,a
	
	; Start of checking
	
	ld	a,[fake3d_current_event]
	ld	h,a
	ld	a,[fake3d_current_event+1]
	ld	l,a
	
	ld	c,[hl]
	inc hl
	ld	b,[hl] ; bc = event counter trigger
	ld	a,c
	and	a,b
	cp	a,$FF ; if both are $FF, exit checking
	jr	z,._exit_check_events
	
	ld	a,d
	cp	a,b
	jr	nz,._exit_check_events
	
	ld	a,e
	cp	a,c
	jr	nz,._exit_check_events
	
	inc	hl
	
	ld	c,[hl]
	inc hl
	ld	b,[hl] ; bc = ptr to function
	inc	hl ; hl = ptr to next event
	
	ld	a,h
	ld	[fake3d_current_event],a
	ld	a,l
	ld	[fake3d_current_event+1],a ; save pointer to next event
	
	ld	h,b
	ld	l,c ; hl = ptr to function
	
	CALL_HL
._exit_check_events:

	; Now, handle functions...
	; ------------------------
	
	; Increment/decrement radius of vertices in RAM
	; It doesn't check bounds!!
	
	ld	a,[fake3d_ram_vertices_radius_increment]
	and	a,a
	jr	z,.dont_change_radius
	
	ld	b,a

	ld	hl,fake3d_ram_vertices_list
	ld	a,[hl]
	add	a,b
	ld	[hl+],a
	inc	hl
	
	ld	a,[hl]
	add	a,b
	ld	[hl+],a
	inc	hl
	
	ld	a,[hl]
	add	a,b
	ld	[hl+],a
	inc	hl
	
	ld	a,[hl]
	add	a,b
	ld	[hl+],a
	inc	hl
	
.dont_change_radius:

	; More checks here
	
	; ...
	
	; Increase counter
	; ----------------
	
	ld	a,[fake3d_event_count]
	ld	l,a
	ld	a,[fake3d_event_count+1]
	ld	h,a
	
	inc	hl
	
	ld	a,l
	ld	[fake3d_event_count],a
	ld	a,h
	ld	[fake3d_event_count+1],a
	
	ret

;-------------------------------------------------------------------------------------------------

fake3d_draw_function_nothing:

	ret
	
; ------------------------------

fake3d_draw_function_2planes:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,3
	call	fake3d_get_y_and_w_from_vertex_number

	; Draw faces
	
	ld	a,[fake3d_norm_list_planes+0]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices

	ld	a,[fake3d_norm_list_planes+1]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,2
	call	fake3d_join_vertices
	
	ret

; ------------------------------

fake3d_draw_function_4planes:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,3
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,4
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,5
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,6
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,7
	call	fake3d_get_y_and_w_from_vertex_number

	; Draw faces
	
	ld	a,[fake3d_norm_list_planes+0]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices

	ld	a,[fake3d_norm_list_planes+1]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,2
	call	fake3d_join_vertices

	ld	a,[fake3d_norm_list_planes+2]
	ld	de,fake3d_pal_blue
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,4
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_planes+3]
	ld	de,fake3d_pal_blue
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,6
	call	fake3d_join_vertices
	
	ret

; ------------------------------

fake3d_draw_function_star:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,3
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,4
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,5
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,6
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,7
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,8
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,9
	call	fake3d_get_y_and_w_from_vertex_number

	ld	a,10
	ld	c,0
	call	fake3d_copy_y_and_w_from_vertex_number ; a = dest, c = src
	
	; Draw faces
	
	ld	a,[fake3d_norm_list_star+0]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_star+1]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,1
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_star+2]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,2
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_star+3]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,3
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_star+4]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,4
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_star+5]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,5
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_star+6]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,6
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_star+7]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,7
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_star+8]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,8
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_star+9]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,9
	call	fake3d_join_vertices
	
	ret

; ------------------------------

fake3d_draw_function_pentagon_1faces:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number

	; Draw faces
	
	ld	a,[fake3d_norm_list_pentagon+0]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices

	ret

; ------------------------------

fake3d_draw_function_pentagon_2faces:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number

	; Draw faces
	
	ld	a,[fake3d_norm_list_pentagon+0]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+1]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,1
	call	fake3d_join_vertices

	ret

; ------------------------------

fake3d_draw_function_pentagon_3faces:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,3
	call	fake3d_get_y_and_w_from_vertex_number

	; Draw faces
	
	ld	a,[fake3d_norm_list_pentagon+0]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+1]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,1
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+2]
	ld	de,fake3d_pal_blue
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,2
	call	fake3d_join_vertices
	
	ret

; ------------------------------

fake3d_draw_function_pentagon_4faces:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,3
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,4
	call	fake3d_get_y_and_w_from_vertex_number
	
	; Draw faces
	
	ld	a,[fake3d_norm_list_pentagon+0]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+1]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,1
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+2]
	ld	de,fake3d_pal_blue
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,2
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+3]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,3
	call	fake3d_join_vertices
	
	ret

; ------------------------------

fake3d_draw_function_pentagon_5faces:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,3
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,4
	call	fake3d_get_y_and_w_from_vertex_number

	ld	a,5
	ld	c,0
	call	fake3d_copy_y_and_w_from_vertex_number ; a = dest, c = src
	
	; Draw faces
	
	ld	a,[fake3d_norm_list_pentagon+0]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+1]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,1
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+2]
	ld	de,fake3d_pal_blue
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,2
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+3]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,3
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_pentagon+4]
	ld	de,fake3d_pal_cyan
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,4
	call	fake3d_join_vertices
	
	ret

; ------------------------------

fake3d_draw_function_2prisms:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,3
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,4
	ld	c,0
	call	fake3d_copy_y_and_w_from_vertex_number ; a = dest, c = src
	; ----------
	ld	a,5
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,6
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,7
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,8
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,9
	ld	c,5
	call	fake3d_copy_y_and_w_from_vertex_number ; a = dest, c = src
	
	; Draw faces
	
	ld	a,[fake3d_norm_list_prisms+0]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_prisms+1]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,1
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_prisms+2]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,2
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_prisms+3]
	ld	de,fake3d_pal_red
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,3
	call	fake3d_join_vertices
	
	; ----------
	
	ld	a,[fake3d_norm_list_prisms+4]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,5
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_prisms+5]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,6
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_prisms+6]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,7
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_prisms+7]
	ld	de,fake3d_pal_yellow
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,8
	call	fake3d_join_vertices
	
	ret

; ------------------------------

fake3d_draw_function_2blocks:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,3
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,4
	ld	c,0
	call	fake3d_copy_y_and_w_from_vertex_number ; a = dest, c = src
	; ----------
	ld	a,5
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,6
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,7
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,8
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,9
	ld	c,5
	call	fake3d_copy_y_and_w_from_vertex_number ; a = dest, c = src
	
	; Draw faces
	
	ld	a,[fake3d_norm_list_2blocks+0]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_2blocks+1]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,1
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_2blocks+2]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,2
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_2blocks+3]
	add	a,$80
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,3
	call	fake3d_join_vertices
	
	; ----------
	
	ld	a,[fake3d_norm_list_2blocks+4]
	ld	de,fake3d_pal_blue
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,5
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_2blocks+5]
	ld	de,fake3d_pal_blue
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,6
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_2blocks+6]
	ld	de,fake3d_pal_blue
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,7
	call	fake3d_join_vertices
	
	ld	a,[fake3d_norm_list_2blocks+7]
	add	a,$80
	ld	de,fake3d_pal_blue
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,8
	call	fake3d_join_vertices
	
	ret

; ------------------------------

fake3d_draw_function_ram_vertices:

	ld	a,0
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,1
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,2
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,3
	call	fake3d_get_y_and_w_from_vertex_number
	ld	a,4
	ld	c,0
	call	fake3d_copy_y_and_w_from_vertex_number ; a = dest, c = src
	; ----------

	; Draw faces
	
	ld	a,[fake3d_norm_list_ram_vertices+0]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,0
	call	fake3d_join_vertices

	ld	a,[fake3d_norm_list_ram_vertices+1]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,1
	call	fake3d_join_vertices

	ld	a,[fake3d_norm_list_ram_vertices+2]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,2
	call	fake3d_join_vertices

	ld	a,[fake3d_norm_list_ram_vertices+3]
	ld	de,fake3d_pal_green
	call	fake3d_set_drawing_color_from_angle_and_palette ; a = angle , de = palette
	ld	a,3
	call	fake3d_join_vertices

	ret

;-------------------------------------------------------------------------------------------------

fake3d_copy_y_and_w_from_vertex_number: ; a = dest, c = src
	
	ld	b,0
	ld	hl,fake3d_vertex_y
	add	hl,bc
	ld	d,[hl] ; d = y
	ld	hl,fake3d_vertex_w
	add	hl,bc
	ld	e,[hl] ; e = w
	
	ld	c,a
	ld	hl,fake3d_vertex_y
	add	hl,bc
	ld	[hl],d
	
	ld	hl,fake3d_vertex_w
	add	hl,bc
	ld	[hl],e
	
	ret

; -----------------------------

fake3d_get_y_and_w_from_vertex_number: ; a = vertex number

	push	af ; *** save vertex
	
	ld	hl,fake3d_vertices_list_ptr
	ld	d,[hl]
	inc	hl
	ld	h,[hl]
	ld	l,d
	
	ld	e,a
	ld	d,0
	add	hl,de
	add	hl,de ; hl = ptr to vertex
	
	ld	b,[hl] ; b = dist
	
	inc	hl
	ld	c,[hl]
	ld	a,[fake3d_rotation_angle]
	add	a,c
	ld	c,a ; c = angle + rotation
	
	ld	hl,fake3d_y_and_w_table
	ld	e,c
	ld	a,b
	sub	a,32
	ld	d,a
	add	hl,de
	ld	a,[hl]
	sra	a
	add	a,96
	ld	c,a ; c = ( (sin * dist) >> 1 ) + 96
	
	ld	hl,fake3d_y_and_w_table
	ld	a,e
	add	a,$40
	ld	e,a
	add	hl,de
	ld	a,[hl]
	
	add	a,64
	ld	b,a ; b = (cos * dist) + 64

	pop	af ; *** get vertex

	ld	e,a
	ld	d,0
	ld	hl,fake3d_vertex_y
	add	hl,de
	ld	[hl],b
	
	ld	hl,fake3d_vertex_w
	add	hl,de
	ld	[hl],c

	ret

;-------------------------------------------------------------------------------------------------

fake3d_div_hl_by_c: ; hl / c ==> hl
	
	bit	7,h
	jr	nz,.negative
	
	xor	a
	ld	b,16
.loop:
	add	hl,hl
	rla
	cp	a,c
	jr	c,.skip
	sub	a,c
	inc	l
.skip:
	dec	b
	jr	nz,.loop
	
	ret

.negative:
	ld	a,h ; negate hl
	cpl
	ld	h,a
	ld	a,l
	cpl
	ld	l,a
	inc	hl
	
	xor	a
	ld	b,16

.loop2:
	add	hl,hl
	rla
	cp	a,c
	jr	c,.skip2
	sub	a,c
	inc	l
.skip2:
	dec	b
	jr	nz,.loop2
	
	ld	a,h  ; negate hl
	cpl
	ld	h,a
	ld	a,l
	cpl
	ld	l,a
	inc	hl
	ret

;-------------------------------------------------------------------------------------------------

fake3d_join_vertices: ; a = first vertex, a+1 = second vertex

	ld	e,a
	ld	d,0
	ld	hl,fake3d_vertex_y
	add	hl,de
	ld	b,[hl]
	inc	hl
	ld	a,[hl]
	
	ld	hl,fake3d_vertex_w
	add	hl,de
	ld	c,[hl]
	inc	hl
	ld	d,[hl]
	
	; Vertex n+0 -> b,c (Y,W)
	; Vertex n+1 -> a,d

	cp	a,b
	jr	nc,.dontswap
	
	ld	e,a
	ld	a,b
	ld	b,e
	
	ld	e,c
	ld	c,d
	ld	d,e
	
.dontswap:
	
	; Vertex 0 -> b,c (Y,W)
	; Vertex 1 -> a,d     ->   a > b
	
	sub	a,b
	inc	a ; lines to draw = deltaY + 1

	push	bc ; save vertex 0 data (Y,W)
	
	ld	b,a ; b = Y1-Y0
	
	ld	a,d
	sub	a,c
	ld	c,a	; c = W1-W0
	
	; We want to calculate deltaW*256/deltaY
	
	ld	h,c
	ld	l,0 ; hl = deltaW*256
	ld	c,b ; c = deltaY
	push	bc
	call	fake3d_div_hl_by_c ; hl / c ==> quotient = hl, remainder = a 
	pop	bc
	
	pop	de  ; restore vertex 0 data (Y,W)
	
	ld	a,c
	
	; a = deltaY + 1 = loop steps
	; d = Y0
	; e = W0
	; hl = W increment per Y increment (8.8 fixed point)
	
	ld	b,d
	
	ld	d,e
	ld	e,0
	
	push	de
	push	hl
	pop	de
	pop	hl

	; a = deltaY + 1 = loop steps -> deltaY + 1 > 0 always
	; b = Y0
	; de = W increment per Y increment (8.8 fixed point). It can be > 0 or < 0
	; hl = W0 (8.8 fixed point).

.loop:
	push	af
	
	ld	a,h

	push	hl
	push	de
	
	; this checks if old Z is higher than new
	
	; fake3d_set_ly_scy: ; a = w, b = y
	
	ld	e,b
	ld	d,0
	ld	hl,fake3d_ly_scy_temp
	add	hl,de
	
	cp	a,[hl]
	jr	c,.next
	ld	[hl],a

	ld	hl,fake3d_ly_pal_temp
	add	hl,de
	add	hl,de
	
	ld	a,[fake3d_drawing_color]
	ld	[hl+],a
	ld	a,[fake3d_drawing_color+1]
	ld	[hl],a
.next:
	
	pop	de
	pop	hl
	
	; Increment counters
	
	inc	b
	
	add	hl,de ; hl = Wn

	pop	af
	
	dec	a
	jr	nz,.loop
	
	ret

;-------------------------------------------------------------------------------------------------

fake3d_vbl_handler:

	ld	hl,fake3d_rotation_angle_temp
	ld	a,[fake3d_rotation_angle_speed]
	add	a,[hl]
	ld	[hl],a
	
	ld	hl,fake3d_light_angle_offset_temp
	ld	a,[fake3d_light_angle_offset_speed]
	add	a,[hl]
	ld	[hl],a
	
	LONG_CALL	gbt_update
	
	ret

;-------------------------------------------------------------------------------------------------

fake3d_update_ly_scy_array:
	
	; Reset colors
	
	ld	b,128
	ld	a,0
	ld	hl,fake3d_ly_pal_temp
	call	memset_fast ; a = value    hl = start address    b = size
	ld	b,128
	call	memset_fast
	
	; Reset array
	ld	a,0
	ld	hl,fake3d_ly_scy_temp
	ld	b,128
	call	memset_fast

	; Calculate vertices and draw faces
	ld	hl,fake3d_draw_function
	ld	a,[hl+]
	ld	h,[hl]
	ld	l,a
	CALL_HL
	
	; Wait to VBL for updating arrays
	
	call	wait_vbl
	
	; Convert W values to SCY in final buffer
	
	ld	hl,fake3d_ly_scy_temp
	ld	de,fake3d_ly_scy
	ld	b,0
.loop:

	ld	a,[hl+]
	sra	a
	sub a,b
	sub	a,16
	ld	[de],a
	inc	de
	
	inc	b
	ld	a,128
	cp	a,b
	jr	nz,.loop
	
	; Copy temp buffer to final buffer
	
	ld	b,128
	ld	hl,fake3d_ly_pal_temp
	ld	de,fake3d_ly_pal
	call	memcopy_fast ; b = size    hl = source address    de = dest address
	ld	b,128
	call	memcopy_fast
	
	; Update angles
	
	ld	a,[fake3d_rotation_angle_temp]
	ld	[fake3d_rotation_angle],a
	
	ld	a,[fake3d_light_angle_offset_temp]
	ld	[fake3d_light_angle_offset],a
	
	ret

;-------------------------------------------------------------------------------------------------

fake3d_set_drawing_color_from_angle_and_palette: ; a = angle , de = palette
	; fake3d_pal_red | fake3d_pal_green | fake3d_pal_blue | fake3d_pal_yellow | fake3d_pal_cyan
	ld	hl,fake3d_rotation_angle
	add	a,[hl]
	ld	hl,fake3d_light_angle_offset
	add	a,[hl]
	ld	c,a
	ld	b,0 ; bc = pal index
	ld	h,d
	ld	l,e
	add	hl,bc
	add	hl,bc ; hl = &palette[palindex]
	ld	e,[hl]
	inc	hl
	ld	d,[hl]
	call	fake3d_set_drawing_color
	
	ret
	
;-------------------------------------------------------------------------------------------------

fake3d_set_drawing_color: ; de = color
	
	ld	hl,fake3d_drawing_color
	ld	[hl],e
	inc	hl
	ld	[hl],d
	
	ret

;-------------------------------------------------------------------------------------------------

fake3d_set_vertices_list: ; de = list
	
	ld	hl,fake3d_vertices_list_ptr
	ld	[hl],e
	inc	hl
	ld	[hl],d
	
	ret

;-------------------------------------------------------------------------------------------------

fake3d_set_draw_function: ; de = fn
	
	ld	hl,fake3d_draw_function
	ld	[hl],e
	inc	hl
	ld	[hl],d
	
	ret

;-------------------------------------------------------------------------------------------------
	
	SECTION "Fake_3D_Bank0", HOME
	
fake3d_lcd_handler:
	
	; return if upper 16 lines
	ld	a,[rLY]
	cp	a,$0F
	jr	nc,.not_upper_lines
	
	ld	a,128
	ld	[rSCY],a
	ret
	
.not_upper_lines:
	
	sub	a,16-1 ; configuration not for this line -> for the next one
	ld	e,a
	ld	d,0
	ld	hl,fake3d_ly_pal
	add	hl,de
	add	hl,de
	
	ld	a,$86 ; auto increment
	ld	[rBCPS],a
	
	ld	a,[hl+]
	ld	b,[hl] ; ab = palette
	
	ld	[rBCPD],a
	ld	a,b
	ld	[rBCPD],a
	
	ld	hl,fake3d_ly_scy
	add	hl,de
	ld	a,[hl]
	ld	[rSCY],a
	
	; tilt right 1
;	ld	hl,rLY
;	add	a,[hl]
;	srl	a
;	srl	a
;	sub	a,16
;	ld	[rSCX],a
	
	; tilt right 2
;	ld	hl,rLY
;	add	a,[hl]
;	srl	a
;	sub	a,32
;	ld	[rSCX],a

	; tilt right 4
;	ld	hl,rLY
;	add	a,[hl]
;	sub	a,64
;	ld	[rSCX],a

	; tilt left 1
;	ld	hl,rLY
;	add	a,[hl]
;	srl	a
;	srl	a
;	cpl
;	add	a,16+1
;	ld	[rSCX],a
	
	; tilt left 2
;	ld	hl,rLY
;	add	a,[hl]
;	srl	a
;	cpl
;	add	a,32+1
;	ld	[rSCX],a
	
	; tilt left 4
;	ld	hl,rLY
;	add	a,[hl]
;	cpl
;	add	a,64+1
;	ld	[rSCX],a

	ret

;----------------------------------------------
	
	SECTION "Fake_3D_Bank5_2", CODE, BANK[6]

fake3d_setup_sprites:
	
	; ROUND
	
	ld	bc,((8+2)<<8)|(16+2)
	ld	l,0
	call	sprite_set_xy
	ld	bc,((16+2)<<8)|(16+2)
	ld	l,1
	call	sprite_set_xy
	ld	bc,((24+2)<<8)|(16+2)
	ld	l,2
	call	sprite_set_xy
	ld	bc,((32+2)<<8)|(16+2)
	ld	l,3
	call	sprite_set_xy
	ld	bc,((40+2)<<8)|(16+2)
	ld	l,4
	call	sprite_set_xy
	ld	bc,((48+2)<<8)|(16+2)
	ld	l,5
	call	sprite_set_xy
	
	ld	a,0
	ld	l,0
	call	sprite_set_tile
	ld	a,2
	ld	l,1
	call	sprite_set_tile
	ld	a,4
	ld	l,2
	call	sprite_set_tile
	ld	a,6
	ld	l,3
	call	sprite_set_tile
	ld	a,8
	ld	l,4
	call	sprite_set_tile
	ld	a,10
	ld	l,5
	call	sprite_set_tile
	
	; AND
	
	ld	bc,((72)<<8)|(24+2)
	ld	l,6
	call	sprite_set_xy
	ld	bc,((80)<<8)|(24+2)
	ld	l,7
	call	sprite_set_xy
	ld	bc,((88)<<8)|(24+2)
	ld	l,8
	call	sprite_set_xy
	ld	bc,((96)<<8)|(24+2)
	ld	l,9
	call	sprite_set_xy
	
	ld	a,12
	ld	l,6
	call	sprite_set_tile
	ld	a,14
	ld	l,7
	call	sprite_set_tile
	ld	a,16
	ld	l,8
	call	sprite_set_tile
	ld	a,18
	ld	l,9
	call	sprite_set_tile
	
	; ROUND
	
	ld	bc,((120-2)<<8)|(32+2)
	ld	l,10
	call	sprite_set_xy
	ld	bc,((128-2)<<8)|(32+2)
	ld	l,11
	call	sprite_set_xy
	ld	bc,((136-2)<<8)|(32+2)
	ld	l,12
	call	sprite_set_xy
	ld	bc,((144-2)<<8)|(32+2)
	ld	l,13
	call	sprite_set_xy
	ld	bc,((152-2)<<8)|(32+2)
	ld	l,14
	call	sprite_set_xy
	ld	bc,((160-2)<<8)|(32+2)
	ld	l,15
	call	sprite_set_xy
	
	ld	a,0
	ld	l,10
	call	sprite_set_tile
	ld	a,2
	ld	l,11
	call	sprite_set_tile
	ld	a,4
	ld	l,12
	call	sprite_set_tile
	ld	a,6
	ld	l,13
	call	sprite_set_tile
	ld	a,8
	ld	l,14
	call	sprite_set_tile
	ld	a,10
	ld	l,15
	call	sprite_set_tile
	
	; Load data
	
	ld	b,$90
	call	wait_ly
	
	call	refresh_OAM
	
	ret

;----------------------------------------------

fake3d_load_vram:

	ld	a,0
	ld	[rVBK],a
	
	ld	bc,4
	ld	hl,fake3d_tiles
	ld	de,256 ;  de = start index
	call	vram_copy_tiles
	
	ld	bc,20
	ld	hl,fake3d_round_and_round_tiles
	ld	de,0 ;  de = start index
	call	vram_copy_tiles
	
	; ----------------
	
	ld	a,1
	ld	[rVBK],a
	
	ld	bc,32*32
	ld	d,0
	ld	hl,$9800
	call	vram_memset ; bc = size    d = value    hl = dest address
	
	ld	bc,32*32
	ld	d,0
	ld	hl,$9C00
	call	vram_memset ; bc = size    d = value    hl = dest address
	
	ld	a,0
	ld	[rVBK],a
	
	ld	bc,32*32
	ld	d,0
	ld	hl,$9800
	call	vram_memset
	
	ld	bc,32*32
	ld	d,0
	ld	hl,$9C00
	call	vram_memset ; bc = size    d = value    hl = dest address
	
	; ----------------
	
	ld	a,0
	ld	[rVBK],a
	
	ld	hl,fake3d_map
	ld	de,$9800
	ld	a,10
.loop_tiles:
	push	af
	
	ld	bc,20
	call	vram_copy
	
	; now increase dst by 12 to align columns
	
	push	hl
	
	ld	hl,12
	add	hl,de
	
	ld	d,h
	ld	e,l
	
	pop	hl
	
	pop	af
	dec	a
	jr	nz,.loop_tiles
	
	; ----------------
	
	ld	a,0
	ld	[rVBK],a

	ret

;----------------------------------------------

	GLOBAL Fake_3D
	
Fake_3D:
	
	ld	a,LCDCF_ON
	ld	[rLCDC],a
	
	call	fake3d_init_variables
	
	; load data...
	; ------------
	
	call	fake3d_load_vram
	call	fake3d_setup_sprites
	
	ld	a,LCDCF_ON|LCDCF_BG9800|LCDCF_BG8800|LCDCF_OBJ16|LCDCF_OBJON
	ld	[rLCDC],a

	; Set up interrupts...
	; --------------------
	
	ld	b,$90
	call	wait_ly
	
	ld	bc,fake3d_vbl_handler
	call	irq_set_VBL
	
	ld	bc,fake3d_lcd_handler
	call	irq_set_LCD
	
	ld	a,0
	ld	[rIF],a
	
	ld	a,$03
	ld	[rIE],a
	
	ld	a,STATF_MODE00
	ld	[rSTAT],a
	
	; Set up first frame and palettes...
	; ----------------------------------
	
	call	fake3d_update_ly_scy_array
	call	fake3d_handle_events
	
	call	wait_vbl
	
	ld	a,0
	ld	hl,fake3d_round_and_round_palette
	call	spr_set_palette
	
	ld	a,0
	ld	hl,fake3d_background_palette
	call	bg_set_palette
	
	; Main loop
	; ---------
	
.loop:

	call	fake3d_update_ly_scy_array
	call	fake3d_handle_events
	
	ld	a,[fake3d_exit_demo]
	and	a,a
	jr	z,.loop
	
	; Exit...
	; -------

	call	demo_config_default

	ret

