format zx81
;labelusenumeric
;LISTOFF

	// hardware options to be set and change defaults in ZX81DEF.INC
	MEMAVL	   =	   MEM_1K	   // can be MEM_1K, MEM_2K, MEM_4K, MEM_8K, MEM_16K, MEM_32K, MEM_48K
					   // default value is MEM_16K
	STARTMODE  EQU	   SLOW_MODE	   // SLOW or FAST
	DFILETYPE  EQU	   COLLAPSED	   // COLLAPSED or EXPANDED or AUTO
	include '..\SINCL-ZX\ZX81.INC'	   // definitions of constants
;LISTON

	AUTOLINE 1

	REM	_asm
;########
StartPos	db	0
Position	db	0
SinPosition	db	0
FrameCounter	db	0
StackSave	dw	0

;########
GenerateRaster:
	ld	r,a		;9 load RasterData adress LSB
	repeat 32		;32 NOPs = 256 pixels
		nop		;4
	end repeat
	jp	(hl)		;4 return
				;9 + 128 + 4 = 141
;########
	align	2
RasterStack:
	repeat	32
		db	RasterData and 255	;Destination address...
		db	%00000000		;...data to write
	end	repeat

;########
	align	256
SineTable:
	db	128,131,134,137,140,143,146,149,152,155,158,162,165,167,170,173
	db	176,179,182,185,188,190,193,196,198,201,203,206,208,211,213,215
	db	218,220,222,224,226,228,230,232,234,235,237,238,240,241,243,244
	db	245,246,248,249,250,250,251,252,253,253,254,254,254,255,255,255
	db	255,255,255,255,254,254,254,253,253,252,251,250,250,249,248,246
	db	245,244,243,241,240,238,237,235,234,232,230,228,226,224,222,220
	db	218,215,213,211,208,206,203,201,198,196,193,190,188,185,182,179
	db	176,173,170,167,165,162,158,155,152,149,146,143,140,137,134,131
	db	128,124,121,118,115,112,109,106,103,100,97,93,90,88,85,82
	db	79,76,73,70,67,65,62,59,57,54,52,49,47,44,42,40
	db	37,35,33,31,29,27,25,23,21,20,18,17,15,14,12,11
	db	10,9,7,6,5,5,4,3,2,2,1,1,1,0,0,0
	db	0,0,0,0,1,1,1,2,2,3,4,5,5,6,7,9
	db	10,11,12,14,15,17,18,20,21,23,25,27,29,31,33,35
	db	37,40,42,44,47,49,52,54,57,59,62,65,67,70,73,76
	db	79,82,85,88,90,93,97,100,103,106,109,112,115,118,121,124

;########
	align	32
RasterData:
	repeat 32	;32 bytes = 256 pixels
		db	%00000000
	end repeat
RasterDataEnd:

;########
	align	8
BarPattern	db	128, 64, 32, 16, 8, 4, 2, 1

;########
RasterMagic:
	ld	(StackSave),sp	;Save ordinary stack
	ld	b,3		;delay
DelayLoop:
	djnz	DelayLoop	;delay
	nop			;delay
	nop			;delay

	ld	hl,RasterData	;graphics is located in RasterData
	ld	a,h		;RasterData address MSB
	ld	i,a		;load MSB into I register
	ld	a,l		;RasterData address LSB, later loaded to R register
	ld	sp,RasterStack	;init the raster-stack
	ld	b,192-8 	;MainCounter, number of hires rasters
NewRaster:
	dec	b		;4 MainCounter
	pop	hl		;10 h=data, l=address
	ld	c,h		;4 prepare data
	ld	h,RasterData shr 8   ;7 set high address
	ld	(hl),c		;7 modify the raster
	ld	hl,RepeatRaster ;10 init return address
	jp	GenerateRaster + $8000	  ;10 draw the raster
RepeatRaster:
	dec	b		;4 MainCounter
	jp	z,MagicDone	;10/10
	inc	ix		;10 delay
	ld	c,0		;7 delay
	ld	c,5		;7 set RepeatCounter
RepeatTiming:
	nop			;4 delay
	nop			;4 delay
	ld	hl,Counting	;10 init return address
	jp	GenerateRaster + $8000	  ;10 draw the raster
Counting:
	dec	c		;4 RepeatCounter
	jp	z,NewRaster	;10/10
	dec	b		;4 MainCounter
	jp	z,MagicDone	;10/10
	jp	nz,RepeatTiming ;10/10
MagicDone:
	ld	sp,(StackSave)	;20 restore ordinary stack
				;FRAME is updated at VSYNC, which is not what the code needs...
	ld	a,(FrameCounter)
	inc	a
	ld	(FrameCounter),a

	ld	c,0		;7 delay
	dec	bc		;6 delay
	ld	bc,$0108	;1 row, 8 rasters
	ld	hl,TextData + $8000
	ld	a,$1e		;standard ROM-patterns
	ld	i,a		;restore text
	ld	a,$f5		;SLOW-mode value
	call	$2b5		;generate text
ReturnToBackground:
	call	$0292		;return to application program
	call	$0220		;extra register PUSH and VSYNC
	ld	ix,RasterMagic	;load the HR vector
	jp	$02A4		;return to application program

;########
TextData	dbzx	'NOLLKOLLTROLL VBARS ZX81 1K 2015'
		db	$76

EnableHires:
	ld	ix,RasterMagic	;simple start of the hires mode

GenerateBars:
	ld	hl,FrameCounter ;address to FrameCounter
	ld	a,(hl)		;get old FrameCounter
BarSync:
	cp	(hl)		;compare to new FrameCounter
	jr	z,BarSync	;continue after a change is detected

ClearRasterData0:		;init RasterData before creating the RasterStack
	ld	hl,RasterData
	ld	a,0
	ld	b,32
ClearLoop0:
	ld	(hl),a
	inc	hl
	djnz	ClearLoop0

	ld	hl,RasterStack
	ld	a,(StartPos)
	ld	(Position),a
	ld	de,RasterData
	ld	c,32
BarLoop:
BarAddress:
	ld	a,(Position)
	ld	(SineTableLow),a
	ld	a,(SineTable)
SineTableLow = $-2
	ld	(SinPosition),a
	srl	a
	srl	a
	srl	a
	add	a,RasterData and 255
	ld	(hl),a		;write addr to RasterStack
	inc	hl
	ld	d,RasterData shr 8
	ld	e,a
BarData:
	ld	a,(SinPosition)
	and	7
	push	hl
	ld	hl,BarPattern
	add	a,l
	ld	l,a
	ld	b,(hl)		;b = new bar-pattern
	pop	hl
	ld	a,(de)		;a = old RasterData
	or	b		;a = a or b
	ld	(de),a		;write masked data back to RasterData
	ld	(hl),a		;write masked data to RasterStack
	inc	hl
	ld	a,(Position)
	add	a,5
	ld	(Position),a
	dec	c
	jp	nz,BarLoop
	ld	a,(StartPos)
	add	a,1
	ld	(StartPos),a
ClearRasterData1:		;init RasterData before drawing a new frame
	ld	hl,RasterData
	ld	a,0
	ld	b,32
ClearLoop1:
	ld	(hl),a
	inc	hl
	djnz	ClearLoop1
	jp	GenerateBars

	end _asm

AUTORUN:
	rand usr #EnableHires

	include '..\SINCL-ZX\ZX81DISP.INC'	;include D_FILE and needed memory areas

VARS_ADDR:
	db 80h			;DO NOT REMOVE!!!

WORKSPACE:

assert ($-MEMST)<MEMAVL
// end of program