const PRT0 = $0007
const PRT1 = $2007
const PRT2 = $4007
const PRT3 = $6007
const PRT4 = $8007
const PRT5 = $a007
const PRT6 = $c007
const PRT7 = $e007

//--------------------------
macro LED_GREEN_ON()
{
	//set green led
	ld	bc,PRT7
	ld	a,$b6
	out	(c),a
}

//--------------------------
macro LED_GREEN_OFF()
{
	//clear green led
	ld	bc,PRT7
	ld	a,$b7
	out	(c),a
}

//--------------------------
macro LED_RED_ON()
{
	//set red led
	ld	bc,PRT7
	ld	a,$b8
	out	(c),a
}

//--------------------------
macro LED_RED_OFF()
{
	//clear red led
	ld	bc,PRT7
	ld	a,$b9
	out	(c),a
}

//--------------------------
//DE = file path, zero-terminated zx-string
OpenFileForStreaming:
	//prepare zxpand buffer for write
	ld	bc,PRT0
	ld	a,$ff
	out	(c),a
	//send filename to zxpand
	ld	bc,PRT2
	.NameOutLoop:
		ld	a,(de)
		out	(c),a		//one character to zxpand
		inc	de
		and	a
	jp	nz,.NameOutLoop 	//repeat until zero-termination
	//open file for read
	ld	bc,PRT4
	xor	a
	out	(c),a
	call	GetResponse
	//do not read meta-data, not needed
	ret

//--------------------------
Request192BytesFromFile:
	//request 192 bytes from file
	ld	bc,PRT5
	ld	a,192
	out	(c),a
	ret

//--------------------------
Read192BytesFromFileToHL:
	//wait for zxpand to finish command
	ld	bc,PRT5
	call	WaitForZXpand
	//prepare zxpand buffer for read
	ld	bc,PRT0
	ld	a,0
	out	(c),a
        nop
        nop
        nop
        nop
	//read 192 bytes from zxpand to screen-memory
        ld      d,h
        ld      e,l
        repeat (192 / 6)
        {
                ld      h,d
                ld      l,e
	        in      a,(c)
                ld      (hl),a
                ld      a,e
                add     a,42
                and     127
                ld      l,a

	        in      a,(c)
                ld      (hl),a
                ld      a,e
                add     a,84
                and     127
                ld      l,a

       	        in      a,(c)
                ld      (hl),a
                ld      a,e
                or      128
                ld      l,a

	        in      a,(c)
                ld      (hl),a
                ld      a,e
                add     a,42
                or      128
                ld      l,a

	        in      a,(c)
                ld      (hl),a
                ld      a,e
                add     a,84
                or      128
                ld      l,a

                in      a,(c)
                ld      (hl),a
                inc     d
        }
	ret

//--------------------------
CloseFile:
	ld	bc,PRT4
	ld	a,$80
	out	(c),a
	call	GetResponse
	ret

//--------------------------
GetResponse:
	.DelayStart:
		in	a,(c)		//get response code
	jp	m,.DelayStart		//and loop while negative
	cp	$40			//all ok
	ret	z			//ret if ok
	//error handling
	in	a,($fe) 		//VSync on, NMI off, HSYNC off
	jp	$

//--------------------------
WaitForZXpand:
	{
		in	a,(c)		//get response code
	        jp	m,@loop		//and loop while not done
        }
	ret
