format zx80
;labelusenumeric
;LISTOFF
	MEMAVL EQU MEM_16K
	STARTMODE EQU FAST_MODE
	DFILETYPE EQU COLLAPSED

	include '..\..\SINCL-ZX\ZX80.INC'
;LISTON
AUTORUN:
10	 RAND USR (#START)
20	 REM _hide _asm

;-------------------------------------
PICTURE_HEIGHT = 192

include 'VideoRoutines.inc'
include 'ScreenData80.inc'

;-------------------------------------
START:
	di
;        out     ($fd),a
;Set which character-map to use
	ld	a,$06
	ld	i,a
;waste time to synchronize with ZX81 HSync
	ld	b,13
	djnz	$
	nop
;Do the job in the VideoStack, never returns
	jp	InitVideoStack

;-------------------------------------
VideoStack:
	dw	EmptyLines, 22			;22 rasters
EffectDuringBorderLower:
	dw	PausePictureDuringBorder	;2 + 32 rasters
	dw	GenerateVSync			;1 + 3 rasters
EffectDuringBorderUpper:
	dw	PausePictureDuringBorder	;2 + 32 rasters
	dw	EmptyLines, 24			;24 rasters
PictureStack:
	LINE = 0
	repeat PICTURE_HEIGHT			;192 rasters
		dw	 HiresVideo256Line, LINE * 33 + ScreenData + $8000
		LINE = LINE + 1
	end repeat
	dw	InitVideoStack			;2 raster

;-------------------------------------
EffectStack:
	dw	PausePictureDuringBorder	;Effect
	dw	PausePictureDuringBorder	;Effect
	dw	GetEffectDataSimple		;GetNewCounter
	dw	100				;Counter

	dw	ScrollEffectDuringBorderLower	;Effect
	dw	ScrollEffectDuringBorderUpper	;Effect
	dw	GetEffectDataSimple		;GetNewCounter
	dw	374 - PICTURE_HEIGHT		;Counter

	dw	PausePictureDuringBorder	;Effect
	dw	PausePictureDuringBorder	;Effect
	dw	GetEffectDataSimple		;GetNewCounter
	dw	50				;Counter

	dw	WobbleEffectDuringBorderLower	;Effect
	dw	WobbleEffectDuringBorderUpper	;Effect
	dw	GetEffectDataWobble		;GetNewCounter
	dw	1				;Counter (extra, do not change)
;Counter, Speed, NrOfPeaksUpper, NrOfPeaksLower
	db	50, 1, 0, 0
	db	50, 3, 0, 0
	db	50, 7, 0, 0
	db	50, 11, 0, 0
EffectLoop:
	db	50, 2, 128, 128
	db	50, 4, 128, 128
	db	50, 7, 128, 128
	db	50, 11, 128, 128

	db	50, 2, 1, 1
	db	50, 4, 3, 1
	db	50, 7, 3, 1
	db	50, 11, 3, 1

	db	50, 5, 130, 129
	db	50, 5, 131, 130
	db	50, 5, 132, 131
	db	50, 5, 133, 132
	dw	0, EffectLoop

;-------------------------------------
	END _asm

	include '..\..\SINCL-ZX\ZX80POST.INC'

assert ($-MEMST)<MEMAVL
; end of program