// Free console demo by AtariSMN82. 2020
// Windows only
#define win32_lean_and_mean
#include <winbase.h>
#include <windows.h>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <ctime>
#include <conio.h>

struct CONREF
{
	/// console size:
	static constexpr int CX = 80;
	static constexpr int CY = 25;
	static constexpr int SIZE = CX * CY;

	// cord 4 pointer:
	int x = CX / 2;
	int y = CY / 2;

	HANDLE handle = nullptr;	/// 4 cursor
	double angle = 0.0;			/// motion angle
	unsigned count = 0;			/// count of points
};

void init(CONREF& ref)
{
	srand(time(nullptr)); // 4 rand seed
	ref.handle = GetStdHandle(STD_OUTPUT_HANDLE);

	// set inviz cursor:
	CONSOLE_CURSOR_INFO cur_inf;
	GetConsoleCursorInfo(GetStdHandle(STD_OUTPUT_HANDLE), &cur_inf);
	cur_inf.bVisible = false;
  SetConsoleCursorInfo(GetStdHandle(STD_OUTPUT_HANDLE), &cur_inf);
}

// cursor move
template <typename T>
void GotoXY(const CONREF& ref, T x, T y)
{
	COORD cord;
	cord.X = SHORT(x);
	cord.Y = SHORT(y);
  SetConsoleCursorPosition(ref.handle, cord);
}

void redraw(const CONREF& ref,
	const char charmap[CONREF::CX][CONREF::CY])
{
	for (int x = 0; x < CONREF::CX; ++x)
	for (int y = 0; y < CONREF::CY; ++y)
	{
		if (charmap[x][y] != ' ')
		{
			GotoXY(ref, x, y);
			const char ch[2] = {char('0' + rand() % 10), 0};
			printf(ch);
		}
	}
}

void randmove(CONREF& ref,
	char charmap[CONREF::CX][CONREF::CY])
{
	static const int move_table[8][2] = {
		{ 0, -1},
		{ 1, -1},
		{ 1,  0},
		{ 1,  1},
		{ 0,  1},
		{-1,  1},
		{-1,  0},
		{-1, -1} };

	// set angle:
	ref.angle += 0.5 * (rand() % 3 - 1);
	if (ref.angle < 0) ref.angle = 8.0 + ref.angle;
	const int ANGLE = int(ref.angle) % 8;

	// move & check bounds:
	ref.x += move_table[ANGLE][0];
	if (ref.x < 0) ref.x = CONREF::CX + ref.x;
	if (ref.x >= CONREF::CX) ref.x -= CONREF::CX;

	ref.y += move_table[ANGLE][1];
	if (ref.y < 0) ref.y = CONREF::CY + ref.y;
	if (ref.y >= CONREF::CY) ref.y -= CONREF::CY;

	// set point:
	charmap[ref.x][ref.y] = '1';
	++ref.count;
}

int main()
{
	// init empty map:
	char charmap[CONREF::CX][CONREF::CY];
	memset(charmap, ' ', CONREF::SIZE);

	CONREF ref;
	init(ref);

	while (!kbhit())
	{
		randmove(ref, charmap);
		redraw(ref, charmap);

		// lags contorl :)
		if (ref.count < 100)
			Sleep(30);
		else if (ref.count < 200)
			Sleep(20);
		else if (ref.count < 300)
			Sleep(10);
	} // while key press
}
