﻿
; Tom et Jerry du GPA * 18/04/2020 

; Detournement de la routine d'envoi des donnees a l'EF9345 par le systeme
; Au lieu de jouer la routine implantee en &38, on utilise le vecteur &47D0
; appele a son debut pour jouer une autre routine.

; Dans le source, c'est une copie identique de la routine du systeme.
; Le source est une adaptation Maxam du travail d'analyse de la ROM du VG5000
; realise par Daniel COULOM. 

; A quoi ca sert ? A bidouiller cette routine pour qu'elle prenne moins de temps
; et qu'il soit possible sous Basic de faire autre chose sous interruption comme
; jouer une musique. Detourner "simplement" la routine n'est pas suffisant (il faudra
; gerer soit meme les timing des interruptions pour appeler la routine d'affichage ou
; la musique).

; Deux axes potentiels pour gagner du temps :

; ne rafraichir que les caracteres et pas leurs attributs
; ne pas rafraichir la totalite de l'ecran

; La premiere idee ne fonctionne pas, l'EF9345 attend apparemment les deux attributs avec
; la commande KRG.

; La deuxieme peut etre declinee de deux manieres :
; ne pas afficher toutes les lignes
; ne pas afficher la totalite d'une ligne

; Les tests effectues avec SoundSheep 1 n'ont donne des resultats probants qu'avec la
; premiere methode. 



ORG &7000
WRITE "EF9345.BIN"


JP bootit

bootit
	DI
	PUSH IX
	PUSH HL
	LD A,&C3
	LD (&47D0),A

	LD HL,hacked
	LD (&47D1),HL
	POP HL
	POP IX
	EI
	RET

; Jack l'embrouille, on passe sur la routine en &7000 en lieu et place
; de celle en &38. On peut adapter cette routine a ses besoins

hacked	POP IY ; en theorie inutilisee par le systeme
	JP ef9345


;----------------------------------
;Interruption masquable (IRQ)
;----------------------------------
	call    &47d0         ; routine utilisateur
ef9345	push    af
	dec     (ix+&00)      ; compteur d'interruptions pour
	jp      nz,u0186      ;le rafraichissement de l'ecran


	ld      a,(ix+&02)    ; valeur de reference compteur interruptions
	ld      (ix+&00),a
	bit     0,(ix+&01)    ; flag si l'ecran doit etre rafraichi (47FB)
	res     0,(ix+&01)
	jp      z,u0186

	push    bc
	push    de
	push    hl

;---------------------------------
;Affichage de l'ecran
;---------------------------------

	ld      a,&28     ; 28=Command register + exec request
	out     (&8f),a
	ld      a,&82     ; 82=Indirect 
	out     (&cf),a
	ld      a,&29     ;   29=Data register R1 + exec request
	out     (&8f),a
	jp      u00bc

;--------------------------------------
; Affichage de l'ecran (suite)
;--------------------------------------

u00bc	ld      a,(ix+&03)    ; couleur bordure et aspect curseur
	and     &bf
	out     (&cf),a      ; ecriture dans R1 + commande IND 
	ld      c,&cf
	ld      a,&26         ; 26=Main pointer R6 (Y)
	out     (&8f),a
	xor     a
	out     (c),a         ; raz de Y 
	ld      a,&27         ; 27=Main pointer R7 (X)
	out     (&8f),a
	xor     a
	out     (c),a         ; raz de X

;-------------------------------------
; Envoi de la premiere ligne de l'ecran
;-------------------------------------

	ld      hl,&4000    ; adresse memoire ecran
	ld      e,&03
	ld      b,&50       ; compteur d'octets a envoyer = 80
	ld      a,&20          
	out     (&8f),a     ; 20=Command register
	out     (c),e       ; KRG ecriture en memoire avec increment 
u00e0	ld      a,&22 		;	<----    22=Data register R2 
	out     (&8f),a     ;|
	outi                ;|   envoi de (hl++) = attribut
	ld      a,&29       ;|   29=Data register R1 + exec request
	out     (&8f),a     ;|
	outi                ;|   envoi de (hl++) = caractere
	jr      nz,u00e0    ;-- 
 
	ld      a,&26       ; 26=Main pointer R6 (Y)
	out     (&8f),a
	ld      a,&08
	out     (c),a
	ld      a,&27       ; 27=Main pointer R7 (X)
	out     (&8f),a
	xor     a
	out     (c),a

;-----------------------------------------------------------
; Envoi des lignes suivantes, c'est ici qu'on peu bidouiller
;-----------------------------------------------------------

	ld      d,&18    ; nombre de lignes à envoyer = 24 
u00ff	ld      b,&78    ; <--------------------------- boucle
	ld      a,&20
	out     (&8f),a  ;      20=Status

u0105	in      a,(&cf)  ; <-
	or      a        ;  |
	jp      m,u0105  ;---

	ld      a,&20          
	out     (&8f),a  ;      20=Command register
	out     (c),e    ;      KRG ecriture en memoire avec increment 

u0111	ld      a,&20    ;<------              
	out     (&8f),a  ;      | 20=Status

u0115	in      a,(&cf) ;  <-  | 
	or      a        ;    | |
	jp      m,u0115  ; ---  |

	ld      a,&22    ;      |    
	out     (&8f),a  ;      | 22=Data register R2
	outi             ;      | envoi de (hl++) = attribut
	ld      a,&29    ;      |    
	out     (&8f),a  ;      | 29=Data register R1 + exec request
	outi             ;      | envoi de (hl++) = caractere
	djnz    u0111    ;-------

	ld      a,&20          
	out     (&8f),a  ;      20=Status  

u012d	in      a,(&cf) ; <-
	or      a        ;  |
	jp      m,u012d  ;---

	ld      a,&28          
	out     (&8f),a  ;      28=Command register + exec request
	ld      a,&b0    
	out     (c),a    ;      INY = increment Y
	dec     d
	jr      nz,u00ff  ; ------------------------------> boucle

	bit     6,(ix+&03)
	jr      z,u0183   ;-------> fin
	ld      hl,(&4805) 
	ld      a,h        
	or      a          
	jr      z,u014e   ; -  
	add     a,&07     ; | 
	ld      h,a       ; | 
u014e	ld      c,&cf    ;<-  
	ld      a,&26
	out     (&8f),a   ;    26=Main pointer R6 (Y)
	out     (c),h
	ld      a,&27     ;    27=Main pointer R7 (X)
	out     (&8f),a
	out     (c),l
	ld      a,&28         
	out     (&8f),a   ;    28=Command register + exec request
	ld      a,&0a
	out     (c),a     ;    KRG=write sans increment         
	ld      a,&20     ;    20=Command register
	out     (&8f),a

u0168	in      a,(&cf)  ; <-
	or      a         ;  |
	jp      m,u0168   ;---

	ld      a,&28     ;    28=Command register + exec request
	out     (&8f),a
	ld      a,&82         
	out     (&cf),a  ;    IND=Indirect read R2
	ld      a,&29     ;    29=Data register R1 + exec request
	out     (&8f),a
	set     6,(ix+&03)
	ld      a,(ix+&03)
	out     (&cf),a
u0183	pop     hl        ;     <----- fin de l'affichage   
	pop     de
	pop     bc
u0186	inc     (ix+&06)  ; <------ sortie sans affichage
	pop     af
	ei                ; enable interrupts      
	ret