#include <cmath>
#include <SDL2/SDL.h>

SDL_Window* window = NULL;
SDL_Surface* screenSurface = NULL;
SDL_Renderer* renderer = NULL;
SDL_Event e;
bool quit = false;
SDL_Surface* currentSurface = NULL;
SDL_Surface *bmp = NULL;
SDL_Texture *ball = NULL;

float cosine[360];
float sine[360];

typedef struct
{
	int x;
	int y;
	int z;
	int color;
} VectBallType;

int maxballs = 8;

int xangle = rand() % 360;
int yangle = rand() % 360;
int zangle = rand() % 360;

int distance = 256;

int direction = 1;

VectBallType object[8];

VectBallType temp[8];

VectBallType dummy;

void create_lookup_tables()
{
	int i;
	for(i=0; i<360; i++)
	{
		cosine[i] = cos(i * 3.14159265 / 180);
		sine[i] = sin(i * 3.14159265 / 180);
	}
}

void create_vector_object()
{
	object[0].x=-30;
	object[0].y=-30;
	object[0].z=30;
	object[1].x=30;
	object[1].y=-30;
	object[1].z=31;
	object[2].x=-30;
	object[2].y=30;
	object[2].z=32;
	object[3].x=30;
	object[3].y=30;
	object[3].z=33;
	object[4].x=-30;
	object[4].y=-30;
	object[4].z=-30;
	object[5].x=30;
	object[5].y=-30;
	object[5].z=-31;
	object[6].x=-30;
	object[6].y=30;
	object[6].z=-32;
	object[7].x=30;
	object[7].y=30;
	object[7].z=-33;
}

void draw_vector_object()
{
	int i,j,k,a,b,nx,ny,nz;

	for(i=0;i<8;i++)
	{
		ny=(int)(object[i].y*cosine[xangle]-object[i].z*sine[xangle]);
		nz=(int)(object[i].y*sine[xangle]+object[i].z*cosine[xangle]);
		nx=(int)(object[i].x);
		temp[i].x=nx;
		temp[i].y=ny;
		temp[i].z=nz;

		nx=(int)(temp[i].x * cosine[yangle] +temp[i].z * sine[yangle]);
		nz=(int)(-temp[i].x * sine[yangle]+temp[i].z * cosine[yangle]);
		temp[i].x=nx;
		temp[i].z=nz;

		nx=(int)(temp[i].x * cosine[zangle]-temp[i].y * sine[zangle]);
		ny=(int)(temp[i].x * sine[zangle]+temp[i].y * cosine[zangle]);
		temp[i].x=nx;
		temp[i].y=ny;

		temp[i].z-=distance;

		temp[i].x=(int)((temp[i].x*256)/temp[i].z+160);
		temp[i].y=(int)((temp[i].y*256)/temp[i].z+120);
		temp[i].color=object[i].color;
	}

	for(j=0;j<7;j++)
	{
		for(k=j+1;k<8;k++)
		{
			a=temp[j].z;
			b=temp[k].z;
			if(a >= b)
			{
				dummy=temp[j];
				temp[j]=temp[k];
				temp[k]=dummy;
			}
		}
	}

	SDL_Rect rect;
		rect.w = 23;
		rect.h = 31;
	for(i=0;i<8;i++)
	{
		SDL_RenderClear(renderer);
		rect.x = temp[0].x-11;
		rect.y = temp[0].y-15;
		SDL_RenderCopy(renderer, ball, NULL, &rect);
		rect.x = temp[1].x-11;
		rect.y = temp[1].y-15;
		SDL_RenderCopy(renderer, ball, NULL, &rect);
		rect.x = temp[2].x-11;
		rect.y = temp[2].y-15;
		SDL_RenderCopy(renderer, ball, NULL, &rect);
		rect.x = temp[3].x-11;
		rect.y = temp[3].y-15;
		SDL_RenderCopy(renderer, ball, NULL, &rect);
		rect.x = temp[4].x-11;
		rect.y = temp[4].y-15;
		SDL_RenderCopy(renderer, ball, NULL, &rect);
		rect.x = temp[5].x-11;
		rect.y = temp[5].y-15;
		SDL_RenderCopy(renderer, ball, NULL, &rect);
		rect.x = temp[6].x-11;
		rect.y = temp[6].y-15;
		SDL_RenderCopy(renderer, ball, NULL, &rect);
		rect.x = temp[7].x-11;
		rect.y = temp[7].y-15;
		SDL_RenderCopy(renderer, ball, NULL, &rect);
		SDL_RenderPresent(renderer);
	}
	SDL_RenderPresent(renderer);
}

int main(int argc, char* argv[]) {
	SDL_Init(SDL_INIT_VIDEO);
	window = SDL_CreateWindow("VECTBALL", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED, 320, 240, SDL_WINDOW_SHOWN);
	renderer = SDL_CreateRenderer(window, -1, SDL_RENDERER_ACCELERATED);
	bmp = SDL_LoadBMP("ball.bmp");
	SDL_SetColorKey(bmp, true, SDL_MapRGB(bmp->format, 0, 0, 0) );
	ball = SDL_CreateTextureFromSurface(renderer, bmp);
	create_lookup_tables();
	create_vector_object();
	while(!quit) {
		while(SDL_PollEvent(&e)!= 0) {
			if(e.type == SDL_QUIT) {
				quit = true;
			}
		}
		SDL_Delay(16);
		if(direction==1) {
			distance++;
			if(distance>=600) {
				direction=0;
				distance=600;
			}
		} else {
			distance--;
			if(distance<=256) {
				direction=1;
				distance=256;
			}
		}
		xangle+=3;
		if(xangle>=360) {
			xangle=0;
		}
		yangle+=3;
		if(yangle>=360) {
			yangle=0;
		}
		zangle-=2;
		if(zangle<=0) {
			zangle=359;
		}
		draw_vector_object();
		SDL_RenderPresent(renderer);
	}
	SDL_DestroyTexture(ball);
	SDL_DestroyRenderer(renderer);
	renderer = NULL;
	SDL_DestroyWindow(window);
	window = NULL;
	SDL_Quit();
	return 0;
}