; VGM player for the NeoGeo Pocket
; TLCS900H part
; /Mic, 2012

; Tell the AS assembler we want to code for NGPC
;
        cpu 96C141
        maxmode on
        include "stddef96.inc"


        include "hardware.inc"  ; Include hardware defines
        include "system.inc"    ; Include System Call defines
        
;
; Define variables
;


RAMRESB: MACRO para,num
para    equ   START_OF_RAM
START_OF_RAM eval START_OF_RAM+num
        ENDM
        

START_OF_RAM    EVAL    _MAINRAM
   RAMDB YHEAD
   RAMDB XHEAD
   RAMDB YTAIL
   RAMDB XTAIL
   RAMDB YFRT
   RAMDB XFRT
   RAMDB DIR
   RAMDB HIL
   RAMDB HIH
   RAMDB VBCOUNTER
   RAMDB SPEED
   RAMDB song_num
   RAMDD vgm_ptr
   RAMDD vgm_header_size
   RAMRESB title_strings,192
   

HEADER_OFS      EQU     0200000H

REG_Z80SND      equ     0b8h    ; 16bit w - switch the z80 and/or snd chip on or off
ZS_Z0S0         equ     0aaaah  ; Z80 off Snd off
ZS_Z0S1         equ     0aa55h  ; Z80 off Snd on - Snd with direct access from TLCS
ZS_Z1S0         equ     055aah  ; Z80 on Snd off
ZS_Z1S1         equ     05555h  ; Z80 on Snd on - Snd only available via Z80

REG_Z80_NMI     equ     0bah    ; 8bit w - triggers Z80 NMI
REG_Z80_COMM    equ     0bch    ; 8bit r/w - comms with z80 address 0x8000

_Z80RAM         equ     7000h   ; start of Z80 RAM


VGM_DATA_BUFFER		equ 07300h
VGM_BUFFER_READ_POS 	equ REG_Z80_COMM
VGM_RESTART 		equ 07080h

;
; Standard cartridge header
;
    org    HEADER_OFS
    db     " LICENSED BY SNK CORPORATION"    ; 28 bytes license string
    dd     Start                             ; Program Counter
    dw     0                                 ; Catalog number
    db     0                                 ; Sub catalog number
    db     10h                               ; colour or b+w (10h = colour)
    db     "   POKEVGM  "                    ; Game name (12 bytes)
    dd     0,0,0,0                           ; padding - reserve for future use

; User Interrupt Vectors

UserIntVect:
        dd      nada            ; Software Interrupt (SWI 3)
        dd      nada            ; Software Interrupt (SWI 4)
        dd      nada            ; Software Interrupt (SWI 5)
        dd      nada            ; Software Interrupt (SWI 6)
        dd      nada            ; RTC Alarm Interrupt
        dd      VBlankInt       ; Vertical Blanking Interrupt
        dd      nada            ; Interrupt from Z80
        dd      nada            ; Timer Interrupt (8 bit timer 0)
        dd      nada            ; Timer Interrupt (8 bit timer 1)
        dd      nada            ; Timer Interrupt (8 bit timer 2)
        dd      nada            ; Timer Interrupt (8 bit timer 3)
        dd      nada            ; Serial Transmission Interrupt
        dd      nada            ; Serial Reception Interrupt
        dd      nada            ; (Reserved)
        dd      nada            ; End Micro DMA Int (MicroDMA 0)
        dd      nada            ; End Micro DMA Int (MicroDMA 1)
        dd      nada            ; End Micro DMA Int (MicroDMA 2)
        dd      nada            ; End Micro DMA Int (MicroDMA 3)

nada:   reti

; *** Start of User Code ***

Start:
        calr    OS_VERSION      ; Initialize NGP or NGPC mode

        set     6,(rUSERA)      ; User Answer

; Install User Interrupt Vectors

        lda     xix,(UserIntVect)
        lda     xiy,(rSWI3)
        ld      b,18
UIVloop:
        ld      xwa,(xix+)
        ld      (xiy+),xwa
        djnz    b,UIVloop


    ; set up screen size 160x152
    ld   (08002h),0
    ld   (08003h),0
    ld   (08004h),0a0h
    ld   (08005h),98h

    ld 	 (08030h),80h	; Scroll2 in front
    
    ei
    
    ld w,1
    call vbWait
    
    ld bc,1264/2
    ld xde, _TILERAM
    ld xhl, bg_tiles
    ldirw (xde+),(xhl+)

    ld w,1
    call vbWait

    ld bc,1280/2
    ld xde, _TILERAM+1264
    ld xhl, font_tiles
    ldirw (xde+),(xhl+)



; Enable Interrupts

        ei      0

Restart:
    ; copy palette to character palette RAM
    ld bc, (ENDPALETTE-PALETTE)/2
    ld xde, _SCR2PAL
    ld xhl, PALETTE
    ldirw (xde+),(xhl+)

    ; background colour 
    ; _BGCPAL = GRxB
    ld (_BGCPAL), 36h
    ld (_BGCPAL+1), 00h

    ld (song_num),0
    call Main
 

slowdown
    ld w, (SPEED)
    call vbWait

; User shutdown? (Power off pressed?)

        cp      (rUSERS),0
        jp      z,Restart      ; no

; Power off NGP

        ld      rw3,VECT_SHUTDOWN
        calr    SYSTEM_CALL

done:   jr      done


; vbWait
; Waits for n vertical blank interrupts
; inputs: w = number of VBIs to wait for

vbWait:
   push xwa
   ld (VBCOUNTER), 0
vbw1:
   ld a, (VBCOUNTER)
   cp a, w
   jr nz, vbw1
   pop xwa
   ret

    
; xhl=string, d=palette, c=column, b=row  (c=0..31, r=0..23)
Puts
	push 	xhl
	push 	xde

	sll	d
	ld	(HIH),d
	
	ld	xde,9800h
	ld	xwa,0
	ld	a,c
	add	a,c
	add	xde,xwa
	ld	c,b
	ld	b,0
	mul	xbc,40h
	add	xde,xbc
	ld	b,16
puts_loop
	ld 	a,(xhl)
	cp 	a,0
	jr	z,puts_done
	inc	xhl
	cp	a,91
	jr	c,is_upper
	add	a,0E0h
is_upper
	ld	w,0
	add	wa,79-32	; first tile in charset
	add 	w,(HIH)		; palette
	ld	(xde),a
	inc	xde
	ld	(xde),w
	inc	xde
	djnz	b,puts_loop
puts_done
	pop	xde
	pop	xhl
	ret
	

;
; Clear the background plane
;
;
ClearScroll2
   	ld 	xbc, _SCR2RAM
   	ld 	hl, 4C0h
cs2
   	ld 	(xbc), 0
   	add 	xbc, 1
   	sub 	hl, 1
   	jr 	nz, cs2
   	ret


ClearScroll1
   	ld 	xbc, _SCR1RAM
   	ld 	hl, 4C0h
cs1
   	ld 	(xbc), 0
   	add 	xbc, 1
   	sub 	hl, 1
   	jr 	nz, cs1
   	ret


CheckPad
   	ld 	a, (rSL)
   	bit 	PADB_DOWN, a
   	jr	z, not_down
   	ld	a,(song_num)
   	ld	w,(num_songs)
   	dec	w
   	cp	a,w
   	;cp	(song_num), NUM_SONGS-1
   	jr	nc, not_down
   	inc	(song_num)
   	ldw 	(REG_Z80SND), ZS_Z0S0  ; turn off z80 and snd chip
   	call	PutsTitles
wait_down_depress
   	ld 	a, (rSL)
   	bit 	PADB_DOWN, a
   	jr 	nz, wait_down_depress   	
   	jp	PlayVGM
   	
not_down
   	bit 	PADB_UP, a
   	jr	z, not_up
   	cp	(song_num), 0
   	jr	z, not_up
   	dec	(song_num)
   	ldw 	(REG_Z80SND), ZS_Z0S0  ; turn off z80 and snd chip
   	call	PutsTitles
wait_up_depress
   	ld 	a, (rSL)
   	bit 	PADB_UP, a
   	jr 	nz, wait_up_depress   	
   	jp	PlayVGM
not_up
	ret
	
   	

PutsTitles
	ld	w,1
	call	vbWait
	ld	(HIL),0			; loop counter
puts_titles
	ld	xhl,0
	ld	l,(HIL)
	mul	xhl,020h
	add	xhl,title_strings	; xhl = &title_string[i*0x20]
	ld	d,2			; use palette 2 for non-highlighted strings
	ld	a,(HIL)
	cp	a,(song_num)
	jr	nz,not_highlighted
	ld	d,1			; use palette 1 for highlighted strings
not_highlighted
    	ld 	xbc,0602h
    	add	b,(HIL)			; print at column 2, row 6+i
    	call 	Puts
	inc	(HIL)
	ld	a,(num_songs)
	cp	a,(HIL)
	jr	nz,puts_titles
	ret


PlayVGM
	ld	xwa,0
	ld	(vgm_header_size),xwa
	ld	a,(song_num)
	sll	a
	sll	a
	add	xwa,vgm_files
	ld	xhl,(xwa)
	ld	(vgm_ptr),xhl
	
	add	xhl,08h
	ld	wa,(xhl)	; version
	cp	wa,0150h
	jr	c,pre_1_50
	add	xhl,034h-08h
	ld	wa,(xhl)	; vgm data offset
	add	wa,034h
	ld	(vgm_header_size),wa
	ld	xhl,(vgm_ptr)
	add	xhl,0Fh
	ld	a,(xhl)		
	sll	a		; is bit31 of the sn76489 clock set?
	jp	c,PlayNGPVGM
	jp	PlaySMSVGM
pre_1_50
	ld	wa,40h
	ld	(vgm_header_size),wa
	jp	PlaySMSVGM
	
	
PlayNGPVGM
        ldw 	(REG_Z80SND), ZS_Z0S0  ; turn off z80 and snd chip

        ld 	xde, _Z80RAM
        ld 	xhl, vgm_ngp_z80_driver
        ld 	bc, 1000h
        ldir 	(xde+), (xhl+) 		; copy sound driver

	ld	xwa,0
	ld	a,(song_num)
	sll	a
	sll	a
	add	xwa,vgm_files
	ld	xhl,(xwa)
	ld	(vgm_ptr),xhl
	
        ld 	xde, VGM_DATA_BUFFER
        add	xhl,(vgm_header_size)
        ld 	bc, 32
        ldir 	(xde+), (xhl+) 		; copy vgm data
        
        ldw 	(REG_Z80SND), ZS_Z1S1   ; restart z80

	ld 	(VGM_BUFFER_READ_POS),0
	ld 	(VGM_RESTART),0
	ld 	xbc,(vgm_ptr)
	add	xbc,(vgm_header_size)
	add	xbc,32
	ld 	xde,VGM_DATA_BUFFER+020h
vgm_loop
	call	CheckPad
	ld 	a,(VGM_RESTART)
	and 	a,a
	jr 	z,vgm_check_data_req
	; The end of the song has been reached. Calculate the
	; loop point and start reading data from there
	ld 	xwa,0
	ld 	xbc,(vgm_ptr)
	add	xbc,01Ch
	ld 	wa,(xbc)
	cp	wa,0
	jr	nz,vgm_loop_offs_ok
	ld	wa,(vgm_header_size)
	sub	wa,01Ch
vgm_loop_offs_ok
	add 	xbc,xwa
	ld	e,(VGM_BUFFER_READ_POS)
	inc	e		; copy data to where the Z80 will be reading from next
	ld	w,32
vgm_buffer_preload
	ld	a,(xbc)
	ld	(xde),a
	inc	xbc
	inc	xde
	ld	d,073h
	djnz	w,vgm_buffer_preload
	ld	(VGM_RESTART),0
vgm_check_data_req	
	ld 	a,(VGM_BUFFER_READ_POS)
	ld 	w,e
	sub 	w,a		; write_pos - read_pos
	cp 	w,010h		; more than 16 bytes remaining?
	jr 	nc,vgm_loop
vgm_send_byte
	; The Z80 is getting close to having consumed
	; all VGM data written to the buffer; send
	; another byte.
	ld 	a,(xbc)
	inc 	xbc
	ld 	(xde),a
	inc	xde
	cp 	xde,VGM_DATA_BUFFER+0100h
	jr 	nz,vgm_loop
	ld 	xde,VGM_DATA_BUFFER
	jr 	vgm_loop

	
PlaySMSVGM
        ldw 	(REG_Z80SND), ZS_Z0S0  ; turn off z80 and snd chip

        ld 	xde, _Z80RAM
        ld 	xhl, vgm_sms_z80_driver
        ld 	bc, 1000h
        ldir 	(xde+), (xhl+) 		; copy sound driver

	ld	xwa,0
	ld	a,(song_num)
	sll	a
	sll	a
	add	xwa,vgm_files
	ld	xhl,(xwa)
	ld	(vgm_ptr),xhl
	
        ld 	xde, VGM_DATA_BUFFER
        add	xhl,(vgm_header_size)
        ld 	bc, 32
        ldir 	(xde+), (xhl+) 		; copy vgm data
        
        ldw 	(REG_Z80SND), ZS_Z1S1   ; restart z80

	ld 	(VGM_BUFFER_READ_POS),0
	ld 	(VGM_RESTART),0
	ld 	xbc,(vgm_ptr)
	add	xbc,(vgm_header_size)
	add	xbc,32
	ld 	xde,VGM_DATA_BUFFER+020h
vgm_sms_loop
	call	CheckPad
	ld 	a,(VGM_RESTART)
	and 	a,a
	jr 	z,vgm_sms_check_data_req
	; The end of the song has been reached. Calculate the
	; loop point and start reading data from there
	ld 	xwa,0
	ld 	xbc,(vgm_ptr)
	add	xbc,01Ch
	ld 	wa,(xbc)
	cp	wa,0
	jr	nz,vgm_sms_loop_offs_ok
	ld	wa,(vgm_header_size)
	sub	wa,01Ch
vgm_sms_loop_offs_ok
	add 	xbc,xwa
	ld	e,(VGM_BUFFER_READ_POS)
	inc	e		; copy data to where the Z80 will be reading from next
	ld	w,32
vgm_sms_buffer_preload
	ld	a,(xbc)
	ld	(xde),a
	inc	xbc
	inc	xde
	ld	d,073h
	djnz	w,vgm_sms_buffer_preload
	ld	(VGM_RESTART),0
vgm_sms_check_data_req	
	ld 	a,(VGM_BUFFER_READ_POS)
	ld 	w,e
	sub 	w,a		; write_pos - read_pos
	cp 	w,010h		; more than 16 bytes remaining?
	jr 	nc,vgm_sms_loop
vgm_sms_send_byte
	; The Z80 is getting close to having consumed
	; all VGM data written to the buffer; send
	; another byte.
	ld 	a,(xbc)
	inc 	xbc
	ld 	(xde),a
	inc	xde
	cp 	xde,VGM_DATA_BUFFER+0100h
	jr 	nz,vgm_sms_loop
	ld 	xde,VGM_DATA_BUFFER
	jr 	vgm_sms_loop
	


Main
	ld	w,1
	call 	vbWait
   
   	call 	ClearScroll2
   	call 	ClearScroll1

	; Copy the background nametable to VRAM
    	ld 	b,19		; rows
    	ld 	xde, _SCR2RAM
    	ld 	xhl, bg_nam
set_nam_y
    	ld 	c,20		; columns
set_nam_x
    	ld 	a,(xhl)
    	inc 	xhl
    	ld 	(xde),a
    	inc 	xde
    	ld 	a,(xhl)
    	inc 	xhl
    	ld 	(xde),a
    	inc 	xde
    	djnz 	c,set_nam_x
    	add 	xde,24
    	djnz 	set_nam_y

	; Go through all the VGM files, find out if they have a GD3 tag, and
	; extract the song title for each song and copy it to a buffer in RAM
	; (converting from WCHAR to CHAR in the process).
	ld	(HIL),0
get_song_titles
	ld	xwa,0
	ld	a,(HIL)
	sll	a
	sll	a
	add	xwa,vgm_files
	ld	xhl,(xwa)
	cp	xhl,0
	jr	z,end_song_titles
	add	xhl,014h
	ld	xbc,(xhl)	; get the GD3 offset
	ld	xwa,0
	ld	a,(HIL)
	mul	xwa,020h
	add	xwa,title_strings
	cp	bc,0		; do we have a GD3 tag?
	jr	z,unknown_title
	add	xbc,xhl
	add	xbc,12		; skip to the song title in the GD3 tag
	ld	xhl,xwa
	ld	e,30		; max chars
copy_wchar_title
	ld	wa,(xbc)
	inc	xbc
	inc	xbc
	cp	wa,0
	jr	z,end_wchar_title
	ld	(xhl),a
	inc	xhl
	djnz	e,copy_wchar_title
end_wchar_title
	cp	e,30
	jr	nz,got_title
	ld	xwa,xhl
	jr	unknown_title	; the GD3 tag had an empty title string
got_title
	ld	(xhl),0
	jr	next_song_title
unknown_title
    	ld 	bc,8
    	ld 	xde, xwa
    	ld 	xhl, unknown
    	ldir 	(xde+),(xhl+)
next_song_title:
	inc	(HIL)
	jr	get_song_titles
end_song_titles

	call	PutsTitles
	
   	call 	PlayVGM
   
   


VBlankInt:
    push xwa
    push xbc
    push xde
    
    ; Update Watch Dog Timer to prevent CPU reset
    ld      (rWDCR),WD_CLR

    ; increment a counter
    inc (VBCOUNTER)
    pop xde
    pop xbc
    pop xwa
    reti

SYSTEM_CALL:
        SystemCallCode
OS_VERSION:
        OsVersionCode

; in the order 0BGR
PALETTE
   dw 0,0700h,0c33h,0f88h
   dw 0000h,044dh,0119h,0aafh
   dw 0000h,0888h,0444h,0dddh
   dw 0, 000fh, 000fh, 000fh
ENDPALETTE 


vgm_sms_z80_driver: binclude "vgmdriv2.bin"
vgm_ngp_z80_driver: binclude "vgmdriv3.bin"

; Graphics data. Converted with
; sixpack.exe -image -target ngp -q 4 -dither -opt -o pokevgm3.chr -v pokevgm3.png
bg_tiles: 	binclude "pokevgm3.chr"
bg_nam: 	binclude "pokevgm3.nam"
; (same but without -opt)
font_tiles: 	binclude "font3.chr"

unknown: db "Unknown",0

num_songs: dd 01001001h

vgm_files: 
	dd 9,1,2,3,4,5,6,7,8,9
	
vgm_data:


    ; make the cartridge size correct
    org HEADER_OFS + 07FFFFh
    db 0FFh

