;   hypnoscope by xylem
;      256b intro for
;    @party 2018 Party
;
; nasm XLMHYPNO.ASM -o XLMHYPNO.COM

  bits 16
  org 0x100

%define WIDTH (320)
%define HEIGHT (200)
%define TEXTURE (256)

  s equ $
segment .text

;h:
  push 0x8000
  pop fs
  push 0x9000
  pop gs
  push 0xa000
  push 0x7000

  push si

  ; assume cx = 0, di = 0
  xor di, di
  mov cl, HEIGHT
@row:
  mov dx, WIDTH
@col:

  ; assume bx = 0, si = 0x100
  pusha

  fild word [bx-0xe]      ; x
  fidiv word [bx-0x3]     ; x/160
  fld1                    ; 1
  fsubp                   ; x = x/160 - 1
  fld st0                 ; x
  fmul st0, st1           ; x2 = x*x

  fild word [bx-0xc]      ; y
  fidiv word [bx-0x5]     ; y/100
  ;fidiv word [si+h-s]     ; y/100
  fld1                    ; 1
  fsubp                   ; y = y/100 - 1
  fld st0                 ; y
  fmul st0, st1           ; y2 = y*y

  ; st = y2, y, x2, x

  fxch st0, st3           ; y2 <-> x
  fpatan                  ; a = atan2(y, x)

  ; st = a, x2, y2

  fxch st0, st2           ; a <-> x2
  faddp                   ; x2 + y2
  fsqrt                   ; d = sqrt(x2 + y2)

  ; st = d, a

  fld st1                 ; a
  fcos                    ; c = cos(a)
  fxch st0, st2           ; c <-> a

  ; st = a, d, c

  fsin                    ; s = sin(a)
  fdiv st0, st1           ; u = s/d

  ; st = u, d, c

  fimul word [bx-0x5]     ; u*256
  fistp word [fs:di]      ; ax = floor(u + 0.5)

  ; st = d, c

  fdivp                   ; v = c/d
  fimul word [bx-0x5]     ; v*256
  fistp word [gs:di]      ; ax = floor(v + 0.5)

  popa

  inc di

  dec dx
  jnz @col

  dec cx
  jnz @row

  pop ax

  pop es

  ;xor di, di
@texture:
  push di
  pop ax
  xor al,ah
  stosb
  loop @texture

  push es


  mov dx, my_isr
  mov ax, 0x13

  call init_reset

  mov ax, es

  pop ds                  ; DS = texture segment
  pop es                  ; ES = 0xa000

  push ax
  push bx

@main:
  ; assume cl = 0
  xor di, di
  mov ch, 0xfa            ; 0xfa00 = 64000 = 320*200
@pixel:
  mov bh, byte [fs:di]
  mov bl, byte [gs:di]
  add bx, si

  mov al, byte [ds:bx]
  stosb
  loop @pixel

  mov ah, 1
  int 0x16
  jz @main

  pop dx
  pop ds
  push 0x3
  pop ax

; set the mode and swap the isr
; ds:dx = <mode>, ax = mode
init_reset:
  cli
  int 0x10
  ; isr into es:bx
  mov ax, 0x3508
  int 0x21
  ; assume ds:dx is set
  mov ah, 0x25
  int 0x21
  mov al, 0x36
  out 0x43, al
  ;mov dx, 23863   ; 50Hz
  mov dx, 11931  ; 100Hz
  mov al, dl
  out 0x40, al
  mov al, dh
  out 0x40, al
  sti
  ret

my_isr:
  inc si
  pushad
  mov dx, 0x388

  ;; init adlib
  mov ax, 0x3fbd          ; turn on rhythm section
  out dx, ax

  ;; setup bass drum
  mov ax, 0xf963          ; fast attack slow decay carrier ch1
  out dx, ax
  mov al, 0x83          ; med sustain, med release carrier ch1
  out dx, ax


  mov cx, 0x100
  and si, 0x3f
  jz start_white
  test si, 0x3
  jnz @end

  ;; key off

  mov ax, 0x15b0
  out dx, ax

  ; orange:   0-127 = 128
  ;  green: 128-181 = 54
  ; purple: 182-221 = 40
  ;   blue: 222-255 = 34
  ; assume cx = 0xff
@colors:
  mov dl, 0xc8
  mov al, cl
  out dx, al
  inc dx
  mul al
  xchg al, ah
  out dx, al
  shr al, 1
  out dx, al
  ;shr al, 1
  out dx, al
  loop @colors
  jmp @end

start_white:
  ;; key on
  mov ax, 0x35b0
  out dx, ax
        
@white:
  mov dl, 0xc8
  mov al, cl
  out dx, al
  inc dx
  mov al, 0x3f
  out dx, al
  out dx, al
  out dx, al
  loop @white
@end:
  mov al,0x20
  out 0x20, al
  popad
  iret
