
DisplayDarkEdgeBuf:

; Search for start of tri

        ld      hl,EdgeBuf
        ld      c,-1
.start2:
        ld      a,[hl+]
        inc     hl
        inc     c
        inc     a
        jr      z,.start2

        dec     hl
        dec     hl

; Render all lines of the tri

        ld      d,h
        ld      e,l

        ld      hl,YTable
        ld      b,0
        add     hl,bc
        add     hl,bc
        ld      a,[hl+]
        ld      c,a
        ld      a,[hl]
        ld      b,a             ; bc = Y addr offset

.mainl2:
        ld      a,[de]
        inc     de
        ld      l,a             ; l = minimum X

        ld      a,[de]
        inc     de
        ld      [maxX],a

        push    de

        push    bc

;.....
; Get start address offset

        ld      a,l
        srl     l
        srl     l
        srl     l

        rlc     l
        rlc     l
        rlc     l

 if RENDER_TO_VRAM
        ld      h,$40           ; Draw to tiles at $8000
 else
        ld      h,NON_VIDEO_RAM/2
 endc

        add     hl,hl           ; the number can be >256

        add     hl,bc

; Get bit positions

        and     7               ; b = Bitmask[b & 7]
        ld      e,a
        ld      d,LEFT_LINE_MASK_ADDR/256
        ld      a,[de]
        ld      [LastBitPos],a

;.....
        ld      a,h
        ld      [LastAdr+1],a
        ld      a,l
        ld      [LastAdr],a

        ld      d,h
        ld      e,l

;.....
; Get end address offset

        ld      a,[maxX]
        ld      l,a
        srl     l
        srl     l
        srl     l

        rlc     l
        rlc     l
        rlc     l

 if RENDER_TO_VRAM
        ld      h,$40           ; Draw to tiles at $8000
 else
        ld      h,NON_VIDEO_RAM/2
 endc

        add     hl,hl           ; the number can be >256

; Get Y address

        add     hl,bc           ; hl = end adr

        and     7
        ld      c,a
        ld      b,RIGHT_LINE_MASK_ADDR/256
        ld      a,[bc]
        ld      b,a             ; b = Bitmask[a & 7]
        cpl
        ld      c,a
;.....

; Figure out if start & end pixel locations on this
; line share the same memory address.

        ld      a,l
        sub     e
        ld      e,a
        ld      a,h
        sbc     d
;        ld      d,a

        srl     a
        rr      e


        or      e               ; Same address?
        jr      z,.sameadr      ; yes

;        srl     d
;        rr      e
        srl     e
        srl     e
        srl     e

 if RENDER_TO_VRAM
        di

; Plot End of line

        lcd_WaitVRAM2
 endc

        ld      a,[hl]
        and     c
        ld      [hl+],a

        ld      a,[hl]
        or      b
        ld      [hl],a

 if RENDER_TO_VRAM
        ei
 endc

        dec     e
        jr      z,.done

;        ld      d,16+1
;        ld      b,$ff

        ld      bc,-17
        xor     a
        ld      d,$ff

        bit     0,e
        jr      nz,.blitloop2

.blitloop:
        add     hl,bc

 if RENDER_TO_VRAM
       di

; Plot middle points of line

        lcd_WaitVRAM2
        xor     a
 endc
        ld      [hl+],a

        ld      [hl],d

 if RENDER_TO_VRAM
        ei
 endc

        dec     e

.blitloop2:
        add     hl,bc

 if RENDER_TO_VRAM
       di

; Plot middle points of line

        lcd_WaitVRAM2
        xor     a
 endc
        ld      [hl+],a

        ld      [hl],d

 if RENDER_TO_VRAM
        ei
 endc

        dec     e
        jr      nz,.blitloop

.done:
; Plot first part of line

        ld      a,[LastBitPos]
        ld      c,a
        cpl
        ld      b,a

        ld      a,[LastAdr+1]
        ld      h,a
        ld      a,[LastAdr]
        ld      l,a

        jr      .DoEndPixels


.sameadr:
        ld      a,[LastBitPos]
;        cpl
        and     b
        ld      c,a
        cpl
        ld      b,a

.DoEndPixels:

 if RENDER_TO_VRAM
        di

        lcd_WaitVRAM2
 endc

        ld      a,[hl]
        and     b
        ld      [hl+],a

        ld      a,[hl]
        or      c
        ld      [hl],a

 if RENDER_TO_VRAM
        ei
 endc

        pop     bc

; Move Y addr offset down one line

        ld      a,c
        and     $f
        cp      $e      ; Are we still on the same tile?
        jr      nz,.incy       ; yes

        ld      a,c     ; no, move to next tile
        add     $30
        ld      c,a
        ld      a,b
        adc     $01
        ld      b,a     ; bc = bc + $130

.incy:
        inc     bc
        inc     bc

        pop     de

        ld      a,[de]
        inc     a               ; Is there another line to render?
        jp      nz,.mainl2      ; yes

        ret