
#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <alloc.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <dos.h>


char palette[768] = {
   0x00,0x00,0x00,0x00,0x00,0x2A,0x00,0x2A,0x00,0x00,0x2A,0x2A,0x2A,0x00,0x00,0x2A,0x00,0x2A,0x2A,0x15,
   0x00,0x2A,0x2A,0x2A,0x15,0x15,0x15,0x15,0x15,0x3F,0x15,0x3F,0x15,0x15,0x3F,0x3F,0x3F,0x15,0x15,0x3F,
   0x15,0x3F,0x3F,0x3F,0x15,0x3F,0x3F,0x3F,0x3B,0x3B,0x3B,0x37,0x37,0x37,0x34,0x34,0x34,0x30,0x30,0x30,
   0x2D,0x2D,0x2D,0x2A,0x2A,0x2A,0x26,0x26,0x26,0x23,0x23,0x23,0x1F,0x1F,0x1F,0x1C,0x1C,0x1C,0x19,0x19,
   0x19,0x15,0x15,0x15,0x12,0x12,0x12,0x0E,0x0E,0x0E,0x0B,0x0B,0x0B,0x08,0x08,0x08,0x3F,0x00,0x00,0x3B,
   0x00,0x00,0x38,0x00,0x00,0x35,0x00,0x00,0x32,0x00,0x00,0x2F,0x00,0x00,0x2C,0x00,0x00,0x29,0x00,0x00,
   0x26,0x00,0x00,0x22,0x00,0x00,0x1F,0x00,0x00,0x1C,0x00,0x00,0x19,0x00,0x00,0x16,0x00,0x00,0x13,0x00,
   0x00,0x10,0x00,0x00,0x3F,0x36,0x36,0x3F,0x2E,0x2E,0x3F,0x27,0x27,0x3F,0x1F,0x1F,0x3F,0x17,0x17,0x3F,
   0x10,0x10,0x3F,0x08,0x08,0x3F,0x00,0x00,0x3F,0x2A,0x17,0x3F,0x26,0x10,0x3F,0x22,0x08,0x3F,0x1E,0x00,
   0x39,0x1B,0x00,0x33,0x18,0x00,0x2D,0x15,0x00,0x27,0x13,0x00,0x3F,0x3F,0x36,0x3F,0x3F,0x2E,0x3F,0x3F,
   0x27,0x3F,0x3F,0x1F,0x3F,0x3E,0x17,0x3F,0x3D,0x10,0x3F,0x3D,0x08,0x3F,0x3D,0x00,0x39,0x36,0x00,0x33,
   0x31,0x00,0x2D,0x2B,0x00,0x27,0x27,0x00,0x21,0x21,0x00,0x1C,0x1B,0x00,0x16,0x15,0x00,0x10,0x10,0x00,
   0x34,0x3F,0x17,0x31,0x3F,0x10,0x2D,0x3F,0x08,0x28,0x3F,0x00,0x24,0x39,0x00,0x20,0x33,0x00,0x1D,0x2D,
   0x00,0x18,0x27,0x00,0x36,0x3F,0x36,0x2F,0x3F,0x2E,0x27,0x3F,0x27,0x20,0x3F,0x1F,0x18,0x3F,0x17,0x10,
   0x3F,0x10,0x08,0x3F,0x08,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3B,0x00,0x00,0x38,0x00,0x00,0x35,0x00,
   0x01,0x32,0x00,0x01,0x2F,0x00,0x01,0x2C,0x00,0x01,0x29,0x00,0x01,0x26,0x00,0x01,0x22,0x00,0x01,0x1F,
   0x00,0x01,0x1C,0x00,0x01,0x19,0x00,0x01,0x16,0x00,0x01,0x13,0x00,0x01,0x10,0x00,0x36,0x3F,0x3F,0x2E,
   0x3F,0x3F,0x27,0x3F,0x3F,0x1F,0x3F,0x3E,0x17,0x3F,0x3F,0x10,0x3F,0x3F,0x08,0x3F,0x3F,0x00,0x3F,0x3F,
   0x00,0x39,0x39,0x00,0x33,0x33,0x00,0x2D,0x2D,0x00,0x27,0x27,0x00,0x21,0x21,0x00,0x1C,0x1C,0x00,0x16,
   0x16,0x00,0x10,0x10,0x17,0x2F,0x3F,0x10,0x2C,0x3F,0x08,0x2A,0x3F,0x00,0x27,0x3F,0x00,0x23,0x39,0x00,
   0x1F,0x33,0x00,0x1B,0x2D,0x00,0x17,0x27,0x36,0x36,0x3F,0x2E,0x2F,0x3F,0x27,0x27,0x3F,0x1F,0x20,0x3F,
   0x17,0x18,0x3F,0x10,0x10,0x3F,0x08,0x09,0x3F,0x00,0x01,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3B,0x00,0x00,
   0x38,0x00,0x00,0x35,0x00,0x00,0x32,0x00,0x00,0x2F,0x00,0x00,0x2C,0x00,0x00,0x29,0x00,0x00,0x26,0x00,
   0x00,0x22,0x00,0x00,0x1F,0x00,0x00,0x1C,0x00,0x00,0x19,0x00,0x00,0x16,0x00,0x00,0x13,0x00,0x00,0x10,
   0x3C,0x36,0x3F,0x39,0x2E,0x3F,0x36,0x27,0x3F,0x34,0x1F,0x3F,0x32,0x17,0x3F,0x2F,0x10,0x3F,0x2D,0x08,
   0x3F,0x2A,0x00,0x3F,0x26,0x00,0x39,0x20,0x00,0x33,0x1D,0x00,0x2D,0x18,0x00,0x27,0x14,0x00,0x21,0x11,
   0x00,0x1C,0x0D,0x00,0x16,0x0A,0x00,0x10,0x3F,0x36,0x3F,0x3F,0x2E,0x3F,0x3F,0x27,0x3F,0x3F,0x1F,0x3F,
   0x3F,0x17,0x3F,0x3F,0x10,0x3F,0x3F,0x08,0x3F,0x3F,0x00,0x3F,0x38,0x00,0x39,0x32,0x00,0x33,0x2D,0x00,
   0x2D,0x27,0x00,0x27,0x21,0x00,0x21,0x1B,0x00,0x1C,0x16,0x00,0x16,0x10,0x00,0x10,0x3F,0x3A,0x37,0x3F,
   0x38,0x34,0x3F,0x36,0x31,0x3F,0x35,0x2F,0x3F,0x33,0x2C,0x3F,0x31,0x29,0x3F,0x2F,0x27,0x3F,0x2E,0x24,
   0x3F,0x2C,0x20,0x3F,0x29,0x1C,0x3F,0x27,0x18,0x3C,0x25,0x17,0x3A,0x23,0x16,0x37,0x22,0x15,0x34,0x20,
   0x14,0x32,0x1F,0x13,0x2F,0x1E,0x12,0x2D,0x1C,0x11,0x2A,0x1A,0x10,0x28,0x19,0x0F,0x27,0x18,0x0E,0x24,
   0x17,0x0D,0x22,0x16,0x0C,0x20,0x14,0x0B,0x1D,0x13,0x0A,0x1B,0x12,0x09,0x17,0x10,0x08,0x15,0x0F,0x07,
   0x12,0x0E,0x06,0x10,0x0C,0x06,0x0E,0x0B,0x05,0x0A,0x08,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x31,0x0A,0x0A,0x31,
   0x13,0x0A,0x31,0x1D,0x0A,0x31,0x27,0x0A,0x31,0x31,0x0A,0x27,0x31,0x0A,0x1D,0x31,0x0A,0x13,0x31,0x0A,
   0x0A,0x31,0x0C,0x0A,0x31,0x17,0x0A,0x31,0x22,0x0A,0x31,0x2D,0x0A,0x2A,0x31,0x0A,0x1F,0x31,0x0A,0x14,
   0x31,0x0B,0x0A,0x31,0x16,0x0A,0x31,0x21,0x0A,0x31,0x2C,0x0A,0x31,0x31,0x0A,0x2B,0x31,0x0A,0x20,0x31,
   0x0A,0x15,0x31,0x0A,0x0A,0x3F,0x3F,0x3F
};



int        xs, ys, n;
unsigned   *sprite;
int        tick;


void setcolor(char *ptr)
{
   struct REGPACK regs;

   regs.r_ax = 0x1012;
   regs.r_bx = 0;
   regs.r_cx = 256;
   regs.r_dx = (unsigned) ptr;
   regs.r_es = _DS;
   intr(0x10, &regs);

}


void setattrib(int m)
{
   struct REGPACK regs;

   regs.r_ax = 0x1013;
   regs.r_bx = (m << 8);
   intr(0x10, &regs);

}


void screenmode(int mode)
{
   struct REGPACK regs;

   regs.r_ax = mode;
   intr(0x10, &regs);

   regs.r_ax = 0x0100;
   regs.r_cx = 0x2000;
   intr(0x10, &regs);

}


void loadsprite(char *file)
{
   int      filvar;
   unsigned size;
   int      i;

   filvar = open(file, O_RDONLY | O_BINARY, S_IREAD);
   if (filvar == -1) abort();

   read(filvar, &xs, 2);
   read(filvar, &ys, 2);
   read(filvar, &n, 2);

   size = filelength(filvar) - 6;
   sprite = malloc(size);

   read(filvar, sprite, size);

   close(filvar);

}


void setspeed(unsigned speed)
{
   outportb(0x43, 0x36);
   outportb(0x40, speed & 0xff);
   outportb(0x40, speed >> 8);
   inportb(0x61);

}


void interrupt new1c(void)
{

    tick = 1;

}



void putsprite(int i)
{
   unsigned  far *scrptr;
   unsigned  *data;
   int   x, y;

   scrptr = MK_FP(0xa000, 0);
   data = sprite + xs*ys*i/2;

   for (y = 0; y < ys; y++) {
      for (x = 0; x < xs/2; x++) {
	 *scrptr = *data;
	 scrptr++; data++;
         }
	 scrptr += 160 - xs/2;
      }

}




void main(void)
{
   int   i;
   int   d;
   int   speed;
   void interrupt (*old)(void);
   char  file[80];


   printf("\n\n\nEnter sprite to animate [.SPR]: ");
   fflush(stdin);
   scanf("%s", file); strcat(file, ".SPR");
   printf("Double each image (y/n) ");
   fflush(stdin); scanf("%c", &i);
   if ((i & 0xff) == 'y') d = 1; else d = 2;
   speed = 0xe8f6;

   screenmode(0x13);
   setcolor(palette);

   loadsprite(file);
   n *= 2;

   old = getvect(0x1c); setvect(0x1c, new1c);

   setspeed(speed);
   i = 0;
   do {
      putsprite(i/2);
      i+=d; if (i >= n) i = 0;
      while(!tick); tick = 0;
   } while (!kbhit());
   getch();

   setspeed(0);
   setvect(0x1c, old);

   free(sprite);
   screenmode(2);


}


