; NASM or FASM

        org 100h

        mov bx,es
        add bh,10h              ; bx = cs + 1000h
        mov es,bx               ; es = segment behind 64k of our code (extra video buffer)
        mov ds,bx               ; ds = es

        xor ax,ax
        mov cx,ax
        dec cx                  ; cx = -1
        rep stosb               ; clear extra video buffer
        dec ax                  ; ax = -1
        mov di,0A2D0h           ; set pointer to pixel at 130,80 (col,row)
        mov cl,80
        rep stosw               ; fill 80*2 = 160 pixels by 0FFh color (draw horizontal line)

        mov bx,19A0h            ; set pointer to pixel at 20,160 (col,row)
v:      mov [bx],ax             ; draw vertical line...
        add bx,320
        ja v                    ; ...until bottom

        mov ax,13h
        int 10h                 ; set 320x200 (256 colors) graphical video mode

        mov dx,3C8h
        xor al,al
        out dx,al               ; start palette set from 0 color
        inc dx
        mov cx,0C0h*3
        rep outsb               ; set first 0C0h (192) colors to black
p:
        out dx,al               ; red component
        outsb                   ; green = 0
        outsb                   ; blue = 0
        inc ax                  ; increase color (1, 2, 3..63)
        cmp al,64
        jb p                    ; set colors 0C0h..0FFh to red gradient (from dark to saturated)

        mov ch,0A0h
        mov ds,cx               ; ds = 0A000h = vedeo segment

l:      ; bx = pixel pointer, dx = pixel pointer delta value (initial values doesn't matter)
        cmp bh,0FAh
        jae s                   ; jump if current pixel is out of screen
        mov al,[bx]             ; else get color of pixel
        cmp al,0C0h
        jb s                    ; jump if pixel color is out of red gradient range (0C0h..0FFh)

        ; flame effect
        dec ax                  ; else decrase color by 1 (make it darker)
        mov [bx+1],al
        mov [bx-1],al
        mov [bx+320],al         ; di = 320
        mov [bx-320],al         ; and fill pixels around the current by new color

        mov si,-640             ; position delta: 2 lines up
        test dh,80h
        jnz n                   ; jump if dx is negative (poor pseudorandom boolean check)
        add si,2                ; wind effect
n:      mov [bx+si],al          ; add pixel 2 lines higher than current pixel considering possible wind
s:
        ; restore cross
        mov al,[es:bx]          ; get color from extra video buffer
        or [bx],al              ; replace pixel on screen by 0FFh is al = 0FFh (slow cross redraw)
        add bx,dx               ; increase pixel pointer by (pseudorandom) delta value
        inc dx                  ; increase delta value

        or bx,bx
        jnz l                   ; loop until full screen will be processed

        in al,60h               ; read keyboard scan code
        cmp al,1
        jnz l                   ; repeat if Esc key is not pressed

        mov al,3
        int 10h                 ; set text video mode

        ret                     ; return to DOS
