              PAGE      ,132
TITLE         Ultima Series I-VI Menu System

;----------------------------------
;The Ultima Series I-VI Menu system
;Designed by Jake Pickett 5.23.92
;----------------------------------


CODE          segment
              assume    cs:CODE,ds:CODE,es:CODE,ss:CODE

              org       100h
START:        jmp       INIT

;-----------------------------
;Define general purpose macros
;-----------------------------
;---------------------------------------------------
;Change directory
;DS:DX -> address of ASCIIZ string of directory name
;---------------------------------------------------
Chdir         MACRO     directory?
   mov   dx,offset directory?
   mov   ah,3Bh
   int   21h
   ENDM
;---------------------------------
;Print message
;DS:DX -> address of ASCIIZ string
;---------------------------------
Print_msg     MACRO     message?
   mov   dx,offset message?
   mov   ah,09h
   int   21h
   ENDM
;------------------------------------
;Set cursor position
;DH,DL = row, column. BH = video page
;------------------------------------
Set_cursor    MACRO     position?
   mov   ah,02h
   mov   dx,position?
   mov   bh,00h
   int   10h
   ENDM
;-------------------------------
;Restore all flags and registers
;-------------------------------
Pop_all       MACRO
   popf
   pop   bp
   pop   si
   pop   di
   pop   es
   pop   ds
   pop   dx
   pop   cx
   pop   bx
   pop   ax
   ENDM
;----------------------------
;Save all registers and flags
;----------------------------
Push_all      MACRO
   push  ax
   push  bx
   push  cx
   push  dx
   push  ds
   push  es
   push  di
   push  si
   push  bp
   pushf
   ENDM


;---------------------------
;DOS error message data area
;---------------------------
NOCODE        db             '<<Unkown Error Code>>',13,10,'$'
ERROR1        db             '<<Invalid Function>>',13,10,'$'
ERROR2        db             '<<File Not Found>>',13,10,'$'
ERROR3        db             '<<Path Not Found>>',13,10,'$'
ERROR5        db             '<<Access Denied>>',13,10,'$'
ERROR7        db             '<<Memory Control Blocks Destroyed>>',13,10,'$'
ERROR8        db             '<<Insufficient Memory>>',13,10,'$'
ERROR9        db             '<<Incorrect Segment In ES>>',13,10,'$'
ERROR0Ah      db             '<<Environment Invalid>>',13,10,'$'
ERROR0Bh      db             '<<Format Invalid>>',13,10,'$'

;--------------------------------------------------------
;Imbed program title, version number, and programmer name
;--------------------------------------------------------
PROG_INFO     db        "Ultima Series I-VI Menu System",'$'
AUTHOR        db        "Designed by Jake Pickett 5.23.92",'$'

;----------------------
;Local stack definition
;----------------------
EVEN                                        ;word align the stack
STACKS        db        32 dup ('stack   ') ;local stack
TOP_STK       equ       $-2                 ;set top stack address

;-------------------------------
;Parameter block definition area
;-------------------------------
SPOINT        dw        ?                   ;storage area for SP
PARAM_BLOCK   label     word                ;parameter block definition
              dw        0
              dw        offset CMD_BUF
P1            dw        ?
              dw        5Ch
P2            dw        ?
              dw        6Ch
P3            dw        ?
CMD_BUF       db        ?
              db        ' '
CMD_TXT       db        80 dup (?)
PARENT_PATH   db        '..',0
U1_PATH       db        'U1',0
U2_PATH       db        'U2',0
U3_PATH       db        'U3',0
U4_PATH       db        'U4',0
U5_PATH       db        'U5',0
U6_PATH       db        'U6',0
U1_U5_NAME    db        'ULTIMA.EXE',0
U2_NAME       db        'ULTIMAII.EXE',0
U3_U4_NAME    db        'ULTIMA.COM',0
U6_NAME       db        'ULTIMA6.EXE',0
RECON_NAME    db        'INSTALL.EXE',0

RUN_MENU      db        0                   ;switch to run main menu

MAIN_MENU     db        '1.  Ultima I:    The First Age of Darkness',13,10
              db        '2.  Ultima II:   Revenge of the Enchantress',13,10
              db        '3.  Ultima III:  Exodus',13,10
              db        '4.  Ultima IV:   Quest of the Avatar',13,10
              db        '5.  Ultima V:    Warriors of Destiny',13,10
              db        '6.  Ultima VI:   The False Prophet',13,10,10,'$'
PRESS_KEY     db        'Using the standard number keys, please press '
              db        'the number of the game you wish to play or press '
              db        'escape to quit.',13,10,10,'$'
RECON_MSG     db        'Do you wish to reconfigure Ultima VI?',13,10,'$'
CLOSE_MSG     db        'Thank you for choosing INC!',13,10,'$'

;----------------------------------------
;Begin actual program initialization here
;We start by setting the stack properly
;----------------------------------------
INIT:
   mov   sp,offset TOP_STK                  ;set the top_of_stack
   mov   ax,cs                              ;set ds equal to cs
   mov   ds,ax

;-----------------------------------------------------------------
;Now we clear the screen and print the first menu selection screen
;-----------------------------------------------------------------
PRINT_MENU:
   mov   ax,0003h                           ;set mode 3
   int   10h
   call  CLEAR_SCR                          ;clear video screen
   set_cursor 0015h
   print_msg  PROG_INFO                     ;print program information
   set_cursor 0114h
   print_msg  AUTHOR                        ;print author information
   set_cursor 0600h
   print_msg  MAIN_MENU                     ;print main menu
   set_cursor 1000h
   print_msg  PRESS_KEY                     ;print request for a key

GET_KEY:
   mov   ah,00h                             ;wait until a key is pressed
   int   16h

   cmp   ah,01h                             ;was escape pressed
   jz    ESCAPE
   cmp   ah,02h                             ;was 1 pressed
   jz    GAME1
   cmp   ah,03h                             ;was 2 pressed
   jz    GAME2
   cmp   ah,04h                             ;was 3 pressed
   jz    GAME3
   cmp   ah,05h                             ;was 4 pressed
   jz    GAME4
   cmp   ah,06h                             ;was 5 pressed
   jz    GAME5
   cmp   ah,07h                             ;was 6 pressed
   jz    GAME6

   jmp   GET_KEY                            ;no valid key was pressed

ESCAPE:
   call  CLEAR_SCR                          ;clear video screen
   jmp   END_IT

GAME1:
   chdir U1_PATH                            ;change path to U1
   jnc   GAME1_NAME
   jmp   ERROR

GAME1_NAME:
   mov   dx,offset U1_U5_NAME               ;filename to run
   jmp   short FREE_MEM

GAME2:
   chdir U2_PATH                            ;change path to U2
   jnc   GAME2_NAME
   jmp   ERROR

GAME2_NAME:
   mov   dx,offset U2_NAME                  ;filename to run
   jmp   short FREE_MEM

GAME3:
   chdir U3_PATH                            ;change path to U1
   jnc   GAME3_NAME
   jmp   ERROR

GAME3_NAME:
   mov   dx,offset U3_U4_NAME               ;filename to run
   jmp   short FREE_MEM

GAME4:
   chdir U4_PATH                            ;change path to U1
   jnc   GAME4_NAME
   jmp   ERROR

GAME4_NAME:
   mov   dx,offset U3_U4_NAME               ;filename to run
   jmp   short FREE_MEM

GAME5:
   chdir U5_PATH                            ;change path to U1
   jnc   GAME5_NAME
   jmp   ERROR

GAME5_NAME:
   mov   dx,offset U1_U5_NAME               ;filename to run
   jmp   short FREE_MEM

GAME6:
   chdir U6_PATH                            ;change path to U1
   jnc   GAME6_NAME
   jmp   short ERROR

GAME6_NAME:
   set_cursor 1300h
   print_msg  RECON_MSG                     ;print reconfigure check

RECONFIG_INPUT:
   mov   ah,00h                             ;wait until a key is pressed
   int   16h
   cmp   ah,15h                             ;was Y pressed
   jz    RECONFIGURE
   cmp   ah,31h                             ;was N pressed
   jnz   RECONFIG_INPUT
   mov   dx,offset U6_NAME                  ;filename to run
   jmp   short FREE_MEM

RECONFIGURE:
   mov   dx,offset RECON_NAME               ;filename to run
   mov   byte ptr RUN_MENU,01h              ;set flag

;----------------------------------------------------------
;Release all unused memory. Compute memory size by dividing
;the size of the program by 16 and adding 1.
;ES contains the address of the PSP
;----------------------------------------------------------
free_mem:
   mov   ax,cs                              ;set es equal to cs
   mov   es,ax
   mov   bx,(offset PROG_END - offset CODE)/16 + 1
   mov   ah,04Ah                            ;reduce memory size to bx
   int   21h
   jnc   MODIFY_OK                          ;if no error then continue
   jmp   short ERROR

;--------------------------------------------------
;Setup the parameter block
;All registers are destroyed after a load/exec call
;--------------------------------------------------
MODIFY_OK:
   mov   ax,cs                              ;set all parameter segments
   mov   P1,ax                              ;equal to cs
   mov   P2,ax
   mov   P3,ax
   mov   bx,offset PARAM_BLOCK              ;move parameter block to bx
   mov   SPOINT,sp                          ;save sp
   mov   ax,4B00h                           ;load & execute child
   int   21h

;---------------------------------------------------
;Restore the segment registers and the stack pointer
;---------------------------------------------------
   mov   cx,cs                              ;set ss equal to cs
   mov   ss,cx
   mov   sp,cs:SPOINT                       ;restore sp
   mov   ds,cx                              ;restore ds
   mov   es,cx                              ;restore es
   jc    ERROR                              ;jump if error
   cmp   RUN_MENU,01h                       ;is flag set
   jnz   END_IT
   mov   byte ptr RUN_MENU,00h              ;reset flag
   chdir PARENT_PATH                        ;change path to U1
   jc    ERROR                              ;jump if error
   jmp   PRINT_MENU                         ;jump back to print menu

;---------------------------------------------------------
;Parse the error code returned from the system and display
;The appropriate error message
;---------------------------------------------------------
ERROR:
   cmp   ax,1
   je    CODE1
   cmp   ax,2
   je    CODE2
   cmp   ax,3
   je    CODE3
   cmp   ax,5
   je    CODE5
   cmp   ax,7
   je    CODE7
   cmp   ax,8
   je    CODE8
   cmp   ax,9
   je    CODE9
   cmp   ax,0Ah
   je    CODE0Ah
   cmp   ax,0Bh
   je    CODE0Bh

   mov   dx,offset NOCODE                   ;no matching error code
   jmp   PRINT_ERROR

CODE1:
   mov   dx,offset ERROR1                   ;invalid function
   jmp   PRINT_ERROR

CODE2:
   mov   dx,offset ERROR2                   ;file not found
   jmp   PRINT_ERROR

CODE3:
   mov   dx,offset ERROR3                   ;file not found
   jmp   PRINT_ERROR

CODE5:
   mov   dx,offset ERROR5                   ;access denied
   jmp   PRINT_ERROR

CODE7:
   mov   dx,offset ERROR7                   ;memory control blocks destroyed
   jmp   PRINT_ERROR

CODE8:
   mov   dx,offset ERROR8                   ;insufficient memory
   jmp   PRINT_ERROR

CODE9:
   mov   dx,offset ERROR9                   ;incorrect segment in ES
   jmp   PRINT_ERROR

CODE0Ah:
   mov   dx,offset ERROR0Ah                 ;environment invalid
   jmp   PRINT_ERROR

CODE0Bh:
   mov   dx,offset ERROR0Bh                 ;format invalid

;-----------------------------------------------------------------
;Display error code to user
;-----------------------------------------------------------------
PRINT_ERROR:
   mov   ah,09h                             ;display stirng
   int   21h

;-----------------
;Terminate program
;-----------------
END_IT:
   print_msg  CLOSE_MSG
   mov   ax,4C00h                           ;terminate program
   int   21h

;-----------------------------
;Procedure to clear the screen
;-----------------------------
CLEAR_SCR     proc      near
   mov   ax,0600h                           ;clear the screen
   mov   bh,07h                             ;grey on black lettering
   xor   cx,cx                              ;upper left
   mov   dh,24                              ;lower right
   mov   dl,79
   int   10h

   set_cursor 0000                          ;top of screen
   int   10h
   ret
CLEAR_SCR     ENDP

PROG_END      label          byte
CODE          ends
              end       START