/*
 * Decompiled with CFR 0.152.
 */
package CPCFileSystem;

import CPCFileSystem.DskSector;
import CPCFileSystem.DskSectorCatalog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DskSectorCatalogs
extends DskSector {
    List<DskSectorCatalog> cats = new ArrayList<DskSectorCatalog>();

    public DskSectorCatalogs(DskSector sector) {
        super(sector);
    }

    public void scanCatalog(Map<String, DskSectorCatalog> previousCats) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (DskSectorCatalog cat : this.cats) {
            cat.scan(baos, previousCats);
        }
        for (int i = this.cats.size() * 32; i < this.master.sectorSizes[this.sectorSizeN]; ++i) {
            baos.write(229);
        }
        this.data = baos.toByteArray();
        baos.close();
    }

    @Override
    public String toString() {
        String s = "DskSectorCatalogs " + String.format("#%02X", this.sectorIdR) + " with " + this.cats.size() + " cats\n";
        for (DskSectorCatalog cat : this.cats) {
            s = s + "cat " + cat.toString();
        }
        return s + super.toString();
    }

    public void scanCatalogFromData() throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
        this.cats.clear();
        for (int c = 0; c < this.data.length / 32; ++c) {
            DskSectorCatalog cat = new DskSectorCatalog(this.master);
            if (!cat.scan(bis)) continue;
            this.cats.add(cat);
        }
        bis.close();
    }
}

