/*
 * Decompiled with CFR 0.152.
 */
package CPCFileSystem;

import CPCFileSystem.DskMaster;
import CPCFileSystem.DskSector;
import CPCFileSystem.DskType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DskSectorCatalog {
    private DskMaster master;
    int jocker;
    String filename;
    List<Integer> catsId = new ArrayList<Integer>();
    List<DskSector> catsSector = new ArrayList<DskSector>();
    int sectorIncrement;
    int sectorLength;
    byte[] entriesSector = new byte[16];
    boolean leftEntries = true;

    public DskSectorCatalog(DskMaster master) {
        this.master = master;
    }

    public boolean scan(ByteArrayInputStream bis) throws IOException {
        this.jocker = bis.read();
        if ((this.jocker & 0xFF) == 229) {
            bis.skip(31L);
            return false;
        }
        byte[] filename = new byte[11];
        bis.read(filename);
        this.filename = this.master.arrayToString(filename);
        this.sectorIncrement = bis.read();
        bis.read();
        bis.read();
        this.sectorLength = bis.read();
        this.entriesSector = new byte[16];
        bis.read(this.entriesSector);
        this.catsId = this.master.findCatsId(this.entriesSector);
        this.catsSector = this.master.findCatsSector(this.entriesSector);
        return true;
    }

    public void scan(ByteArrayOutputStream bos, Map<String, DskSectorCatalog> previousCats) throws IOException {
        if (this.jocker == 229) {
            for (int i = 0; i < 32; ++i) {
                bos.write(229);
            }
            return;
        }
        bos.write(new byte[]{(byte)this.jocker});
        byte[] entryFileName = this.master.stringToArray(this.master.realname2cpcname(this.filename));
        bos.write(entryFileName);
        bos.write(new byte[]{(byte)this.sectorIncrement});
        bos.write(new byte[]{0, 0});
        bos.write(new byte[]{(byte)this.sectorLength});
        int nbTrou = 0;
        if (this.master.type == DskType.DOSD40 || this.master.type == DskType.SDOS) {
            if (previousCats != null && previousCats.get(this.filename) != null) {
                this.leftEntries = !previousCats.get((Object)this.filename).leftEntries;
                previousCats.put(this.filename, this);
            } else {
                this.leftEntries = true;
                previousCats.put(this.filename, this);
            }
            if (!this.leftEntries) {
                for (int k = 0; k < 8; ++k) {
                    bos.write(0);
                    ++nbTrou;
                }
            }
        }
        for (Integer cat : this.catsId) {
            if (this.master.type == DskType.DOSD40 || this.master.type == DskType.SDOS) {
                bos.write((byte)cat.intValue());
                continue;
            }
            if (this.master.type == DskType.DOSD2 || this.master.type == DskType.DOSD10 || this.master.type == DskType.DOSD20) {
                byte k1 = (byte)(cat & 0xFF);
                byte k2 = (byte)((cat & 0xFF00) >> 8);
                bos.write(k1);
                bos.write(k2);
                ++nbTrou;
                continue;
            }
            if (this.master.type != DskType.PARADOS80 && this.master.type != DskType.PARADOS41 && this.master.type != DskType.PARADOS40D && this.master.type != DskType.SS40 && this.master.type != DskType.SYSTEM && this.master.type != DskType.VORTEX) continue;
            bos.write((byte)cat.intValue());
        }
        for (int j = 0; j < 16 - (this.catsId.size() + nbTrou); ++j) {
            bos.write(new byte[]{0});
        }
    }

    public String toString() {
        String s = "DskSectorCatalog\n" + this.catsId.size() + " sectors references\n";
        for (Integer cat : this.catsId) {
            s = s + "cat:" + String.format("#%02X", cat) + "\n";
        }
        return s;
    }
}

